/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.mixin.diving;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.content.item.SuitArmorItem;
import com.unascribed.yttr.init.YBlocks;
import com.unascribed.yttr.init.YCriteria;
import com.unascribed.yttr.init.YSounds;
import com.unascribed.yttr.init.YStats;
import com.unascribed.yttr.mechanics.SuitResource;
import com.unascribed.yttr.mixin.accessor.AccessorServerPlayNetHandler;
import com.unascribed.yttr.mixinsupport.DiverPlayer;
import com.unascribed.yttr.network.MessageS2CDiveEnd;
import com.unascribed.yttr.util.math.Vec2i;
import com.unascribed.yttr.world.Geyser;
import com.unascribed.yttr.world.GeysersState;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class MixinServerPlayerEntity
extends class_1657
implements DiverPlayer {
    private boolean yttr$isDiving = false;
    private boolean yttr$isInvisibleFromDiving = false;
    private boolean yttr$isNoGravityFromDiving = false;
    private int yttr$lastDivePosUpdate;
    private Vec2i yttr$divePos;
    private int yttr$fastDiveTime;
    private class_2338 yttr$fastDiveTarget;
    private final Set<UUID> yttr$knownGeysers = Sets.newHashSet();

    public MixinServerPlayerEntity(class_1937 world, class_2338 pos, float yaw, GameProfile profile) {
        super(world, pos, yaw, profile);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void tick(CallbackInfo ci) {
        class_3222 self = (class_3222)this;
        if (!self.method_5805()) {
            return;
        }
        if (this.yttr$isDiving) {
            class_3244 class_32442 = self.field_13987;
            if (class_32442 instanceof AccessorServerPlayNetHandler) {
                AccessorServerPlayNetHandler acc = (AccessorServerPlayNetHandler)class_32442;
                acc.yttr$setFloatingTicks(0);
            }
            YStats.add((class_1309)self, YStats.TIME_IN_VOID, 1);
            if (self.method_19538().field_1351 > (double)this.field_6002.method_31607()) {
                this.yttr$isDiving = false;
                new MessageS2CDiveEnd().sendTo((class_1657)self);
            } else {
                if (!self.method_5767()) {
                    self.method_5648(true);
                    this.yttr$isInvisibleFromDiving = true;
                } else if (!self.method_5740()) {
                    self.method_5875(true);
                    this.yttr$isNoGravityFromDiving = true;
                }
                self.method_23327(self.method_19538().field_1352, (double)(this.field_6002.method_31607() - 24), self.method_19538().field_1350);
            }
            class_1799 chest = self.method_6118(class_1304.field_6174);
            if (Yttr.isWearingFullSuit((class_1297)self)) {
                SuitArmorItem sai = (SuitArmorItem)chest.method_7909();
                int pressure = Yttr.calculatePressure(self.method_14220(), this.yttr$divePos.x, this.yttr$divePos.z);
                for (SuitResource sr : SuitResource.VALUES) {
                    int amt = sai.getResourceAmount(chest, sr);
                    if (amt <= 0) {
                        sr.applyDepletedEffect(self);
                        continue;
                    }
                    if (this.yttr$fastDiveTarget != null) continue;
                    sai.consumeResource(chest, sr, sr.getConsumptionPerTick(pressure));
                }
            } else {
                SuitResource.INTEGRITY.applyDepletedEffect(self);
            }
            self.field_6017 = 0.0f;
            if (this.yttr$fastDiveTarget != null) {
                class_2338 pos = this.yttr$fastDiveTarget;
                if (this.yttr$fastDiveTime > 0) {
                    --this.yttr$fastDiveTime;
                    if (pos.method_19770((class_2374)self.method_19538()) > 2.5E7) {
                        YCriteria.DIVE_FAR.trigger(self);
                    }
                    self.method_20620((double)pos.method_10263() + 0.5, (double)(this.field_6002.method_31607() - 24), (double)pos.method_10260() + 0.5);
                } else {
                    this.yttr$isDiving = false;
                    new MessageS2CDiveEnd().sendTo((class_1657)self);
                    self.method_5783(YSounds.DIVE_END, 2.0f, 1.0f);
                    double closestDist = Double.POSITIVE_INFINITY;
                    class_2338 closestPad = null;
                    for (class_2338 bp : class_2338.method_10097((class_2338)pos.method_10069(-5, -5, -5), (class_2338)pos.method_10069(5, 5, 5))) {
                        double dist;
                        if (!self.field_6002.method_8320(bp).method_27852((class_2248)YBlocks.DIVING_PLATE) || !((dist = bp.method_10262((class_2382)pos)) < closestDist) || !self.field_6002.method_22347(bp.method_10084())) continue;
                        closestPad = bp.method_10062();
                        closestDist = dist;
                    }
                    if (closestPad == null) {
                        self.method_20620((double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 4), (double)pos.method_10260() + 0.5);
                        self.method_18800(self.field_6002.field_9229.nextGaussian() / 2.0, 1.0, self.field_6002.field_9229.nextGaussian() / 2.0);
                        self.field_13987.method_14364((class_2596)new class_2743((class_1297)self));
                    } else {
                        self.method_20620((double)closestPad.method_10263() + 0.5, (double)(closestPad.method_10264() + 1), (double)closestPad.method_10260() + 0.5);
                    }
                }
            } else {
                GeysersState gs = GeysersState.get(self.method_14220());
                for (Geyser g : gs.getGeysersInRange(this.yttr$divePos.x, this.yttr$divePos.z, 64)) {
                    if (this.yttr$knownGeysers.contains(g.id)) continue;
                    Yttr.discoverGeyser(g.id, self);
                    YCriteria.DISCOVER_GEYSER.trigger(self);
                }
            }
        } else {
            if (this.yttr$isNoGravityFromDiving) {
                self.method_5875(false);
                this.yttr$isNoGravityFromDiving = false;
            }
            if (this.yttr$isInvisibleFromDiving) {
                self.method_5648(false);
                this.yttr$isInvisibleFromDiving = false;
            }
            if (this.yttr$divePos != null) {
                this.yttr$divePos = null;
            }
            if (this.yttr$lastDivePosUpdate != 0) {
                this.yttr$lastDivePosUpdate = 0;
            }
            if (this.yttr$fastDiveTarget != null) {
                this.yttr$fastDiveTarget = null;
            }
            if (this.yttr$fastDiveTime != 0) {
                this.yttr$fastDiveTime = 0;
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onSpawn()V"})
    public void onSpawn(CallbackInfo ci) {
        if (this.yttr$isDiving) {
            class_3222 self = (class_3222)this;
            Yttr.syncDive(self);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"writeCustomDataToNbt"})
    public void writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        if (this.yttr$isDiving) {
            nbt.method_10556("yttr:Diving", this.yttr$isDiving);
        }
        if (this.yttr$isInvisibleFromDiving) {
            nbt.method_10556("yttr:InvisibleFromDiving", this.yttr$isInvisibleFromDiving);
        }
        if (this.yttr$isNoGravityFromDiving) {
            nbt.method_10556("yttr:NoGravityFromDiving", this.yttr$isNoGravityFromDiving);
        }
        if (this.yttr$divePos != null) {
            nbt.method_10566("yttr:DivePos", (class_2520)this.yttr$divePos.toTag());
        }
        if (this.yttr$fastDiveTarget != null) {
            nbt.method_10566("yttr:FastDiveTarget", (class_2520)class_2512.method_10692((class_2338)this.yttr$fastDiveTarget));
        }
        if (this.yttr$fastDiveTime != 0) {
            nbt.method_10569("yttr:FastDiveTime", this.yttr$fastDiveTime);
        }
        if (!this.yttr$knownGeysers.isEmpty()) {
            class_2499 li = new class_2499();
            for (UUID id : this.yttr$knownGeysers) {
                li.add((Object)class_2512.method_25929((UUID)id));
            }
            nbt.method_10566("yttr:KnownGeysers", (class_2520)li);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readCustomDataFromNbt"})
    public void readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        this.yttr$isDiving = nbt.method_10577("yttr:Diving");
        this.yttr$isInvisibleFromDiving = nbt.method_10577("yttr:InvisibleFromDiving");
        this.yttr$isNoGravityFromDiving = nbt.method_10577("yttr:NoGravityFromDiving");
        this.yttr$divePos = Vec2i.fromTag(nbt.method_10580("yttr:DivePos"));
        this.yttr$fastDiveTarget = nbt.method_10573("yttr:FastDiveTarget", 10) ? class_2512.method_10691((class_2487)nbt.method_10562("yttr:FastDiveTarget")) : null;
        this.yttr$fastDiveTime = nbt.method_10550("yttr:FastDiveTime");
        this.yttr$knownGeysers.clear();
        class_2499 li = nbt.method_10554("yttr:KnownGeysers", 11);
        for (int i = 0; i < li.size(); ++i) {
            this.yttr$knownGeysers.add(class_2512.method_25930((class_2520)li.method_10534(i)));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"copyFrom"})
    public void copyFrom(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        if (oldPlayer instanceof DiverPlayer) {
            this.yttr$knownGeysers.addAll(((DiverPlayer)oldPlayer).yttr$getKnownGeysers());
        }
    }

    @Override
    public boolean yttr$isDiving() {
        return this.yttr$isDiving;
    }

    @Override
    public void yttr$setDiving(boolean b) {
        this.yttr$isDiving = b;
    }

    @Override
    public boolean yttr$isInvisibleFromDiving() {
        return this.yttr$isInvisibleFromDiving;
    }

    @Override
    public boolean yttr$isNoGravityFromDiving() {
        return this.yttr$isNoGravityFromDiving;
    }

    @Override
    public Set<UUID> yttr$getKnownGeysers() {
        return this.yttr$knownGeysers;
    }

    @Override
    public int yttr$getLastDivePosUpdate() {
        return this.yttr$lastDivePosUpdate;
    }

    @Override
    public void yttr$setLastDivePosUpdate(int i) {
        this.yttr$lastDivePosUpdate = i;
    }

    @Override
    @Nullable
    public Vec2i yttr$getDivePos() {
        return this.yttr$divePos;
    }

    @Override
    public void yttr$setDivePos(@Nullable Vec2i v) {
        this.yttr$divePos = v;
    }

    @Override
    public int yttr$getFastDiveTime() {
        return this.yttr$fastDiveTime;
    }

    @Override
    public void yttr$setFastDiveTime(int i) {
        this.yttr$fastDiveTime = i;
    }

    @Override
    @Nullable
    public class_2338 yttr$getFastDiveTarget() {
        return this.yttr$fastDiveTarget;
    }

    @Override
    public void yttr$setFastDiveTarget(@Nullable class_2338 g) {
        this.yttr$fastDiveTarget = g;
    }
}

