/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.mechanics.rifle;

import com.google.common.collect.ImmutableList;
import com.unascribed.yttr.YConfig;
import com.unascribed.yttr.content.entity.RifleDummyEntity;
import com.unascribed.yttr.content.item.RifleItem;
import com.unascribed.yttr.init.YBlocks;
import com.unascribed.yttr.init.YItems;
import com.unascribed.yttr.init.YTags;
import com.unascribed.yttr.mechanics.VoidLogic;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1284;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RifleMode {
    DAMAGE(class_124.field_1061, 0xFF0000, () -> class_1802.field_8725, 12, 2.0f){

        @Override
        public void handleFire(class_1309 user, class_1799 stack, float power, class_239 hit) {
            if (hit instanceof class_3966) {
                int damage = (int)Math.ceil(power * 14.0f);
                ((class_3966)hit).method_17782().method_5643((class_1282)new class_1284("yttr.rifle", (class_1297)new RifleDummyEntity(user.field_6002), (class_1297)user), (float)damage);
            }
            if (power > 1.2f) {
                user.field_6002.method_8454(null, class_1282.method_5512((class_1309)user), null, hit.method_17784().field_1352, hit.method_17784().field_1351, hit.method_17784().field_1350, 2.0f * power, false, class_1927.class_4179.field_18685);
            }
        }
    }
    ,
    EXPLODE(class_124.field_1080, 0xAAAAAA, () -> class_1802.field_8054, 1, 1.0f){

        @Override
        public void handleFire(class_1309 user, class_1799 stack, float power, class_239 hit) {
            user.field_6002.method_8454(null, class_1282.method_5512((class_1309)user), null, hit.method_17784().field_1352, hit.method_17784().field_1351, hit.method_17784().field_1350, (double)power > 1.2 ? 5.0f : 3.0f * power, (double)power > 1.2, YConfig.Rifle.allowExplode == YConfig.TrileanSoft.SOFT ? class_1927.class_4179.field_18685 : ((double)power > 1.2 ? class_1927.class_4179.field_18687 : class_1927.class_4179.field_18686));
        }

        @Override
        public void handleBackfire(class_1309 user, class_1799 stack) {
            user.field_6002.method_8454(null, class_1282.method_5512((class_1309)user), null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, 5.5f, false, YConfig.Rifle.allowExplode == YConfig.TrileanSoft.SOFT ? class_1927.class_4179.field_18685 : class_1927.class_4179.field_18687);
        }

        @Override
        public boolean isEnabled() {
            return YConfig.Rifle.allowExplode != YConfig.TrileanSoft.OFF;
        }
    }
    ,
    TELEPORT(class_124.field_1076, 0xFF00FF, () -> class_1802.field_8233, 3, 1.5f){

        @Override
        public void handleFire(class_1309 user, class_1799 stack, float power, class_239 hit) {
            if (hit.method_17783() == class_239.class_240.field_1333) {
                return;
            }
            if (power > 1.1f) {
                user.field_6002.method_8437((class_1297)user, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, 1.0f * power, class_1927.class_4179.field_18685);
            }
            user.method_20620(hit.method_17784().field_1352, hit.method_17784().field_1351, hit.method_17784().field_1350);
            if (power > 1.2f) {
                user.method_5643(class_1282.method_5512((class_1309)user), 4.0f);
                user.field_6002.method_8437((class_1297)user, hit.method_17784().field_1352, hit.method_17784().field_1351, hit.method_17784().field_1350, 2.0f * power, class_1927.class_4179.field_18685);
            }
        }

        @Override
        public boolean canFire(class_1309 user, class_1799 stack, float power) {
            return power >= 0.8f;
        }

        @Override
        public void handleBackfire(class_1309 user, class_1799 stack) {
            for (int i = 0; i < 4; ++i) {
                class_1802.field_8233.method_7861(new class_1799((class_1935)class_1802.field_8233), user.field_6002, user);
            }
        }
    }
    ,
    FIRE(class_124.field_1065, 0xFFAA00, () -> class_1802.field_8183, 2, 2.0f){

        @Override
        public void handleFire(class_1309 user, class_1799 stack, float power, class_239 hit) {
            if (hit instanceof class_3966) {
                class_1297 e = ((class_3966)hit).method_17782();
                e.method_20803((int)(200.0f * power));
                int damage = (int)Math.ceil(power * 6.0f);
                e.method_5643((class_1282)new class_1284("yttr.rifle", (class_1297)new RifleDummyEntity(user.field_6002), (class_1297)user), (float)damage);
            } else if (power > 0.5f && hit instanceof class_3965) {
                class_3965 bhr = (class_3965)hit;
                if (bhr.method_17783() == class_239.class_240.field_1333) {
                    return;
                }
                if (user.field_6002.method_22347(bhr.method_17777()) || user.field_6002.method_8320(bhr.method_17777()).method_26164(YTags.Block.FIRE_MODE_INSTABREAK)) {
                    user.field_6002.method_8501(bhr.method_17777(), class_2246.field_10036.method_9564());
                } else {
                    class_2338 bp2 = bhr.method_17777().method_10093(bhr.method_17780());
                    if (user.field_6002.method_22347(bp2)) {
                        user.field_6002.method_8501(bp2, class_2246.field_10036.method_9564());
                    }
                }
            }
            if (power > 1.0f) {
                user.field_6002.method_8454(null, class_1282.method_5512((class_1309)user), null, hit.method_17784().field_1352, hit.method_17784().field_1351, hit.method_17784().field_1350, 2.0f * power, true, class_1927.class_4179.field_18685);
                class_2338 base = new class_2338(hit.method_17784());
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            class_2338 bp = base.method_10069(x, y, z);
                            if (!user.field_6002.method_8320(bp).method_26164(YTags.Block.FIRE_MODE_INSTABREAK)) continue;
                            user.field_6002.method_8501(bp, class_2246.field_10036.method_9564());
                        }
                    }
                }
            }
        }

        @Override
        public void handleBackfire(class_1309 user, class_1799 stack) {
            user.method_5639(20);
        }

        @Override
        public boolean isEnabled() {
            return YConfig.Rifle.allowFire;
        }
    }
    ,
    VOID(class_124.field_1074, 0, () -> YItems.VOID_BUCKET, 1, 0.75f){

        @Override
        public void handleFire(class_1309 user, class_1799 stack, float power, class_239 hit) {
            if (!(user instanceof class_1657)) {
                return;
            }
            VoidLogic.doVoid((class_1657)user, user.field_6002, hit.method_17784(), Math.round(7.5f * power) + 1);
        }

        @Override
        public void handleBackfire(class_1309 user, class_1799 stack) {
            if (!(user instanceof class_1657)) {
                return;
            }
            VoidLogic.doVoid((class_1657)user, user.field_6002, user.method_19538(), 12);
        }

        @Override
        public boolean isEnabled() {
            return YConfig.Rifle.allowVoid;
        }
    }
    ,
    LIGHT(class_124.field_1054, 0xFFFF00, () -> class_1802.field_8601, 8, 2.0f){

        @Override
        public void handleFire(class_1309 user, class_1799 stack, float power, class_239 hit) {
            class_243 start = RifleItem.getMuzzlePos((class_1297)user, false);
            double len = Math.sqrt(start.method_1025(hit.method_17784()));
            double diffX = hit.method_17784().field_1352 - start.field_1352;
            double diffY = hit.method_17784().field_1351 - start.field_1351;
            double diffZ = hit.method_17784().field_1350 - start.field_1350;
            class_2338.class_2339 mut = new class_2338.class_2339();
            int count = (int)(len * 4.0);
            for (int i = 0; i < count; ++i) {
                double t = (double)i / (double)count;
                double x = start.field_1352 + diffX * t;
                double y = start.field_1351 + diffY * t;
                double z = start.field_1350 + diffZ * t;
                mut.method_10102(x, y, z);
                this.illuminate(user.field_6002, (class_2338)mut, power > 1.1f);
            }
            if (hit instanceof class_3966) {
                class_1297 e = ((class_3966)hit).method_17782();
                if (e instanceof class_1309) {
                    ((class_1309)e).method_6092(new class_1293(class_1294.field_5912, (int)(200.0f * power)));
                }
            } else if (hit instanceof class_3965 && power > 0.8f) {
                class_3965 bhr = (class_3965)hit;
                class_2338 end = bhr.method_17777().method_10093(bhr.method_17780());
                this.illuminate(user.field_6002, end, true);
            }
        }

        @Override
        public void handleBackfire(class_1309 user, class_1799 stack) {
            user.method_6092(new class_1293(class_1294.field_5912, 300));
            for (class_2338 bp : class_2338.method_10097((class_2338)user.method_24515().method_10069(-2, -2, -2), (class_2338)user.method_24515().method_10069(2, 2, 2))) {
                this.illuminate(user.field_6002, bp, false);
            }
        }

        private void illuminate(class_1937 world, class_2338 bp, boolean permanent) {
            class_2680 bs = world.method_8320(bp);
            if (bs.method_26215()) {
                world.method_8501(bp, (permanent ? YBlocks.PERMANENT_LIGHT_AIR : YBlocks.TEMPORARY_LIGHT_AIR).method_9564());
            } else if (bs.method_27852(class_2246.field_10382) || bs.method_27852((class_2248)YBlocks.TEMPORARY_LIGHT_WATER)) {
                class_2680 nbs = (permanent ? YBlocks.PERMANENT_LIGHT_WATER : YBlocks.TEMPORARY_LIGHT_WATER).method_9564();
                nbs = (class_2680)nbs.method_11657((class_2769)class_2404.field_11278, (Comparable)((Integer)bs.method_11654((class_2769)class_2404.field_11278)));
                world.method_8501(bp, nbs);
            }
        }
    };

    public static final ImmutableList<RifleMode> VALUES;
    public static final ImmutableList<RifleMode> ALL_VALUES;
    public final class_124 chatColor;
    public final int color;
    public final Supplier<class_1935> item;
    public final int shotsPerItem;
    public final float speed;
    private int effectiveOrdinal = -1;

    private RifleMode(class_124 chatColor, int color, Supplier<class_1935> item, int shotsPerItem, float speed) {
        this.chatColor = chatColor;
        this.color = color;
        this.item = item;
        this.shotsPerItem = shotsPerItem;
        this.speed = speed;
    }

    public boolean canFire(class_1309 user, class_1799 stack, float power) {
        return power > 0.0f;
    }

    public int effectiveOrdinal() {
        return this.effectiveOrdinal;
    }

    public abstract void handleFire(class_1309 var1, class_1799 var2, float var3, class_239 var4);

    public void handleBackfire(class_1309 user, class_1799 stack) {
    }

    public boolean isEnabled() {
        return true;
    }

    public RifleMode next() {
        if (!VALUES.contains((Object)this)) {
            return (RifleMode)((Object)VALUES.get(0));
        }
        return (RifleMode)((Object)VALUES.get((VALUES.indexOf((Object)this) + 1) % VALUES.size()));
    }

    public RifleMode prev() {
        if (!VALUES.contains((Object)this)) {
            return (RifleMode)((Object)VALUES.get(0));
        }
        int idx = VALUES.indexOf((Object)this);
        if (idx == 0) {
            return (RifleMode)((Object)VALUES.get(VALUES.size() - 1));
        }
        return (RifleMode)((Object)VALUES.get(idx - 1));
    }

    static {
        VALUES = (ImmutableList)Arrays.stream(RifleMode.values()).filter(RifleMode::isEnabled).collect(ImmutableList.toImmutableList());
        ALL_VALUES = ImmutableList.copyOf((Object[])RifleMode.values());
        for (int i = 0; i < VALUES.size(); ++i) {
            ((RifleMode)((Object)RifleMode.VALUES.get((int)i))).effectiveOrdinal = i;
        }
    }
}

