/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.mechanics;

import com.google.common.collect.ImmutableList;
import net.minecraft.class_1282;
import net.minecraft.class_3222;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SuitResource {
    FUEL{

        @Override
        public int getConsumptionPerBlock(int pressure) {
            return 5;
        }

        @Override
        public int getConsumptionPerTick(int pressure) {
            return 0;
        }

        @Override
        public int getMaximum() {
            return 40000;
        }

        @Override
        public int getSpeedDivider(boolean depleted) {
            return depleted ? 4 : 1;
        }
    }
    ,
    OXYGEN{
        private final class_1282 SUFFOCATION = new class_1282("yttr.suit_suffocation"){
            {
                this.method_5509();
                this.method_5508();
            }
        };

        @Override
        public int getConsumptionPerBlock(int pressure) {
            return 2 * ((pressure + 699) / 700);
        }

        @Override
        public int getConsumptionPerTick(int pressure) {
            return 5 * ((pressure + 699) / 700);
        }

        @Override
        public int getMaximum() {
            return 80000;
        }

        @Override
        public void applyDepletedEffect(class_3222 player) {
            if (player.field_6012 % 10 == 0) {
                player.method_5643(this.SUFFOCATION, 1.0f);
            }
        }
    }
    ,
    INTEGRITY{
        private final class_1282 INTEGRITY_FAILURE = new class_1282("yttr.suit_integrity_failure"){
            {
                this.method_5509();
                this.method_5508();
                this.method_5505();
            }
        };

        @Override
        public int getConsumptionPerBlock(int pressure) {
            return 0;
        }

        @Override
        public int getConsumptionPerTick(int pressure) {
            if (pressure < 200) {
                return 0;
            }
            return pressure / 70;
        }

        @Override
        public int getMaximum() {
            return 60000;
        }

        @Override
        public int getDefaultAmount() {
            return this.getMaximum();
        }

        @Override
        public void applyDepletedEffect(class_3222 player) {
            player.method_5643(this.INTEGRITY_FAILURE, player.method_6032() * 6.0f);
        }
    };

    public static final ImmutableList<SuitResource> VALUES;

    public abstract int getConsumptionPerTick(int var1);

    public abstract int getConsumptionPerBlock(int var1);

    public abstract int getMaximum();

    public int getDefaultAmount() {
        return 0;
    }

    public void applyDepletedEffect(class_3222 player) {
    }

    public int getSpeedDivider(boolean depleted) {
        return 1;
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])SuitResource.values());
    }
}

