/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.mechanics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.unascribed.yttr.util.Resolvable;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Nullable;

public enum LampColor implements class_3542
{
    WHITE(class_1767.field_7952),
    ORANGE(class_1767.field_7946),
    MAGENTA(class_1767.field_7958),
    LIGHT_BLUE(class_1767.field_7951),
    YELLOW(class_1767.field_7947),
    LIME(class_1767.field_7961),
    PINK(class_1767.field_7954),
    GRAY(class_1767.field_7944),
    LIGHT_GRAY(class_1767.field_7967),
    CYAN(class_1767.field_7955),
    PURPLE(class_1767.field_7945),
    BLUE(class_1767.field_7966),
    BROWN(class_1767.field_7957),
    GREEN(class_1767.field_7942),
    RED(class_1767.field_7964),
    BLACK(class_1767.field_7963, 0x222222),
    TEAL("yttr:yttrium_dust", 1752218, 56205),
    COLORLESS(16774112, 16758605);

    public static final ImmutableList<LampColor> VALUES;
    public static final ImmutableMap<class_1767, LampColor> BY_DYE;
    public static final ImmutableMap<Resolvable<class_1792>, LampColor> BY_ITEM;
    @Nullable
    public final class_1767 dyeColor;
    @Nullable
    public final Resolvable<class_1792> item;
    public final int baseLitColor;
    public final int baseUnlitColor;
    public final int glowColor;
    private final String lowerName;

    private LampColor(class_1767 inherit) {
        this(inherit, inherit.method_16357());
    }

    private LampColor(class_1767 inherit, int glowColor) {
        this(inherit, null, LampColor.packColor(inherit.method_7787()), glowColor);
    }

    private static int packColor(float[] colorComponents) {
        int a = 255;
        int r = (int)(colorComponents[0] * 255.0f) & 0xFF;
        int g = (int)(colorComponents[1] * 255.0f) & 0xFF;
        int b = (int)(colorComponents[2] * 255.0f) & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    private LampColor(String item, int baseColor, int glowColor) {
        this(null, item, baseColor, glowColor);
    }

    private LampColor(int baseColor, int glowColor) {
        this(null, null, baseColor, glowColor);
    }

    private LampColor(class_1767 dyeColor, String item, int baseColor, int glowColor) {
        this.dyeColor = dyeColor;
        this.item = item == null ? null : Resolvable.of(new class_2960(item), class_2378.field_11142);
        this.baseLitColor = baseColor;
        this.glowColor = glowColor;
        int r = baseColor >> 16 & 0xFF;
        int g = baseColor >> 8 & 0xFF;
        int b = baseColor & 0xFF;
        this.baseUnlitColor = (r /= 2) << 16 | (g /= 2) << 8 | (b /= 2);
        this.lowerName = this.name().toLowerCase(Locale.ROOT);
    }

    public String method_15434() {
        return this.lowerName;
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])LampColor.values());
        BY_DYE = ImmutableMap.copyOf((Iterable)VALUES.stream().filter(lc -> lc.dyeColor != null).map(lc -> Maps.immutableEntry((Object)lc.dyeColor, (Object)lc)).collect(Collectors.toList()));
        BY_ITEM = ImmutableMap.copyOf((Iterable)VALUES.stream().filter(lc -> lc.item != null).map(lc -> Maps.immutableEntry(lc.item, (Object)lc)).collect(Collectors.toList()));
    }
}

