/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.inred;

import com.unascribed.yttr.init.YBlocks;
import com.unascribed.yttr.inred.InRedDevice;
import com.unascribed.yttr.inred.InRedProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public class InRedLogic {
    public static final int MAX_SIGNAL = 63;
    private static final int INTER_IR_TICKS = 1;
    public static int tickCount = 0;
    private static final class_2350[] PLANAR_FACINGS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};

    public static void onServerTick() {
        if (++tickCount > 1) {
            tickCount = 0;
        }
    }

    public static boolean isIRTick() {
        return tickCount == 0;
    }

    public static int findIRValue(class_1937 world, class_2338 devicePos, class_2350 dir) {
        InRedDevice device;
        class_2338 initialPos = devicePos.method_10093(dir);
        if (!InRedLogic.checkCandidacy(world, initialPos, dir.method_10153())) {
            class_2338 up = initialPos.method_10084();
            if (InRedLogic.checkCandidacy(world, up, dir.method_10153()) && world.method_8320(up).method_26204() != YBlocks.INRED_SCAFFOLD) {
                initialPos = up;
            } else {
                class_2338 down = initialPos.method_10074();
                if (InRedLogic.checkCandidacy(world, down, dir.method_10153()) && world.method_8320(down).method_26204() != YBlocks.INRED_SCAFFOLD) {
                    initialPos = down;
                } else {
                    return world.method_8499(initialPos, dir) != 0 ? 1 : 0;
                }
            }
        }
        if (world.method_22347(initialPos)) {
            return 0;
        }
        class_2680 initialState = world.method_8320(initialPos);
        if (initialState.method_26204() == YBlocks.INRED_CABLE || initialState.method_26204() == YBlocks.INRED_SCAFFOLD) {
            return InRedLogic.wireSearch(world, devicePos, dir);
        }
        if (initialState.method_26204() instanceof InRedProvider && (device = ((InRedProvider)initialState.method_26204()).getDevice((class_1922)world, initialPos, initialState, dir.method_10153())) != null) {
            return device.getSignalValue();
        }
        return world.method_8499(initialPos, dir) != 0 ? 1 : 0;
    }

    public static boolean checkCandidacy(class_1937 world, class_2338 pos, class_2350 side) {
        if (world.method_22347(pos)) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() == YBlocks.INRED_CABLE || state.method_26204() == YBlocks.INRED_SCAFFOLD) {
            return true;
        }
        if (state.method_26204() instanceof InRedProvider) {
            return ((InRedProvider)state.method_26204()).getDevice((class_1922)world, pos, state, side) != null;
        }
        return false;
    }

    public static boolean canConnect(class_1922 world, class_2338 pos, class_2350 from) {
        if (world.method_8320(pos).method_26215()) {
            return false;
        }
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block == YBlocks.INRED_CABLE || block == YBlocks.INRED_SCAFFOLD) {
            return true;
        }
        if (block instanceof InRedProvider) {
            return ((InRedProvider)block).getDevice(world, pos, state, from) != null;
        }
        return false;
    }

    public static boolean isSideSolid(class_1922 world, class_2338 pos, class_2350 dir) {
        return class_2248.method_9501((class_265)world.method_8320(pos).method_26218(world, pos), (class_2350)dir);
    }

    private static int wireSearch(class_1937 world, class_2338 device, class_2350 dir) {
        int depth = 0;
        HashSet<Endpoint> rejected = new HashSet<Endpoint>();
        HashSet<class_2338> traversed = new HashSet<class_2338>();
        ArrayList<Endpoint> members = new ArrayList<Endpoint>();
        ArrayList<Endpoint> queue = new ArrayList<Endpoint>();
        ArrayList<Endpoint> next = new ArrayList<Endpoint>();
        queue.add(new Endpoint(device.method_10093(dir), dir.method_10153()));
        if (device.method_10264() < 255 && !InRedLogic.isSideSolid((class_1922)world, device.method_10093(class_2350.field_11036), class_2350.field_11033)) {
            queue.add(new Endpoint(device.method_10093(dir).method_10084(), dir.method_10153()));
        }
        if (device.method_10264() > 0 && !InRedLogic.isSideSolid((class_1922)world, device.method_10093(dir), dir.method_10153())) {
            queue.add(new Endpoint(device.method_10093(dir).method_10074(), dir.method_10153()));
        }
        while (!queue.isEmpty() || !next.isEmpty()) {
            if (queue.isEmpty()) {
                if (++depth > 63) {
                    return 0;
                }
                queue.addAll(next);
                next.clear();
            }
            Endpoint cur = (Endpoint)queue.remove(0);
            if (world.method_22347(cur.pos)) continue;
            class_2680 state = world.method_8320(cur.pos);
            class_2248 block = state.method_26204();
            if (block == YBlocks.INRED_CABLE || block == YBlocks.INRED_SCAFFOLD) {
                class_2338 offset;
                traversed.add(cur.pos);
                if (block == YBlocks.INRED_CABLE) {
                    for (class_2350 facing : PLANAR_FACINGS) {
                        offset = cur.pos.method_10093(facing);
                        if (offset.method_10264() < 255 && !InRedLogic.isSideSolid((class_1922)world, cur.pos.method_10084(), class_2350.field_11033)) {
                            InRedLogic.checkAdd(new Endpoint(offset.method_10084(), facing.method_10153()), next, traversed, rejected);
                        }
                        if (offset.method_10264() > 0 && !InRedLogic.isSideSolid((class_1922)world, offset, facing.method_10153()) && InRedLogic.specialCaseWire(world, offset.method_10074())) {
                            InRedLogic.checkAdd(new Endpoint(offset.method_10074(), facing.method_10153()), next, traversed, rejected);
                        }
                        if (facing == cur.facing) continue;
                        InRedLogic.checkAdd(new Endpoint(offset, facing.method_10153()), next, traversed, rejected);
                    }
                    continue;
                }
                if (block != YBlocks.INRED_SCAFFOLD) continue;
                for (class_2350 facing : class_2350.values()) {
                    class_2338 specialCase;
                    offset = cur.pos.method_10093(facing);
                    if (offset.method_10264() < 0 || offset.method_10264() > 255) continue;
                    InRedLogic.checkAdd(new Endpoint(offset, facing.method_10153()), next, traversed, rejected);
                    if (facing == class_2350.field_11036 || facing == class_2350.field_11033 || (specialCase = offset.method_10074()).method_10264() < 0 || world.method_8320(specialCase).method_26204() != YBlocks.INRED_CABLE) continue;
                    InRedLogic.checkAdd(new Endpoint(specialCase, facing.method_10153()), next, traversed, rejected);
                }
                continue;
            }
            Integer rightHere = InRedLogic.valueDirectlyAt(world, cur.pos, cur.facing);
            if (rightHere == null) continue;
            members.add(cur);
            rejected.add(cur);
        }
        int result = 0;
        for (Endpoint cur : members) {
            int val = InRedLogic.valueDirectlyAt(world, cur.pos, cur.facing);
            result |= val;
        }
        return result;
    }

    private static boolean specialCaseWire(class_1937 world, class_2338 target) {
        return world.method_8320(target).method_26204() != YBlocks.INRED_BLOCK && world.method_8320(target).method_26204() != YBlocks.INRED_SCAFFOLD;
    }

    private static void checkAdd(Endpoint endpoint, List<Endpoint> next, Set<class_2338> traversed, Set<Endpoint> rejected) {
        if (traversed.contains(endpoint.pos)) {
            return;
        }
        if (rejected.contains(endpoint)) {
            return;
        }
        next.add(endpoint);
    }

    public static Integer valueDirectlyAt(class_1937 world, class_2338 pos, class_2350 dir) {
        InRedDevice comp;
        if (world.method_22347(pos)) {
            return null;
        }
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block == YBlocks.INRED_CABLE || block == YBlocks.INRED_SCAFFOLD) {
            return null;
        }
        if (block instanceof InRedProvider && (comp = ((InRedProvider)block).getDevice((class_1922)world, pos, state, dir)) != null) {
            return comp.getSignalValue();
        }
        return null;
    }

    private static class Endpoint {
        class_2338 pos;
        class_2350 facing;

        public Endpoint(class_2338 pos, class_2350 facing) {
            this.pos = pos;
            this.facing = facing;
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.facing);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Endpoint)) {
                return false;
            }
            Endpoint otherEnd = (Endpoint)other;
            return Objects.equals(this.pos, otherEnd.pos) && Objects.equals(this.facing, otherEnd.facing);
        }

        public String toString() {
            return "{x:" + this.pos.method_10263() + ", y:" + this.pos.method_10264() + ", z:" + this.pos.method_10260() + ", dir:" + this.facing + "}";
        }
    }
}

