/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.crafting.ingredient;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class FluidIngredient
implements Predicate<class_3611> {
    private final Set<class_3611> exacts = Sets.newHashSet();
    private final Set<class_6862<class_3611>> tags = Sets.newHashSet();

    private FluidIngredient() {
    }

    @Override
    public boolean test(class_3611 b) {
        if (this.exacts.contains(b)) {
            return true;
        }
        for (class_6862<class_3611> tag : this.tags) {
            if (!b.method_15791(tag)) continue;
            return true;
        }
        return false;
    }

    public List<class_3611> getMatchingFluids() {
        ArrayList li = Lists.newArrayList();
        li.addAll(this.exacts);
        for (class_6862<class_3611> tag : this.tags) {
            for (class_6880 fluid : class_2378.field_11154.method_40286(tag)) {
                li.add((class_3611)fluid.comp_349());
            }
        }
        return li;
    }

    public void write(class_2540 out) {
        List<class_3611> all = this.getMatchingFluids();
        out.method_10804(all.size());
        for (class_3611 f : all) {
            out.method_10804(class_2378.field_11154.method_10206((Object)f));
        }
    }

    public static FluidIngredient read(class_2540 in) {
        int amt = in.method_10816();
        FluidIngredient out = new FluidIngredient();
        for (int i = 0; i < amt; ++i) {
            out.exacts.add((class_3611)class_2378.field_11154.method_10200(in.method_10816()));
        }
        return out;
    }

    public static FluidIngredient fromJson(JsonElement ele) {
        FluidIngredient out = new FluidIngredient();
        if (ele.isJsonArray()) {
            for (JsonElement child : ele.getAsJsonArray()) {
                FluidIngredient.readInto(out, child);
            }
        } else {
            FluidIngredient.readInto(out, ele);
        }
        return out;
    }

    private static void readInto(FluidIngredient out, JsonElement ele) {
        if (!ele.isJsonObject()) {
            throw new IllegalArgumentException("Expected object, got " + ele);
        }
        JsonObject obj = ele.getAsJsonObject();
        if (obj.has("fluid")) {
            out.exacts.add((class_3611)class_2378.field_11154.method_10223(class_2960.method_12829((String)obj.get("fluid").getAsString())));
        } else if (obj.has("tag")) {
            out.tags.add((class_6862<class_3611>)class_6862.method_40092((class_5321)class_2378.field_25103, (class_2960)class_2960.method_12829((String)obj.get("tag").getAsString())));
        } else {
            throw new IllegalArgumentException("Don't know how to parse " + ele + " without a fluid or tag value");
        }
    }
}

