/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.crafting.ingredient;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;

public class BlockIngredient
implements Predicate<class_2248> {
    private final Set<class_2248> exacts = Sets.newHashSet();
    private final Set<class_6862<class_2248>> tags = Sets.newHashSet();

    private BlockIngredient() {
    }

    @Override
    public boolean test(class_2248 b) {
        if (this.exacts.contains(b)) {
            return true;
        }
        for (class_6862<class_2248> tag : this.tags) {
            if (!b.method_40142().method_40220(tag)) continue;
            return true;
        }
        return false;
    }

    public List<class_2248> getMatchingBlocks() {
        ArrayList li = Lists.newArrayList();
        li.addAll(this.exacts);
        for (class_6862<class_2248> tag : this.tags) {
            for (class_6880 block : class_2378.field_11146.method_40286(tag)) {
                li.add((class_2248)block.comp_349());
            }
        }
        return li;
    }

    public void write(class_2540 out) {
        List<class_2248> all = this.getMatchingBlocks();
        out.method_10804(all.size());
        for (class_2248 b : all) {
            out.method_10804(class_2378.field_11146.method_10206((Object)b));
        }
    }

    public static BlockIngredient read(class_2540 in) {
        int amt = in.method_10816();
        BlockIngredient out = new BlockIngredient();
        for (int i = 0; i < amt; ++i) {
            out.exacts.add((class_2248)class_2378.field_11146.method_10200(in.method_10816()));
        }
        return out;
    }

    public static BlockIngredient fromJson(JsonElement ele) {
        BlockIngredient out = new BlockIngredient();
        if (ele.isJsonArray()) {
            for (JsonElement child : ele.getAsJsonArray()) {
                BlockIngredient.readInto(out, child);
            }
        } else {
            BlockIngredient.readInto(out, ele);
        }
        return out;
    }

    private static void readInto(BlockIngredient out, JsonElement ele) {
        if (!ele.isJsonObject()) {
            throw new IllegalArgumentException("Expected object, got " + ele);
        }
        JsonObject obj = ele.getAsJsonObject();
        if (obj.has("block")) {
            out.exacts.add((class_2248)class_2378.field_11146.method_10223(class_2960.method_12829((String)obj.get("block").getAsString())));
        } else if (obj.has("tag")) {
            out.tags.add((class_6862<class_2248>)class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)class_2960.method_12829((String)obj.get("tag").getAsString())));
        } else {
            throw new IllegalArgumentException("Don't know how to parse " + ele + " without a block or tag value");
        }
    }
}

