/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.unascribed.yttr.content.block.decor.LampBlock;
import com.unascribed.yttr.content.item.block.LampBlockItem;
import com.unascribed.yttr.init.YItems;
import com.unascribed.yttr.init.YRecipeSerializers;
import com.unascribed.yttr.mechanics.LampColor;
import com.unascribed.yttr.mixin.accessor.AccessorShapedRecipe;
import com.unascribed.yttr.util.Resolvable;
import java.util.List;
import net.minecraft.class_1715;
import net.minecraft.class_1747;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class LampRecipe
extends class_1869 {
    private final List<String> stripTags = Lists.newArrayList();
    private boolean misc;
    private boolean important;

    public LampRecipe(class_2960 id, String group, int width, int height, class_2371<class_1856> ingredients, class_1799 output) {
        super(id, group, width, height, ingredients, output);
    }

    public LampRecipe(class_1869 copy) {
        this(copy.method_8114(), ((AccessorShapedRecipe)copy).yttr$getGroup(), copy.method_8150(), copy.method_8158(), (class_2371<class_1856>)copy.method_8117(), copy.method_8110());
    }

    public boolean method_17728(class_1715 inv, class_1937 world) {
        return super.method_17728(inv, world) && !this.method_17727(inv).method_7960();
    }

    public boolean method_8118() {
        return !this.important;
    }

    public int getPriority() {
        if (this.important) {
            return this.misc ? 2 : 3;
        }
        return this.misc ? 0 : 1;
    }

    public class_1799 method_17727(class_1715 inv) {
        class_1799 stack = this.method_8110().method_7972();
        boolean containsTorch = false;
        Boolean inputLampInverted = null;
        LampColor inputLampColor = null;
        LampColor color = null;
        for (int i = 0; i < inv.method_5439(); ++i) {
            LampColor thisColor;
            class_1799 in = inv.method_5438(i);
            if (in.method_7909() == class_1802.field_8530) {
                containsTorch = true;
                continue;
            }
            if (in.method_7909() instanceof class_1747 && ((class_1747)in.method_7909()).method_7711() instanceof LampBlock) {
                boolean thisInverted = LampBlockItem.isInverted(in);
                thisColor = LampBlockItem.getColor(in);
                if (inputLampInverted != null && inputLampInverted != thisInverted) {
                    return class_1799.field_8037;
                }
                if (inputLampColor != null && inputLampColor != thisColor) {
                    return class_1799.field_8037;
                }
                inputLampColor = thisColor;
                inputLampInverted = thisInverted;
                continue;
            }
            class_1792 item = in.method_7909();
            thisColor = null;
            thisColor = item instanceof class_1769 ? (LampColor)((Object)LampColor.BY_DYE.get((Object)((class_1769)item).method_7802())) : (LampColor)((Object)LampColor.BY_ITEM.get(Resolvable.mapKey(item, class_2378.field_11142)));
            if (color != null && color != thisColor) {
                return class_1799.field_8037;
            }
            if (thisColor == null) continue;
            color = thisColor;
        }
        if (stack.method_7909() != YItems.LAZOR_EMITTER) {
            LampBlockItem.setInverted(stack, inputLampInverted == null ? containsTorch : inputLampInverted ^ containsTorch);
        }
        LampBlockItem.setColor(stack, color == null ? (inputLampColor == null ? LampColor.COLORLESS : inputLampColor) : color);
        for (String s : this.stripTags) {
            stack.method_7969().method_10551(s);
        }
        return stack;
    }

    public void addStripTag(String tag) {
        this.stripTags.add(tag);
    }

    public List<String> getStripTags() {
        return this.stripTags;
    }

    public boolean isMisc() {
        return this.misc;
    }

    public void setMisc(boolean misc) {
        this.misc = misc;
    }

    public boolean isImportant() {
        return this.important;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    public class_1865<?> method_8119() {
        return YRecipeSerializers.LAMP_CRAFTING;
    }

    public static class Serializer
    extends class_1869.class_1870 {
        public class_1869 method_8164(class_2960 identifier, JsonObject jsonObject) {
            LampRecipe lr = new LampRecipe(super.method_8164(identifier, jsonObject));
            if (jsonObject.has("yttr:strip_tags")) {
                for (JsonElement je : jsonObject.get("yttr:strip_tags").getAsJsonArray()) {
                    lr.addStripTag(je.getAsString());
                }
            }
            if (jsonObject.has("yttr:misc")) {
                lr.setMisc(jsonObject.get("yttr:misc").getAsBoolean());
            }
            if (jsonObject.has("yttr:important")) {
                lr.setImportant(jsonObject.get("yttr:important").getAsBoolean());
            }
            return lr;
        }

        public class_1869 method_8163(class_2960 identifier, class_2540 packetByteBuf) {
            LampRecipe lr = new LampRecipe(super.method_8163(identifier, packetByteBuf));
            if (packetByteBuf.isReadable()) {
                int count = packetByteBuf.method_10816();
                for (int i = 0; i < count; ++i) {
                    lr.addStripTag(packetByteBuf.method_10800(Short.MAX_VALUE));
                }
                lr.setMisc(packetByteBuf.readBoolean());
                lr.setImportant(packetByteBuf.readBoolean());
            }
            return lr;
        }

        public void method_8165(class_2540 packetByteBuf, class_1869 shapedRecipe) {
            super.method_8165(packetByteBuf, shapedRecipe);
            if (shapedRecipe instanceof LampRecipe) {
                LampRecipe lr = (LampRecipe)shapedRecipe;
                packetByteBuf.method_10804(lr.getStripTags().size());
                for (String tag : lr.getStripTags()) {
                    packetByteBuf.method_10814(tag);
                }
                packetByteBuf.writeBoolean(lr.isMisc());
                packetByteBuf.writeBoolean(lr.isImportant());
            }
        }
    }
}

