/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.crafting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.unascribed.yttr.init.YRecipeSerializers;
import com.unascribed.yttr.init.YRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;

public class CentrifugingRecipe
implements class_1860<class_1263> {
    protected final class_2960 id;
    protected final String group;
    protected final class_1856 input;
    protected final int inputCount;
    protected final ImmutableList<class_1799> outputs;
    protected final int spinTime;

    public CentrifugingRecipe(class_2960 id, String group, class_1856 input, int inputCount, List<class_1799> outputs, int spinTime) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.inputCount = inputCount;
        this.outputs = ImmutableList.copyOf(outputs);
        this.spinTime = spinTime;
    }

    public class_1856 getInput() {
        return this.input;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public boolean method_8115(class_1263 inv, class_1937 world) {
        return this.input.method_8093(inv.method_5438(0)) && inv.method_5438(0).method_7947() >= this.inputCount && this.canFitOutput(inv);
    }

    public class_1799 method_8116(class_1263 inv) {
        if (!this.canFitOutput(inv)) {
            return class_1799.field_8037;
        }
        inv.method_5434(0, this.inputCount);
        for (int i = 0; i < this.outputs.size(); ++i) {
            class_1799 out = (class_1799)this.outputs.get(i);
            class_1799 cur = inv.method_5438(i + 1);
            if (cur.method_7960()) {
                inv.method_5447(i + 1, out.method_7972());
                continue;
            }
            cur.method_7933(out.method_7947());
            inv.method_5447(i + 1, cur);
        }
        return ((class_1799)this.outputs.get(0)).method_7972();
    }

    public boolean canFitOutput(class_1263 inv) {
        for (int i = 0; i < this.outputs.size(); ++i) {
            class_1799 out = (class_1799)this.outputs.get(i);
            class_1799 cur = inv.method_5438(i + 1);
            if (cur.method_7960()) continue;
            if (!class_1799.method_7987((class_1799)out, (class_1799)cur) || !class_1799.method_7975((class_1799)out, (class_1799)cur)) {
                return false;
            }
            if (cur.method_7947() + out.method_7947() <= cur.method_7914()) continue;
            return false;
        }
        return true;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 out = class_2371.method_10211();
        out.add((Object)this.input);
        return out;
    }

    public class_1799 method_8110() {
        return class_1799.field_8037;
    }

    public ImmutableList<class_1799> getOutputs() {
        return this.outputs;
    }

    public String method_8112() {
        return this.group;
    }

    public int getSpinTime() {
        return this.spinTime;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public boolean method_8118() {
        return true;
    }

    public class_3956<?> method_17716() {
        return YRecipeTypes.CENTRIFUGING;
    }

    public class_1865<?> method_8119() {
        return YRecipeSerializers.CENTRIFUGING;
    }

    public static class Serializer
    implements class_1865<CentrifugingRecipe> {
        public CentrifugingRecipe read(class_2960 id, JsonObject obj) {
            JsonArray resultsJson;
            JsonObject ingobj;
            String group = class_3518.method_15253((JsonObject)obj, (String)"group", (String)"");
            class_1856 ingredient = class_1856.method_8102((JsonElement)obj.get("ingredient"));
            int inputCount = 1;
            if (obj.get("ingredient") instanceof JsonObject && (ingobj = obj.getAsJsonObject("ingredient")).has("count")) {
                inputCount = ingobj.getAsJsonPrimitive("count").getAsInt();
            }
            if ((resultsJson = obj.getAsJsonArray("results")).size() == 0) {
                throw new IllegalArgumentException("A centrifuging recipe must have at least 1 output");
            }
            if (resultsJson.size() > 4) {
                throw new IllegalArgumentException("A centrifuging recipe can only have up to 4 outputs");
            }
            ArrayList results = Lists.newArrayList();
            for (JsonElement je : resultsJson) {
                results.add(class_1869.method_35228((JsonObject)je.getAsJsonObject()));
            }
            int time = class_3518.method_15282((JsonObject)obj, (String)"time", (int)400);
            return new CentrifugingRecipe(id, group, ingredient, inputCount, results, time);
        }

        public CentrifugingRecipe read(class_2960 id, class_2540 buf) {
            String group = buf.method_10800(Short.MAX_VALUE);
            class_1856 ingredient = class_1856.method_8086((class_2540)buf);
            short inputCount = buf.readUnsignedByte();
            int outputsCount = buf.readUnsignedByte();
            ArrayList outputs = Lists.newArrayList();
            for (int i = 0; i < outputsCount; ++i) {
                outputs.add(buf.method_10819());
            }
            int time = buf.method_10816();
            return new CentrifugingRecipe(id, group, ingredient, inputCount, outputs, time);
        }

        public void write(class_2540 buf, CentrifugingRecipe recipe) {
            buf.method_10814(recipe.group);
            recipe.input.method_8088(buf);
            buf.writeByte(recipe.inputCount);
            buf.writeByte(recipe.outputs.size());
            for (class_1799 is : recipe.outputs) {
                buf.method_10793(is);
            }
            buf.method_10804(recipe.spinTime);
        }
    }
}

