/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.content.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.unascribed.yttr.mechanics.SuitResource;
import com.unascribed.yttr.util.FakeEntityAttribute;
import java.util.UUID;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5134;

public class SuitArmorItem
extends class_1738 {
    private static final UUID[] MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    private final Multimap<class_1320, class_1322> attributeModifiers;

    public SuitArmorItem(class_1741 material, class_1304 slot, class_1792.class_1793 settings) {
        super(material, slot, settings);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.method_7844(slot));
        UUID id = MODIFIERS[slot.method_5927()];
        builder.put((Object)class_5134.field_23718, (Object)new class_1322(id, "Armor knockback resistance", (double)this.field_21976, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23719, (Object)new class_1322(id, "Armor penalty", -0.4, class_1322.class_1323.field_6331));
        builder.put((Object)class_5134.field_23720, (Object)new class_1322(id, "Armor penalty", -0.4, class_1322.class_1323.field_6331));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(id, "Armor penalty", -0.15, class_1322.class_1323.field_6331));
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(id, "Armor penalty", -0.15, class_1322.class_1323.field_6331));
        builder.put((Object)new FakeEntityAttribute("attribute.name.yttr.jump_height"), (Object)new class_1322(id, "Armor penalty", -0.2, class_1322.class_1323.field_6331));
        this.attributeModifiers = builder.build();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == this.field_7880 ? this.attributeModifiers : super.method_7844(slot);
    }

    public int getResourceAmount(class_1799 stack, SuitResource resource) {
        class_2487 resources = stack.method_7941("Resources");
        if (resources == null || !resources.method_10545(resource.name())) {
            return resource.getDefaultAmount();
        }
        return resources.method_10550(resource.name());
    }

    public void setResourceAmount(class_1799 stack, SuitResource resource, int amount) {
        stack.method_7911("Resources").method_10569(resource.name(), amount);
    }

    public void consumeResource(class_1799 stack, SuitResource resource, int amount) {
        if (amount <= 0) {
            return;
        }
        int amt = this.getResourceAmount(stack, resource);
        this.setResourceAmount(stack, resource, Math.max(0, amt -= amount));
    }

    public void replenishResource(class_1799 stack, SuitResource resource, int amount) {
        if (amount <= 0) {
            return;
        }
        int amt = this.getResourceAmount(stack, resource);
        this.setResourceAmount(stack, resource, Math.min(resource.getMaximum(), amt += amount));
    }
}

