/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.content.item;

import com.google.common.base.Charsets;
import com.google.common.base.Enums;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.unascribed.yttr.client.cache.SnareEntityTextureCache;
import com.unascribed.yttr.client.util.TextureColorThief;
import com.unascribed.yttr.init.YCriteria;
import com.unascribed.yttr.init.YItemGroups;
import com.unascribed.yttr.init.YItems;
import com.unascribed.yttr.init.YSounds;
import com.unascribed.yttr.init.YTags;
import com.unascribed.yttr.mechanics.TicksAlwaysItem;
import com.unascribed.yttr.mixin.accessor.AccessorLivingEntity;
import com.unascribed.yttr.mixin.accessor.AccessorMobEntity;
import com.unascribed.yttr.util.YLog;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1744;
import net.minecraft.class_1750;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2968;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_326;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3737;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

@EnvironmentInterface(itf=class_326.class, value=EnvType.CLIENT)
public class SnareItem
extends class_1792
implements class_326,
TicksAlwaysItem {
    private static final int maxDamage = 40960;

    public SnareItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        return class_1269.field_5811;
    }

    public class_1269 method_7884(class_1838 context) {
        return class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 world, final class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        class_3965 hr = SnareItem.method_7872((class_1937)world, (class_1657)user, (class_3959.class_242)class_3959.class_242.field_1348);
        class_243 start = user.method_5836(1.0f);
        class_243 end = hr.method_17784();
        class_1297 hit = null;
        class_3966 ehr = class_1675.method_18077((class_1937)world, (class_1297)user, (class_243)start, (class_243)end, (class_238)new class_238(start, end).method_1014(0.2), e -> true);
        if (ehr != null) {
            end = ehr.method_17784();
            hit = ehr.method_17782();
        }
        if (stack.method_7985() && stack.method_7969().method_10545("Contents")) {
            class_1297 e2;
            boolean miss;
            if (world.field_9236) {
                return class_1271.method_29237((Object)stack, (boolean)false);
            }
            boolean bl = miss = ehr == null && hr.method_17783() == class_239.class_240.field_1333;
            if (miss) {
                end = start.method_1019(user.method_5828(1.0f).method_1021(3.0));
            }
            if ((e2 = this.release(user, world, stack, end, -user.method_5791(), false)) instanceof class_1540) {
                class_1540 fbe = (class_1540)e2;
                if (ehr == null && hr.method_17783() == class_239.class_240.field_1332) {
                    class_2680 bs = fbe.method_6962();
                    class_2338 target = world.method_8320(hr.method_17777()).method_26207().method_15800() ? hr.method_17777() : hr.method_17777().method_10093(hr.method_17780());
                    class_2968 ctx = new class_2968(world, target, user.method_5735(), new class_1799((class_1935)bs.method_26204()), hr.method_17780()){

                        public float method_8044() {
                            return user.method_5705(1.0f);
                        }
                    };
                    if (world.method_8320(target).method_26166((class_1750)ctx) && fbe.method_6962().method_26184((class_4538)world, target)) {
                        class_2586 be;
                        fbe.method_31472();
                        try {
                            class_2680 placement = bs.method_26204().method_9605((class_1750)ctx);
                            if (placement.method_26204() == bs.method_26204()) {
                                for (class_2769 prop : bs.method_28501()) {
                                    if (prop != class_2741.field_12532 && !(placement.method_11654(prop) instanceof class_2350) && prop != class_2741.field_12506 && prop != class_2741.field_12508) continue;
                                    bs = (class_2680)bs.method_11657(prop, placement.method_11654(prop));
                                }
                            }
                        }
                        catch (Throwable t) {
                            YLog.warn("Failed to update rotation for snare placement", t);
                        }
                        world.method_8501(target, bs);
                        for (class_2350 dir : class_2350.values()) {
                            bs = bs.method_26191(dir, bs, (class_1936)world, target, target.method_10093(dir));
                        }
                        world.method_8501(target, bs);
                        if (fbe.field_7194 != null && (be = world.method_8321(target)) != null) {
                            class_2487 data = be.method_38244();
                            class_2487 incoming = fbe.field_7194.method_10553();
                            incoming.method_10551("x");
                            incoming.method_10551("y");
                            incoming.method_10551("z");
                            data.method_10543(incoming);
                            be.method_11014(data);
                        }
                    } else {
                        if (fbe.field_7194 != null) {
                            return class_1271.method_22431((Object)stack);
                        }
                        world.method_8649(e2);
                    }
                } else {
                    if (fbe.field_7194 != null) {
                        return class_1271.method_22431((Object)stack);
                    }
                    world.method_8649(e2);
                }
            } else {
                world.method_8649(e2);
            }
            if (e2 != null && miss) {
                e2.method_18799(user.method_5828(1.0f).method_1021(0.75).method_1019(user.method_18798()));
            }
            stack.method_7969().method_10551("Contents");
            world.method_8465(null, end.field_1352, end.field_1351, end.field_1350, YSounds.SNARE_PLOP, class_3419.field_15248, 1.0f, 0.75f);
            world.method_8465(null, end.field_1352, end.field_1351, end.field_1350, YSounds.SNARE_PLOP, class_3419.field_15248, 1.0f, 0.95f);
            world.method_8465(null, end.field_1352, end.field_1351, end.field_1350, YSounds.SNARE_RELEASE, class_3419.field_15248, 0.3f, 1.75f);
            return class_1271.method_29237((Object)stack, (boolean)true);
        }
        class_2338 toDelete = null;
        class_2680 deleteState = null;
        if (user.method_5715() && hit == null && hr.method_17783() != class_239.class_240.field_1333) {
            class_2680 bs = world.method_8320(hr.method_17777());
            class_2586 be = world.method_8321(hr.method_17777());
            if ((be == null || bs.method_26164(YTags.Block.SNAREABLE)) && !bs.method_26164(YTags.Block.UNSNAREABLE) && bs.method_26214((class_1922)world, hr.method_17777()) >= 0.0f) {
                toDelete = hr.method_17777();
                boolean waterlogged = bs.method_26204() instanceof class_3737 && (Boolean)bs.method_11654((class_2769)class_2741.field_12508) != false;
                class_2680 class_26802 = deleteState = waterlogged ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564();
                if (waterlogged) {
                    bs = (class_2680)bs.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                }
                class_1540 fbe = new class_1540(world, (double)hr.method_17777().method_10263() + 0.5, (double)hr.method_17777().method_10264(), (double)hr.method_17777().method_10260() + 0.5, bs);
                fbe.field_7193 = true;
                fbe.field_7192 = 2;
                if (be != null) {
                    class_2487 data;
                    fbe.field_7194 = data = be.method_38244();
                }
                hit = fbe;
                if (be != null && user instanceof class_3222) {
                    YCriteria.SNARE_BLOCK_ENTITY.trigger((class_3222)user);
                }
            }
        }
        if (hit == null) {
            return class_1271.method_22430((Object)stack);
        }
        if (world.field_9236) {
            return class_1271.method_29237((Object)stack, (boolean)false);
        }
        if (!hit.method_5805()) {
            return class_1271.method_22431((Object)stack);
        }
        if (hit instanceof class_1657 || hit.method_5864().method_20210(YTags.Entity.UNSNAREABLE) || hit.method_5782()) {
            return class_1271.method_22431((Object)stack);
        }
        if (!(hit.method_5864().method_20210(YTags.Entity.SNAREABLE_NONLIVING) || hit instanceof class_1309 || hit instanceof class_1540)) {
            return class_1271.method_22431((Object)stack);
        }
        if (hit instanceof class_1542 && ((class_1542)hit).method_6983().method_31573(YTags.Item.UNSNAREABLE)) {
            return class_1271.method_22431((Object)stack);
        }
        class_2487 data = new class_2487();
        if (hit.method_5786(data)) {
            boolean tryingToCheatSnareTimer = this.checkForCheating(data);
            if (tryingToCheatSnareTimer) {
                return class_1271.method_22431((Object)stack);
            }
            this.damage(stack, 400, () -> user.method_20236(hand));
            if (stack.method_7960()) {
                return class_1271.method_22431((Object)class_1799.field_8037);
            }
            if (toDelete != null) {
                world.method_8544(toDelete);
                world.method_8501(toDelete, deleteState);
            }
            stack.method_7969().method_10551("AmbientSound");
            stack.method_7969().method_10551("AmbientSoundTimer");
            stack.method_7969().method_10551("AmbientSoundDelay");
            stack.method_7969().method_10551("AmbientSoundPitches");
            stack.method_7969().method_10551("AmbientSoundVolumes");
            stack.method_7969().method_10551("AmbientSoundCategory");
            if (hit instanceof class_1309) {
                ((AccessorLivingEntity)hit).yttr$playHurtSound(class_1282.field_5869);
                if (user instanceof class_3222) {
                    YCriteria.SNARE_LIVING_ENTITY.trigger((class_3222)user);
                }
            }
            hit.method_5783(YSounds.SNARE_PLOP, 1.0f, 0.5f);
            hit.method_5783(YSounds.SNARE_PLOP, 1.0f, 0.75f);
            hit.method_5783(YSounds.SNARE_GRAB, 0.2f, 2.0f);
            if (hit instanceof class_1308) {
                class_1308 mob = (class_1308)hit;
                class_3414 sound = ((AccessorMobEntity)hit).yttr$getAmbientSound();
                if (sound != null) {
                    class_2960 id = class_2378.field_11156.method_10221((Object)sound);
                    stack.method_7969().method_10582("AmbientSound", id.toString());
                    stack.method_7969().method_10569("AmbientSoundTimer", -mob.method_5970());
                    stack.method_7969().method_10569("AmbientSoundDelay", mob.method_5970());
                    int[] soundPitches = new int[10];
                    int[] soundVolumes = new int[10];
                    for (int i = 0; i < soundPitches.length; ++i) {
                        soundPitches[i] = Float.floatToIntBits(((AccessorLivingEntity)hit).yttr$getSoundPitch());
                        soundVolumes[i] = Float.floatToIntBits(((AccessorLivingEntity)hit).yttr$getSoundVolume());
                    }
                    stack.method_7969().method_10539("AmbientSoundPitches", soundPitches);
                    stack.method_7969().method_10539("AmbientSoundVolumes", soundVolumes);
                    stack.method_7969().method_10582("AmbientSoundCategory", hit.method_5634().name());
                }
            }
            boolean baby = hit instanceof class_1309 && ((class_1309)hit).method_6109();
            hit.method_31472();
            if (!stack.method_7985()) {
                stack.method_7980(new class_2487());
            }
            stack.method_7969().method_10544("LastUpdate", (long)user.field_6002.method_8503().method_3780());
            stack.method_7969().method_10566("Contents", (class_2520)data);
            stack.method_7969().method_10556("Baby", baby);
            return class_1271.method_29237((Object)stack, (boolean)true);
        }
        return class_1271.method_22431((Object)stack);
    }

    private boolean checkForCheating(class_2487 data) {
        for (String key : data.method_10541()) {
            if (key.contains("yttr:snare")) {
                return true;
            }
            if (!this.checkForCheating(data.method_10580(key))) continue;
            return true;
        }
        return false;
    }

    private boolean checkForCheating(class_2499 data) {
        for (int i = 0; i < data.size(); ++i) {
            if (!this.checkForCheating(data.method_10534(i))) continue;
            return true;
        }
        return false;
    }

    private boolean checkForCheating(class_2520 tag) {
        if (tag instanceof class_2519) {
            return ((class_2519)tag).method_10714().contains("yttr:snare");
        }
        if (tag instanceof class_2499) {
            return this.checkForCheating((class_2499)tag);
        }
        if (tag instanceof class_2487) {
            return this.checkForCheating((class_2487)tag);
        }
        return false;
    }

    public class_2561 method_7864(class_1799 stack) {
        class_1299<?> type = this.getEntityType(stack);
        if (type != null) {
            if (type == class_1299.field_6052) {
                return new class_2588("item.yttr.snare.filled", new Object[]{class_1799.method_7915((class_2487)stack.method_7969().method_10562("Contents").method_10562("Item")).method_7964()});
            }
            if (type == class_1299.field_6089) {
                return new class_2588("item.yttr.snare.filled", new Object[]{class_2512.method_10681((class_2487)stack.method_7969().method_10562("Contents").method_10562("BlockState")).method_26204().method_9518()});
            }
            return new class_2588("item.yttr.snare.filled", new Object[]{type.method_5897()});
        }
        return super.method_7864(stack);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        class_2561 msg = this.getContainmentMessage(world, stack);
        if (msg != null) {
            tooltip.add(msg);
        }
    }

    private class_2561 getContainmentMessage(class_1937 world, class_1799 stack) {
        int dmg = this.calculateDamageRate(world, stack);
        if (dmg > 0) {
            int ticksLeft = (40960 - stack.method_7919()) / dmg * (class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)stack) + 1);
            if ((ticksLeft -= this.getCheatedTicks(world, stack)) < 0) {
                return new class_2588("tip.yttr.snare.failed").method_27692(class_124.field_1061);
            }
            int seconds = ticksLeft / 20;
            int minutes = seconds / 60;
            return new class_2588("tip.yttr.snare.unstable", new Object[]{minutes, Integer.toString((seconds %= 60) + 100).substring(1)}).method_27692(minutes <= 1 ? (minutes == 0 && seconds <= 30 ? class_124.field_1061 : class_124.field_1054) : class_124.field_1080);
        }
        if (stack.method_7985() && stack.method_7969().method_10545("Contents")) {
            return new class_2588("tip.yttr.snare.stable").method_27692(class_124.field_1080);
        }
        return null;
    }

    private int getCheatedTicks(class_1937 world, class_1799 stack) {
        long lastUpdate;
        if (world.field_9236) {
            return 0;
        }
        long l = lastUpdate = stack.method_7985() ? stack.method_7969().method_10537("LastUpdate") : 0L;
        if (lastUpdate == 0L) {
            return 0;
        }
        long cheatedTicks = (long)world.method_8503().method_3780() - lastUpdate;
        if (cheatedTicks < 5L) {
            return 0;
        }
        return Ints.saturatedCast((long)cheatedTicks);
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_2561 msg;
        if (world.field_9236) {
            return;
        }
        this.handleAmbientSound(stack, world, entity.method_19538(), selected);
        int dmg = this.calculateDamageRate(world, stack);
        if (dmg > 0 && this.damage(stack, dmg * (this.getCheatedTicks(world, stack) + 1), null)) {
            stack.method_7934(1);
            world.method_8465(null, entity.method_19538().field_1352, entity.method_19538().field_1351, entity.method_19538().field_1350, YSounds.SNARE_PLOP, entity.method_5634(), 1.0f, 0.75f);
            world.method_8465(null, entity.method_19538().field_1352, entity.method_19538().field_1351, entity.method_19538().field_1350, YSounds.SNARE_PLOP, entity.method_5634(), 1.0f, 0.95f);
            world.method_8465(null, entity.method_19538().field_1352, entity.method_19538().field_1351, entity.method_19538().field_1350, YSounds.SNARE_BREAK, entity.method_5634(), 0.7f, 1.75f);
            world.method_8465(null, entity.method_19538().field_1352, entity.method_19538().field_1351, entity.method_19538().field_1350, YSounds.SNARE_BREAK, entity.method_5634(), 0.5f, 1.3f);
            this.release(entity instanceof class_1657 ? (class_1657)entity : null, world, stack, entity.method_19538(), entity.method_5705(1.0f), true);
        }
        if (stack.method_7985() && stack.method_7969().method_10545("Contents")) {
            stack.method_7969().method_10544("LastUpdate", (long)world.method_8503().method_3780());
        }
        if (entity instanceof class_1657 && selected && (msg = this.getContainmentMessage(world, stack)) != null) {
            ((class_1657)entity).method_7353(msg, true);
        }
    }

    @Override
    public void blockInventoryTick(class_1799 stack, class_1937 world, class_2338 pos, int slot) {
        this.handleAmbientSound(stack, world, class_243.method_24953((class_2382)pos), false);
        int dmg = this.calculateDamageRate(world, stack);
        if (dmg > 0 && this.damage(stack, dmg * (this.getCheatedTicks(world, stack) + 1), null)) {
            stack.method_7934(1);
            world.method_8396(null, pos, YSounds.SNARE_PLOP, class_3419.field_15245, 1.0f, 0.75f);
            world.method_8396(null, pos, YSounds.SNARE_PLOP, class_3419.field_15245, 1.0f, 0.95f);
            world.method_8396(null, pos, YSounds.SNARE_BREAK, class_3419.field_15245, 0.7f, 1.75f);
            world.method_8396(null, pos, YSounds.SNARE_BREAK, class_3419.field_15245, 0.5f, 1.3f);
            this.release(null, world, stack, class_243.method_24955((class_2382)pos.method_10084()), 0.0f, true);
        }
        if (stack.method_7985() && stack.method_7969().method_10545("Contents")) {
            stack.method_7969().method_10544("LastUpdate", (long)world.method_8503().method_3780());
        }
    }

    private boolean damage(class_1799 stack, int amt, Runnable breakCallback) {
        boolean broke;
        if (stack.method_7985() && stack.method_7969().method_10577("Unbreakable")) {
            return false;
        }
        int unbreaking = class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)stack);
        amt = (amt + unbreaking) / (unbreaking + 1);
        stack.method_7974(stack.method_7919() + amt);
        boolean bl = broke = stack.method_7919() > 40960;
        if (broke && breakCallback != null) {
            breakCallback.run();
        }
        return broke;
    }

    private void handleAmbientSound(class_1799 stack, class_1937 world, class_243 pos, boolean selected) {
        if (stack.method_7985() && stack.method_7969().method_10545("AmbientSound") && stack.method_7969().method_10545("Contents")) {
            int ambientSoundTimer = stack.method_7969().method_10550("AmbientSoundTimer");
            if (ThreadLocalRandom.current().nextInt(1000) < (ambientSoundTimer += this.getCheatedTicks(world, stack) + 1)) {
                ambientSoundTimer = -stack.method_7969().method_10550("AmbientSoundDelay");
                int[] pitches = stack.method_7969().method_10561("AmbientSoundPitches");
                int[] volumes = stack.method_7969().method_10561("AmbientSoundVolumes");
                class_2960 id = class_2960.method_12829((String)stack.method_7969().method_10558("AmbientSound"));
                if (id == null) {
                    return;
                }
                class_3414 sound = class_2378.field_11156.method_17966(id).orElse(null);
                if (sound == null) {
                    return;
                }
                class_3419 category = (class_3419)Enums.getIfPresent(class_3419.class, (String)stack.method_7969().method_10558("AmbientSoundCategory")).or((Object)class_3419.field_15250);
                world.method_8465(null, pos.field_1352, pos.field_1351, pos.field_1350, sound, category, Float.intBitsToFloat(volumes[ThreadLocalRandom.current().nextInt(volumes.length)]) / (float)(selected ? 2 : 3), Float.intBitsToFloat(pitches[ThreadLocalRandom.current().nextInt(pitches.length)]));
            }
            stack.method_7969().method_10569("AmbientSoundTimer", ambientSoundTimer);
        }
    }

    private int calculateDamageRate(class_1937 world, class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10577("Unbreakable")) {
            return 0;
        }
        class_1299<?> type = this.getEntityType(stack);
        if (type != null) {
            if (type == class_1299.field_6131 || type == class_1299.field_6052) {
                return 0;
            }
            class_2487 data = stack.method_7969().method_10562("Contents");
            int dmg = class_3532.method_15386((float)(data.method_10583("Health") * class_3532.method_15355((float)(type.method_18386().field_18068 * type.method_18386().field_18067))));
            switch (type.method_5891()) {
                case field_6303: 
                case field_24460: {
                    dmg /= 2;
                    break;
                }
                case field_6294: 
                case field_6300: {
                    dmg /= 4;
                    break;
                }
            }
            if (type.method_20210(YTags.Entity.BOSSES)) {
                dmg *= 4;
            }
            if (stack.method_7969().method_10577("Baby")) {
                dmg /= 2;
            }
            for (class_2520 nbt : data.method_10554("ActiveEffects", 10)) {
                class_1293 se = class_1293.method_5583((class_2487)((class_2487)nbt));
                if (se.method_5579() == class_1294.field_5911) {
                    dmg /= se.method_5578() + 2;
                    continue;
                }
                if (se.method_5579() == class_1294.field_5910) {
                    dmg *= se.method_5578() + 2;
                    continue;
                }
                if (se.method_5579() != class_1294.field_5905) continue;
                dmg *= 2;
            }
            return dmg;
        }
        return 0;
    }

    public class_1299<?> getEntityType(class_1799 stack) {
        if (!stack.method_7985()) {
            return null;
        }
        class_2487 data = stack.method_7969().method_10562("Contents");
        class_2960 id = class_2960.method_12829((String)data.method_10558("id"));
        if (id == null) {
            return null;
        }
        return class_2378.field_11145.method_17966(id).orElse(null);
    }

    private class_1297 release(@Nullable class_1657 player, class_1937 world, class_1799 stack, class_243 pos, float yaw, boolean spawn) {
        if (!(world instanceof class_3218)) {
            return null;
        }
        class_1297 e = this.createEntity(world, stack);
        if (e != null) {
            if (e instanceof class_1542 && ((class_1542)e).method_6983().method_7909() instanceof class_1744 && ((class_1542)e).method_6983().method_7947() == 1 && player != null) {
                e = ((class_1744)((class_1542)e).method_6983().method_7909()).method_7702(world, ((class_1542)e).method_6983(), (class_1309)player);
            } else {
                e.method_5636(yaw);
                e.method_5847(yaw);
                e.method_36457(0.0f);
                e.method_18800(0.0, 0.0, 0.0);
                e.field_6017 = 0.0f;
            }
            e.method_29495(pos);
            if (spawn) {
                world.method_8649(e);
            }
            if (player != null) {
                e.field_6012 = -1;
                e.method_5643(class_1282.method_5532((class_1657)player), 0.0f);
                e.field_6012 = 0;
            }
            if (spawn) {
                stack.method_7969().method_10551("Contents");
            }
            return e;
        }
        return null;
    }

    public class_1297 createEntity(class_1937 world, class_1799 stack) {
        class_1299<?> type = this.getEntityType(stack);
        if (type == null) {
            return null;
        }
        class_1297 e = type.method_5883(world);
        e.method_5651(stack.method_7969().method_10562("Contents"));
        return e;
    }

    public void method_7850(class_1761 group, class_2371<class_1799> stacks) {
        super.method_7850(group, stacks);
        if (group == YItemGroups.SNARE) {
            for (Map.Entry en : class_2378.field_11145.method_29722()) {
                class_1299 e = (class_1299)en.getValue();
                if (e == class_1299.field_6052 || e == class_1299.field_6089 || e.method_5891() == class_1311.field_17715 && !e.method_20210(YTags.Entity.SNAREABLE_NONLIVING) || e.method_20210(YTags.Entity.UNSNAREABLE)) continue;
                class_1799 is = new class_1799((class_1935)this);
                is.method_7911("Contents").method_10582("id", ((class_5321)en.getKey()).method_29177().toString());
                stacks.add((Object)is);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public int getColor(class_1799 stack, int tintIndex) {
        if (tintIndex == 0) {
            return -1;
        }
        class_1299<?> type = YItems.SNARE.getEntityType(stack);
        if (type != null) {
            int secondary;
            int primary;
            class_2960 tex = SnareEntityTextureCache.get(stack);
            if (tex != null && tex != TextureColorThief.MISSINGNO) {
                primary = TextureColorThief.getPrimaryColor(tex);
                secondary = TextureColorThief.getSecondaryColor(tex);
            } else {
                class_1826 spi = class_1826.method_8019(type);
                if (spi != null) {
                    primary = spi.method_8016(0);
                    secondary = spi.method_8016(1);
                } else {
                    primary = Hashing.murmur3_32_fixed().hashString((CharSequence)class_2378.field_11145.method_10221(type).toString(), Charsets.UTF_8).asInt();
                    secondary = ~primary;
                }
            }
            return tintIndex == 1 ? primary : secondary;
        }
        return -1;
    }

    public boolean method_31567(class_1799 stack) {
        return stack.method_7919() > 0;
    }

    public int method_31569(class_1799 stack) {
        return Math.round(13.0f - (float)stack.method_7919() * 13.0f / 40960.0f);
    }

    public int method_31571(class_1799 stack) {
        float f = Math.max(0.0f, (40960.0f - (float)stack.method_7919()) / 40960.0f);
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }
}

