/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.content.item;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.unascribed.yttr.DelayedTask;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.content.block.big.BigBlock;
import com.unascribed.yttr.content.block.decor.CleavedBlockEntity;
import com.unascribed.yttr.content.block.decor.ContinuousPlatformBlock;
import com.unascribed.yttr.content.item.CleaverItem;
import com.unascribed.yttr.content.item.ProjectorItem;
import com.unascribed.yttr.content.item.block.ReplicatorBlockItem;
import com.unascribed.yttr.init.YBlocks;
import com.unascribed.yttr.init.YCriteria;
import com.unascribed.yttr.init.YSounds;
import com.unascribed.yttr.init.YStats;
import com.unascribed.yttr.mixin.accessor.AccessorBlockSoundGroup;
import com.unascribed.yttr.util.ControlHintable;
import com.unascribed.yttr.util.YLog;
import com.unascribed.yttr.util.math.partitioner.Plane;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;

public class ShifterItem
extends class_1792
implements ControlHintable {
    public ShifterItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void changeMode(class_3222 player, boolean disconnected, boolean hidden, boolean plane) {
        boolean curPlane;
        class_1799 stack = player.method_5998(class_1268.field_5808);
        boolean curDisconnected = stack.method_7985() && stack.method_7969().method_10577("ReplaceDisconnected");
        boolean curHidden = stack.method_7985() && stack.method_7969().method_10577("ReplaceHidden");
        boolean bl = curPlane = stack.method_7985() && stack.method_7969().method_10577("PlaneRestrict");
        if (disconnected != curDisconnected) {
            player.method_7353((class_2561)new class_2588("tip.yttr.shifter.disconnected." + (disconnected ? "en" : "dis") + "abled"), true);
        }
        if (hidden != curHidden) {
            player.method_7353((class_2561)new class_2588("tip.yttr.shifter.hidden." + (hidden ? "en" : "dis") + "abled"), true);
        }
        if (plane != curPlane) {
            player.method_7353((class_2561)new class_2588("tip.yttr.shifter.plane." + (plane ? "en" : "dis") + "abled"), true);
        }
        if (!stack.method_7985()) {
            stack.method_7980(new class_2487());
        }
        stack.method_7969().method_10556("ReplaceDisconnected", disconnected);
        stack.method_7969().method_10556("ReplaceHidden", hidden);
        stack.method_7969().method_10556("PlaneRestrict", plane);
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_20287() == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        class_1799 stack = context.method_8041();
        class_1799 repl = context.method_8036().method_5998(class_1268.field_5810);
        Set<class_2338> blocks = this.getAffectedBlocks(context.method_8036(), context.method_8045(), context.method_8037(), context.method_8038(), stack.method_7985() && stack.method_7969().method_10577("ReplaceDisconnected"), stack.method_7985() && stack.method_7969().method_10577("ReplaceHidden"), stack.method_7985() && stack.method_7969().method_10577("PlaneRestrict"));
        this.scheduleMultiReplace(stack, context.method_8036(), context.method_8037(), context.method_8045(), repl.method_7972(), blocks);
        return class_1269.field_5812;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        class_1799 stack = miner.method_5998(class_1268.field_5808);
        class_1799 repl = miner.method_5998(class_1268.field_5810);
        this.performReplacement(stack, miner, pos, world, repl);
        return false;
    }

    public float method_7865(class_1799 stack, class_2680 state) {
        return 1.0E7f;
    }

    public void scheduleMultiReplace(class_1799 shifter, class_1657 player, class_2338 center, class_1937 _world, class_1799 replacement, Set<class_2338> positions) {
        if (!(_world instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)_world;
        HashMultiset delays = HashMultiset.create();
        for (class_2338 pos : positions) {
            int delay;
            int n = delay = pos.equals((Object)center) ? 0 : (int)(Math.sqrt(pos.method_10262((class_2382)center) * 4.0) + (double)ThreadLocalRandom.current().nextInt(5));
            while (delays.count((Object)delay) > 4) {
                ++delay;
            }
            delays.add((Object)delay);
            Yttr.delayedServerTasks.add(new DelayedTask(delay, () -> this.performReplacement(shifter, player, pos, (class_1937)world, replacement)));
        }
    }

    public void performReplacement(class_1799 shifter, class_1657 player, class_2338 pos, class_1937 _world, class_1799 _replacement) {
        class_2680 replState;
        if (!(_world instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)_world;
        if (_replacement.method_7960()) {
            return;
        }
        if (_replacement.method_7909() instanceof ReplicatorBlockItem) {
            _replacement = ReplicatorBlockItem.getHeldItem(_replacement);
        } else if (_replacement.method_7909() instanceof CleaverItem) {
            CleaverItem ci = (CleaverItem)_replacement.method_7909();
            if (!CleaverItem.canCleave((class_1937)world, pos, world.method_8320(pos))) {
                return;
            }
            Plane p = ci.getLastCut(_replacement);
            if (p != null && ci.performWorldCleave((class_1937)world, pos, _replacement, player, p)) {
                return;
            }
        }
        if (_replacement.method_7960()) {
            return;
        }
        class_1799 replacement = _replacement;
        class_2586 be = world.method_8321(pos);
        class_2680 curState = this.getEffectiveBlockState((class_1937)world, pos);
        if (curState.method_26215()) {
            return;
        }
        int consumed = class_1262.method_29234((class_1263)player.method_31548(), is -> class_1799.method_7987((class_1799)is, (class_1799)replacement) && class_1799.method_7975((class_1799)is, (class_1799)replacement), (int)1, (boolean)true);
        if (consumed == 0) {
            return;
        }
        class_1792 i = replacement.method_7909();
        class_3965 bhr = null;
        if (i instanceof ProjectorItem && curState.method_27852((class_2248)YBlocks.CONTINUOUS_PLATFORM)) {
            replState = curState.method_11654(ContinuousPlatformBlock.AGE) == ContinuousPlatformBlock.Age.IMMORTAL ? curState.method_26227().method_15759() : (class_2680)curState.method_11657(ContinuousPlatformBlock.AGE, (Comparable)((Object)ContinuousPlatformBlock.Age.IMMORTAL));
        } else {
            if (!(i instanceof class_1747)) {
                return;
            }
            class_2248 b = ((class_1747)i).method_7711();
            if (b instanceof BigBlock) {
                return;
            }
            bhr = new class_3965(new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5), class_2350.field_11036, pos, true);
            replState = b.method_9605(new class_1750(player, class_1268.field_5810, replacement, bhr));
        }
        if (replState == null) {
            return;
        }
        if (replState == curState) {
            return;
        }
        if (!replState.method_26184((class_4538)world, pos)) {
            return;
        }
        List drops = class_2248.method_9609((class_2680)curState, (class_3218)world, (class_2338)pos, (class_2586)world.method_8321(pos), (class_1297)player, (class_1799)shifter);
        if (curState.method_26214((class_1922)world, pos) < 0.0f && !curState.method_27852((class_2248)YBlocks.CONTINUOUS_PLATFORM)) {
            return;
        }
        class_2498 curSg = curState.method_26231();
        world.method_8396(null, pos, ((AccessorBlockSoundGroup)curSg).yttr$getBreakSound(), class_3419.field_15245, (curSg.method_10597() + 1.0f) / 2.0f * 0.2f, curSg.method_10599() * 0.8f);
        if (bhr != null && be == null) {
            world.method_30092(pos, curState.method_26227().method_15759(), 0, 0);
            class_2680 refinedReplState = replState.method_26204().method_9605(new class_1750(player, class_1268.field_5810, replacement, bhr));
            if (refinedReplState != null) {
                replState = refinedReplState;
            }
        }
        replState = this.copySafeProperties(curState, replState);
        if (be instanceof CleavedBlockEntity && !CleaverItem.canCleave((class_1937)world, pos, replState)) {
            return;
        }
        class_2498 replSg = replState.method_26231();
        world.method_8396(null, pos, replSg.method_10598(), class_3419.field_15245, (replSg.method_10597() + 1.0f) / 2.0f * 0.2f, replSg.method_10599() * 0.8f);
        if (!player.method_7337()) {
            int rm;
            if (world.method_8450().method_8355(class_1928.field_19392)) {
                for (class_1799 is2 : drops) {
                    double xo = (double)(world.field_9229.nextFloat() * 0.5f) + 0.25;
                    double yo = (double)(world.field_9229.nextFloat() * 0.5f) + 0.25;
                    double zo = (double)(world.field_9229.nextFloat() * 0.5f) + 0.25;
                    class_1542 ie = new class_1542((class_1937)world, (double)pos.method_10263() + xo, (double)pos.method_10264() + yo, (double)pos.method_10260() + zo, is2);
                    ie.method_6982(0);
                    world.method_8649((class_1297)ie);
                    ie.method_5694(player);
                    if (ie.method_6983().method_7960()) {
                        ie.method_31472();
                        continue;
                    }
                    ie.method_6988();
                }
            }
            if (!(i instanceof ProjectorItem) && (rm = class_1262.method_29234((class_1263)player.method_31548(), is -> class_1799.method_7987((class_1799)is, (class_1799)replacement) && class_1799.method_7975((class_1799)is, (class_1799)replacement), (int)1, (boolean)false)) == 0) {
                YLog.warn("Couldn't consume a replacement item after verifying it with a dry run?? Forcefully decrementing off-hand stack!");
                class_1799 off = player.method_5998(class_1268.field_5810);
                off.method_7934(1);
                player.method_6122(class_1268.field_5810, off);
            }
        }
        YStats.add((class_1309)player, YStats.BLOCKS_SHIFTED, 1);
        if (player instanceof class_3222) {
            YCriteria.SHIFT_BLOCK.method_9087((class_3222)player, pos, player.method_5998(class_1268.field_5808));
        }
        if (be instanceof CleavedBlockEntity) {
            ((CleavedBlockEntity)be).setDonor(replState);
        } else {
            world.method_8501(pos, replState);
        }
        world.method_8396(null, pos, YSounds.SHIFT, class_3419.field_15248, 0.75f, ThreadLocalRandom.current().nextFloat() + 1.0f);
        world.method_14199((class_2394)class_2398.field_11205, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.05);
        world.method_14199((class_2394)class_2398.field_11248, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.05);
    }

    private class_2680 copySafeProperties(class_2680 src, class_2680 dst) {
        dst = this.maybeCopy((class_2769)class_2741.field_12496, src, dst);
        dst = this.maybeCopy((class_2769)class_2741.field_12529, src, dst);
        dst = this.maybeCopy((class_2769)class_2741.field_12525, src, dst);
        dst = this.maybeCopy((class_2769)class_2741.field_12545, src, dst);
        dst = this.maybeCopy((class_2769)class_2741.field_12481, src, dst);
        dst = this.maybeCopy((class_2769)class_2741.field_12507, src, dst);
        dst = this.maybeCopy((class_2769)class_2741.field_12542, src, dst);
        dst = this.maybeCopy((class_2769)class_2741.field_12532, src, dst);
        if (src.method_28498((class_2769)class_2741.field_12485) && dst.method_28498((class_2769)class_2741.field_12485) && src.method_11654((class_2769)class_2741.field_12485) != class_2771.field_12682 && dst.method_11654((class_2769)class_2741.field_12485) != class_2771.field_12682) {
            dst = (class_2680)dst.method_11657((class_2769)class_2741.field_12485, (Comparable)((class_2771)src.method_11654((class_2769)class_2741.field_12485)));
        }
        return dst;
    }

    private <T extends Comparable<T>> class_2680 maybeCopy(class_2769<T> p, class_2680 src, class_2680 dst) {
        if (src.method_28498(p) && dst.method_28498(p)) {
            dst = (class_2680)dst.method_11657(p, src.method_11654(p));
        }
        return dst;
    }

    public Set<class_2338> getAffectedBlocks(class_1657 player, class_1937 world, class_2338 start, class_2350 face, boolean includeDisconnected, boolean includeHidden, boolean planeRestrict) {
        class_2680 sample = this.getEffectiveBlockState(world, start);
        if (sample.method_26215()) {
            return Collections.emptySet();
        }
        Iterable<Object> directions = Arrays.asList(class_2350.values());
        if (planeRestrict) {
            class_2350.class_2351 axisZ = face.method_10166();
            List<class_2350.class_2351> axes = Arrays.asList(class_2350.class_2351.values());
            class_2350.class_2351 axisX = (class_2350.class_2351)Iterables.find(axes, a -> a != axisZ);
            class_2350.class_2351 class_23512 = (class_2350.class_2351)Iterables.find((Iterable)Lists.reverse(axes), a -> a != axisZ);
            directions = Iterables.filter(directions, d -> d.method_10166() == axisX || d.method_10166() == axisY);
        }
        class_2338 corner1 = start;
        class_2338 corner2 = start;
        for (class_2350 class_23502 : directions) {
            if (class_23502.method_10171() == class_2350.class_2352.field_11060) {
                corner1 = corner1.method_10079(class_23502, 5);
                continue;
            }
            corner2 = corner2.method_10079(class_23502, 5);
        }
        if (includeDisconnected) {
            return StreamSupport.stream(class_2338.method_10097((class_2338)corner1, (class_2338)corner2).spliterator(), false).filter(bp -> this.getEffectiveBlockState(world, (class_2338)bp) == sample || this.areCompatiblePlatforms(sample, this.getEffectiveBlockState(world, (class_2338)bp))).filter(bp -> this.getEffectiveBlockState(world, (class_2338)bp).method_26214((class_1922)world, bp) >= 0.0f || this.getEffectiveBlockState(world, (class_2338)bp).method_27852((class_2248)YBlocks.CONTINUOUS_PLATFORM)).filter(bp -> includeHidden || !ShifterItem.isHidden(world, bp)).map(class_2338::method_10062).collect(Collectors.toSet());
        }
        class_238 box = new class_238((double)corner1.method_10263(), (double)corner1.method_10264(), (double)corner1.method_10260(), (double)(corner2.method_10263() + 1), (double)(corner2.method_10264() + 1), (double)(corner2.method_10260() + 1));
        HashSet hashSet = Sets.newHashSet();
        HashSet scan = Sets.newHashSet();
        HashSet nextScan = Sets.newHashSet();
        int i = 0;
        scan.add(start);
        hashSet.add(start);
        while (!scan.isEmpty() && i++ <= 768) {
            for (class_2338 bp2 : scan) {
                for (class_2350 class_23503 : directions) {
                    class_2680 bs2;
                    class_2338 c = bp2.method_10093(class_23503);
                    if (!box.method_1008((double)c.method_10263() + 0.5, (double)c.method_10264() + 0.5, (double)c.method_10260() + 0.5) || !includeHidden && ShifterItem.isHidden(world, c) || (bs2 = this.getEffectiveBlockState(world, c)) != sample && !this.areCompatiblePlatforms(sample, bs2) || !hashSet.add(c)) continue;
                    nextScan.add(c);
                }
            }
            scan.clear();
            scan.addAll(nextScan);
            nextScan.clear();
        }
        if (!includeHidden) {
            hashSet.removeIf(bp -> ShifterItem.isHidden(world, bp));
        }
        return hashSet;
    }

    private class_2680 getEffectiveBlockState(class_1937 world, class_2338 pos) {
        class_2586 be;
        class_2680 bs = world.method_8320(pos);
        if (bs.method_27852((class_2248)YBlocks.CLEAVED_BLOCK) && (be = world.method_8321(pos)) instanceof CleavedBlockEntity) {
            return ((CleavedBlockEntity)be).getDonor();
        }
        return bs;
    }

    private boolean areCompatiblePlatforms(class_2680 a, class_2680 b) {
        if (!a.method_27852((class_2248)YBlocks.CONTINUOUS_PLATFORM) || !b.method_27852((class_2248)YBlocks.CONTINUOUS_PLATFORM)) {
            return false;
        }
        boolean aImm = a.method_11654(ContinuousPlatformBlock.AGE) == ContinuousPlatformBlock.Age.IMMORTAL;
        boolean bImm = b.method_11654(ContinuousPlatformBlock.AGE) == ContinuousPlatformBlock.Age.IMMORTAL;
        return aImm == bImm;
    }

    public static boolean isHidden(class_1937 world, class_2338 bp) {
        class_2338.class_2339 mut = bp.method_25503();
        for (class_2350 d : class_2350.values()) {
            mut.method_10101((class_2382)bp).method_10098(d);
            if (world.method_8320((class_2338)mut).method_26206((class_1922)world, (class_2338)mut, d.method_10153())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getState(class_1657 player, class_1799 stack, boolean fHeld) {
        return fHeld ? "mode" : "normal";
    }
}

