/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.content.item;

import com.google.common.base.Enums;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.unascribed.yttr.YConfig;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.content.item.block.ReplicatorBlockItem;
import com.unascribed.yttr.init.YCriteria;
import com.unascribed.yttr.init.YItems;
import com.unascribed.yttr.init.YSounds;
import com.unascribed.yttr.init.YStats;
import com.unascribed.yttr.mechanics.rifle.RifleMode;
import com.unascribed.yttr.mechanics.rifle.Shootable;
import com.unascribed.yttr.mixin.accessor.AccessorEntity;
import com.unascribed.yttr.network.MessageC2STrustedRifleFire;
import com.unascribed.yttr.network.MessageS2CBeam;
import com.unascribed.yttr.util.Attackable;
import com.unascribed.yttr.util.ControlHintable;
import com.unascribed.yttr.util.InventoryProviderItem;
import com.unascribed.yttr.util.SlotReference;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.minecraft.class_1011;
import net.minecraft.class_1160;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_326;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;

@EnvironmentInterface(itf=class_326.class, value=EnvType.CLIENT)
public class RifleItem
extends class_1792
implements class_326,
Attackable,
ControlHintable {
    private final float speedMod;
    private final int ammoMod;
    private final boolean simpleCurve;
    private final int baseColor;

    public RifleItem(class_1792.class_1793 settings, float speedMod, int ammoMod, boolean simpleCurve, int baseColor) {
        super(settings);
        this.speedMod = speedMod;
        this.ammoMod = ammoMod;
        this.simpleCurve = simpleCurve;
        this.baseColor = baseColor;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (hand == class_1268.field_5808) {
            RifleMode mode = this.getMode(stack);
            if (!mode.isEnabled()) {
                return class_1271.method_22431((Object)stack);
            }
            SlotReference can = this.getAmmoCanSlot(user, mode);
            if (can == null) {
                int need;
                if (stack.method_7985()) {
                    stack.method_7969().method_10551("FiringFromCan");
                    stack.method_7969().method_10551("LastCanFullness");
                }
                int ammo = this.getRemainingAmmo(stack);
                int n = need = mode != RifleMode.VOID && mode.shotsPerItem < this.ammoMod ? this.ammoMod : 1;
                if (ammo <= 0) {
                    if (user.method_31549().field_7477) {
                        ammo = mode.shotsPerItem;
                    } else {
                        for (int i = 0; i < user.method_31548().method_5439(); ++i) {
                            boolean replicator = false;
                            class_1799 is = user.method_31548().method_5438(i);
                            if (is.method_7909() == YItems.REPLICATOR) {
                                is = ReplicatorBlockItem.getHeldItem(is);
                                is.method_7939(64);
                                replicator = true;
                            }
                            if (is.method_7909() != mode.item.get().method_8389() || is.method_7947() < need) continue;
                            class_1792 remainder = is.method_7909().method_7858();
                            if (!replicator && remainder != null) {
                                if (is.method_7947() == need) {
                                    user.method_31548().method_5447(i, new class_1799((class_1935)remainder));
                                } else {
                                    is.method_7934(need);
                                    user.method_31548().method_7398(new class_1799((class_1935)remainder));
                                }
                            } else {
                                is.method_7934(need);
                            }
                            if (mode == RifleMode.VOID) {
                                ammo = Math.max(1, mode.shotsPerItem / this.ammoMod);
                                user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, class_3417.field_14834, user.method_5634(), 1.0f, 1.0f);
                                user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, YSounds.RIFLE_LOAD, user.method_5634(), 0.1f, 1.0f);
                                break;
                            }
                            if (mode == RifleMode.LIGHT) {
                                ammo = mode.shotsPerItem * need / this.ammoMod;
                                user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, class_3417.field_15029, user.method_5634(), 1.0f, 1.0f);
                                user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, YSounds.RIFLE_LOAD, user.method_5634(), 0.1f, 1.0f);
                                break;
                            }
                            ammo = mode.shotsPerItem * need / this.ammoMod;
                            user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, YSounds.RIFLE_LOAD, user.method_5634(), 3.0f, 2.0f);
                            user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, YSounds.RIFLE_LOAD, user.method_5634(), 3.0f, 1.75f);
                            user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, YSounds.RIFLE_LOAD, user.method_5634(), 3.0f, 1.5f);
                            break;
                        }
                    }
                }
                if (ammo <= 0) {
                    user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, YSounds.RIFLE_FIRE_DUD, user.method_5634(), 1.0f, 1.25f);
                    if (need > 1) {
                        user.method_7353((class_2561)new class_2588("tip.yttr.rifle_no_ammo_multi", new Object[]{need, new class_1799(mode.item.get()).method_7964()}), true);
                    } else {
                        user.method_7353((class_2561)new class_2588("tip.yttr.rifle_no_ammo", new Object[]{new class_1799(mode.item.get()).method_7964()}), true);
                    }
                    return class_1271.method_22431((Object)stack);
                }
                this.setRemainingAmmo(stack, ammo);
            } else {
                if (!stack.method_7985()) {
                    stack.method_7980(new class_2487());
                }
                stack.method_7969().method_10556("FiringFromCan", true);
                stack.method_7969().method_10548("LastCanFullness", (float)can.getStack().method_7969().method_10550("Shots") / 1024.0f);
            }
            user.method_5783(YSounds.RIFLE_FIRE_DUD, 1.0f, 1.75f);
            float speed = mode.speed * this.speedMod;
            if (speed > 2.0f) {
                world.method_8449((class_1657)(YConfig.General.trustPlayers ? user : null), (class_1297)user, YSounds.RIFLE_CHARGE_FAST, user.method_5634(), 1.0f, speed /= 1.75f);
            } else {
                world.method_8449((class_1657)(YConfig.General.trustPlayers ? user : null), (class_1297)user, YSounds.RIFLE_CHARGE, user.method_5634(), 1.0f, speed);
            }
            user.method_6019(hand);
            return class_1271.method_29237((Object)stack, (boolean)false);
        }
        return class_1271.method_22430((Object)stack);
    }

    @Override
    public void attack(class_1657 user) {
        class_1799 held = user.method_5998(class_1268.field_5808);
        if (!held.method_7985()) {
            held.method_7980(new class_2487());
        }
        boolean scoped = held.method_7969().method_10577("Scoped");
        held.method_7969().method_10556("Scoped", !scoped);
        if (!scoped && user instanceof class_3222) {
            YCriteria.RIFLE_SCOPE.trigger((class_3222)user);
        }
        user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, YSounds.RIFLE_SCOPE, class_3419.field_15248, 1.0f, scoped ? 0.8f : 1.2f);
    }

    public int getPotentialAmmoCount(class_1657 user, RifleMode mode) {
        RifleItem ri;
        if (user.method_7337()) {
            return -1;
        }
        SlotReference can = this.getAmmoCanSlot(user, mode);
        if (can != null) {
            return can.getStack().method_7969().method_10550("Shots");
        }
        int need = mode != RifleMode.VOID && mode.shotsPerItem < this.ammoMod ? this.ammoMod : 1;
        int ammo = 0;
        for (int i = 0; i < user.method_31548().method_5439(); ++i) {
            boolean replicator = false;
            class_1799 is = user.method_31548().method_5438(i);
            if (is.method_7909() == YItems.REPLICATOR) {
                is = ReplicatorBlockItem.getHeldItem(is);
                is.method_7939(64);
                replicator = true;
            }
            if (is.method_7909() != mode.item.get().method_8389()) continue;
            if (replicator) {
                return -1;
            }
            if (mode == RifleMode.VOID) {
                ammo += Math.max(1, mode.shotsPerItem / this.ammoMod);
                continue;
            }
            if (mode == RifleMode.LIGHT) {
                ammo += mode.shotsPerItem * (is.method_7947() / need) / this.ammoMod;
                continue;
            }
            ammo += mode.shotsPerItem * (is.method_7947() / need) / this.ammoMod;
        }
        class_1799 held = user.method_5998(class_1268.field_5808);
        if (held.method_7909() instanceof RifleItem && (ri = (RifleItem)held.method_7909()).getMode(held) == mode) {
            ammo += ri.getRemainingAmmo(held);
        }
        return ammo;
    }

    public boolean isAmmoCanned(class_1657 user, RifleMode mode) {
        return this.getAmmoCanSlot(user, mode) != null;
    }

    @Nullable
    public SlotReference getAmmoCanSlot(class_1657 user, RifleMode mode) {
        class_1799 is;
        class_1263 inv;
        SlotReference ref;
        Optional<SlotReference> backpack = Yttr.trinketsAccess.getWorn(user, YItems.AMMO_PACK::is);
        if (backpack.isPresent() && (ref = Yttr.scanInventory(inv = ((InventoryProviderItem)(is = backpack.get().getStack()).method_7909()).asInventory(is), this.isMatchingCan(mode))) != null) {
            return ref;
        }
        return Yttr.scanInventory((class_1263)user.method_31548(), this.isMatchingCan(mode));
    }

    private Predicate<class_1799> isMatchingCan(RifleMode mode) {
        return is -> this.isMatchingCan((class_1799)is, mode);
    }

    private boolean isMatchingCan(class_1799 is, RifleMode mode) {
        return is.method_7909() == YItems.AMMO_CAN && is.method_7985() && mode.name().equals(is.method_7969().method_10558("Mode")) && is.method_7969().method_10550("Shots") > 0;
    }

    public void changeMode(class_1657 user, RifleMode mode) {
        SlotReference can;
        if (user.method_6115()) {
            return;
        }
        class_1799 stack = user.method_6047();
        if (stack.method_7985() && stack.method_7969().method_10577("ModeLocked")) {
            return;
        }
        RifleMode oldMode = this.getMode(stack);
        if (this.setMode(stack, mode)) {
            user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, YSounds.RIFLE_WASTE, user.method_5634(), 3.0f, 0.75f);
            user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, YSounds.RIFLE_WASTE, user.method_5634(), 3.0f, 1.0f);
            user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, YSounds.RIFLE_WASTE, user.method_5634(), 3.0f, 1.5f);
            if (user.field_6002 instanceof class_3218) {
                float r = (float)(oldMode.color >> 16 & 0xFF) / 255.0f;
                float g = (float)(oldMode.color >> 8 & 0xFF) / 255.0f;
                float b = (float)(oldMode.color >> 0 & 0xFF) / 255.0f;
                ((class_3218)user.field_6002).method_14199((class_2394)new class_2390(new class_1160(r, g, b), 1.0f), user.method_19538().field_1352, user.method_19538().field_1351 + 0.1, user.method_19538().field_1350, 12, 0.2, 0.1, 0.2, 1.0);
            }
        }
        if ((can = this.getAmmoCanSlot(user, mode)) == null) {
            if (stack.method_7985()) {
                stack.method_7969().method_10551("FiringFromCan");
                stack.method_7969().method_10551("LastCanFullness");
            }
        } else {
            if (!stack.method_7985()) {
                stack.method_7980(new class_2487());
            }
            stack.method_7969().method_10556("FiringFromCan", true);
            stack.method_7969().method_10548("LastCanFullness", (float)can.getStack().method_7969().method_10550("Shots") / 1024.0f);
        }
        user.method_6122(class_1268.field_5808, stack);
        user.field_6002.method_8465(null, user.method_19538().field_1352, user.method_19538().field_1351, user.method_19538().field_1350, YSounds.RIFLE_FIRE_DUD, user.method_5634(), 1.0f, 1.3f + (float)mode.ordinal() * 0.1f);
    }

    public int method_7881(class_1799 stack) {
        float max = this.getTrueMaxUseTime(stack);
        if (YConfig.General.trustPlayers) {
            max *= 1.25f;
        }
        return (int)max;
    }

    public int getTrueMaxUseTime(class_1799 stack) {
        return (int)(140.0f / (this.getMode((class_1799)stack).speed * this.speedMod));
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 _user, int remainingUseTicks) {
        if (!(_user instanceof class_1657)) {
            return;
        }
        class_1657 user = (class_1657)_user;
        if (YConfig.General.trustPlayers) {
            if (world.field_9236) {
                world.method_8449(user, (class_1297)user, YSounds.RIFLE_CHARGE_CANCEL, user.method_5634(), 1.0f, 1.0f);
                this.playFireSoundAndSetCooldown(user, this.calculatePower(this.calcAdjustedUseTime(stack, remainingUseTicks)));
                new MessageC2STrustedRifleFire(remainingUseTicks).sendToServer();
            }
        } else {
            this.doOnStoppedUsing(stack, world, user, remainingUseTicks);
        }
    }

    public void doOnStoppedUsing(class_1799 stack, class_1937 world, class_1657 user, int remainingUseTicks) {
        world.method_8449((class_1657)(YConfig.General.trustPlayers ? user : null), (class_1297)user, YSounds.RIFLE_CHARGE_CANCEL, user.method_5634(), 1.0f, 1.0f);
        int useTicks = this.calcAdjustedUseTime(stack, remainingUseTicks);
        float power = this.calculatePower(useTicks);
        RifleMode mode = this.getMode(stack);
        SlotReference can = this.getAmmoCanSlot(user, mode);
        if (can == null) {
            int ammo = this.getRemainingAmmo(stack);
            if (useTicks > 30) {
                this.setRemainingAmmo(stack, --ammo);
            }
            if (stack.method_7985()) {
                stack.method_7969().method_10551("FiringFromCan");
                stack.method_7969().method_10551("LastCanFullness");
            }
        } else if (useTicks > 30) {
            int shots = can.getStack().method_7969().method_10550("Shots");
            if (--shots <= 0) {
                can.setStack(new class_1799((class_1935)YItems.EMPTY_AMMO_CAN));
            } else {
                can.getStack().method_7969().method_10569("Shots", shots);
            }
            if (!stack.method_7985()) {
                stack.method_7980(new class_2487());
            }
            stack.method_7969().method_10556("FiringFromCan", true);
            stack.method_7969().method_10548("LastCanFullness", (float)shots / 1024.0f);
        }
        if (!mode.canFire((class_1309)user, stack, power)) {
            user.method_5783(YSounds.RIFLE_FIRE_DUD, 1.0f, 1.0f);
        } else {
            this.playFireSoundAndSetCooldown(user, power);
            if (world instanceof class_3218) {
                class_239 hr = RifleItem.raycast(world, user);
                int color = mode.color;
                color = (double)power > 1.2 ? -1 : (color |= (int)Math.min(255.0f, power * 255.0f) << 24);
                new MessageS2CBeam(user.method_5628(), color, (float)hr.method_17784().field_1352, (float)hr.method_17784().field_1351, (float)hr.method_17784().field_1350).sendToAllWatching((class_1297)user);
                if (hr instanceof class_3965) {
                    class_3965 bhr = (class_3965)hr;
                    class_2680 bs = world.method_8320(bhr.method_17777());
                    if (bs.method_26204() instanceof Shootable && ((Shootable)bs.method_26204()).onShotByRifle(world, bs, (class_1309)user, mode, power, bhr.method_17777(), bhr)) {
                        return;
                    }
                } else if (hr instanceof class_3966) {
                    class_3966 ehr = (class_3966)hr;
                    if (user instanceof class_3222 && stack.method_7985() && stack.method_7969().method_10577("Scoped") && ehr.method_17782().method_5858((class_1297)user) > 10000.0) {
                        YCriteria.SHOOT_SOMETHING_FAR_AWAY.trigger((class_3222)user);
                    }
                }
                YStats.add((class_1309)user, YStats.RIFLE_SHOTS_FIRED, 1);
                if ((double)power > 1.1) {
                    YStats.add((class_1309)user, YStats.RIFLE_SHOTS_OVERCHARGED, 1);
                }
                mode.handleFire((class_1309)user, stack, power, hr);
            }
        }
    }

    public static class_239 raycast(class_1937 world, class_1657 user) {
        class_243 max;
        class_243 preStart = user.method_5836(0.0f);
        class_243 preEnd = user.method_5836(0.0f).method_1019(user.method_5828(0.0f).method_1021(64.0));
        class_243 start = RifleItem.getMuzzlePos((class_1297)user, false);
        class_243 end = max = user.method_5836(0.0f).method_1019(user.method_5828(0.0f).method_1021(256.0));
        class_3965 preBlock = world.method_17742(new class_3959(preStart, preEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)user));
        class_3966 preEnt = RifleItem.correctEntityHit(class_1675.method_18077((class_1937)user.field_6002, (class_1297)user, (class_243)preStart, (class_243)preBlock.method_17784(), (class_238)new class_238(preStart, preEnd).method_1014(0.3), (Predicate)Predicates.alwaysTrue()), preStart, preEnd);
        class_239 pre = (class_239)MoreObjects.firstNonNull((Object)preEnt, (Object)preBlock);
        if (pre.method_17783() != class_239.class_240.field_1333 && start.method_1025(pre.method_17784()) > 9.0) {
            end = pre.method_17784().method_1019(preBlock.method_17784().method_1020(start).method_1029());
        }
        class_3965 bhr = world.method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)user));
        class_3966 ehr = RifleItem.correctEntityHit(class_1675.method_18077((class_1937)user.field_6002, (class_1297)user, (class_243)start, (class_243)bhr.method_17784(), (class_238)new class_238(start, end).method_1014(0.3), (Predicate)Predicates.alwaysTrue()), start, end);
        return (class_239)MoreObjects.firstNonNull((Object)ehr, (Object)bhr);
    }

    protected void playFireSoundAndSetCooldown(class_1657 user, float power) {
        if ((double)power > 1.1) {
            if ((double)power > 1.2) {
                if ((double)power >= 1.29) {
                    user.method_5783(YSounds.RIFLE_FIRE, 2.0f, 0.5f);
                    user.method_5783(YSounds.RIFLE_FIRE, 2.0f, 0.5f);
                    user.method_5783(YSounds.RIFLE_FIRE, 2.0f, 2.0f);
                    user.method_5783(YSounds.RIFLE_FIRE, 2.0f, 1.0f);
                }
                user.method_5783(YSounds.RIFLE_FIRE, 2.0f, 0.75f);
                user.method_5783(YSounds.RIFLE_FIRE, 2.0f, 0.65f);
            }
            user.method_5783(YSounds.RIFLE_FIRE, 2.0f, 0.5f);
            user.method_5783(YSounds.RIFLE_FIRE, 1.0f, 1.0f);
            user.method_5783(YSounds.RIFLE_FIRE, 1.0f, 2.0f);
            user.method_5783(YSounds.RIFLE_FIRE, 1.0f, 1.25f);
            user.method_7357().method_7906((class_1792)this, 30);
        } else {
            user.method_5783(YSounds.RIFLE_FIRE, 1.0f, 0.9f + power / 4.0f);
            if (power > 1.0f) {
                user.method_5783(YSounds.RIFLE_FIRE, 1.0f, 0.75f);
            }
        }
    }

    private static class_3966 correctEntityHit(class_3966 ehr, class_243 start, class_243 end) {
        if (ehr == null) {
            return null;
        }
        return new class_3966(ehr.method_17782(), ehr.method_17782().method_5829().method_1014(0.3).method_992(start, end).orElse(end));
    }

    public int calcAdjustedUseTime(class_1799 stack, int remainingUseTicks) {
        return (int)this.calcAdjustedUseTime(stack, (float)remainingUseTicks);
    }

    public float calcAdjustedUseTime(class_1799 stack, float remainingUseTicks) {
        int diff = this.method_7881(stack) - this.getTrueMaxUseTime(stack);
        int max = this.getTrueMaxUseTime(stack);
        return ((float)max - (remainingUseTicks -= (float)diff)) / (float)max * 140.0f;
    }

    public RifleMode getMode(class_1799 stack) {
        return (RifleMode)((Object)Enums.getIfPresent(RifleMode.class, (String)(stack.method_7985() ? stack.method_7969().method_10558("Mode") : RifleMode.DAMAGE.name())).or((Object)RifleMode.DAMAGE));
    }

    public boolean setMode(class_1799 stack, RifleMode mode) {
        RifleMode cur;
        if (!stack.method_7985()) {
            stack.method_7980(new class_2487());
        }
        if ((cur = this.getMode(stack)) == mode) {
            return false;
        }
        stack.method_7969().method_10582("Mode", mode.name());
        stack.method_7969().method_10556("WasSelected", false);
        stack.method_7969().method_10556("FiringFromCan", false);
        int ammo = this.getRemainingAmmo(stack);
        this.setRemainingAmmo(stack, 0);
        return ammo > 0;
    }

    public int getRemainingAmmo(class_1799 stack) {
        return stack.method_7985() ? stack.method_7969().method_10550("RemainingAmmo") : 0;
    }

    public void setRemainingAmmo(class_1799 stack, int ammo) {
        if (!stack.method_7985()) {
            stack.method_7980(new class_2487());
        }
        stack.method_7969().method_10569("RemainingAmmo", ammo);
    }

    public int getMaxAmmo(class_1799 stack) {
        return this.getMode((class_1799)stack).shotsPerItem / this.ammoMod;
    }

    public float calculatePower(int i) {
        float power = 0.0f;
        if (this.simpleCurve) {
            if (i > 30) {
                int j = i - 30;
                power = (float)j / 40.0f;
                if (power > 1.0f) {
                    power = 1.0f;
                }
                if (j > 80) {
                    power += (float)(j - 80) / 50.0f;
                }
                if (power > 1.24f) {
                    power = 1.24f;
                }
            }
        } else if (i == 132 || i == 133) {
            power = 1.3f;
        } else if (i > 30) {
            int j = i - 30;
            power = j > 80 ? 0.8f + class_3532.method_15374((float)((float)(j - 90) / 25.0f * (float)Math.PI)) / 2.0f : (j > 60 ? 0.7f - class_3532.method_15374((float)((float)(j - 60) / 40.0f * (float)Math.PI)) * 0.4f : class_3532.method_15374((float)((float)j / 80.0f * (float)Math.PI)));
        }
        return power;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 _user) {
        SlotReference can;
        if (!(_user instanceof class_1657)) {
            return stack;
        }
        class_1657 user = (class_1657)_user;
        user.method_5783(YSounds.RIFLE_OVERCHARGE, 1.0f, 1.0f);
        user.method_5643(new class_1282("yttr.rifle_overcharge"){}, 8.0f * this.speedMod);
        user.method_5639((int)(3.0f * this.speedMod));
        if (!stack.method_7985()) {
            stack.method_7980(new class_2487());
        }
        if ((can = this.getAmmoCanSlot(user, this.getMode(stack))) == null) {
            this.setRemainingAmmo(stack, 0);
        } else {
            int shots = can.getStack().method_7969().method_10550("Shots");
            if ((shots -= 10) <= 0) {
                can.setStack(new class_1799((class_1935)YItems.EMPTY_AMMO_CAN));
            } else {
                can.getStack().method_7969().method_10569("Shots", shots);
            }
            if (!stack.method_7985()) {
                stack.method_7980(new class_2487());
            }
            stack.method_7969().method_10556("FiringFromCan", true);
            stack.method_7969().method_10548("LastCanFullness", (float)shots / 1024.0f);
        }
        if (!world.field_9236) {
            this.getMode(stack).handleBackfire((class_1309)user, stack);
        }
        YStats.add((class_1309)user, YStats.RIFLE_SHOTS_BACKFIRED, 1);
        user.method_7357().method_7906((class_1792)this, (int)(160.0f * this.speedMod));
        return stack;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        YStats.add(user, YStats.RIFLE_CHARGING_TIME, 1);
        int useTicks = this.calcAdjustedUseTime(stack, remainingUseTicks);
        if (world.field_9236 && YConfig.Rifle.timingAssist) {
            if (!this.simpleCurve) {
                if (useTicks == 70) {
                    user.method_5783(class_3417.field_14627, 0.3f, 0.8f);
                    user.method_5783(class_3417.field_14627, 0.3f, 0.5f);
                } else if (useTicks == 110 || useTicks == 120) {
                    user.method_5783(class_3417.field_14627, 0.6f, 1.0f);
                    user.method_5783(class_3417.field_14627, 0.3f, 1.2f);
                } else if (useTicks == 130) {
                    user.method_5783(class_3417.field_14627, 0.6f, 2.0f);
                    user.method_5783(class_3417.field_14627, 0.3f, 1.5f);
                }
            } else if (useTicks == 70) {
                user.method_5783(class_3417.field_14627, 0.3f, 0.8f);
                user.method_5783(class_3417.field_14627, 0.3f, 0.5f);
            } else if (useTicks == 122) {
                user.method_5783(class_3417.field_14627, 0.6f, 2.0f);
                user.method_5783(class_3417.field_14627, 0.3f, 1.5f);
            }
        }
        if (useTicks >= 140 && YConfig.General.trustPlayers && world.field_9236) {
            user.method_6021();
            this.method_7861(stack, world, user);
            new MessageC2STrustedRifleFire(0).sendToServer();
            return;
        }
        if (remainingUseTicks % 5 == 0) {
            user.method_5783(YSounds.RIFLE_CHARGE_CONTINUE, 1.0f, 1.0f);
            if (useTicks >= 100) {
                user.method_5783(YSounds.RIFLE_CHARGE_RATTLE, 1.0f, 1.0f);
            }
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        boolean wasSelected;
        super.method_7888(stack, world, entity, slot, selected);
        boolean bl = wasSelected = stack.method_7985() && stack.method_7969().method_10577("WasSelected");
        if (selected != wasSelected) {
            if (!stack.method_7985()) {
                stack.method_7980(new class_2487());
            }
            stack.method_7969().method_10556("WasSelected", selected);
            if (wasSelected) {
                world.method_8449(null, entity, YSounds.RIFLE_CHARGE_CANCEL, entity.method_5634(), 1.0f, 1.0f);
            }
        }
        if (entity.field_6012 % 4 == 0 && entity instanceof class_1657 && ((class_1657)entity).method_7357().method_7904((class_1792)this)) {
            entity.method_5783(YSounds.RIFLE_VENT, selected ? 0.5f : 0.2f, 0.6f + ThreadLocalRandom.current().nextFloat() / 3.0f);
        }
    }

    public boolean method_7886(class_1799 stack) {
        return false;
    }

    public static class_243 getMuzzlePos(class_1297 entity, boolean firstPerson) {
        class_1799 stack;
        class_1306 arm = entity instanceof class_1309 ? ((class_1309)entity).method_6068() : class_1306.field_6183;
        class_243 eyes = entity.method_5836(0.0f);
        class_243 look = entity.method_5828(0.0f);
        class_243 right = ((AccessorEntity)entity).yttr$invokeGetRotationVector(0.0f, entity.method_5705(0.0f) + 90.0f);
        class_243 down = look.method_1036(right);
        if (entity instanceof class_1309 && (stack = ((class_1309)entity).method_5998(class_1268.field_5808)).method_7909() instanceof RifleItem && stack.method_7985() && stack.method_7969().method_10577("Scoped")) {
            return eyes.method_1019(down.method_1021(0.075));
        }
        if (arm == class_1306.field_6182) {
            right = right.method_1021(-1.0);
        }
        return eyes.method_1019(look.method_1021(0.5)).method_1019(right.method_1021(0.25)).method_1019(down.method_1021(0.075));
    }

    @Environment(value=EnvType.CLIENT)
    public int getColor(class_1799 stack, int tintIndex) {
        if (tintIndex == 0) {
            return this.baseColor;
        }
        RifleItem item = (RifleItem)stack.method_7909();
        RifleMode mode = ((RifleItem)stack.method_7909()).getMode(stack);
        float v = stack.method_7985() && stack.method_7969().method_10577("FiringFromCan") ? stack.method_7969().method_10583("LastCanFullness") : (float)item.getRemainingAmmo(stack) / (float)item.getMaxAmmo(stack);
        return RifleItem.getPortionColor(tintIndex - 1, 6, v, mode.color, this.baseColor);
    }

    @Environment(value=EnvType.CLIENT)
    public static int getPortionColor(int idx, int portions, float v, int filledColor, int emptyColor) {
        int vi = (int)(v *= (float)portions);
        if (vi > idx) {
            return filledColor;
        }
        float a = vi < idx ? 1.0f : 1.0f - v % 1.0f;
        float rF = (float)class_1011.method_24035((int)filledColor) / 255.0f;
        float gF = (float)class_1011.method_24034((int)filledColor) / 255.0f;
        float bF = (float)class_1011.method_24033((int)filledColor) / 255.0f;
        float rE = (float)(emptyColor >> 16 & 0xFF) / 255.0f + 0.05f;
        float gE = (float)(emptyColor >> 8 & 0xFF) / 255.0f + 0.05f;
        float bE = (float)(emptyColor & 0xFF) / 255.0f + 0.15f;
        float r = rF + (rE - rF) * a;
        float g = gF + (gE - gF) * a;
        float b = bF + (bE - bF) * a;
        return class_1011.method_24031((int)255, (int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f)));
    }

    @Override
    public String getState(class_1657 player, class_1799 stack, boolean fHeld) {
        if (player.method_6115() && player.method_6058() == class_1268.field_5808) {
            return "charge";
        }
        return fHeld ? "mode" : "normal";
    }
}

