/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.content.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.unascribed.yttr.content.block.decor.CleavedBlock;
import com.unascribed.yttr.content.block.decor.CleavedBlockEntity;
import com.unascribed.yttr.init.YBlocks;
import com.unascribed.yttr.init.YCriteria;
import com.unascribed.yttr.init.YItems;
import com.unascribed.yttr.init.YSounds;
import com.unascribed.yttr.init.YStats;
import com.unascribed.yttr.init.YTags;
import com.unascribed.yttr.mixin.accessor.AccessorBlockSoundGroup;
import com.unascribed.yttr.util.Attackable;
import com.unascribed.yttr.util.ControlHintable;
import com.unascribed.yttr.util.NBTUtils;
import com.unascribed.yttr.util.math.partitioner.DEdge;
import com.unascribed.yttr.util.math.partitioner.Plane;
import com.unascribed.yttr.util.math.partitioner.Polygon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class CleaverItem
extends class_1792
implements Attackable,
ControlHintable {
    public static final int SUBDIVISIONS = 4;

    public CleaverItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_7909() == YItems.GLASSY_VOID;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return !miner.method_31549().field_7477;
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_1799 stack = ctx.method_8041();
        class_1657 player = ctx.method_8036();
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        if (!this.requiresSneaking() || player.method_5715()) {
            class_2338 expected = this.getCleaveBlock(stack);
            if (expected == null) {
                class_2680 state = world.method_8320(pos);
                if (!CleaverItem.canCleave(world, pos, state)) {
                    return class_1269.field_5814;
                }
                class_243 point = this.findCutPoint(ctx.method_17698().method_1020(class_243.method_24954((class_2382)pos)));
                if (point == null) {
                    return class_1269.field_5814;
                }
                this.setCleaveCorner(stack, null);
                this.setCleaveBlock(stack, pos);
                this.setCleaveStart(stack, point);
                return class_1269.field_5812;
            }
            if (this.getCleaveCorner(stack) == null) {
                pos = this.getCleaveBlock(stack);
                class_243 point = this.findCutPoint(ctx.method_17698().method_1020(class_243.method_24954((class_2382)pos)));
                if (point == null) {
                    return class_1269.field_5814;
                }
                this.setCleaveCorner(stack, point);
                return class_1269.field_5812;
            }
            if (world.field_9236) {
                return class_1269.field_21466;
            }
            pos = this.getCleaveBlock(stack);
            class_243 start = this.getCleaveStart(stack);
            class_243 corner = this.getCleaveCorner(stack);
            class_2680 state = world.method_8320(pos);
            if (!CleaverItem.canCleave(world, pos, state)) {
                return class_1269.field_5814;
            }
            class_243 end = this.findCutPoint(ctx.method_17698().method_1020(class_243.method_24954((class_2382)pos)));
            if (end == null) {
                return class_1269.field_5814;
            }
            Plane plane = new Plane(start, corner, end);
            if (this.performWorldCleave(world, pos, stack, player, plane)) {
                this.setLastCut(stack, plane);
                this.setCleaveBlock(stack, null);
                this.setCleaveStart(stack, null);
                this.setCleaveCorner(stack, null);
                player.method_7353((class_2561)new class_2588("tip.yttr.cleaver.repeat_cut" + (this.requiresSneaking() ? "_sneak" : "")), true);
            }
        }
        return class_1269.field_5811;
    }

    public static boolean canCleave(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_26164(YTags.Block.UNCLEAVABLE)) {
            return false;
        }
        return !(state.method_26204() instanceof class_2343) && state.method_26218((class_1922)world, pos) == class_259.method_1077() && state.method_26214((class_1922)world, pos) >= 0.0f;
    }

    public static List<Polygon> getShape(class_1937 world, class_2338 pos) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof CleavedBlockEntity) {
            return Lists.newArrayList((Iterable)Iterables.transform(((CleavedBlockEntity)be).getPolygons(), Polygon::copy));
        }
        return CleavedBlockEntity.cube();
    }

    private class_243 findCutPoint(class_243 hit) {
        double z;
        double y;
        double x = (double)Math.round(hit.field_1352 * 4.0) / 4.0;
        double dist = hit.method_1028(x, y = (double)Math.round(hit.field_1351 * 4.0) / 4.0, z = (double)Math.round(hit.field_1350 * 4.0) / 4.0);
        if (dist > 0.0225) {
            return null;
        }
        if (x < 0.0 || y < 0.0 || z < 0.0 || x > 1.0 || y > 1.0 || z > 1.0) {
            return null;
        }
        return new class_243(x, y, z);
    }

    @Override
    public void attack(class_1657 user) {
        class_1799 stack = user.method_6047();
        if (this.getCleaveBlock(stack) == null) {
            class_3965 bhr;
            if (this.requiresSneaking() && !user.method_5715()) {
                return;
            }
            Plane p = this.getLastCut(stack);
            if (p != null && (bhr = CleaverItem.method_7872((class_1937)user.field_6002, (class_1657)user, (class_3959.class_242)class_3959.class_242.field_1348)).method_17783() != class_239.class_240.field_1333 && CleaverItem.canCleave(user.field_6002, bhr.method_17777(), user.field_6002.method_8320(bhr.method_17777())) && this.performWorldCleave(user.field_6002, bhr.method_17777(), stack, user, p)) {
                YStats.add((class_1309)user, YStats.BLOCKS_CLEAVED, 1);
            }
        } else if (this.getCleaveCorner(stack) != null) {
            this.setCleaveCorner(stack, null);
        } else {
            this.setCleaveBlock(stack, null);
            this.setCleaveStart(stack, null);
        }
    }

    public boolean performWorldCleave(class_1937 world, class_2338 pos, class_1799 stack, class_1657 player, Plane plane) {
        class_2680 state = world.method_8320(pos);
        List<Polygon> shape = CleaverItem.getShape(world, pos);
        List<Polygon> result = CleaverItem.performCleave(plane, shape, false);
        if (!result.isEmpty()) {
            CleavedBlockEntity cbe;
            class_2586 be;
            world.method_8396(null, pos, YSounds.CLEAVER, class_3419.field_15245, 1.0f, 1.5f);
            class_3414 breakSound = ((AccessorBlockSoundGroup)state.method_26231()).yttr$getBreakSound();
            if (breakSound != null) {
                world.method_8396(null, pos, breakSound, class_3419.field_15245, 0.5f, 1.0f);
            }
            if ((be = world.method_8321(pos)) instanceof CleavedBlockEntity) {
                cbe = (CleavedBlockEntity)be;
            } else {
                class_2680 newState = (class_2680)YBlocks.CLEAVED_BLOCK.method_9564().method_11657((class_2769)CleavedBlock.LUMINANCE, (Comparable)Integer.valueOf(state.method_26213()));
                if (state.method_28498((class_2769)class_2741.field_12508)) {
                    newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508)));
                }
                world.method_8501(pos, newState);
                cbe = (CleavedBlockEntity)world.method_8321(pos);
                cbe.setDonor(state);
            }
            cbe.setPolygons(result);
            stack.method_7956(1, (class_1309)player, e -> player.method_20236(class_1268.field_5808));
            YStats.add((class_1309)player, YStats.BLOCKS_CLEAVED, 1);
            if (player instanceof class_3222) {
                YCriteria.CLEAVE_BLOCK.method_9087((class_3222)player, pos, stack);
            }
            return true;
        }
        return false;
    }

    public static List<Polygon> performCleave(Plane plane, List<Polygon> polygonsIn, boolean invert) {
        ArrayList out;
        ArrayList above = Lists.newArrayList();
        ArrayList on = Lists.newArrayList();
        ArrayList below = Lists.newArrayList();
        for (Polygon polygon : polygonsIn) {
            Polygon.split(polygon, plane, above, on, below);
        }
        if (invert) {
            out = Lists.newArrayList();
            out.addAll(on);
            out.addAll(below);
        } else {
            out = above;
        }
        if (out.isEmpty()) {
            return out;
        }
        if (out.size() < 3) {
            return Collections.emptyList();
        }
        ArrayList joinerPoints = Lists.newArrayList();
        for (Polygon polygon : out) {
            for (DEdge de : polygon) {
                if (!(Math.abs(plane.sDistance(de.srcPoint())) < 1.0E-5)) continue;
                joinerPoints.add(de.srcPoint());
            }
        }
        if (!joinerPoints.isEmpty()) {
            Polygon p = new Polygon(Lists.reverse((List)joinerPoints));
            out.add(p);
        }
        if (out.equals(polygonsIn)) {
            return Collections.emptyList();
        }
        return out;
    }

    public int method_7881(class_1799 stack) {
        return 36000;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }

    public boolean requiresSneaking() {
        return false;
    }

    @Nullable
    public class_2338 getCleaveBlock(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10573("CleaveBlock", 9)) {
            return NBTUtils.listToBlockPos(stack.method_7969().method_10554("CleaveBlock", 3));
        }
        return null;
    }

    @Nullable
    public class_243 getCleaveStart(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10573("CleaveStart", 9)) {
            return NBTUtils.listToVec(stack.method_7969().method_10554("CleaveStart", 6));
        }
        return null;
    }

    @Nullable
    public class_243 getCleaveCorner(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10573("CleaveCorner", 9)) {
            return NBTUtils.listToVec(stack.method_7969().method_10554("CleaveCorner", 6));
        }
        return null;
    }

    @Nullable
    public Plane getLastCut(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10573("LastCut", 10)) {
            class_2487 tag = stack.method_7969().method_10562("LastCut");
            class_243 normal = NBTUtils.listToVec(tag.method_10554("Normal", 6));
            if (normal == null) {
                return null;
            }
            double distance = tag.method_10574("Distance");
            double epsilon = tag.method_10574("Epsilon");
            return new Plane(normal, distance, epsilon);
        }
        return null;
    }

    public void setCleaveBlock(class_1799 stack, @Nullable class_2338 pos) {
        if (!stack.method_7985()) {
            if (pos == null) {
                return;
            }
            stack.method_7980(new class_2487());
        }
        if (pos == null) {
            stack.method_7969().method_10551("CleaveBlock");
        } else {
            stack.method_7969().method_10566("CleaveBlock", (class_2520)NBTUtils.blockPosToList(pos));
        }
    }

    public void setCleaveStart(class_1799 stack, @Nullable class_243 pos) {
        this.setVec(stack, "CleaveStart", pos);
    }

    public void setCleaveCorner(class_1799 stack, @Nullable class_243 pos) {
        this.setVec(stack, "CleaveCorner", pos);
    }

    public void setLastCut(class_1799 stack, @Nullable Plane plane) {
        if (!stack.method_7985()) {
            if (plane == null) {
                return;
            }
            stack.method_7980(new class_2487());
        }
        if (plane == null) {
            stack.method_7969().method_10551("LastCut");
        } else {
            class_2487 tag = new class_2487();
            tag.method_10566("Normal", (class_2520)NBTUtils.vecToList(plane.normal()));
            tag.method_10549("Distance", plane.distance());
            tag.method_10549("Epsilon", plane.epsilon());
            stack.method_7969().method_10566("LastCut", (class_2520)tag);
        }
    }

    private void setVec(class_1799 stack, String key, @Nullable class_243 pos) {
        if (!stack.method_7985()) {
            if (pos == null) {
                return;
            }
            stack.method_7980(new class_2487());
        }
        if (pos == null) {
            stack.method_7969().method_10551(key);
        } else {
            stack.method_7969().method_10566(key, (class_2520)NBTUtils.vecToList(pos));
        }
    }

    @Override
    public String getState(class_1657 player, class_1799 stack, boolean fHeld) {
        if (stack.method_7985()) {
            if (stack.method_7969().method_10545("CleaveCorner")) {
                return "step2";
            }
            if (stack.method_7969().method_10545("CleaveStart")) {
                return "step1";
            }
            if (stack.method_7969().method_10545("LastCut")) {
                return "repeatable";
            }
        }
        return "normal";
    }
}

