/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.content.block.decor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.client.cache.CleavedBlockMeshes;
import com.unascribed.yttr.init.YBlockEntities;
import com.unascribed.yttr.mixinsupport.YttrWorld;
import com.unascribed.yttr.util.math.partitioner.Polygon;
import com.unascribed.yttr.util.math.partitioner.Where;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_244;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_249;
import net.minecraft.class_2499;
import net.minecraft.class_251;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class CleavedBlockEntity
extends class_2586
implements RenderAttachmentBlockEntity {
    public static int SHAPE_GRANULARITY = 8;
    private List<Polygon> polygons = CleavedBlockEntity.cube();
    private class_2680 donor = class_2246.field_10124.method_9564();
    public Object clientCacheData;
    private class_265 cachedShape;

    public static List<Polygon> cube() {
        return Lists.newArrayList((Object[])new Polygon[]{new Polygon(new class_243(0.0, 0.0, 0.0), new class_243(1.0, 0.0, 0.0), new class_243(1.0, 0.0, 1.0), new class_243(0.0, 0.0, 1.0)), new Polygon(new class_243(0.0, 1.0, 1.0), new class_243(1.0, 1.0, 1.0), new class_243(1.0, 1.0, 0.0), new class_243(0.0, 1.0, 0.0)), new Polygon(new class_243(0.0, 0.0, 1.0), new class_243(0.0, 1.0, 1.0), new class_243(0.0, 1.0, 0.0), new class_243(0.0, 0.0, 0.0)), new Polygon(new class_243(1.0, 0.0, 0.0), new class_243(1.0, 1.0, 0.0), new class_243(1.0, 1.0, 1.0), new class_243(1.0, 0.0, 1.0)), new Polygon(new class_243(0.0, 1.0, 0.0), new class_243(1.0, 1.0, 0.0), new class_243(1.0, 0.0, 0.0), new class_243(0.0, 0.0, 0.0)), new Polygon(new class_243(0.0, 0.0, 1.0), new class_243(1.0, 0.0, 1.0), new class_243(1.0, 1.0, 1.0), new class_243(0.0, 1.0, 1.0))});
    }

    public CleavedBlockEntity(class_2338 pos, class_2680 state) {
        super(YBlockEntities.CLEAVED_BLOCK, pos, state);
    }

    public List<Polygon> getPolygons() {
        return this.polygons;
    }

    public void setPolygons(Iterable<Polygon> polygons) {
        this.polygons = ImmutableList.copyOf(polygons);
        this.cachedShape = null;
        this.method_5431();
        Yttr.sync(this);
    }

    public class_265 getShape() {
        class_265 shape;
        if (this.cachedShape != null) {
            return this.cachedShape;
        }
        this.field_11863.method_16107().method_15396("yttr:cleaved_shapegen");
        int acc = SHAPE_GRANULARITY;
        class_244 voxels = new class_244(acc, acc, acc);
        for (int x = 0; x < acc; ++x) {
            for (int y = 0; y < acc; ++y) {
                for (int z = 0; z < acc; ++z) {
                    class_243[] points = new class_243[]{new class_243(((double)x + 0.1) / (double)acc, ((double)y + 0.1) / (double)acc, ((double)z + 0.1) / (double)acc), new class_243(((double)x + 0.9) / (double)acc, ((double)y + 0.1) / (double)acc, ((double)z + 0.1) / (double)acc), new class_243(((double)x + 0.1) / (double)acc, ((double)y + 0.1) / (double)acc, ((double)z + 0.9) / (double)acc), new class_243(((double)x + 0.9) / (double)acc, ((double)y + 0.1) / (double)acc, ((double)z + 0.9) / (double)acc), new class_243(((double)x + 0.1) / (double)acc, ((double)y + 0.9) / (double)acc, ((double)z + 0.1) / (double)acc), new class_243(((double)x + 0.9) / (double)acc, ((double)y + 0.9) / (double)acc, ((double)z + 0.1) / (double)acc), new class_243(((double)x + 0.1) / (double)acc, ((double)y + 0.9) / (double)acc, ((double)z + 0.9) / (double)acc), new class_243(((double)x + 0.9) / (double)acc, ((double)y + 0.9) / (double)acc, ((double)z + 0.9) / (double)acc)};
                    int outsideCount = 0;
                    for (Polygon p : this.polygons) {
                        for (class_243 point : points) {
                            if (p.plane().whichSide(point) != Where.ABOVE) continue;
                            ++outsideCount;
                        }
                    }
                    if (outsideCount >= 4) continue;
                    voxels.method_1049(x, y, z);
                }
            }
        }
        this.cachedShape = shape = new class_249((class_251)voxels).method_1097();
        this.field_11863.method_16107().method_15407();
        return shape;
    }

    public class_2680 getDonor() {
        return this.donor;
    }

    public void setDonor(class_2680 donor) {
        this.donor = donor;
        this.method_5431();
        Yttr.sync(this);
    }

    public void fromTagInner(class_2487 tag) {
        if (tag.method_10573("Polygons", 9)) {
            ImmutableList.Builder builder = ImmutableList.builder();
            class_2499 li = tag.method_10554("Polygons", 7);
            for (int i = 0; i < li.size(); ++i) {
                class_2520 en = li.method_10534(i);
                ArrayList points = Lists.newArrayList();
                if (!(en instanceof class_2479)) continue;
                byte[] arr = ((class_2479)en).method_10521();
                for (int j = 0; j < arr.length; j += 3) {
                    points.add(new class_243(this.byteToUnit(arr[j]), this.byteToUnit(arr[j + 1]), this.byteToUnit(arr[j + 2])));
                }
                builder.add((Object)new Polygon(points));
            }
            this.polygons = builder.build();
        } else {
            this.polygons = CleavedBlockEntity.cube();
        }
        this.donor = class_2512.method_10681((class_2487)tag.method_10562("Donor"));
        this.clientCacheData = null;
        this.cachedShape = null;
        if (this.field_11863 instanceof YttrWorld) {
            ((YttrWorld)this.field_11863).yttr$scheduleRenderUpdate(this.field_11867);
        }
    }

    public class_2487 toTagInner(class_2487 tag) {
        class_2499 li = new class_2499();
        for (Polygon poly : this.polygons) {
            ByteBuffer buf = ByteBuffer.allocate(poly.nPoints() * 3);
            poly.forEachDEdge(de -> {
                buf.put(this.unitToByte(de.srcPoint().field_1352));
                buf.put(this.unitToByte(de.srcPoint().field_1351));
                buf.put(this.unitToByte(de.srcPoint().field_1350));
            });
            buf.flip();
            li.add((Object)new class_2479(buf.array()));
        }
        tag.method_10566("Polygons", (class_2520)li);
        tag.method_10566("Donor", (class_2520)class_2512.method_10686((class_2680)this.donor));
        return tag;
    }

    private byte unitToByte(double d) {
        return (byte)((int)(d * 255.0) & 0xFF);
    }

    private double byteToUnit(byte b) {
        return (double)(b & 0xFF) / 255.0;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.fromTagInner(tag);
    }

    public void method_11007(class_2487 tag) {
        this.toTagInner(tag);
        super.method_11007(tag);
    }

    public class_2487 method_16887() {
        return this.toTagInner(super.method_16887());
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public Object getRenderAttachmentData() {
        return CleavedBlockMeshes.getMesh(this);
    }
}

