/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.content.block.decor;

import com.unascribed.yttr.YConfig;
import com.unascribed.yttr.content.block.decor.CleavedBlockEntity;
import com.unascribed.yttr.init.YBlocks;
import com.unascribed.yttr.mixinsupport.SlopeStander;
import com.unascribed.yttr.util.math.partitioner.DEdge;
import com.unascribed.yttr.util.math.partitioner.Polygon;
import com.unascribed.yttr.util.math.partitioner.Where;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.minecraft.class_1297;
import net.minecraft.class_1307;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_4970;

@EnvironmentInterface(itf=class_322.class, value=EnvType.CLIENT)
public class CleavedBlock
extends class_2248
implements class_2343,
class_322,
class_3737 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_2758 LUMINANCE = class_2758.method_11867((String)"luminance", (int)0, (int)15);

    public CleavedBlock(class_4970.class_2251 settings) {
        super(settings.method_9631(bs -> (Integer)bs.method_11654((class_2769)LUMINANCE)));
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LUMINANCE, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, LUMINANCE});
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CleavedBlockEntity(pos, state);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15785() : class_3612.field_15906.method_15785();
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof CleavedBlockEntity) {
            return ((CleavedBlockEntity)be).getShape();
        }
        return super.method_9530(state, world, pos, context);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        class_2586 be = (class_2586)builder.method_305(class_181.field_1228);
        if (be instanceof CleavedBlockEntity) {
            return ((CleavedBlockEntity)be).getDonor().method_26189(builder);
        }
        return Collections.emptyList();
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof CleavedBlockEntity) {
            world.method_8444(player, 2001, pos, CleavedBlock.method_9507((class_2680)((CleavedBlockEntity)be).getDonor()));
        }
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof CleavedBlockEntity) {
            return ((CleavedBlockEntity)be).getDonor().method_26165(player, world, pos);
        }
        return super.method_9594(state, player, world, pos);
    }

    public int method_9505(class_2680 state, class_1922 world, class_2338 pos) {
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof CleavedBlockEntity) {
            return ((CleavedBlockEntity)be).getDonor().method_26204().method_9574(world, pos, ((CleavedBlockEntity)be).getDonor());
        }
        return super.method_9574(world, pos, state);
    }

    public void onEntityNearby(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof CleavedBlockEntity) {
            if (entity instanceof class_1307 || entity instanceof class_1657 && (((class_1657)entity).method_6128() || ((class_1657)entity).method_31549().field_7479)) {
                return;
            }
            List<Polygon> shape = ((CleavedBlockEntity)be).getPolygons();
            double checkDist = 2.0 / (double)CleavedBlockEntity.SHAPE_GRANULARITY;
            class_238 box = entity.method_5829();
            double x = box.method_1005().field_1352;
            double y = box.field_1322;
            double z = box.method_1005().field_1350;
            int signum = -1;
            if (box.field_1322 < (double)pos.method_10264()) {
                return;
            }
            Polygon relevant = null;
            for (Polygon p : shape) {
                class_243 normal = p.plane().normal();
                if (normal.field_1352 == 0.0 && normal.field_1351 == 0.0 || normal.field_1352 == 0.0 && normal.field_1350 == 0.0 || normal.field_1350 == 0.0 && normal.field_1351 == 0.0) continue;
                relevant = p;
                break;
            }
            x -= (double)pos.method_10263();
            y -= (double)pos.method_10264();
            z -= (double)pos.method_10260();
            if (relevant == null) {
                return;
            }
            double pMinY = 200.0;
            double pMaxY = -200.0;
            for (DEdge edge : relevant) {
                pMinY = Math.min(pMinY, edge.srcPoint().field_1351);
                pMaxY = Math.max(pMaxY, edge.srcPoint().field_1351);
            }
            if (y > pMaxY + 0.05 || y < pMinY - 0.05) {
                return;
            }
            double origY = y;
            y -= checkDist * (double)signum;
            int steps = 64;
            boolean found = false;
            class_243 up = new class_243(0.0, 1.0, 0.0);
            float steepness = 0.0f;
            double dist = checkDist * 4.0;
            for (int i = 0; i < steps; ++i) {
                class_243 vec = new class_243(x, y += dist / (double)steps * (double)signum, z);
                if (relevant.plane().whichSide(vec) == Where.ABOVE) continue;
                found = true;
                steepness = (float)(1.0 - relevant.plane().normal().method_1026(up));
                break;
            }
            if (found) {
                SlopeStander ss = (SlopeStander)entity;
                class_2338 below = entity.method_24515().method_10074();
                class_2680 belowState = world.method_8320(below);
                if (!belowState.method_27852((class_2248)YBlocks.CLEAVED_BLOCK)) {
                    class_265 belowShape = belowState.method_26220((class_1922)world, below);
                    class_243 point = new class_243(x + (double)pos.method_10263(), y + (double)pos.method_10264(), z + (double)pos.method_10260());
                    for (class_238 b : belowShape.method_1090()) {
                        if (!b.method_996(below).method_1006(point)) continue;
                        return;
                    }
                }
                if (YConfig.Client.slopeSmoothing) {
                    double yO = y - origY;
                    if (ss.yttr$getYOffset() == 0.0 || ss.yttr$getYOffset() < yO) {
                        ss.yttr$setYOffset(yO);
                    }
                }
                ss.yttr$setSlopeSteepness(Math.max(ss.yttr$getSlopeSteepness(), steepness));
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public int getColor(class_2680 state, class_1920 world, class_2338 pos, int tintIndex) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof CleavedBlockEntity) {
            return class_310.method_1551().method_1505().method_1697(((CleavedBlockEntity)be).getDonor(), world, pos, tintIndex);
        }
        return -1;
    }
}

