/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.content.block.decor;

import com.google.common.base.MoreObjects;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.content.block.decor.BloqueBlock;
import com.unascribed.yttr.init.YBlockEntities;
import com.unascribed.yttr.mixinsupport.YttrWorld;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1160;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;

public class BloqueBlockEntity
extends class_2586
implements RenderAttachmentBlockEntity {
    private final class_1767[] colors = new class_1767[12];
    private final Adjacency[] adjacency = new Adjacency[12];
    private int welds;

    public BloqueBlockEntity(class_2338 pos, class_2680 state) {
        super(YBlockEntities.BLOQUE, pos, state);
    }

    public void set(int slot, @Nullable class_1767 color) {
        if (slot < 0 || slot >= this.colors.length) {
            return;
        }
        this.colors[slot] = color;
        if (!this.isWelded()) {
            this.field_11863.method_8427(this.method_11016(), this.method_11010().method_26204(), slot, color == null ? -1 : color.method_7789());
        }
        this.method_5431();
    }

    @Nullable
    public class_1767 get(int slot) {
        if (slot < 0 || slot >= this.colors.length) {
            return null;
        }
        return this.colors[slot];
    }

    public void weld() {
        if (!this.isWeldable()) {
            return;
        }
        if (this.welds == 0) {
            this.welds = 1;
            this.computeAdjacency(true, false, true);
        } else if (this.welds == 1) {
            this.welds = 2;
            this.computeAdjacency(true, true, false);
        } else if (this.welds >= 2) {
            this.welds = 3;
            this.computeAdjacency(true, true, true);
        }
        this.method_5431();
        Yttr.sync(this);
    }

    public void unweld() {
        if (!this.isWelded()) {
            return;
        }
        this.welds = 0;
        Arrays.fill(this.adjacency, null);
        this.method_5431();
        Yttr.sync(this);
    }

    private void computeAdjacency(boolean weld, boolean allowExternal, boolean mixColors) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 2; ++x) {
                for (int z = 0; z < 2; ++z) {
                    int slot = BloqueBlock.getSlot(x, y, z);
                    class_1767 cur = this.get(slot);
                    if (cur == null) {
                        this.adjacency[slot] = Adjacency.NONE;
                        continue;
                    }
                    AdjType[] b = new AdjType[6];
                    Arrays.fill((Object[])b, (Object)AdjType.NONE);
                    for (class_2350 d : class_2350.values()) {
                        boolean match;
                        int ox = x + d.method_10148();
                        int oy = y + d.method_10164();
                        int oz = z + d.method_10165();
                        class_1767 other = allowExternal ? this.getMulti(ox, oy, oz) : this.get(ox, oy, oz);
                        boolean external = false;
                        if (ox < 0 || oy < 0 || oz < 0 || ox >= 2 || oy >= 3 || oz >= 2) {
                            external = true;
                        }
                        boolean bl = weld && (mixColors ? other != null : other == cur) ? true : (match = false);
                        if (match) {
                            b[d.ordinal()] = external ? AdjType.MERGE_EXTERNAL : AdjType.MERGE_INTERNAL;
                            continue;
                        }
                        if (external) {
                            b[d.ordinal()] = AdjType.CULL_EDGE;
                            continue;
                        }
                        if (other == null) continue;
                        b[d.ordinal()] = AdjType.CULL;
                    }
                    this.adjacency[slot] = new Adjacency(b);
                }
            }
        }
    }

    public boolean isWelded() {
        return this.welds > 0;
    }

    public boolean isWeldable() {
        return true;
    }

    public void set(int x, int y, int z, @Nullable class_1767 color) {
        this.set(BloqueBlock.getSlot(x, y, z), color);
    }

    @Nullable
    public class_1767 get(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= 2 || y >= 3 || z >= 2) {
            return null;
        }
        return this.get(BloqueBlock.getSlot(x, y, z));
    }

    @Nullable
    public class_1767 getMulti(int x, int y, int z, class_2350 d) {
        return this.getMulti(x + d.method_10148(), y + d.method_10164(), z + d.method_10165());
    }

    @Nullable
    public class_1767 getMulti(int x, int y, int z) {
        class_2338 pos = this.method_11016();
        while (x < 0) {
            pos = pos.method_30513(class_2350.class_2351.field_11048, -1);
            x += 2;
        }
        while (x >= 2) {
            pos = pos.method_30513(class_2350.class_2351.field_11048, 1);
            x -= 2;
        }
        while (y < 0) {
            pos = pos.method_30513(class_2350.class_2351.field_11052, -1);
            y += 3;
        }
        while (y >= 3) {
            pos = pos.method_30513(class_2350.class_2351.field_11052, 1);
            y -= 3;
        }
        while (z < 0) {
            pos = pos.method_30513(class_2350.class_2351.field_11051, -1);
            z += 2;
        }
        while (z >= 2) {
            pos = pos.method_30513(class_2350.class_2351.field_11051, 1);
            z -= 2;
        }
        class_2586 be = this.field_11863.method_8321(pos);
        if (be instanceof BloqueBlockEntity) {
            BloqueBlockEntity bbe = (BloqueBlockEntity)be;
            return bbe.get(x, y, z);
        }
        return null;
    }

    public Adjacency getAdjacency(int slot) {
        if (slot < 0 || slot >= this.adjacency.length) {
            return Adjacency.NONE;
        }
        return (Adjacency)MoreObjects.firstNonNull((Object)this.adjacency[slot], (Object)Adjacency.NONE);
    }

    public Adjacency getAdjacency(int x, int y, int z) {
        return this.getAdjacency(BloqueBlock.getSlot(x, y, z));
    }

    public boolean isFullCube() {
        for (int i = 0; i < this.colors.length; ++i) {
            if (this.colors[i] != null) continue;
            return false;
        }
        return true;
    }

    public int getPopCount() {
        int c = 0;
        for (int i = 0; i < this.colors.length; ++i) {
            if (this.colors[i] == null) continue;
            ++c;
        }
        return c;
    }

    public boolean method_11004(int type, int data) {
        if (!this.field_11863.field_9236) {
            return true;
        }
        this.colors[type] = data == -1 ? null : class_1767.method_7791((int)data);
        this.computeAdjacency(false, false, false);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof YttrWorld) {
            YttrWorld yw = (YttrWorld)class_19372;
            yw.yttr$scheduleRenderUpdate(this.method_11016());
        }
        return true;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        byte[] bys = new byte[12];
        for (int i = 0; i < 12; ++i) {
            bys[i] = (byte)(this.colors[i] == null ? -1 : this.colors[i].method_7789());
        }
        nbt.method_10570("Colors", bys);
        if (this.welds > 0) {
            nbt.method_10567("Welds", (byte)this.welds);
            byte[] abys = new byte[72];
            for (int i = 0; i < 12; ++i) {
                int j = i * 6;
                for (class_2350 d : class_2350.values()) {
                    abys[j + d.ordinal()] = (byte)this.getAdjacency(i).getType(d).ordinal();
                }
            }
            nbt.method_10570("Adjacency", abys);
        }
    }

    public void method_11014(class_2487 nbt) {
        class_1937 class_19372;
        super.method_11014(nbt);
        byte[] bys = nbt.method_10547("Colors");
        Arrays.fill(this.colors, null);
        for (int i = 0; i < Math.min(bys.length, this.colors.length); ++i) {
            byte v = bys[i];
            if (v == -1) continue;
            this.colors[i] = class_1767.method_7791((int)v);
        }
        this.welds = nbt.method_10571("Welds");
        if (this.welds > 0 && nbt.method_10547("Adjacency").length == 72) {
            byte[] abys = nbt.method_10547("Adjacency");
            for (int i = 0; i < 12; ++i) {
                int j = i * 6;
                AdjType[] types = new AdjType[6];
                for (class_2350 d : class_2350.values()) {
                    types[d.ordinal()] = AdjType.values()[abys[j + d.ordinal()] & 0xFF];
                }
                this.adjacency[i] = new Adjacency(types);
            }
        } else if (this.field_11863 != null && this.field_11863.field_9236) {
            this.computeAdjacency(false, true, false);
        }
        if ((class_19372 = this.field_11863) instanceof YttrWorld) {
            YttrWorld yw = (YttrWorld)class_19372;
            yw.yttr$scheduleRenderUpdate(this.method_11016());
        }
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Nullable
    public Object getRenderAttachmentData() {
        Adjacency[] adj = (Adjacency[])this.adjacency.clone();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 2; ++x) {
                for (int z = 0; z < 2; ++z) {
                    int slot = BloqueBlock.getSlot(x, y, z);
                    if (this.colors[slot] == null) continue;
                    boolean changed = false;
                    AdjType[] nw = new AdjType[6];
                    for (class_2350 d : class_2350.values()) {
                        AdjType type = this.getAdjacency(slot).getType(d);
                        if (type.cullable() && type.cullable() && this.getMulti(x, y, z, d) != null) {
                            type = type.culled();
                            changed = true;
                        }
                        nw[d.ordinal()] = type;
                    }
                    if (!changed) continue;
                    adj[slot] = new Adjacency(nw);
                }
            }
        }
        DrawStyle style = DrawStyle.NORMAL;
        if (this.welds > 0) {
            style = DrawStyle.WELDED;
            if (this.welds > 2) {
                style = DrawStyle.SMOOTHED;
            }
        }
        return new RenderData((class_1767[])this.colors.clone(), adj, style);
    }

    public int getSlotForPlacement(class_243 hitPos, class_2338 blockPos, class_2350 face) {
        int slot = BloqueBlock.getSlot(hitPos, blockPos, face);
        if (this.get(slot) != null) {
            class_1160 vec = face.method_23955();
            return BloqueBlock.getSlot(hitPos.method_1019(new class_243((double)vec.method_4943() * 0.2, (double)vec.method_4945() * 0.2, (double)vec.method_4947() * 0.2)), blockPos, face);
        }
        return slot;
    }

    public record Adjacency(AdjType downType, AdjType upType, AdjType northType, AdjType southType, AdjType westType, AdjType eastType) {
        public static final Adjacency NONE = new Adjacency(AdjType.NONE, AdjType.NONE, AdjType.NONE, AdjType.NONE, AdjType.NONE, AdjType.NONE);

        public Adjacency(AdjType[] vals) {
            this(vals[0], vals[1], vals[2], vals[3], vals[4], vals[5]);
        }

        public AdjType getType(class_2350 d) {
            switch (d) {
                case field_11033: {
                    return this.downType;
                }
                case field_11036: {
                    return this.upType;
                }
                case field_11043: {
                    return this.northType;
                }
                case field_11035: {
                    return this.southType;
                }
                case field_11039: {
                    return this.westType;
                }
                case field_11034: {
                    return this.eastType;
                }
            }
            throw new AssertionError(d);
        }

        public boolean merged(class_2350 d) {
            return this.getType(d).merged();
        }

        public boolean skipFace(class_2350 d) {
            return this.getType(d).skipFace();
        }

        public boolean cullable(class_2350 d) {
            return this.getType(d).cullable();
        }

        public boolean down() {
            return this.downType.merged();
        }

        public boolean up() {
            return this.upType.merged();
        }

        public boolean north() {
            return this.northType.merged();
        }

        public boolean south() {
            return this.southType.merged();
        }

        public boolean west() {
            return this.westType.merged();
        }

        public boolean east() {
            return this.eastType.merged();
        }
    }

    public static enum AdjType {
        NONE,
        CULL,
        CULL_EDGE,
        MERGE_INTERNAL,
        MERGE_EXTERNAL,
        MERGE_EXTERNAL_CULL;


        public boolean merged() {
            return this == MERGE_INTERNAL || this == MERGE_EXTERNAL || this == MERGE_EXTERNAL_CULL;
        }

        public boolean skipFace() {
            return this == CULL || this == MERGE_INTERNAL || this == MERGE_EXTERNAL_CULL;
        }

        public boolean cullable() {
            return this == CULL_EDGE || this == MERGE_EXTERNAL;
        }

        public AdjType culled() {
            switch (this) {
                case CULL_EDGE: {
                    return CULL;
                }
                case MERGE_EXTERNAL: {
                    return MERGE_EXTERNAL_CULL;
                }
            }
            return this;
        }
    }

    public static enum DrawStyle {
        NORMAL,
        WELDED,
        SMOOTHED;


        public boolean welded() {
            return this != NORMAL;
        }

        public boolean drawStuds() {
            return this != SMOOTHED;
        }
    }

    public record RenderData(class_1767[] colors, Adjacency[] adjacency, DrawStyle style) {
    }
}

