/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.content.block.big;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.unascribed.yttr.init.YSounds;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3619;
import net.minecraft.class_3737;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public abstract class BigBlock
extends class_2248 {
    public final class_2758 xProp;
    public final class_2758 yProp;
    public final class_2758 zProp;
    public final int xSize;
    public final int ySize;
    public final int zSize;

    public BigBlock(class_2758 x, class_2758 y, class_2758 z, class_4970.class_2251 settings) {
        super(settings);
        this.xSize = (Integer)Iterables.getLast((Iterable)x.method_11898()) + 1;
        this.ySize = (Integer)Iterables.getLast((Iterable)y.method_11898()) + 1;
        this.zSize = (Integer)Iterables.getLast((Iterable)z.method_11898()) + 1;
        this.xProp = x;
        this.yProp = y;
        this.zProp = z;
    }

    protected class_2680 copyState(class_2680 us, class_2680 neighbor) {
        return us;
    }

    @Nullable
    public class_2680 getExpectedNeighbor(class_2680 state, class_2350 dir) {
        int x = (Integer)state.method_11654((class_2769)this.xProp) + dir.method_10148();
        int y = (Integer)state.method_11654((class_2769)this.yProp) + dir.method_10164();
        int z = (Integer)state.method_11654((class_2769)this.zProp) + dir.method_10165();
        if (x < 0 || y < 0 || z < 0) {
            return null;
        }
        if (x >= this.xSize || y >= this.ySize || z >= this.zSize) {
            return null;
        }
        return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)this.xProp, (Comparable)Integer.valueOf(x))).method_11657((class_2769)this.yProp, (Comparable)Integer.valueOf(y))).method_11657((class_2769)this.zProp, (Comparable)Integer.valueOf(z));
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        class_2680 expected = this.getExpectedNeighbor(state, direction);
        if (expected == null) {
            return state;
        }
        if (newState.method_27852((class_2248)this)) {
            expected = this.copyState(expected, newState);
        }
        if (newState != expected) {
            if (this instanceof class_3737 && ((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue()) {
                return class_2246.field_10382.method_9564();
            }
            return class_2246.field_10124.method_9564();
        }
        return this.copyState(state, newState);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        super.method_9536(state, world, pos, newState, moved);
        world.method_39279(pos, (class_2248)this, 1);
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        world.method_39279(pos, (class_2248)this, 1);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (player.method_7337()) {
            class_2338 origin = pos.method_10069(-((Integer)state.method_11654((class_2769)this.xProp)).intValue(), -((Integer)state.method_11654((class_2769)this.yProp)).intValue(), -((Integer)state.method_11654((class_2769)this.zProp)).intValue());
            for (int y = 0; y < this.ySize; ++y) {
                for (int x = 0; x < this.xSize; ++x) {
                    for (int z = 0; z < this.zSize; ++z) {
                        world.method_8651(origin.method_10069(x, y, z), false, (class_1297)player);
                    }
                }
            }
        } else if (world.field_9236 && (Integer)state.method_11654((class_2769)this.xProp) == 0 && (Integer)state.method_11654((class_2769)this.yProp) == 0 && (Integer)state.method_11654((class_2769)this.zProp) == 0) {
            class_2498 sg = this.method_9573(state);
            world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, sg.method_10595(), class_3419.field_15245, (sg.method_10597() + 1.0f) / 2.0f, sg.method_10599() * 0.8f, false);
        }
    }

    public class_2498 method_9573(class_2680 state) {
        class_2498 sg = super.method_9573(state);
        if ((Integer)state.method_11654((class_2769)this.xProp) == 0 && (Integer)state.method_11654((class_2769)this.yProp) == 0 && (Integer)state.method_11654((class_2769)this.zProp) == 0) {
            return sg;
        }
        return new class_2498(sg.field_11540, sg.field_11539, YSounds.SILENCE, sg.method_10594(), sg.method_10598(), sg.method_10596(), sg.method_10593());
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, Random random) {
        super.method_9588(state, world, pos, random);
        for (class_2350 dir : class_2350.values()) {
            class_2680 have;
            class_2680 expected = this.getExpectedNeighbor(state, dir);
            if (expected == null || (have = world.method_8320(pos.method_10093(dir))) == expected) continue;
            world.method_22352(pos, false);
            return;
        }
    }

    public class_3619 method_9527(class_2680 state) {
        return class_3619.field_15972;
    }

    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        if ((Integer)state.method_11654((class_2769)this.xProp) != 0 || (Integer)state.method_11654((class_2769)this.yProp) != 0 || (Integer)state.method_11654((class_2769)this.zProp) != 0) {
            return ImmutableList.of();
        }
        return super.method_9560(state, builder);
    }

    public void alterDroppedEntity(class_2338 pos, class_2680 state, class_1542 entity) {
        double x = (double)(pos.method_10263() - (Integer)state.method_11654((class_2769)this.xProp)) + ((double)entity.field_6002.field_9229.nextFloat() * ((double)this.xSize / 2.0) + (double)this.xSize / 4.0);
        double y = (double)(pos.method_10264() - (Integer)state.method_11654((class_2769)this.yProp)) + ((double)entity.field_6002.field_9229.nextFloat() * ((double)this.ySize / 2.0) + (double)this.ySize / 4.0);
        double z = (double)(pos.method_10260() - (Integer)state.method_11654((class_2769)this.zProp)) + ((double)entity.field_6002.field_9229.nextFloat() * ((double)this.zSize / 2.0) + (double)this.zSize / 4.0);
        entity.method_5814(x, y, z);
    }

    public static void playSound(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_3414 event, class_3419 cat, float vol, float pitch) {
        if (!(state.method_26204() instanceof BigBlock)) {
            world.method_8396(player, pos, event, cat, vol, pitch);
            return;
        }
        BigBlock b = (BigBlock)state.method_26204();
        double x = (double)(pos.method_10263() - (Integer)state.method_11654((class_2769)b.xProp)) + (double)b.xSize / 2.0;
        double y = (double)(pos.method_10264() - (Integer)state.method_11654((class_2769)b.yProp)) + (double)b.ySize / 2.0;
        double z = (double)(pos.method_10260() - (Integer)state.method_11654((class_2769)b.zProp)) + (double)b.zSize / 2.0;
        world.method_8465(player, x, y, z, event, cat, vol, pitch);
    }

    public static boolean isReceivingRedstonePower(class_1937 world, class_2338 pos, class_2680 state) {
        if (!(state.method_26204() instanceof BigBlock)) {
            return world.method_8479(pos);
        }
        BigBlock b = (BigBlock)state.method_26204();
        int oX = pos.method_10263() - (Integer)state.method_11654((class_2769)b.xProp);
        int oY = pos.method_10264() - (Integer)state.method_11654((class_2769)b.yProp);
        int oZ = pos.method_10260() - (Integer)state.method_11654((class_2769)b.zProp);
        class_2338.class_2339 bp = new class_2338.class_2339();
        for (int x = 0; x < b.xSize; ++x) {
            for (int y = 0; y < b.ySize; ++y) {
                for (int z = 0; z < b.zSize; ++z) {
                    bp.method_10103(oX + x, oY + y, oZ + z);
                    if (!world.method_8479((class_2338)bp)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean anyNeighborsMatch(class_1937 w, class_2338 pos, class_2680 state, Predicate<class_2680> pred) {
        if (!(state.method_26204() instanceof BigBlock)) {
            return false;
        }
        BigBlock b = (BigBlock)state.method_26204();
        int x = (Integer)state.method_11654((class_2769)b.xProp);
        int y = (Integer)state.method_11654((class_2769)b.yProp);
        int z = (Integer)state.method_11654((class_2769)b.zProp);
        for (class_2350 d : class_2350.values()) {
            class_2338 bp;
            int nX = x + d.method_10148();
            int nY = y + d.method_10164();
            int nZ = z + d.method_10165();
            if (nX < 0 || nX >= b.xSize || nY < 0 || nY >= b.ySize || nZ < 0 || nZ >= b.zSize || !w.method_8320(bp = pos.method_10093(d)).method_27852(state.method_26204()) || !pred.test(w.method_8320(bp))) continue;
            return true;
        }
        return false;
    }
}

