/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.compat.modmenu;

import com.google.common.base.Ascii;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import com.mojang.blaze3d.systems.RenderSystem;
import com.unascribed.yttr.YConfig;
import com.unascribed.yttr.client.suit.SuitMusic;
import com.unascribed.yttr.client.suit.SuitRenderer;
import com.unascribed.yttr.init.YSounds;
import com.unascribed.yttr.mechanics.LampColor;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1160;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5195;

public class YttrConfigScreen
extends class_437 {
    public static final class_5195 MUSIC = new class_5195(YSounds.SILENCE, 10, 10, true);
    private final class_437 parent;
    private int time;
    private int closeTime;
    private boolean isClosing;
    private int initialMouseX = -1;
    private int initialMouseY = -1;
    private int mouseX;
    private int mouseY;
    private boolean clicked;
    private boolean rclicked;
    private Section currentSection = null;
    private Section prevSection = null;
    private int uniq;
    private int descUniq;
    private boolean drawingDesc;
    private boolean anyDescDrawnThisFrame;
    private boolean textTestMode = false;
    private StringBuilder textTestContent = new StringBuilder("hello, world!");
    private final SuitRenderer sr = new SuitRenderer();
    private final SuitMusic music = new SuitMusic(YSounds.TORUS, 0.6f, class_3419.field_15253){

        @Override
        public boolean method_4793() {
            return !(class_310.method_1551().field_1755 instanceof YttrConfigScreen);
        }
    };
    private int sectionTicks = 0;
    private static final Map<String, String> shortDescs = ImmutableMap.builder().put((Object)"general.trust-players", (Object)"makes things more reliable despite lag, but makes cheating on servers easier").put((Object)"general.fixup-debug-world", (Object)"adds missing modded blockstates to the vanilla debug world").put((Object)"general.shenanigans", (Object)"inside-jokes and various chaos - nothing destructive").put((Object)"general.convert-void-holes", (Object)"automatically convert non-yttr overworld void holes into geysers").put((Object)"client.slope-smoothing", (Object)"attempts to smooth your camera when walking on slopes - a little buggy but cool when it works").put((Object)"client.force-opengl-core", (Object)"force-disables opengl compatibility mode - not supported, may cause render bugs and crashes - restart required").put((Object)"client.config-color", (Object)"customize the color of this very setup utility").put((Object)"client.shrink-debug-hud", (Object)"make the vanilla debug hud smaller").put((Object)"client.rifle-timing-assist", (Object)"if on, play a ding noise at 500kj and three dings leading up to 650kj while charging the rifle").put((Object)"client.control-hints", (Object)"if on, show on-screen hints for nonstandard controls").put((Object)"rifle.allow-void", (Object)"off disables the yttric rifle void mode to avoid griefing concerns - note there is a command to undo voids and voids are logged to console").put((Object)"rifle.allow-explode", (Object)"off disables the yttric rifle explode mode to avoid griefing concerns - breaks progression - prefer soft to disable block damage").put((Object)"rifle.allow-fire", (Object)"off disables the yttric rifle fire mode to avoid griefing concerns").put((Object)"rifle.timing-assist", (Object)"if on, play a ding noise at 500kj and three dings leading up to 650kj while charging the rifle").put((Object)"enchantments.vorpal", (Object)"if on, the vorpal weapon enchantment can be obtained - a level-dependent chance to deal a very large amount of damage on strike").put((Object)"enchantments.disjunction", (Object)"if on, the disjunction weapon enchantment can be obtained - an analogue to smite for ender creatures").put((Object)"enchantments.annihilation", (Object)"if on, the curse of annihilation tool enchantment can be obtained - completely destroys any items that would have been dropped").put((Object)"enchantments.shattering", (Object)"if on, the curse of shattering tool enchantment can be obtained - \"shatters\" dropped items via various means").put((Object)"enchantments.springing", (Object)"if on, the springing coil enchantment can be obtained - increases jump height").put((Object)"enchantments.stabilization", (Object)"if on, the stabilization coil enchantment can be obtained - removes midair mining speed penalty").put((Object)"enchantments.curses-in-table", (Object)"if on, yttr curses can be obtained via regular enchanting").put((Object)"worldgen.gadolinite", (Object)"generates gadolinite in the overworld, a source of yttrium and iron - required for progression").put((Object)"worldgen.brookite", (Object)"generates brookite ore in the overworld - required for some recipes, and future progression").put((Object)"worldgen.squeeze-trees", (Object)"generates squeeze trees in deep oceans - required for some recipes").put((Object)"worldgen.wasteland", (Object)"generates the wasteland biome in the overworld").put((Object)"worldgen.core-lava", (Object)"replaces nether lower bedrock with core lava for lore consistency").put((Object)"worldgen.scorched", (Object)"replaces nether ceiling with a brand new biome - required for future progression").put((Object)"worldgen.scorched-retrogen", (Object)"performs scorched generation in existing chunks - will not destroy existing structures").put((Object)"worldgen.continuity", (Object)"generates roots of continuity under small end islands - required for progression").build();
    private static final Map<String, Object> badSettings = ImmutableMap.builder().put((Object)"client.force-opengl-core", (Object)YConfig.Trilean.ON).put((Object)"rifle.allow-explode", (Object)YConfig.TrileanSoft.OFF).put((Object)"worldgen.gadolinite", (Object)false).build();
    private final Multiset<String> timesModified = HashMultiset.create();

    public YttrConfigScreen(class_437 parent) {
        super((class_2561)new class_2585("Yttr configuration"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.parent.method_25423(this.field_22787, this.field_22789, this.field_22790);
        super.method_25426();
    }

    public void method_25419() {
        if (this.isClosing) {
            this.field_22787.method_1507(this.parent);
            this.field_22787.method_1538().method_4859();
            return;
        }
        this.isClosing = true;
        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)YSounds.EFFECTOR_CLOSE, (float)1.0f));
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        float sca;
        float a;
        this.sr.setColor(YConfig.Client.configColor);
        this.anyDescDrawnThisFrame = false;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        float t = (float)this.time + delta;
        float ct = (float)this.closeTime + delta;
        if (this.isClosing) {
            a = YttrConfigScreen.sCurve5(1.0f - class_3532.method_15363((float)(ct / 20.0f), (float)0.0f, (float)1.0f));
            sca = YttrConfigScreen.sCurve5(1.0f - class_3532.method_15363((float)(ct / 15.0f), (float)0.0f, (float)1.0f));
            this.music.setVolume(a * 0.6f);
        } else {
            a = YttrConfigScreen.sCurve5(class_3532.method_15363((float)(t / 10.0f), (float)0.0f, (float)1.0f));
            sca = YttrConfigScreen.sCurve5(class_3532.method_15363((float)(t / 7.0f), (float)0.0f, (float)1.0f));
        }
        if (this.initialMouseX == -1) {
            this.initialMouseX = mouseX;
            this.initialMouseY = mouseY;
        }
        if (a < 1.0f) {
            class_4587 modelView = RenderSystem.getModelViewStack();
            matrices.method_22903();
            modelView.method_22903();
            modelView.method_22904((double)this.initialMouseX, (double)this.initialMouseY, 0.0);
            modelView.method_22905(1.0f + sca / 2.0f, 1.0f + sca / 2.0f, 1.0f);
            modelView.method_22904((double)(-this.initialMouseX), (double)(-this.initialMouseY), 0.0);
            RenderSystem.applyModelViewMatrix();
            this.parent.method_25394(matrices, -200, -200, delta);
            modelView.method_22909();
            RenderSystem.applyModelViewMatrix();
            matrices.method_22909();
            float r = (float)Math.max(this.initialMouseX, this.field_22790 - this.initialMouseY) * 1.1f * a;
            matrices.method_22903();
            matrices.method_22904((double)this.initialMouseX, (double)this.initialMouseY, 0.0);
            matrices.method_22905(r / 10.0f, r / 10.0f, 1.0f);
            matrices.method_22907(class_1160.field_20707.method_23214(45.0f));
            YttrConfigScreen.method_25294((class_4587)matrices, (int)-10, (int)-10, (int)10, (int)10, (int)-16777216);
            YttrConfigScreen.method_25294((class_4587)matrices, (int)-12, (int)-12, (int)12, (int)12, (int)0x33000000);
            YttrConfigScreen.method_25294((class_4587)matrices, (int)-16, (int)-16, (int)16, (int)16, (int)0x33000000);
            YttrConfigScreen.method_25294((class_4587)matrices, (int)-20, (int)-20, (int)20, (int)20, (int)0x33000000);
            matrices.method_22909();
        } else {
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.clear((int)16384, (boolean)false);
        }
        float sa = 1.0f;
        if (this.isClosing) {
            sa = YttrConfigScreen.sCurve5(1.0f - class_3532.method_15363((float)(ct / 5.0f), (float)0.0f, (float)1.0f));
        }
        if (this.time > 15 && sa > 0.0f) {
            this.sr.setAlpha(sa);
            this.sr.setUp();
            if (this.textTestMode) {
                String content = this.textTestContent.toString();
                int x = this.field_22789 / 4;
                int y = 3;
                matrices.method_22903();
                matrices.method_22905(2.0f, 2.0f, 1.0f);
                for (String line : content.split("\n")) {
                    if (this.time - 15 > y) {
                        this.sr.drawText(matrices, "test" + this.uniq + y, line, x - line.length() * 3, y, delta);
                    }
                    y += 12;
                }
                matrices.method_22909();
                if (this.drawButton(matrices, "reset", 0, "reset", this.field_22789 - 180, this.field_22790 - 24, 80, delta)) {
                    ++this.uniq;
                    if (this.rclicked) {
                        this.time = 15;
                    }
                }
            } else if (this.currentSection == null) {
                this.drawHeading(matrices, "sections", 6, 6, delta);
                int y = 26;
                for (Section s : Section.values()) {
                    if (this.sectionTicks >= y / 8 && this.drawButton(matrices, s.name() + this.uniq, this.uniq, Ascii.toLowerCase((String)s.name()), 6, y, 80, delta)) {
                        this.currentSection = s;
                        this.sectionTicks = 0;
                        this.uniq = ThreadLocalRandom.current().nextInt();
                    }
                    y += 22;
                }
                if (this.sectionTicks >= (y += 8) / 8) {
                    this.drawHeading(matrices, "extras", 6, y, delta);
                }
                if (this.sectionTicks >= (y += 20) / 8 && this.drawButton(matrices, "texttest" + this.uniq, this.uniq, "text test", 6, y, 80, delta)) {
                    this.textTestMode = true;
                }
            } else {
                String currentSectionStr = Ascii.toLowerCase((String)this.currentSection.name());
                this.drawHeading(matrices, currentSectionStr, 6, 6, delta);
                int y = 24;
                for (String k : YConfig.data.keySet()) {
                    if (this.sectionTicks < y / 8) break;
                    int dot = k.indexOf(46);
                    String section = k.substring(0, dot);
                    if (!section.equals(currentSectionStr)) continue;
                    String name = k.substring(dot + 1);
                    Class<?> type = YConfig.getKeyType(k);
                    if (type == Void.TYPE) continue;
                    Object objV = null;
                    String label = name.replace('-', ' ');
                    if (type == Boolean.TYPE) {
                        boolean v = YConfig.data.getBoolean(k).get();
                        if (this.drawBoolean(matrices, label, v, 6, y, shortDescs.getOrDefault(k, "no description"), delta)) {
                            boolean bl = v = !v;
                            if (badSettings.get(k) == Boolean.valueOf(v)) {
                                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)YSounds.DANGER, (float)1.0f, (float)1.0f));
                                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)YSounds.DANGER, (float)1.0f, (float)0.6f));
                            }
                            this.timesModified.add((Object)label);
                            YConfig.data.put(k, v ? "on" : "off");
                            YConfig.copyDataToFields();
                            YConfig.save();
                        }
                        objV = v;
                    } else if (type.isEnum()) {
                        Enum v = (Enum)YConfig.data.getEnum(k, type).get();
                        if (this.drawEnum(matrices, label, v, 6, y, shortDescs.getOrDefault(k, "no description"), delta)) {
                            int idx;
                            if (this.rclicked) {
                                idx = v.ordinal() - 1;
                                if (idx < 0) {
                                    idx = type.getEnumConstants().length + idx;
                                }
                            } else {
                                idx = (v.ordinal() + 1) % type.getEnumConstants().length;
                            }
                            v = (Enum)type.getEnumConstants()[idx];
                            if (badSettings.get(k) == v) {
                                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)YSounds.DANGER, (float)1.0f, (float)1.0f));
                                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)YSounds.DANGER, (float)1.0f, (float)0.6f));
                            }
                            this.timesModified.add((Object)label);
                            YConfig.data.put(k, Ascii.toLowerCase((String)v.name()));
                            YConfig.copyDataToFields();
                            YConfig.save();
                        }
                        objV = v;
                    }
                    if (badSettings.get(k) == objV) {
                        this.drawDescription(matrices, 170, y + 2, 18, 18, "this setting is not supported and may cause problems", delta);
                        this.sr.drawElement(matrices, "ogl-warning" + this.uniq + this.timesModified.count((Object)label), 170, y + 2, 0, 18, 11, 12, delta);
                    }
                    y += 22;
                }
                this.drawDescription(matrices, 6, 2, 18, 18, "go back to the section list", delta);
                if (this.drawButton(matrices, "back" + this.uniq, this.uniq, "<", 6, 2, 18, delta)) {
                    this.currentSection = null;
                    this.sectionTicks = 0;
                    this.uniq = ThreadLocalRandom.current().nextInt();
                }
            }
            if (!this.textTestMode && !this.anyDescDrawnThisFrame) {
                String v = ((ModContainer)FabricLoader.getInstance().getModContainer("yttr").get()).getMetadata().getVersion().getFriendlyString();
                if (v.equals("${version}")) {
                    v = "dev";
                }
                this.sr.drawText(matrices, "setup" + this.descUniq, "yttr " + v + " setup utility", this.field_22789 - 113 - (v.length() + 1) * 6, 6, delta);
                if (this.currentSection != null) {
                    this.sr.drawText(matrices, "setup2" + this.descUniq + this.uniq, "hover for descriptions", this.field_22789 - 137, 17, delta);
                }
            }
            if (this.drawButton(matrices, "done", 0, "done", this.field_22789 - 90, this.field_22790 - 24, 80, delta)) {
                if (this.textTestMode) {
                    this.textTestMode = false;
                    ++this.uniq;
                } else {
                    this.method_25419();
                }
            }
            this.sr.tearDown();
        }
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.clicked = false;
        this.rclicked = false;
        if (!this.anyDescDrawnThisFrame) {
            this.drawingDesc = false;
        }
    }

    private void drawHeading(class_4587 matrices, String text, int x, int y, float delta) {
        this.sr.drawText(matrices, this.uniq + text, text, this.currentSection == null ? x : x + 22, y, delta);
        matrices.method_22903();
        matrices.method_22904((double)x, 0.0, 0.0);
        matrices.method_22905(2.0f, 1.0f, 1.0f);
        this.sr.drawElement(matrices, "separator", 0, y + 15, 0, 30, 80, 1, delta);
        matrices.method_22909();
    }

    private boolean drawBoolean(class_4587 matrices, String label, boolean value, int x, int y, String desc, float delta) {
        this.drawDescription(matrices, x, y, 160, 16, desc, delta);
        this.sr.drawText(matrices, this.uniq + label, label, x, y + 4, delta);
        return this.drawButton(matrices, label, this.uniq + this.timesModified.count((Object)label), value ? "on" : "off", x + 120, y, 40, delta);
    }

    private boolean drawEnum(class_4587 matrices, String label, Enum<?> value, int x, int y, String desc, float delta) {
        String display;
        this.drawDescription(matrices, x, y, 160, 16, desc, delta);
        this.sr.drawText(matrices, this.uniq + label, label, x, y + 4, delta);
        if (value instanceof LampColor) {
            LampColor lc = (LampColor)value;
            display = switch (lc) {
                case LampColor.COLORLESS -> "warm";
                case LampColor.LIGHT_BLUE -> "lblue";
                case LampColor.LIGHT_GRAY -> "silver";
                case LampColor.MAGENTA -> "mgnta";
                default -> Ascii.toLowerCase((String)value.name());
            };
        } else {
            display = Ascii.toLowerCase((String)value.name());
        }
        return this.drawButton(matrices, label, this.uniq + this.timesModified.count((Object)label), display, x + 120, y, 40, delta);
    }

    private void drawDescription(class_4587 matrices, int x, int y, int w, int h, String desc, float delta) {
        if (this.mouseX >= x && this.mouseX <= x + w && this.mouseY >= y && this.mouseY <= y + h) {
            int initialX;
            this.anyDescDrawnThisFrame = true;
            if (!this.drawingDesc) {
                this.drawingDesc = true;
                ++this.descUniq;
            }
            x = initialX = this.field_22789 - 130;
            int i = 0;
            y = 8;
            for (String word : desc.split(" ")) {
                int wordW = (word.length() + 1) * 6;
                int x2 = x + wordW - 6;
                if (x2 >= this.field_22789) {
                    x = initialX;
                    y += 12;
                }
                this.sr.drawText(matrices, "description" + i + this.descUniq + desc.hashCode(), word, x, y, delta);
                x += wordW;
                ++i;
            }
        }
    }

    private boolean drawButton(class_4587 matrices, String id, int uniq, String text, int x, int y, int w, float delta) {
        boolean rtrn;
        int uniq2;
        matrices.method_22903();
        matrices.method_22904((double)x, 0.0, 0.0);
        int n = uniq2 = uniq == 0 ? 0 : this.uniq;
        if (w > 50) {
            matrices.method_22905((float)w / 50.0f, 1.0f, 1.0f);
            this.sr.drawElement(matrices, id + "top" + uniq2, 0, y, 0, 30, 50, 1, delta);
            this.sr.drawElement(matrices, id + "bot" + uniq2, 0, y + 16, 0, 30, 50, 1, delta);
        } else {
            this.sr.drawElement(matrices, id + "top" + uniq2, 0, y, 0, 30, w, 1, delta);
            this.sr.drawElement(matrices, id + "bot" + uniq2, 0, y + 16, 0, 30, w, 1, delta);
        }
        matrices.method_22909();
        this.sr.drawElement(matrices, id + "left" + uniq2, x, y, 80, 4, 1, 16, delta);
        this.sr.drawElement(matrices, id + "right" + uniq2, x + w - 1, y, 80, 4, 1, 16, delta);
        int tw = 6 * text.length();
        this.sr.drawText(matrices, id + uniq, text, x + (w - tw) / 2, y + 4, delta);
        boolean bl = rtrn = this.clicked && this.mouseX >= x && this.mouseX <= x + w && this.mouseY >= y && this.mouseY <= y + 16;
        if (rtrn) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)YSounds.DIVE_THRUST, (float)ThreadLocalRandom.current().nextFloat(1.4f, 1.8f), (float)1.0f));
        }
        return rtrn;
    }

    public void method_25393() {
        if (this.time == 0) {
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)YSounds.EFFECTOR_OPEN, (float)1.0f));
        }
        if (this.time == 10) {
            this.field_22787.method_1483().method_4873((class_1113)this.music);
        }
        ++this.time;
        if (this.isClosing) {
            ++this.closeTime;
            if (this.closeTime > 20) {
                this.field_22787.method_1507(this.parent);
                this.field_22787.method_1538().method_4859();
            }
        }
        this.sr.tick();
        ++this.sectionTicks;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.clicked = true;
            this.rclicked = button == 1;
            this.mouseX = (int)mouseX;
            this.mouseY = (int)mouseY;
        }
        if (button == 3 && this.currentSection != null) {
            this.currentSection = null;
            this.sectionTicks = 0;
            this.uniq = ThreadLocalRandom.current().nextInt();
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)YSounds.DIVE_THRUST, (float)ThreadLocalRandom.current().nextFloat(1.4f, 1.8f), (float)1.0f));
        }
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257) {
            this.textTestContent.append("\n");
        } else if (keyCode == 259 && this.textTestContent.length() > 0) {
            this.textTestContent.setLength(this.textTestContent.length() - 1);
        }
        return true;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.textTestMode) {
            this.textTestContent.append(Ascii.toLowerCase((char)chr));
        }
        return true;
    }

    private static float sCurve5(float a) {
        float a3 = a * a * a;
        float a4 = a3 * a;
        float a5 = a4 * a;
        return 6.0f * a5 - 15.0f * a4 + 10.0f * a3;
    }

    private static enum Section {
        GENERAL,
        CLIENT,
        RIFLE,
        ENCHANTMENTS,
        WORLDGEN;

    }
}

