/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.compat.emi.recipe;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.compat.emi.YttrEmiPlugin;
import com.unascribed.yttr.crafting.SoakingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public class EmiSoakingRecipe
implements EmiRecipe {
    private final class_2960 id;
    private final List<EmiIngredient> inputs;
    private final EmiIngredient catalyst;
    private final EmiStack output;
    private final boolean consumesCatalyst;

    public EmiSoakingRecipe(SoakingRecipe r) {
        this.id = r.method_8114();
        this.inputs = (List)r.getSoakingIngredients().map(is -> List.of(EmiStack.of((class_1799)is)), li -> li.stream().map(EmiIngredient::of).toList());
        this.catalyst = EmiIngredient.of(r.getCatalyst().getMatchingFluids().stream().map(f -> EmiStack.of((class_3611)f, (long)81000L)).toList());
        this.output = EmiStack.of((class_1799)((class_1799)r.getResult().map(is -> is, bs -> new class_1799((class_1935)bs.method_26204().method_8389()))));
        this.consumesCatalyst = r.getResult().right().isPresent();
    }

    public EmiSoakingRecipe(class_2960 id, List<EmiIngredient> inputs, EmiIngredient catalyst, EmiStack output, boolean consumesCatalyst) {
        this.id = id;
        this.inputs = inputs;
        this.catalyst = catalyst;
        this.output = output;
        this.consumesCatalyst = consumesCatalyst;
    }

    public class_2960 getId() {
        return this.id;
    }

    public EmiRecipeCategory getCategory() {
        return YttrEmiPlugin.SOAKING;
    }

    public int getDisplayHeight() {
        return 36 + Math.max(0, ((this.inputs.size() - 1) / 3 - 1) * 18);
    }

    public int getDisplayWidth() {
        return 64 + Math.min(3, this.inputs.size()) * 18;
    }

    public List<EmiIngredient> getInputs() {
        return this.consumesCatalyst ? Lists.newArrayList((Iterable)Iterables.concat(this.inputs, Collections.singleton(this.catalyst))) : this.inputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return this.consumesCatalyst ? List.of() : List.of(this.catalyst);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.output);
    }

    public void addWidgets(WidgetHolder widgets) {
        int x = widgets.getWidth() - 59;
        widgets.addTexture(Yttr.id("textures/gui/curved_arrow_down.png"), x, 2, 16, 16, 0, 0, 16, 16, 16, 16);
        widgets.addTexture(Yttr.id("textures/gui/curved_arrow.png"), x + 20, 2, 16, 16, 0, 0, 16, 16, 16, 16);
        widgets.addSlot(this.catalyst, x, 18).drawBack(false);
        widgets.addSlot(this.catalyst, x + 16, 18).drawBack(false);
        widgets.addSlot((EmiIngredient)this.output, x + 40, 0).recipeContext((EmiRecipe)this);
        int y = 0;
        int sX = x -= 4;
        x -= Math.min(this.inputs.size(), 3) * 18;
        int rem = this.inputs.size();
        for (EmiIngredient input : this.inputs) {
            --rem;
            widgets.addSlot(input, x, y);
            if ((x += 18) < sX) continue;
            x = sX;
            x -= Math.min(rem, 3) * 18;
            y += 18;
        }
    }
}

