/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.compat.emi.recipe;

import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.compat.emi.YttrEmiPlugin;
import com.unascribed.yttr.compat.emi.stack.BlockEmiStack;
import com.unascribed.yttr.compat.emi.widget.ColoredTextureWidget;
import com.unascribed.yttr.compat.emi.widget.RotatedTextureWidget;
import com.unascribed.yttr.crafting.PistonSmashingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import org.apache.commons.compress.utils.Lists;

public class EmiPistonSmashingRecipe
implements EmiRecipe {
    private final class_2960 id;
    private final List<class_2248> input;
    private final List<class_2248> catalysts;
    private final EmiStack output;
    private final int cloudColor;
    private final EmiStack cloudOutput;

    public EmiPistonSmashingRecipe(PistonSmashingRecipe r) {
        this.id = r.method_8114();
        this.input = r.getInput().getMatchingBlocks();
        this.catalysts = r.getCatalyst().getMatchingBlocks();
        this.output = EmiStack.of((class_1799)r.method_8110());
        this.cloudColor = r.getCloudColor();
        class_1799 multCloudOutput = r.getCloudOutput().method_7972();
        multCloudOutput.method_7939(multCloudOutput.method_7947() * r.getCloudSize());
        this.cloudOutput = EmiStack.of((class_1799)multCloudOutput);
    }

    public EmiPistonSmashingRecipe(class_2960 id, List<class_2248> input, List<class_2248> catalysts, EmiStack output, int cloudColor, EmiStack cloudOutput) {
        this.id = id;
        this.input = input;
        this.catalysts = catalysts;
        this.output = output;
        this.cloudColor = cloudColor;
        this.cloudOutput = cloudOutput;
    }

    public class_2960 getId() {
        return this.id;
    }

    public EmiRecipeCategory getCategory() {
        return YttrEmiPlugin.PISTON_SMASHING;
    }

    public int getDisplayHeight() {
        return 43;
    }

    public int getDisplayWidth() {
        return 118;
    }

    public List<EmiIngredient> getInputs() {
        ArrayList li = Lists.newArrayList();
        if (!this.cloudOutput.isEmpty()) {
            li.add(EmiStack.of((class_1935)class_1802.field_8469, (long)this.cloudOutput.getAmount()));
        }
        li.add(EmiIngredient.of(this.input.stream().map(EmiStack::of).toList()));
        return li;
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(EmiIngredient.of(this.catalysts.stream().map(EmiStack::of).toList()));
    }

    public List<EmiStack> getOutputs() {
        ArrayList li = Lists.newArrayList();
        if (!this.cloudOutput.isEmpty()) {
            li.add(this.cloudOutput);
        }
        if (!this.output.isEmpty()) {
            li.add(this.output);
        }
        return li;
    }

    public void addWidgets(WidgetHolder widgets) {
        int x = widgets.getWidth() / 2 - 24;
        widgets.addSlot(EmiIngredient.of(this.input.stream().map(BlockEmiStack::new).toList()), x, 24).drawBack(false);
        widgets.addSlot(EmiIngredient.of(this.catalysts.stream().map(BlockEmiStack::new).toList()), x - 16, 24).drawBack(false);
        widgets.addSlot(EmiIngredient.of(this.catalysts.stream().map(BlockEmiStack::new).toList()), x + 16, 24).drawBack(false);
        widgets.add((Widget)new RotatedTextureWidget(new class_2960("textures/block/piston_side.png"), x - 31, 25, 16, 16, 0, 0, 16, 16, 16, 16, class_1160.field_20707.method_23214(90.0f)));
        widgets.addTexture(Yttr.id("textures/gui/curved_arrow.png"), x += 8, 3, 16, 16, 0, 0, 16, 16, 16, 16);
        x += 20;
        if (!this.output.isEmpty()) {
            widgets.addSlot((EmiIngredient)this.output, x, 0).recipeContext((EmiRecipe)this);
            x += 22;
        }
        if (!this.cloudOutput.isEmpty()) {
            widgets.add((Widget)new ColoredTextureWidget(new class_2960("textures/particle/effect_4.png"), x, 6, 8, 8, 0, 0, 8, 8, 8, 8, this.cloudColor));
            widgets.addSlot((EmiIngredient)this.cloudOutput, x += 12, 0).recipeContext((EmiRecipe)this).appendTooltip((class_2561)new class_2588("emi.category.yttr.piston_smashing.cloud_output_hint"));
            x += 20;
        }
    }
}

