/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.compat.emi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.client.RuinedRecipeResourceMetadata;
import com.unascribed.yttr.compat.emi.handler.ProjectTableRecipeHandler;
import com.unascribed.yttr.compat.emi.handler.RaftingRecipeHandler;
import com.unascribed.yttr.compat.emi.recipe.EmiCentrifugingRecipe;
import com.unascribed.yttr.compat.emi.recipe.EmiForgottenRecipe;
import com.unascribed.yttr.compat.emi.recipe.EmiGiftRecipe;
import com.unascribed.yttr.compat.emi.recipe.EmiPistonSmashingRecipe;
import com.unascribed.yttr.compat.emi.recipe.EmiShatteringRecipe;
import com.unascribed.yttr.compat.emi.recipe.EmiSoakingRecipe;
import com.unascribed.yttr.compat.emi.recipe.EmiVoidFilteringRecipe;
import com.unascribed.yttr.compat.emi.stack.SuitHelmetEmiStack;
import com.unascribed.yttr.content.item.DropOfContinuityItem;
import com.unascribed.yttr.content.item.block.LampBlockItem;
import com.unascribed.yttr.crafting.CentrifugingRecipe;
import com.unascribed.yttr.crafting.LampRecipe;
import com.unascribed.yttr.crafting.PistonSmashingRecipe;
import com.unascribed.yttr.crafting.SecretShapedRecipe;
import com.unascribed.yttr.crafting.ShatteringRecipe;
import com.unascribed.yttr.crafting.SoakingRecipe;
import com.unascribed.yttr.init.YBlocks;
import com.unascribed.yttr.init.YEnchantments;
import com.unascribed.yttr.init.YHandledScreens;
import com.unascribed.yttr.init.YItems;
import com.unascribed.yttr.init.YRecipeTypes;
import com.unascribed.yttr.mechanics.LampColor;
import com.unascribed.yttr.mixinsupport.ItemGroupParent;
import com.unascribed.yttr.mixinsupport.SubTabLocation;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRecipeHandler;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.screen.tooltip.IngredientTooltipComponent;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3300;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_481;
import net.minecraft.class_5251;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

public class YttrEmiPlugin
implements EmiPlugin {
    @Simple(from=PistonSmashingRecipe.class, to=EmiPistonSmashingRecipe.class)
    public static final EmiRecipeCategory PISTON_SMASHING = YttrEmiPlugin.category((EmiRenderable)EmiStack.of((class_1935)class_1802.field_8249));
    @Simple(from=CentrifugingRecipe.class, to=EmiCentrifugingRecipe.class)
    public static final EmiRecipeCategory CENTRIFUGING = YttrEmiPlugin.category((EmiRenderable)EmiStack.of((class_1935)YItems.CENTRIFUGE));
    @Simple(from=SoakingRecipe.class, to=EmiSoakingRecipe.class)
    public static final EmiRecipeCategory SOAKING = YttrEmiPlugin.category((EmiRenderable)EmiStack.of((class_1935)YItems.VOID_BUCKET));
    public static final EmiRecipeCategory VOID_FILTERING = YttrEmiPlugin.category((EmiRenderable)EmiStack.of((class_1935)YItems.VOID_FILTER));
    @Simple(from=ShatteringRecipe.class, to=EmiShatteringRecipe.class)
    public static final EmiRecipeCategory SHATTERING = YttrEmiPlugin.category((EmiRenderable)YttrEmiPlugin.createShatteringPickaxe(class_1802.field_8377));
    public static final EmiRecipeCategory CONTINUITY_GIFTS = YttrEmiPlugin.category((EmiRenderable)EmiStack.of((class_1935)YItems.DROP_OF_CONTINUITY));
    public static final EmiRecipeCategory FORGOTTEN_CRAFTING = YttrEmiPlugin.category((EmiRenderable)EmiStack.of((class_1935)YItems.WASTELAND_DIRT));

    public void register(EmiRegistry registry) {
        Yttr.autoRegister((id, c) -> {
            c.id = id;
            class_2960 iconId = Yttr.id("textures/gui/emi_simple/" + id.method_12832() + ".png");
            if (class_310.method_1551().method_1478().method_18234(iconId)) {
                c.simplified = new EmiTexture(iconId, 0, 0, 16, 16, 16, 16, 16, 16);
            }
            registry.addCategory(c);
        }, YttrEmiPlugin.class, EmiRecipeCategory.class);
        Yttr.eachRegisterableField(YttrEmiPlugin.class, EmiRecipeCategory.class, Simple.class, (f, t, a) -> {
            if (a == null) {
                return;
            }
            try {
                class_3956 rt = (class_3956)class_2378.field_17597.method_10223(t.id);
                MethodHandle cons = MethodHandles.lookup().findConstructor(a.to(), MethodType.methodType(Void.TYPE, a.from()));
                for (class_1860 r : registry.getRecipeManager().method_30027(rt)) {
                    registry.addRecipe(cons.invoke(r));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        registry.addWorkstation(PISTON_SMASHING, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8249));
        registry.addWorkstation(PISTON_SMASHING, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8105));
        registry.addWorkstation(VOID_FILTERING, (EmiIngredient)EmiStack.of((class_1935)YItems.VOID_FILTER));
        registry.addWorkstation(CENTRIFUGING, (EmiIngredient)EmiStack.of((class_1935)YItems.CENTRIFUGE));
        registry.addWorkstation(CONTINUITY_GIFTS, (EmiIngredient)EmiStack.of((class_1935)YItems.DROP_OF_CONTINUITY));
        registry.addRecipeHandler(YHandledScreens.RAFTING, (EmiRecipeHandler)new RaftingRecipeHandler());
        registry.addRecipeHandler(YHandledScreens.PROJECT_TABLE, (EmiRecipeHandler)new ProjectTableRecipeHandler());
        final ArrayList<EmiStack> pickaxes = new ArrayList<EmiStack>();
        for (Map.Entry en : class_2378.field_11142.method_29722()) {
            if (!YEnchantments.SHATTERING_CURSE.method_8192(new class_1799((class_1935)en.getValue()))) continue;
            pickaxes.add(YttrEmiPlugin.createShatteringPickaxe((class_1792)en.getValue()));
        }
        registry.addWorkstation(SHATTERING, (EmiIngredient)new ListEmiIngredient(pickaxes, 1L){

            public List<class_5684> getTooltip() {
                ArrayList tooltip = Lists.newArrayList();
                tooltip.add(class_5684.method_32662((class_5481)new class_2588("emi.tooltip.yttr.any_tool").method_30937()));
                tooltip.add(class_5684.method_32662((class_5481)YEnchantments.SHATTERING_CURSE.method_8179(1).method_30937()));
                tooltip.add(new IngredientTooltipComponent(pickaxes));
                return tooltip;
            }
        });
        registry.addRecipe((EmiRecipe)new EmiGiftRecipe(DropOfContinuityItem.getPossibilities().stream().map(EmiStack::of).toList()));
        registry.addRecipe((EmiRecipe)EmiWorldInteractionRecipe.builder().id(Yttr.id("stripping/squeeze_log")).leftInput((EmiIngredient)EmiStack.of((class_1935)YBlocks.SQUEEZE_LOG)).rightInput((EmiIngredient)EmiStack.of((class_1935)class_1802.field_8475), true).output(EmiStack.of((class_1935)YBlocks.STRIPPED_SQUEEZE_LOG)).build());
        registry.removeRecipes(er -> er.getCategory() == VanillaEmiRecipeCategories.CRAFTING && registry.getRecipeManager().method_8130(er.getId()).map(it -> {
            class_1869 sr;
            class_3955 cr;
            return it instanceof SecretShapedRecipe || it instanceof LampRecipe || it instanceof class_3955 && ((cr = (class_3955)it).method_8117().size() > 9 || cr instanceof class_1869 && ((sr = (class_1869)cr).method_8150() > 3 || sr.method_8158() > 3));
        }).orElse(false) != false);
        registry.removeEmiStacks(EmiStack.of((class_1935)YBlocks.RAFTER));
        registry.removeEmiStacks(EmiStack.of((class_1935)YBlocks.GIANT_COBBLESTONE));
        registry.removeEmiStacks(EmiStack.of((class_1935)YItems.LOOTBOX_OF_CONTINUITY));
        registry.removeEmiStacks(EmiStack.of((class_1935)YItems.SPATULA));
        registry.removeEmiStacks(EmiStack.of((class_1935)YItems.LOGO));
        registry.removeEmiStacks(EmiStack.of((class_1935)YItems.CREASE));
        registry.removeEmiStacks(EmiStack::isEmpty);
        Function<Comparison, Comparison> compareNbt = c -> c.copy().nbt(true).build();
        registry.setDefaultComparison((Object)YItems.MERCURIAL_POTION, compareNbt);
        registry.setDefaultComparison((Object)YItems.MERCURIAL_SPLASH_POTION, compareNbt);
        registry.setDefaultComparison((Object)YItems.LAZOR_EMITTER, compareNbt);
        registry.setDefaultComparison((Object)YItems.LAMP, compareNbt);
        registry.setDefaultComparison((Object)YItems.FIXTURE, compareNbt);
        registry.setDefaultComparison((Object)YItems.CAGE_LAMP, compareNbt);
        registry.setDefaultComparison((Object)YItems.PANEL, compareNbt);
        registry.addExclusionArea(class_481.class, (screen, out) -> {
            class_1761 selected = class_1761.field_7921[screen.method_2469()];
            ItemGroupParent parent = (ItemGroupParent)selected;
            if (screen instanceof SubTabLocation) {
                SubTabLocation stl = (SubTabLocation)screen;
                if (parent.yttr$getChildren() != null && !parent.yttr$getChildren().isEmpty()) {
                    out.accept(new Bounds(stl.yttr$getX(), stl.yttr$getY(), stl.yttr$getW(), stl.yttr$getH()));
                }
            }
        });
        registry.getRecipeManager().method_30027(YRecipeTypes.VOID_FILTERING).stream().filter(r -> !r.isHidden()).sorted((a, b) -> Float.compare(b.getChance(), a.getChance())).map(EmiVoidFilteringRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        registry.getRecipeManager().method_30027(class_3956.field_17641).stream().filter(r -> r.method_8110().method_7947() == 1 && !r.method_8117().isEmpty()).map(EmiShatteringRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        registry.getRecipeManager().method_30027(class_3956.field_17545).stream().filter(r -> r.method_8113(1, 1) && !r.method_8117().isEmpty()).map(EmiShatteringRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        class_3300 rm = class_310.method_1551().method_1478();
        for (class_2960 id2 : rm.method_14488("textures/gui/ruined_recipe", path -> path.endsWith(".png"))) {
            class_2960 itemId;
            class_1792 result;
            String name = id2.method_12832();
            name = name.substring(27, name.length() - 4);
            if (id2.method_12836().equals("yttr") && (name.equals("border") || name.equals("overlay")) || (result = (class_1792)class_2378.field_11142.method_17966(itemId = new class_2960(id2.method_12836(), name)).orElse(null)) == null) continue;
            RuinedRecipeResourceMetadata meta = null;
            try {
                meta = (RuinedRecipeResourceMetadata)rm.method_14486(id2).method_14481((class_3270)RuinedRecipeResourceMetadata.READER);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Set<Integer> emptySlots = Collections.emptySet();
            if (meta != null) {
                emptySlots = meta.getEmptySlots();
            }
            registry.addRecipe((EmiRecipe)new EmiForgottenRecipe(itemId, emptySlots, EmiStack.of((class_1935)result)));
        }
        Hash.Strategy<class_1799> itemStackStrategy = new Hash.Strategy<class_1799>(){

            public int hashCode(class_1799 o) {
                return Objects.hash(o.method_7909(), o.method_7947(), o.method_7969());
            }

            public boolean equals(class_1799 a, class_1799 b) {
                if (a == b) {
                    return true;
                }
                if (a == null) {
                    return false;
                }
                if (b == null) {
                    return false;
                }
                return class_1799.method_31577((class_1799)a, (class_1799)b) && a.method_7947() == b.method_7947();
            }
        };
        Multimap resultsToInputs = Multimaps.newMultimap((Map)new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)itemStackStrategy), Lists::newArrayList);
        Multimap resultsToColorlessInputs = Multimaps.newMultimap((Map)new Object2ObjectLinkedOpenCustomHashMap((Hash.Strategy)itemStackStrategy), Lists::newArrayList);
        List<LampRecipe> recipes = registry.getRecipeManager().method_8126().stream().map(r -> {
            LampRecipe lr;
            return r instanceof LampRecipe ? (lr = (LampRecipe)((Object)r)) : null;
        }).filter(lr -> lr != null).sorted((a, b) -> Integer.compare(b.getPriority(), a.getPriority())).toList();
        for (LampRecipe r2 : recipes) {
            resultsToInputs.clear();
            resultsToColorlessInputs.clear();
            LampRecipe lr2 = r2;
            class_2371 ingredients = lr2.method_8117();
            boolean interesting = false;
            int w = 0;
            int h = 0;
            block5: for (int i = 1; i <= 3; ++i) {
                for (int j = 1; j <= 3; ++j) {
                    if (!lr2.method_8113(i, j)) continue;
                    w = i;
                    h = j;
                    break block5;
                }
            }
            class_1715 inv = new class_1715(new class_1703(null, 0){

                public boolean method_7597(class_1657 player) {
                    return false;
                }
            }, w, h);
            for (int i = 0; i < ingredients.size(); ++i) {
                class_1799[] matching = ((class_1856)ingredients.get(i)).method_8105();
                if (matching.length == 0) {
                    inv.method_5447(i, class_1799.field_8037);
                    continue;
                }
                inv.method_5447(i, matching[0]);
            }
            if (interesting) {
                System.out.println(r2.method_8114() + " is " + w + "x" + h);
                System.out.println("initial inventory setup: " + Yttr.asList((class_1263)inv));
            }
            boolean shapeless = true;
            boolean finteresting = interesting;
            for (int i = 0; i < ingredients.size(); ++i) {
                int fi = i;
                for (class_1799 is : ((class_1856)ingredients.get(i)).method_8105()) {
                    if (is.method_31574(YItems.YTTRIUM_INGOT)) {
                        shapeless = false;
                    }
                    this.permute(is, (isp, colorless) -> {
                        inv.method_5447(fi, isp);
                        for (int j = 0; j < ingredients.size(); ++j) {
                            if (ingredients.size() > 1 && j == fi) continue;
                            int fj = j;
                            for (class_1799 is2 : ((class_1856)ingredients.get(j)).method_8105()) {
                                this.permute(is2, (isp2, colorless2) -> {
                                    inv.method_5447(fj, isp2);
                                    class_1799 result = lr2.method_17727(inv);
                                    if (finteresting) {
                                        System.out.println(Yttr.asList((class_1263)inv) + " => " + result);
                                    }
                                    if (!result.method_7960()) {
                                        boolean isColorless;
                                        boolean bl = isColorless = colorless != false || colorless2 != false;
                                        if (ingredients.size() == 1) {
                                            isColorless = colorless2;
                                        }
                                        if (result.method_7909() instanceof LampBlockItem && LampBlockItem.getColor(result) == LampColor.COLORLESS || result.method_7909() == YItems.SUIT_HELMET) {
                                            isColorless = false;
                                        }
                                        (isColorless ? resultsToColorlessInputs : resultsToInputs).put((Object)result, (Object)Lists.newArrayList(Yttr.asList((class_1263)inv)));
                                    }
                                });
                            }
                        }
                    });
                }
            }
            String[] names = new String[]{"/colorless.", "."};
            int k = 0;
            for (Multimap mm : List.of(resultsToColorlessInputs, resultsToInputs)) {
                int permutation = 0;
                for (Map.Entry en : mm.asMap().entrySet()) {
                    ArrayList fin = Lists.newArrayList();
                    for (List inputs : (Collection)en.getValue()) {
                        for (int i = 0; i < inputs.size(); ++i) {
                            int x = i % w;
                            int y = i / w;
                            int j = y * 3 + x;
                            while (fin.size() <= j) {
                                fin.add(new ObjectLinkedOpenCustomHashSet((Hash.Strategy)itemStackStrategy));
                            }
                            ((Set)fin.get(j)).add((class_1799)inputs.get(i));
                        }
                    }
                    class_1799 result = (class_1799)en.getKey();
                    ArrayList tip = Lists.newArrayList();
                    if (result.method_7909() == YItems.SUIT_HELMET) {
                        LampColor color = LampBlockItem.getColor(result);
                        tip.add(new class_2588("emi.yttr.suit_helmet_hud", new Object[]{new class_2588("color.yttr." + color.method_15434()).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)color.baseLitColor)))}));
                    }
                    EmiCraftingRecipe ecr = new EmiCraftingRecipe(fin.stream().map(Collection::stream).map(class_1856::method_26964).map(EmiIngredient::of).toList(), (EmiStack)(result.method_31574((class_1792)YItems.SUIT_HELMET) ? new SuitHelmetEmiStack(result) : EmiStack.of((class_1799)result)), Yttr.id(r2.method_8114().method_12832() + names[k] + permutation), shapeless);
                    registry.addRecipe((EmiRecipe)ecr);
                    ++permutation;
                }
                ++k;
            }
        }
    }

    private static EmiRecipeCategory category(EmiRenderable icon) {
        return new EmiRecipeCategory(null, icon);
    }

    private static EmiStack createShatteringPickaxe(class_1792 item) {
        class_1799 is = new class_1799((class_1935)item);
        class_1890.method_8214((Map)ImmutableMap.of((Object)((Object)YEnchantments.SHATTERING_CURSE), (Object)1), (class_1799)is);
        return EmiStack.of((class_1799)is);
    }

    private void permute(class_1799 is, BiConsumer<class_1799, Boolean> cb) {
        if (is.method_7909() instanceof LampBlockItem) {
            for (LampColor lc : LampColor.VALUES) {
                class_1799 is2 = is.method_7972();
                LampBlockItem.setColor(is2, lc);
                LampBlockItem.setInverted(is2, false);
                cb.accept(is2, false);
                if (lc == LampColor.COLORLESS) {
                    cb.accept(is2, true);
                }
                is2 = is2.method_7972();
                LampBlockItem.setInverted(is2, true);
                cb.accept(is2, false);
                if (lc != LampColor.COLORLESS) continue;
                cb.accept(is2, true);
            }
        } else {
            cb.accept(is, false);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Simple {
        public Class<? extends class_1860<?>> from();

        public Class<? extends EmiRecipe> to();
    }

    public static class Texture {
        public static final EmiTexture SHATTERING = new EmiTexture(Yttr.id("textures/gui/shattering.png"), 0, 0, 24, 17, 24, 17, 24, 33);
    }
}

