/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.command;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.unascribed.yttr.mechanics.VoidLogic;
import com.unascribed.yttr.util.YLog;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1923;
import net.minecraft.class_2164;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class VoidUndoCommand {
    public static LiteralArgumentBuilder<class_2168> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"yttr:void_undo").requires(scs -> scs.method_9259(4))).then(class_2170.method_9247((String)"clean").executes(ctx -> {
            try {
                long count;
                Path dir = VoidLogic.getUndoDirectory(((class_2168)ctx.getSource()).method_9211());
                if (Files.exists(dir, new LinkOption[0])) {
                    count = Files.list(dir).count();
                    MoreFiles.deleteRecursively((Path)dir, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
                } else {
                    count = 0L;
                }
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("commands.yttr.void_undo.clean", new Object[]{count}), true);
            }
            catch (IOException e) {
                YLog.warn("Failed to clean undos", e);
                throw new UncheckedIOException(e);
            }
            return 1;
        }))).then(class_2170.method_9247((String)"just").then(class_2170.method_9244((String)"file", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, bldr) -> {
            class_2168 scs = (class_2168)ctx.getSource();
            Path root = VoidLogic.getUndoDirectory(scs.method_9211());
            String dim = scs.method_9225().method_27983().method_29177().toString();
            class_2338 pos = new class_2338(scs.method_9222());
            class_1923 chunkPos = new class_1923(pos);
            return CompletableFuture.supplyAsync(() -> {
                try {
                    Path indexFile = root.resolve("index.dat");
                    if (Files.exists(indexFile, new LinkOption[0])) {
                        class_2487 index = class_2507.method_30613((File)indexFile.toFile());
                        class_2487 byChunk = index.method_10562("ByChunk");
                        ArrayList suggestorsByDistance = Lists.newArrayList();
                        for (int x = -2; x <= 2; ++x) {
                            for (int z = -2; z <= 2; ++z) {
                                String s = chunkPos.field_9181 + x + " " + (chunkPos.field_9180 + z);
                                if (!byChunk.method_10573(s, 9)) continue;
                                class_2499 list = byChunk.method_10554(s, 10);
                                for (int i = 0; i < list.size(); ++i) {
                                    class_2487 entry = list.method_10602(i);
                                    if (!entry.method_10558("Dim").equals(dim)) continue;
                                    int hpos = entry.method_10571("HPos") & 0xFF;
                                    class_2338 entryPos = new class_1923(chunkPos.field_9181 + x, chunkPos.field_9180 + z).method_8323().method_10069(hpos >> 4 & 0xF, entry.method_10550("YPos"), hpos & 0xF);
                                    double dist = entryPos.method_10262((class_2382)pos);
                                    if (!(dist < 1024.0)) continue;
                                    suggestorsByDistance.add(Pair.of((Object)dist, () -> bldr.suggest(entry.method_10558("Name"), (Message)new class_2588("commands.yttr.void_undo.location", new Object[]{entryPos.method_10263(), entryPos.method_10264(), entryPos.method_10260(), (int)class_3532.method_15355((float)((float)dist))}))));
                                }
                            }
                        }
                        Collections.sort(suggestorsByDistance, (a, b) -> Double.compare((Double)a.getFirst(), (Double)b.getFirst()));
                        for (Pair p : suggestorsByDistance) {
                            ((Runnable)p.getSecond()).run();
                        }
                    }
                    return bldr.build();
                }
                catch (IOException e) {
                    YLog.warn("Failed to suggest undos", e);
                    throw new UncheckedIOException(e);
                }
            });
        }).executes(ctx -> {
            Path root = VoidLogic.getUndoDirectory(((class_2168)ctx.getSource()).method_9211());
            Path indexFile = root.resolve("index.dat");
            String fname = StringArgumentType.getString((CommandContext)ctx, (String)"file");
            Path file = root.resolve(fname + ".dat");
            if (Files.exists(file, new LinkOption[0])) {
                try {
                    class_2487 data = class_2507.method_30613((File)file.toFile());
                    int count = VoidUndoCommand.undo(((class_2168)ctx.getSource()).method_9211(), data);
                    if (Files.exists(indexFile, new LinkOption[0])) {
                        class_2487 index = class_2507.method_30613((File)indexFile.toFile());
                        VoidUndoCommand.removeFromIndex(index, Collections.singleton(fname));
                        class_2507.method_30614((class_2487)index, (File)indexFile.toFile());
                        Files.delete(file);
                    }
                    ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("commands.yttr.void_undo.success", new Object[]{count}), true);
                }
                catch (IOException e) {
                    YLog.warn("Failed to undo", e);
                    throw new UncheckedIOException(e);
                }
            } else {
                throw new class_2164((class_2561)new class_2588("commands.yttr.void_undo.not_found"));
            }
            return 1;
        })))).then(class_2170.method_9247((String)"by").then(class_2170.method_9244((String)"user", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, bldr) -> {
            class_2168 scs = (class_2168)ctx.getSource();
            Path root = VoidLogic.getUndoDirectory(scs.method_9211());
            return CompletableFuture.supplyAsync(() -> {
                try {
                    Path indexFile = root.resolve("index.dat");
                    if (Files.exists(indexFile, new LinkOption[0])) {
                        class_2487 index = class_2507.method_30613((File)indexFile.toFile());
                        class_2487 byUser = index.method_10562("ByUser");
                        for (String k : byUser.method_10541()) {
                            class_2487 tag = byUser.method_10562(k);
                            bldr.suggest(tag.method_10558("Username"), (Message)new class_2585(k));
                        }
                    }
                    return bldr.build();
                }
                catch (IOException e) {
                    YLog.warn("Failed to suggest undos", e);
                    throw new UncheckedIOException(e);
                }
            });
        }).executes(ctx -> {
            Path root = VoidLogic.getUndoDirectory(((class_2168)ctx.getSource()).method_9211());
            Path indexFile = root.resolve("index.dat");
            String user = StringArgumentType.getString((CommandContext)ctx, (String)"user");
            HashSet fnames = Sets.newHashSet();
            try {
                if (!Files.exists(indexFile, new LinkOption[0])) throw new class_2164((class_2561)new class_2588("commands.yttr.void_undo.not_found"));
                class_2487 index = class_2507.method_30613((File)indexFile.toFile());
                class_2487 byUser = index.method_10562("ByUser");
                for (String k : byUser.method_10541()) {
                    class_2487 tag = byUser.method_10562(k);
                    if (!k.equals(user) && !tag.method_10558("Username").equals(user)) continue;
                    class_2499 list = tag.method_10554("List", 8);
                    for (int i = 0; i < list.size(); ++i) {
                        fnames.add(list.method_10608(i));
                    }
                }
                if (fnames.isEmpty()) throw new class_2164((class_2561)new class_2588("commands.yttr.void_undo.not_found"));
                int count = 0;
                int success = 0;
                for (String fname : fnames) {
                    try {
                        Path file = root.resolve(fname + ".dat");
                        class_2487 data = class_2507.method_30613((File)file.toFile());
                        count += VoidUndoCommand.undo(((class_2168)ctx.getSource()).method_9211(), data);
                        ++success;
                        if (!Files.exists(indexFile, new LinkOption[0])) continue;
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        YLog.warn("Failed to undo " + fname, e);
                    }
                }
                ((class_2168)ctx.getSource()).method_9226((class_2561)new class_2588("commands.yttr.void_undo.success_multi", new Object[]{count, success}), true);
                VoidUndoCommand.removeFromIndex(index, fnames);
                class_2507.method_30614((class_2487)index, (File)indexFile.toFile());
                return 1;
            }
            catch (IOException e) {
                YLog.warn("Failed to read/update index", e);
                throw new UncheckedIOException(e);
            }
        })));
    }

    private static int undo(MinecraftServer server, class_2487 data) {
        int count = 0;
        class_2960 dim = new class_2960(data.method_10558("Dim"));
        class_3218 world = server.method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)dim));
        if (world == null) {
            throw new class_2164((class_2561)new class_2588("commands.yttr.void_undo.no_world", new Object[]{dim.toString()}));
        }
        int[] posArr = data.method_10561("Pos");
        class_2338 pos = new class_2338(posArr[0], posArr[1], posArr[2]);
        class_2499 blocks = data.method_10554("Blocks", 10);
        class_2338.class_2339 mut = new class_2338.class_2339();
        for (int i = 0; i < blocks.size(); ++i) {
            class_2487 block = blocks.method_10602(i);
            byte[] posOfs = block.method_10547("Pos");
            mut.method_10103(pos.method_10263() + posOfs[0], pos.method_10264() + posOfs[1], pos.method_10260() + posOfs[2]);
            class_2248 b = (class_2248)class_2378.field_11146.method_10223(new class_2960(block.method_10558("Block")));
            if (b == null) continue;
            class_2680 bs = b.method_9564();
            if (block.method_10573("State", 10)) {
                class_2487 state = block.method_10562("State");
                for (class_2769 prop : bs.method_28501()) {
                    if (!state.method_10573(prop.method_11899(), 8)) continue;
                    bs = VoidUndoCommand.setParseProperty(bs, prop, state.method_10558(prop.method_11899()));
                }
            }
            if (bs.method_26215() && !world.method_22347((class_2338)mut)) continue;
            if (world.method_8501((class_2338)mut, bs)) {
                ++count;
            }
            if (!block.method_10573("Entity", 10)) continue;
            class_2487 tag = block.method_10562("Entity");
            if (world.method_8321((class_2338)mut) != null) {
                world.method_8321((class_2338)mut).method_11014(tag);
                continue;
            }
            world.method_8438(class_2586.method_11005((class_2338)mut, (class_2680)bs, (class_2487)tag));
        }
        return count;
    }

    private static void removeFromIndex(class_2487 index, Set<String> fnames) {
        class_2487 byChunk = index.method_10562("ByChunk");
        for (String k : ImmutableList.copyOf((Collection)byChunk.method_10541())) {
            class_2499 list = byChunk.method_10554(k, 10);
            for (int i = list.size() - 1; i >= 0; --i) {
                if (!fnames.contains(list.method_10602(i).method_10558("Name"))) continue;
                list.method_10536(i);
            }
            if (!list.isEmpty()) continue;
            byChunk.method_10551(k);
        }
        class_2487 byUser = index.method_10562("ByUser");
        for (String k : ImmutableList.copyOf((Collection)byUser.method_10541())) {
            class_2487 userData = byUser.method_10562(k);
            class_2499 list = userData.method_10554("List", 8);
            for (int i = list.size() - 1; i >= 0; --i) {
                if (!fnames.contains(list.method_10608(i))) continue;
                list.method_10536(i);
            }
            if (!list.isEmpty()) continue;
            byUser.method_10551(k);
        }
    }

    private static <T extends Comparable<T>> class_2680 setParseProperty(class_2680 bs, class_2769<T> prop, String val) {
        Optional opt = prop.method_11900(val);
        if (!opt.isPresent()) {
            return bs;
        }
        return (class_2680)bs.method_11657(prop, (Comparable)opt.get());
    }

    public static void init() {
    }
}

