/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.client.suit;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.mechanics.LampColor;
import com.unascribed.yttr.util.math.Interp;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class SuitRenderer {
    public static final class_2960 SUIT_TEX = Yttr.id("textures/gui/suit.png");
    public static final int SUIT_TEX_WIDTH = 280;
    public static final int SUIT_TEX_HEIGHT = 200;
    private final Multiset<String> suitElementTickTimes = HashMultiset.create();
    private final Map<String, Integer> uniqifiers = Maps.newHashMap();
    private final Random rand = new Random();
    private final Random independentRand = new Random();
    private int seed = Long.hashCode(System.nanoTime());
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;
    private float a = 1.0f;

    public void setColor(LampColor color) {
        if (color == LampColor.COLORLESS) {
            this.setColor(16766893);
        } else if (color == LampColor.BLACK) {
            this.setColor(0x333388);
        } else if (color == LampColor.LIGHT_BLUE) {
            this.setColor(10141951);
        } else if (color == LampColor.BLUE) {
            this.setColor(26367);
        } else {
            this.setColor(color.glowColor);
        }
    }

    public void setColor(int color) {
        this.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    public void setColor(float r, float g, float b) {
        this.r = r * 0.65f;
        this.g = g * 0.65f;
        this.b = b * 0.65f;
    }

    public void setAlpha(float a) {
        this.a = a;
    }

    public void setUp() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderTexture((int)0, (class_2960)SUIT_TEX);
    }

    public void tearDown() {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public void tick() {
        for (String k : this.suitElementTickTimes.elementSet()) {
            this.suitElementTickTimes.add((Object)k);
        }
    }

    public void drawText(class_4587 matrices, String s, int x, int y, float delta) {
        this.drawText(matrices, s, s, x, y, delta);
    }

    public void drawText(class_4587 matrices, String id, String s, int x, int y, float delta) {
        for (int i = 0; i < s.length(); ++i) {
            int v;
            int u;
            char c = s.charAt(i);
            if (c >= 'a' && c <= 'z') {
                l = c - 97;
                u = l % 13 * 5;
                v = l / 13 * 9;
            } else if (c >= '0' && c <= '?') {
                l = c - 48;
                u = l * 5;
                v = 46;
            } else if (c >= '!' && c <= '/') {
                l = c - 33;
                u = l * 5;
                v = 82;
            } else {
                if (c == ' ') {
                    x += 6;
                    continue;
                }
                u = 75;
                v = 46;
            }
            this.drawElement(matrices, id + ":" + i, x, y, u, v, 5, 9, delta);
            x += 6;
        }
    }

    public void drawElement(class_4587 matrices, String name, int x, int y, int u, int v, int w, int h, float delta) {
        float t;
        int uniq = this.uniqifiers.computeIfAbsent(name, k -> Hashing.murmur3_32((int)this.seed).hashUnencodedChars((CharSequence)name).asInt());
        this.rand.setSeed(uniq);
        int timeToEnable = this.rand.nextInt(10);
        if (!this.suitElementTickTimes.contains((Object)name)) {
            this.suitElementTickTimes.add((Object)name);
        }
        if ((t = (float)(this.suitElementTickTimes.count((Object)name) - 1) + delta) < (float)timeToEnable) {
            return;
        }
        int timeToFullBrightness = this.rand.nextInt(20) + 5;
        int flickeriness = this.rand.nextInt(10);
        float a = t < (float)timeToFullBrightness ? Interp.sCurve5((t -= (float)timeToEnable) / (float)timeToFullBrightness) : 1.0f;
        float wA = w > 10 && h < 10 ? a : 1.0f;
        float hA = h > 10 ? a : 1.0f;
        a = 0.3f + a * 0.7f;
        if (flickeriness > 0 && this.independentRand.nextInt(flickeriness * 8) == 0) {
            a *= 0.85f;
        }
        RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)((a *= this.a) * (Yttr.vectorSuit ? 0.03f : 0.1f)));
        float o = 1.0f;
        float s = 1.0f;
        if (Yttr.vectorSuit) {
            o = 0.8f;
            s = 0.2f;
        }
        for (float xo = -o; xo <= o; xo += s) {
            for (float yo = -o; yo <= o; yo += s) {
                matrices.method_22903();
                matrices.method_22904((double)xo, (double)yo, 0.0);
                class_332.method_25290((class_4587)matrices, (int)x, (int)y, (float)u, (float)v, (int)((int)((float)w * wA)), (int)((int)((float)h * hA)), (int)280, (int)200);
                matrices.method_22909();
            }
        }
        RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)a);
        class_332.method_25290((class_4587)matrices, (int)x, (int)y, (float)u, (float)v, (int)((int)((float)w * wA)), (int)((int)((float)h * hA)), (int)280, (int)200);
    }

    public void drawBar(class_4587 matrices, String id, int x, int y, float value, boolean flip, float delta) {
        int w = (int)(80.0f * value);
        int xo = flip ? 80 - w : 0;
        this.drawElement(matrices, id + "-backdrop", x, y, 0, 30, 80, 8, delta);
        this.drawElement(matrices, id + "-bar", x + xo, y, xo, 38, w, 8, delta);
    }
}

