/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.client.screen;

import com.google.common.base.Ascii;
import com.google.common.collect.EnumMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.client.suit.SuitMusic;
import com.unascribed.yttr.client.suit.SuitRenderer;
import com.unascribed.yttr.client.suit.SuitSound;
import com.unascribed.yttr.content.item.SuitArmorItem;
import com.unascribed.yttr.content.item.block.LampBlockItem;
import com.unascribed.yttr.init.YSounds;
import com.unascribed.yttr.mechanics.SuitResource;
import com.unascribed.yttr.network.MessageC2SDivePos;
import com.unascribed.yttr.network.MessageC2SDiveTo;
import com.unascribed.yttr.world.Geyser;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_301;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.lwjgl.system.MemoryUtil;

public class SuitScreen
extends class_437 {
    private boolean initialized = false;
    private int ticks = 0;
    private boolean hasDangered = false;
    private final SuitRenderer sr = new SuitRenderer();
    private final List<Geyser> geysers;
    private float posX;
    private float posZ;
    private int pressure = 120;
    private int pressureLag = 120;
    private int lastPressureLag = 120;
    private boolean fastDiving = false;
    private Multiset<SuitResource> fdResourceCosts = EnumMultiset.create(SuitResource.class);
    private float fdStartX;
    private float fdStartZ;
    private float fdTgtX;
    private float fdTgtZ;
    private int fastDiveTime;
    private int fastDiveTicks;
    private boolean holdingForward;
    private boolean holdingLeft;
    private boolean holdingRight;
    private boolean holdingBack;
    private Geyser mouseOver;
    private double mouseOverDist;
    private int errorId;
    private int errorTicks;
    private String error;
    private SuitSound music;
    private float zoom = 1.0f;
    private static final FloatBuffer MATRIX_BUFFER = (FloatBuffer)GLX.make((Object)MemoryUtil.memAllocFloat((int)16), floatBuffer -> class_301.method_1407((long)MemoryUtil.memAddress((FloatBuffer)floatBuffer)));

    public SuitScreen(int x, int z, List<Geyser> geysers) {
        super((class_2561)new class_2585(""));
        this.posX = (float)x + 0.5f;
        this.posZ = (float)z + 0.5f;
        this.geysers = Lists.newArrayList(geysers);
    }

    public void addGeyser(Geyser g) {
        this.geysers.add(g);
    }

    public void setPos(int x, int z) {
        this.posX = (float)x + 0.5f;
        this.posZ = (float)z + 0.5f;
    }

    public void setPressure(int pressure) {
        this.pressure = pressure;
    }

    public void showError(String msg) {
        ++this.errorId;
        this.errorTicks = 0;
        this.error = msg;
    }

    public void startFastDive(Multiset<SuitResource> costs, int x, int z, int time) {
        this.fastDiving = true;
        this.fdResourceCosts.clear();
        this.fdResourceCosts.addAll(costs);
        this.fdStartX = this.posX;
        this.fdStartZ = this.posZ;
        this.fdTgtX = (float)x + 0.5f;
        this.fdTgtZ = (float)z + 0.5f;
        this.fastDiveTime = time;
    }

    protected void method_25426() {
        if (!this.initialized) {
            this.initialized = true;
            this.field_22787.method_1483().method_4881();
        }
        if (this.field_22787.field_1724 != null) {
            this.sr.setColor(LampBlockItem.getColor(this.field_22787.field_1724.method_6118(class_1304.field_6169)));
        }
    }

    public void method_25393() {
        if (this.ticks == 1) {
            this.field_22787.method_1483().method_4873((class_1113)new SuitSound(YSounds.DIVE));
        }
        ++this.ticks;
        if (this.ticks > 400) {
            if (this.music == null) {
                this.music = new SuitMusic(YSounds.VOID_MUSIC, 0.5f, class_3419.field_15256);
            }
            int time = this.ticks - 400;
            this.music.setVolume(class_3532.method_15363((float)((float)time / 400.0f), (float)0.05f, (float)0.5f));
            if (!this.field_22787.method_1483().method_4877((class_1113)this.music)) {
                this.field_22787.method_1483().method_4873((class_1113)this.music);
            }
        }
        if (!this.fastDiving && this.ticks % 5 == 0) {
            new MessageC2SDivePos((int)this.posX, (int)this.posZ).sendToServer();
        }
        if (this.fastDiving) {
            ++this.fastDiveTicks;
        }
        this.sr.tick();
        if (this.field_22787.field_1724 != null) {
            this.field_22787.field_1724.method_23327(this.field_22787.field_1724.method_19538().field_1352, (double)(this.field_22787.field_1724.field_6002.method_31607() - 24), this.field_22787.field_1724.method_19538().field_1350);
            this.field_22787.field_1724.field_6017 = 0.0f;
            if (!Yttr.isWearingFullSuit((class_1297)this.field_22787.field_1724)) {
                this.field_22787.method_1507(null);
            }
        }
        if (!this.fastDiving) {
            float l;
            float movementX = 0.0f;
            float movementZ = 0.0f;
            if (this.holdingForward) {
                movementZ -= 1.0f;
            }
            if (this.holdingBack) {
                movementZ += 1.0f;
            }
            if (this.holdingLeft) {
                movementX += 1.0f;
            }
            if (this.holdingRight) {
                movementX -= 1.0f;
            }
            if ((double)(l = class_3532.method_15355((float)(movementX * movementX + movementZ * movementZ))) > 1.0E-5) {
                movementX /= l;
                movementZ /= l;
                int moveSpeed = 2;
                class_1799 is = this.field_22787.field_1724.method_6118(class_1304.field_6174);
                if (is.method_7909() instanceof SuitArmorItem) {
                    SuitArmorItem sai = (SuitArmorItem)is.method_7909();
                    UnmodifiableIterator unmodifiableIterator = SuitResource.VALUES.iterator();
                    while (unmodifiableIterator.hasNext()) {
                        SuitResource sr;
                        moveSpeed /= sr.getSpeedDivider(sai.getResourceAmount(is, sr = (SuitResource)((Object)unmodifiableIterator.next())) <= 0);
                    }
                }
                this.posX += movementX * (float)moveSpeed;
                this.posZ += movementZ * (float)moveSpeed;
            }
        }
        if ((this.fastDiving || this.holdingForward || this.holdingBack || this.holdingLeft || this.holdingRight) && ThreadLocalRandom.current().nextInt(this.fastDiving ? 10 : 20) == 0) {
            this.field_22787.method_1483().method_4873((class_1113)new SuitSound(YSounds.DIVE_THRUST, 0.2f));
        }
        this.lastPressureLag = this.pressureLag;
        if (this.pressure != this.pressureLag) {
            this.pressureLag = Math.abs(this.pressure - this.pressureLag) < 3 ? this.pressure : (this.pressureLag += (this.pressure - this.pressureLag) / 3);
        }
        if (this.error != null && this.errorTicks++ > 80) {
            this.error = null;
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_1799 chest;
        float fastDiveT;
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.clear((int)16384, (boolean)false);
        if (this.ticks < 40) {
            return;
        }
        float factor = 0.0f;
        factor *= this.field_22787.field_1690.field_26675 + 0.2f;
        if ((factor /= 2.0f) > 0.0f || factor < 0.0f) {
            // empty if block
        }
        this.sr.setUp();
        this.sr.drawText(matrices, "distance", 10, this.field_22790 - 78, delta);
        int dist = 0;
        if (this.field_22787.field_1724 != null) {
            dist = (int)Math.sqrt(this.field_22787.field_1724.method_19538().method_1028((double)this.posX, this.field_22787.field_1724.method_19538().field_1351, (double)this.posZ));
        }
        this.sr.drawText(matrices, "distance-num", dist + "m", 10, this.field_22790 - 66, delta);
        float f = fastDiveT = this.fastDiving ? ((float)this.fastDiveTicks + delta) / (float)this.fastDiveTime : 0.0f;
        if (this.fastDiving) {
            this.posX = this.fdStartX + (this.fdTgtX - this.fdStartX) * fastDiveT;
            this.posZ = this.fdStartZ + (this.fdTgtZ - this.fdStartZ) * fastDiveT;
        }
        float pressureA = ((float)this.lastPressureLag + (float)(this.pressureLag - this.lastPressureLag) * delta) / 1000.0f;
        this.sr.drawText(matrices, "pressure", 10, this.field_22790 - 46, delta);
        this.sr.drawElement(matrices, "pressure-notches", 10, this.field_22790 - 34, 0, 55, 81, 8, delta);
        if (!this.fastDiving) {
            this.sr.drawElement(matrices, "pressure-indicator", 9 + (int)(pressureA * 80.0f), this.field_22790 - 25, 0, 63, 3, 6, delta);
            this.sr.drawText(matrices, "pressure-num", this.pressureLag + "kpa", 10, this.field_22790 - 16, delta);
        }
        if ((chest = this.field_22787.field_1724.method_6118(class_1304.field_6174)).method_7909() instanceof SuitArmorItem) {
            Multiset<SuitResource> costs = null;
            if (this.mouseOver != null) {
                costs = Yttr.determineNeededResourcesForFastDive(this.mouseOverDist);
            }
            SuitArmorItem sai = (SuitArmorItem)chest.method_7909();
            int resourceBarY = this.field_22790 - 20 - SuitResource.VALUES.size() * 24;
            float lowestResource = 1.0f;
            for (SuitResource res : SuitResource.VALUES) {
                int len = res.name().length() * 6;
                String name = res.name().toLowerCase(Locale.ROOT);
                float amt = sai.getResourceAmount(chest, res);
                if (this.fastDiving && this.fdResourceCosts.contains((Object)res)) {
                    amt += (float)this.fdResourceCosts.count((Object)res) * (1.0f - fastDiveT);
                }
                float a = amt / (float)res.getMaximum();
                lowestResource = Math.min(a, lowestResource);
                if (a < 0.5f) {
                    this.sr.drawElement(matrices, name + "-warning", this.field_22789 - 96, resourceBarY - 2, 0, 18, 11, 12, delta);
                }
                this.sr.drawText(matrices, name, this.field_22789 - len - 16, resourceBarY, delta);
                this.sr.drawBar(matrices, name, this.field_22789 - 96, resourceBarY + 12, a, true, delta);
                if (costs != null) {
                    int mainW = (int)(80.0f * a);
                    int xo = 80 - mainW;
                    float ca = (float)costs.count((Object)res) / (float)res.getMaximum();
                    RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO, (GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                    this.sr.drawElement(matrices, name + "-bar-cut", this.field_22789 - 97 + xo + 2, resourceBarY + 14, xo + 2, 76, (int)(80.0f * ca), 4, delta);
                    RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                }
                resourceBarY += 24;
            }
            int blinkSpeed = -1;
            if (lowestResource < 0.1f) {
                blinkSpeed = 3;
            } else if (lowestResource < 0.3f) {
                blinkSpeed = 6;
            } else if (lowestResource < 0.5f) {
                blinkSpeed = 12;
            }
            if (blinkSpeed != -1 && this.ticks / blinkSpeed % 4 != 0) {
                if (!this.hasDangered && !this.field_22787.field_1724.method_7337()) {
                    this.hasDangered = true;
                    this.field_22787.method_1483().method_4873((class_1113)new SuitSound(YSounds.DANGER));
                }
                this.sr.drawElement(matrices, "warning", this.field_22789 - 27, this.field_22790 - 18, 0, 18, 11, 12, delta);
            } else {
                this.hasDangered = false;
            }
        }
        int cX = this.field_22789 / 2;
        int cY = this.field_22790 / 2;
        this.sr.drawText(matrices, "n", cX - 2, cY - 95, delta);
        this.sr.drawText(matrices, "e", cX + 90, cY - 4, delta);
        this.sr.drawText(matrices, "s", cX - 2, cY + 83, delta);
        this.sr.drawText(matrices, "w", cX - 95, cY - 4, delta);
        int scale = (int)(25.0f * this.zoom);
        this.mouseOver = null;
        for (Geyser g : this.geysers) {
            double d;
            float dX = this.posX - (float)g.pos.method_10263();
            float dZ = -(this.posZ - (float)g.pos.method_10260());
            int x = (int)((float)cX + dX / (float)scale) - 6;
            int y = (int)((float)cY + dZ / (float)scale) - 6;
            if (x < cX - 100 || x > cX + 90 || y < cY - 95 || y > cY + 90) continue;
            this.sr.drawElement(matrices, "geyser-" + g.id, x, y, 23, 18, 12, 12, delta);
            if (this.fastDiving || mouseX < x || mouseX >= x + 12 || mouseY < y || mouseY >= y + 12) continue;
            this.mouseOver = g;
            this.mouseOverDist = d = Math.sqrt(dX * dX + dZ * dZ);
            this.sr.drawText(matrices, Ascii.toLowerCase((String)g.name), mouseX + 10, mouseY + 10, delta);
            this.sr.drawText(matrices, "geyser-" + g.id + "-dist", "distance " + (int)d, mouseX + 10, mouseY + 22, delta);
        }
        int cornerX = (this.field_22789 - 200) / 2;
        int cornerY = (this.field_22790 - 200) / 2;
        this.sr.drawElement(matrices, "map-border", cornerX, cornerY, 80, 0, 200, 200, delta);
        this.sr.drawElement(matrices, "scale-indicator", cornerX + 160, cornerY + 185, 0, 69, 32, 6, delta);
        int scaleMeter = scale * 32;
        String indicator = scaleMeter > 1000 ? scaleMeter / 1000 + "." + scaleMeter / 100 % 10 + "km" : scaleMeter + "m";
        this.sr.drawText(matrices, "scale-indicator-num", indicator, cornerX + 160, cornerY + 173, delta);
        if (this.fastDiving) {
            this.sr.drawText(matrices, "navigating", 8, 8, delta);
        }
        if (this.error != null) {
            this.sr.drawText(matrices, "error-" + this.errorId, this.error, (this.field_22789 - this.error.length() * 6) / 2, 8, delta);
        }
        this.sr.tearDown();
        if (factor > 0.0f || factor < 0.0f) {
            // empty if block
        }
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25422() {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.mouseOver != null) {
            new MessageC2SDiveTo(this.mouseOver.id).sendToServer();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (amount < 0.0) {
            this.zoom = this.zoom < 0.2f ? (this.zoom + 0.01f > 0.2f ? 0.2f : (this.zoom += 0.01f)) : (this.zoom += 0.1f);
            if (this.zoom > 4.0f) {
                this.zoom = 4.0f;
            }
        }
        if (amount > 0.0) {
            this.zoom = this.zoom <= 0.2f ? (this.zoom -= 0.01f) : (this.zoom -= 0.1f);
            if (this.zoom < 0.05f) {
                this.zoom = 0.05f;
            }
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1894.method_1417(keyCode, scanCode)) {
            this.holdingForward = true;
        }
        if (this.field_22787.field_1690.field_1913.method_1417(keyCode, scanCode)) {
            this.holdingLeft = true;
        }
        if (this.field_22787.field_1690.field_1849.method_1417(keyCode, scanCode)) {
            this.holdingRight = true;
        }
        if (this.field_22787.field_1690.field_1881.method_1417(keyCode, scanCode)) {
            this.holdingBack = true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.field_22787.field_1690.field_1894.method_1417(keyCode, scanCode)) {
            this.holdingForward = false;
        }
        if (this.field_22787.field_1690.field_1913.method_1417(keyCode, scanCode)) {
            this.holdingLeft = false;
        }
        if (this.field_22787.field_1690.field_1849.method_1417(keyCode, scanCode)) {
            this.holdingRight = false;
        }
        if (this.field_22787.field_1690.field_1881.method_1417(keyCode, scanCode)) {
            this.holdingBack = false;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }
}

