/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.client.render.block_entity;

import com.google.common.collect.ImmutableMap;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.client.util.DelegatingVertexConsumer;
import com.unascribed.yttr.client.util.TextureColorThief;
import com.unascribed.yttr.content.block.big.DSUBlock;
import com.unascribed.yttr.content.block.big.DSUBlockEntity;
import com.unascribed.yttr.init.YItems;
import com.unascribed.yttr.init.YTags;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_809;
import net.minecraft.class_827;

public class DSUBlockEntityRenderer
implements class_827<DSUBlockEntity> {
    private static final class_2960 TEX = Yttr.id("textures/block/dsu/front_inside_contents.png");
    private static final ImmutableMap<class_1792, Integer> CUBE_COLORS = ImmutableMap.builder().put((Object)YItems.ULTRAPURE_CARBON, (Object)3751494).put((Object)YItems.ULTRAPURE_CINNABAR, (Object)13895937).put((Object)YItems.ULTRAPURE_GOLD, (Object)16306751).put((Object)YItems.ULTRAPURE_IRON, (Object)0xFFFFFF).put((Object)YItems.ULTRAPURE_LAZURITE, (Object)3432131).put((Object)YItems.ULTRAPURE_SILICA, (Object)16246735).put((Object)YItems.ULTRAPURE_YTTRIUM, (Object)6792093).put((Object)YItems.ULTRAPURE_NEODYMIUM, (Object)7241378).put((Object)YItems.ULTRAPURE_NETHERITE, (Object)0x5A575A).put((Object)YItems.ULTRAPURE_WOLFRAM, (Object)8282201).build();

    public void render(DSUBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (entity.getController() != entity) {
            return;
        }
        class_2680 bs = entity.method_11010();
        class_2248 block = bs.method_26204();
        if (!(block instanceof DSUBlock)) {
            return;
        }
        DSUBlock dsu = (DSUBlock)block;
        if (!((DSUBlock.OpenState)((Object)bs.method_11654(DSUBlock.OPEN))).isTrue()) {
            return;
        }
        class_2338.class_2339 front = entity.method_11016().method_25503();
        class_2680 scan = entity.method_10997().method_8320((class_2338)front);
        class_2350 dir = (class_2350)bs.method_11654((class_2769)DSUBlock.FACING);
        while (scan.method_26204() == dsu) {
            front.method_10098(dir);
            scan = entity.method_10997().method_8320((class_2338)front);
        }
        class_2338.class_2339 frontScan = front.method_25503();
        int maxBlockLight = 0;
        int maxSkyLight = 0;
        if (dir.method_10166() == class_2350.class_2351.field_11048) {
            for (y = 0; y < dsu.ySize; ++y) {
                for (int z = 0; z < dsu.zSize; ++z) {
                    frontScan.method_10100(0, y, z);
                    maxBlockLight = Math.max(maxBlockLight, entity.method_10997().method_8314(class_1944.field_9282, (class_2338)frontScan));
                    maxSkyLight = Math.max(maxSkyLight, entity.method_10997().method_8314(class_1944.field_9284, (class_2338)frontScan));
                }
            }
        } else if (dir.method_10166() == class_2350.class_2351.field_11051) {
            for (y = 0; y < dsu.ySize; ++y) {
                for (int x = 0; x < dsu.xSize; ++x) {
                    frontScan.method_10100(x, y, 0);
                    maxBlockLight = Math.max(maxBlockLight, entity.method_10997().method_8314(class_1944.field_9282, (class_2338)frontScan));
                    maxSkyLight = Math.max(maxSkyLight, entity.method_10997().method_8314(class_1944.field_9284, (class_2338)frontScan));
                }
            }
        }
        light = class_765.method_23687((int)maxBlockLight, (int)maxSkyLight);
        matrices.method_22903();
        matrices.method_22904((double)dsu.xSize / 2.0, (double)dsu.ySize / 2.0, (double)dsu.zSize / 2.0);
        float ang = 0.0f;
        switch ((class_2350)entity.method_11010().method_11654((class_2769)DSUBlock.FACING)) {
            case field_11043: {
                ang = 0.0f;
                break;
            }
            case field_11034: {
                ang = 270.0f;
                break;
            }
            case field_11035: {
                ang = 180.0f;
                break;
            }
            case field_11039: {
                ang = 90.0f;
                break;
            }
            default: {
                ang = -30.0f;
            }
        }
        matrices.method_22907(class_1160.field_20705.method_23214(ang));
        matrices.method_22904((double)(-dsu.xSize) / 2.0, (double)(-dsu.ySize) / 2.0, (double)(-dsu.zSize) / 2.0);
        matrices.method_22904(2.0, 2.0, 0.0);
        matrices.method_22905(-0.0625f, -0.0625f, 0.0625f);
        class_1159 mat = matrices.method_23760().method_23761();
        class_4581 nmat = matrices.method_23760().method_23762();
        matrices.method_22904(2.5, 2.0, -0.0025);
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 9; ++x) {
                class_1799 item = entity.method_5438(y * 9 + x);
                if (item.method_7960()) continue;
                if (item.method_31573(YTags.Item.ULTRAPURE_CUBES)) {
                    int color;
                    if (CUBE_COLORS.containsKey((Object)item.method_7909())) {
                        color = (Integer)CUBE_COLORS.get((Object)item.method_7909());
                    } else {
                        class_2960 spriteId = class_310.method_1551().method_1480().method_4019(item, null, null, 0).method_4711().method_4598();
                        class_2960 id = new class_2960(spriteId.method_12836(), "textures/" + spriteId.method_12832() + ".png");
                        color = TextureColorThief.getPrimaryColor(id);
                    }
                    float a = (float)(item.method_7947() + 64) / 384.0f;
                    if (a > 1.0f) {
                        a = 1.0f;
                    }
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color >> 0 & 0xFF) / 255.0f;
                    int minU = 2 + x * 3;
                    int minV = 2 + y * 6;
                    int maxU = 5 + x * 3;
                    int maxV = 5 + y * 6;
                    float w = 32.0f;
                    float h = 32.0f;
                    class_4588 vc = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)TEX));
                    vc.method_22918(mat, (float)(x * 3), (float)(y * 6), 0.0f).method_22915(r, g, b, a).method_22913((float)minU / w, (float)minV / h).method_22922(overlay).method_22916(light).method_23763(nmat, 0.0f, 0.0f, 1.0f).method_1344();
                    vc.method_22918(mat, (float)(x * 3 + 3), (float)(y * 6), 0.0f).method_22915(r, g, b, a).method_22913((float)maxU / w, (float)minV / h).method_22922(overlay).method_22916(light).method_23763(nmat, 0.0f, 0.0f, 1.0f).method_1344();
                    vc.method_22918(mat, (float)(x * 3 + 3), (float)(y * 6 + 3), 0.0f).method_22915(r, g, b, a).method_22913((float)maxU / w, (float)maxV / h).method_22922(overlay).method_22916(light).method_23763(nmat, 0.0f, 0.0f, 1.0f).method_1344();
                    vc.method_22918(mat, (float)(x * 3), (float)(y * 6 + 3), 0.0f).method_22915(r, g, b, a).method_22913((float)minU / w, (float)maxV / h).method_22922(overlay).method_22916(light).method_23763(nmat, 0.0f, 0.0f, 1.0f).method_1344();
                    continue;
                }
                matrices.method_22903();
                matrices.method_22905(3.0f, -3.0f, -3.0f);
                final class_4581 nmat2 = matrices.method_23760().method_23762();
                matrices.method_22909();
                matrices.method_22903();
                matrices.method_22904((double)(x * 3), (double)(y * 6), 0.0);
                matrices.method_22904(1.5, 1.5, -0.015);
                matrices.method_22905(3.0f, -3.0f, -0.01f);
                class_310.method_1551().method_1480().method_23178(item, class_809.class_811.field_4317, light, overlay, matrices, layer -> new DelegatingVertexConsumer(vertexConsumers.getBuffer(layer)){

                    public void method_22919(class_4587.class_4665 matrixEntry, class_777 quad, float red, float green, float blue, int light, int overlay) {
                        super.method_22919(new class_4587.class_4665(matrixEntry.method_23761(), nmat2), quad, red, green, blue, light, overlay);
                    }
                }, 0);
                matrices.method_22909();
            }
        }
        matrices.method_22909();
    }
}

