/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.client.render;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import com.unascribed.yttr.client.IHasAClient;
import com.unascribed.yttr.client.RenderBridge;
import com.unascribed.yttr.client.ReplicatorShapes;
import com.unascribed.yttr.content.block.mechanism.ReplicatorBlockEntity;
import com.unascribed.yttr.init.YBlocks;
import com.unascribed.yttr.init.YItems;
import com.unascribed.yttr.util.math.Interp;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5481;
import net.minecraft.class_765;
import net.minecraft.class_804;
import net.minecraft.class_809;
import net.minecraft.class_918;

public class ReplicatorRenderer
extends IHasAClient {
    public static final Set<ReplicatorBlockEntity> replicators = Sets.newLinkedHashSet();
    public static final Set<ReplicatorBlockEntity> removing = Sets.newLinkedHashSet();
    private static final List<ReplicatorBlockEntity> renderList = Lists.newArrayList();
    private static final class_437 dummyScreen = new class_437((class_2561)new class_2585("")){};
    private static final Random rand = new Random();

    public static boolean renderOutline(WorldRenderContext wrc, WorldRenderContext.BlockOutlineContext boc) {
        class_2586 be;
        if (boc.blockState().method_27852((class_2248)YBlocks.REPLICATOR) && (be = wrc.world().method_8321(boc.blockPos())) instanceof ReplicatorBlockEntity) {
            ReplicatorBlockEntity rbe = (ReplicatorBlockEntity)be;
            class_4587 matrices = wrc.matrixStack();
            matrices.method_22903();
            matrices.method_22904((double)boc.blockPos().method_10263() - boc.cameraX(), (double)boc.blockPos().method_10264() - boc.cameraY(), (double)boc.blockPos().method_10260() - boc.cameraZ());
            matrices.method_22904(0.5, 0.5, 0.5);
            rand.setSeed(((ReplicatorBlockEntity)be).seed);
            if ((float)rbe.clientAge + wrc.tickDelta() < 5.0f) {
                float a = Interp.sCurve5(((float)rbe.clientAge + wrc.tickDelta()) / 5.0f);
                matrices.method_22905(a, a, a);
            }
            float t = (float)(rand.nextInt(200) + rbe.clientAge) + wrc.tickDelta();
            int shape = rand.nextInt(ReplicatorShapes.ALL.size());
            rand.nextInt(ReplicatorShapes.ALL.size());
            matrices.method_22907(class_1160.field_20705.method_23214(t * (rand.nextFloat() * 2.0f)));
            matrices.method_22907(class_1160.field_20703.method_23214(t * (rand.nextFloat() * 2.0f)));
            matrices.method_22907(class_1160.field_20707.method_23214(t * (rand.nextFloat() * 2.0f)));
            matrices.method_22905(1.4f - rand.nextFloat() * 0.65f, 1.4f - rand.nextFloat() * 0.65f, 1.4f - rand.nextFloat() * 0.65f);
            class_4588 vc = wrc.consumers().getBuffer(class_1921.method_23594());
            switch (shape) {
                case 0: {
                    matrices.method_22905(0.5f, 0.5f, 0.5f);
                    ReplicatorShapes.octahedronOutline(matrices, vc, 0.0f, 0.0f, 0.0f, 0.4f);
                    break;
                }
                case 1: {
                    matrices.method_22905(0.509165f, 0.509165f, 0.509165f);
                    ReplicatorShapes.dodecahedronOutline(matrices, vc, 0.0f, 0.0f, 0.0f, 0.4f);
                    break;
                }
                case 2: {
                    matrices.method_22905(0.5f, 0.5f, 0.5f);
                    ReplicatorShapes.icosahedronOutline(matrices, vc, 0.0f, 0.0f, 0.0f, 0.4f);
                }
            }
            matrices.method_22909();
            return false;
        }
        return true;
    }

    public static void render(class_4587 matrices, float tickDelta, int seed, class_1799 item, class_2338 pos, int ticks, class_4184 cam, int pass, float detail) {
        class_3965 bhr;
        if (pass < 2 || pass == -1) {
            matrices.method_22903();
            matrices.method_22904(0.5, 0.5, 0.5);
            if ((float)ticks + tickDelta < 5.0f) {
                float a = Interp.sCurve5(((float)ticks + tickDelta) / 5.0f);
                matrices.method_22905(a, a, a);
            }
            rand.setSeed(seed);
            float t = (float)(rand.nextInt(200) + ticks) + tickDelta;
            if (pass == 0 || pass == -1) {
                matrices.method_22903();
                class_918 ir = mc.method_1480();
                class_1087 model = ir.method_4012().method_3308(item);
                if (pass == -1) {
                    class_1087 ours = ir.method_4012().method_3304((class_1792)YItems.REPLICATOR);
                    class_804 undo = ours.method_4709().field_4300;
                    matrices.method_22905(1.0f / undo.field_4285.method_4943(), 1.0f / undo.field_4285.method_4945(), 1.0f / undo.field_4285.method_4947());
                    class_1158 q = new class_1158(undo.field_4287.method_4943(), undo.field_4287.method_4945(), undo.field_4287.method_4947(), true);
                    q.method_4926();
                    matrices.method_22907(q);
                    matrices.method_22904((double)(-undo.field_4286.method_4943()), (double)(-undo.field_4286.method_4945()), (double)(-undo.field_4286.method_4947()));
                    model.method_4709().field_4300.method_23075(false, matrices);
                    matrices.method_22905(0.65f, 0.65f, 0.65f);
                } else {
                    matrices.method_22905(0.35f, 0.35f, 0.35f);
                }
                if (cam != null) {
                    matrices.method_22907(cam.method_23767());
                }
                matrices.method_22907(class_1160.field_20707.method_23214(class_3532.method_15374((float)(t / 6.0f % ((float)Math.PI * 2))) * 10.0f));
                class_4597.class_4598 imm = mc.method_22940().method_23000();
                ir.method_23179(item, class_809.class_811.field_4315, false, matrices, (class_4597)imm, class_765.method_23687((int)15, (int)15), class_4608.field_21444, model);
                imm.method_22993();
                matrices.method_22909();
            }
            if (pass == 1 && RenderBridge.canUseCompatFunctions()) {
                int solid1 = (Integer)ReplicatorShapes.ALL.get(rand.nextInt(ReplicatorShapes.ALL.size()));
                int solid2 = (Integer)ReplicatorShapes.ALL.get(rand.nextInt(ReplicatorShapes.ALL.size()));
                RenderBridge.glDepthMask((boolean)false);
                RenderBridge.glEnable((int)2929);
                RenderBridge.glDepthFunc((int)513);
                RenderBridge.glPushMCMatrix(matrices);
                RenderBridge.glEnable((int)32826);
                RenderBridge.glEnable((int)3042);
                RenderBridge.glEnable((int)2903);
                RenderBridge.glDisable((int)3553);
                RenderBridge.glDefaultBlendFunc();
                RenderBridge.glRotatef((float)(t * (rand.nextFloat() * 2.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
                RenderBridge.glRotatef((float)(t * (rand.nextFloat() * 2.0f)), (float)1.0f, (float)0.0f, (float)0.0f);
                RenderBridge.glRotatef((float)(t * (rand.nextFloat() * 2.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
                float xSo = rand.nextFloat() * 0.65f;
                float ySo = rand.nextFloat() * 0.65f;
                float zSo = rand.nextFloat() * 0.65f;
                if (cam == null) {
                    zSo = 0.0f;
                    ySo = 0.0f;
                    xSo = 0.0f;
                }
                RenderBridge.glScalef((float)(1.4f - xSo), (float)(1.4f - ySo), (float)(1.4f - zSo));
                RenderBridge.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                RenderBridge.glBlendFuncSeparate((int)770, (int)1, (int)770, (int)771);
                float r = rand.nextFloat() / 2.0f;
                float g = rand.nextFloat() / 2.0f;
                float b = (0.25f + rand.nextFloat() * 0.75f) / 2.0f;
                RenderBridge.glDisable((int)2896);
                RenderBridge.glPushMatrix();
                int i = 0;
                while (true) {
                    double d = i;
                    int n = class_310.method_1517() ? 6 : 1;
                    if (!(d < Math.ceil((float)n * detail))) break;
                    RenderBridge.glColor4f((float)r, (float)g, (float)b, (float)(i == 0 ? 0.4f : 0.1f / detail));
                    RenderBridge.glCallList((int)solid1);
                    float s = 1.0f + 0.05f / detail;
                    RenderBridge.glScalef((float)s, (float)s, (float)s);
                    ++i;
                }
                RenderBridge.glPopMatrix();
                RenderBridge.glScalef((float)(0.9f - rand.nextFloat() * 0.25f), (float)(0.9f - rand.nextFloat() * 0.25f), (float)(0.9f - rand.nextFloat() * 0.25f));
                RenderBridge.glDefaultBlendFunc();
                RenderBridge.glEnable((int)2896);
                RenderBridge.glCopyMCLight();
                RenderBridge.glColor4f((float)rand.nextFloat(), (float)(0.25f + rand.nextFloat() * 0.75f), (float)rand.nextFloat(), (float)0.25f);
                RenderBridge.glCallList((int)solid2);
                RenderBridge.glEnable((int)3553);
                RenderBridge.glDisable((int)32826);
                RenderBridge.glDisable((int)3042);
                RenderBridge.glDisable((int)2896);
                RenderBridge.glDisable((int)2903);
                RenderBridge.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderBridge.glPopMCMatrix();
                RenderBridge.glDepthFunc((int)515);
                RenderBridge.glDepthMask((boolean)true);
            }
            matrices.method_22909();
        }
        if (pass == 2 && !item.method_7960() && !ReplicatorRenderer.mc.field_1690.field_1842 && ReplicatorRenderer.mc.field_1765.method_17783() == class_239.class_240.field_1332 && (bhr = (class_3965)ReplicatorRenderer.mc.field_1765).method_17777().equals((Object)pos)) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            matrices.method_22903();
            matrices.method_22904(0.5, 0.5, 0.5);
            if (cam != null) {
                matrices.method_22907(cam.method_23767());
            }
            matrices.method_22905(-0.0125f, -0.0125f, 0.01f);
            matrices.method_22904(0.0, -50.0, -400.0);
            dummyScreen.method_25423(mc, 4000, 4000);
            List tip = Lists.transform((List)dummyScreen.method_25408(item), class_2561::method_30937);
            int width = 0;
            int height = tip.size() * 8;
            for (class_5481 ot : tip) {
                width = Math.max(width, ReplicatorRenderer.mc.field_1772.method_30880(ot));
            }
            matrices.method_22904((double)((float)(-(width + 16)) / 2.0f), (double)(-height), 0.0);
            dummyScreen.method_25417(matrices, tip, 0, 0);
            matrices.method_22909();
            RenderSystem.disableBlend();
        }
    }

    public static void render(WorldRenderContext wrc) {
        wrc.profiler().method_15405("yttr:replicators");
        if (!replicators.isEmpty() || !removing.isEmpty()) {
            renderList.clear();
            renderList.addAll(replicators);
            renderList.addAll(removing);
            wrc.profiler().method_15396("prepare");
            for (ReplicatorBlockEntity rbe : renderList) {
                double dist;
                if (rbe.clientAge < 1 || !((dist = rbe.method_11016().method_19770((class_2374)wrc.camera().method_19326())) < 4096.0) || !wrc.frustum().method_23093(new class_238(rbe.method_11016()))) continue;
                rbe.distTmp = dist;
            }
            wrc.profiler().method_15405("sort");
            Collections.sort(renderList, (a, b) -> Double.compare(b.distTmp, a.distTmp));
            wrc.profiler().method_15405("render");
            class_4587 matrices = wrc.matrixStack();
            matrices.method_22903();
            class_243 cam = wrc.camera().method_19326();
            matrices.method_22904(-cam.field_1352, -cam.field_1351, -cam.field_1350);
            for (int pass = 0; pass < 3; ++pass) {
                wrc.profiler().method_15396("pass" + pass);
                for (ReplicatorBlockEntity rbe : renderList) {
                    matrices.method_22903();
                    matrices.method_22904((double)rbe.method_11016().method_10263(), (double)rbe.method_11016().method_10264(), (double)rbe.method_11016().method_10260());
                    if (rbe.method_11015()) {
                        float a2 = Interp.sCurve5(Math.max(0.0f, 1.0f - ((float)rbe.removedTicks + wrc.tickDelta()) / 10.0f));
                        matrices.method_22904(0.5, 0.5, 0.5);
                        matrices.method_22905(a2, a2, a2);
                        matrices.method_22907(class_1160.field_20707.method_23214(a2 * 720.0f));
                        matrices.method_22904(-0.5, -0.5, -0.5);
                    }
                    float detail = 1.0f;
                    if (rbe.distTmp < 4.0) {
                        detail = 2.0f;
                    } else if (rbe.distTmp > 144.0) {
                        detail = 0.5f;
                    } else if (rbe.distTmp > 1024.0) {
                        detail = 0.1f;
                    }
                    ReplicatorRenderer.render(matrices, wrc.tickDelta(), rbe.seed, rbe.item, rbe.method_11016(), rbe.clientAge, wrc.camera(), pass, detail);
                    matrices.method_22909();
                }
                wrc.profiler().method_15407();
            }
            matrices.method_22909();
            wrc.profiler().method_15407();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        wrc.profiler().method_15405("particles");
    }

    public static void notifyCreated(ReplicatorBlockEntity rbe) {
        replicators.add(rbe);
    }

    public static void tick() {
        class_3695 p = mc.method_16011();
        p.method_15396("main");
        HashSet valid = Sets.newHashSet();
        if (ReplicatorRenderer.mc.field_1687 != null) {
            for (ReplicatorBlockEntity rbe : replicators) {
                if (rbe.method_11015() || rbe.method_10997() != ReplicatorRenderer.mc.field_1687) continue;
                valid.add(rbe);
            }
        } else {
            replicators.clear();
            removing.clear();
        }
        replicators.clear();
        replicators.addAll(valid);
        p.method_15405("removed");
        Iterator<ReplicatorBlockEntity> iter = removing.iterator();
        while (iter.hasNext()) {
            ReplicatorBlockEntity rbe;
            rbe = iter.next();
            rbe.clientTick();
            if (rbe.method_11015() && rbe.removedTicks <= 10) continue;
            rbe.removedTicks = 0;
            iter.remove();
        }
        p.method_15407();
    }
}

