/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.client.render;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.unascribed.yttr.client.IHasAClient;
import com.unascribed.yttr.client.YRenderLayers;
import com.unascribed.yttr.client.YttrClient;
import com.unascribed.yttr.client.util.DelegatingVertexConsumer;
import com.unascribed.yttr.mechanics.HaloBlockEntity;
import com.unascribed.yttr.util.MysticSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1160;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

public class LampRenderer
extends IHasAClient {
    private static final Map<class_2338, class_2586> lampsByBlock = new Object2ObjectOpenHashMap();
    private static final Map<class_2586, Object> lastState = new Object2ObjectOpenHashMap();
    private static final Multimap<class_4076, class_2586> lampsBySection = Multimaps.newSetMultimap((Map)new Object2ObjectOpenHashMap(), ReferenceOpenHashSet::new);
    private static final Map<class_4076, class_291> buffers = new Object2ObjectOpenHashMap();
    private static final Map<class_4076, class_238> boundingBoxes = new Object2ObjectOpenHashMap();

    public static void clearCache() {
        buffers.values().forEach(class_291::close);
        buffers.clear();
        boundingBoxes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(class_1937 world, class_4587 matrices, class_4588 vc, class_2680 state, int color, @Nullable class_2350 facing, @Nullable class_2338 pos) {
        class_1087 bm;
        if (color == 0) {
            color = 0x222222;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_1087 base = class_310.method_1551().method_1541().method_3349(state);
        try {
            YttrClient.retrievingHalo = true;
            bm = base.method_4710().method_3495(base, class_1799.field_8037, class_310.method_1551().field_1687, (class_1309)class_310.method_1551().field_1724, 39);
        }
        finally {
            YttrClient.retrievingHalo = false;
        }
        if (bm == null) {
            return;
        }
        DelegatingVertexConsumer dvc = new DelegatingVertexConsumer(vc){

            public void method_23919(float x, float y, float z, float red, float green, float blue, float alpha, float u, float v, int overlay, int light, float normalX, float normalY, float normalZ) {
                this.method_22912(x, y, z);
                this.method_22913(u, v);
                this.method_22915(red, green, blue, alpha);
                this.method_22914(normalX, normalY, normalZ);
                this.method_1344();
            }
        };
        matrices.method_22903();
        if (facing != null) {
            int x = 0;
            int y = 0;
            switch (facing) {
                case field_11033: {
                    break;
                }
                case field_11039: {
                    x = 90;
                    y = 90;
                    break;
                }
                case field_11043: {
                    x = 90;
                    break;
                }
                case field_11035: {
                    x = 90;
                    y = 180;
                    break;
                }
                case field_11034: {
                    x = 90;
                    y = 270;
                    break;
                }
                case field_11036: {
                    x = 180;
                }
            }
            matrices.method_22904(0.5, 0.5, 0.5);
            matrices.method_22907(class_1160.field_20705.method_23214((float)y));
            matrices.method_22907(class_1160.field_20703.method_23214((float)x));
            matrices.method_22904(-0.5, -0.5, -0.5);
        }
        for (class_777 bq : bm.method_4707(state, null, world.field_9229)) {
            dvc.method_22919(matrices.method_23760(), bq, r, g, b, 0, 0);
        }
        for (class_2350 dir : class_2350.values()) {
            if (pos != null && !class_2248.method_9607((class_2680)state, (class_1922)class_310.method_1551().field_1687, (class_2338)pos, (class_2350)dir, (class_2338)pos.method_10093(dir))) continue;
            for (class_777 bq : bm.method_4707(state, dir, world.field_9229)) {
                dvc.method_22919(matrices.method_23760(), bq, r, g, b, 0, 0);
            }
        }
        matrices.method_22909();
    }

    public static void render(WorldRenderContext wrc) {
        wrc.profiler().method_15405("yttr:lamps");
        if (!lampsBySection.isEmpty()) {
            wrc.profiler().method_15396("prepare");
            MysticSet<class_4076> needsRebuild = MysticSet.of();
            for (Object be : lampsBySection.values()) {
                if (!(be instanceof HaloBlockEntity)) continue;
                Object s = ((HaloBlockEntity)be).getStateObject();
                class_4076 csp = class_4076.method_18682((class_2338)be.method_11016());
                if (lastState.get(be) == s && buffers.containsKey(csp)) continue;
                lastState.put((class_2586)be, s);
                needsRebuild = needsRebuild.add(csp);
            }
            wrc.profiler().method_15405("rebuild");
            class_4587 scratch = new class_4587();
            for (class_4076 csp : needsRebuild.mundane()) {
                Collection l = lampsBySection.get((Object)csp);
                if (l.isEmpty()) {
                    if (!buffers.containsKey(csp)) continue;
                    buffers.remove(csp).close();
                    boundingBoxes.remove(csp);
                    continue;
                }
                class_238 bounds = null;
                class_287 vc = new class_287(24 * class_290.field_1577.method_1362() * l.size());
                vc.method_1328(class_293.class_5596.field_27382, class_290.field_1577);
                for (class_2586 be : l) {
                    if (!(be instanceof HaloBlockEntity) || !((HaloBlockEntity)be).shouldRenderHalo()) continue;
                    scratch.method_22903();
                    scratch.method_22904((double)(be.method_11016().method_10263() - csp.method_19527()), (double)(be.method_11016().method_10264() - csp.method_19528()), (double)(be.method_11016().method_10260() - csp.method_19529()));
                    int color = ((HaloBlockEntity)be).getGlowColor();
                    class_2680 state = be.method_11010();
                    class_2350 facing = ((HaloBlockEntity)be).getFacing();
                    LampRenderer.render((class_1937)LampRenderer.mc.field_1687, scratch, (class_4588)vc, state, color, facing, be.method_11016());
                    class_238 myBox = new class_238(be.method_11016()).method_1014(0.5);
                    bounds = bounds == null ? myBox : bounds.method_991(myBox);
                    scratch.method_22909();
                }
                vc.method_1326();
                class_291 vb = buffers.computeIfAbsent(csp, blah -> new class_291());
                vb.method_1352(vc);
                buffers.put(csp, vb);
                boundingBoxes.put(csp, bounds);
            }
            wrc.profiler().method_15405("render");
            class_4587 matrices = wrc.matrixStack();
            matrices.method_22903();
            class_243 cam = wrc.camera().method_19326();
            matrices.method_22904(-cam.field_1352, -cam.field_1351, -cam.field_1350);
            for (class_4076 pos : buffers.keySet()) {
                class_238 box = boundingBoxes.get(pos);
                if (box == null || !wrc.frustum().method_23093(box)) continue;
                matrices.method_22903();
                matrices.method_22904((double)pos.method_19527(), (double)pos.method_19528(), (double)pos.method_19529());
                class_291 buf = buffers.get(pos);
                buf.method_1353();
                YRenderLayers.getLampHalo().method_23516();
                buf.method_34427(matrices.method_23760().method_23761(), RenderSystem.getProjectionMatrix(), class_757.method_34549());
                YRenderLayers.getLampHalo().method_23518();
                class_291.method_1354();
                matrices.method_22909();
                if (!mc.method_1561().method_3958() || mc.method_1555()) continue;
                class_4597.class_4598 vcp = mc.method_22940().method_23000();
                class_761.method_22982((class_4587)matrices, (class_4588)vcp.getBuffer(class_1921.method_23594()), (class_238)box, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                vcp.method_22994(class_1921.method_23594());
            }
            matrices.method_22909();
            wrc.profiler().method_15407();
        }
        wrc.profiler().method_15405("particles");
    }

    public static <T extends class_2586> void notifyCreated(T be) {
        class_4076 cs = class_4076.method_18682((class_2338)be.method_11016());
        if (!lampsBySection.containsEntry((Object)cs, be)) {
            if (lampsByBlock.containsKey(be.method_11016())) {
                class_2586 other = lampsByBlock.remove(be.method_11016());
                lampsBySection.remove((Object)class_4076.method_18682((class_2338)be.method_11016()), (Object)other);
            }
            lampsByBlock.put(be.method_11016(), be);
            lampsBySection.put((Object)cs, be);
        }
    }

    public static void tick() {
        if (LampRenderer.mc.field_1687 != null) {
            class_3695 p = mc.method_16011();
            p.method_15396("validate");
            Iterator iter = lampsBySection.values().iterator();
            while (iter.hasNext()) {
                class_2586 be = (class_2586)iter.next();
                if (!be.method_11015() && be.method_10997() == LampRenderer.mc.field_1687) continue;
                class_4076 cs = class_4076.method_18682((class_2338)be.method_11016());
                if (buffers.containsKey(cs)) {
                    buffers.remove(cs).close();
                }
                lampsByBlock.remove(be.method_11016(), be);
                iter.remove();
            }
            p.method_15407();
        } else {
            lampsByBlock.clear();
            lampsBySection.clear();
            lastState.clear();
            LampRenderer.clearCache();
        }
    }
}

