/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.client.render;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.unascribed.yttr.client.IHasAClient;
import com.unascribed.yttr.content.item.EffectorItem;
import com.unascribed.yttr.mixinsupport.YttrWorld;
import com.unascribed.yttr.util.math.Interp;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1723;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_777;

public class EffectorRenderer
extends IHasAClient {
    public static final List<EffectorHole> effectorHoles = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(WorldRenderContext wrc) {
        if (effectorHoles.isEmpty()) {
            return;
        }
        class_638 w = wrc.world();
        if (!(w instanceof YttrWorld)) {
            return;
        }
        ((YttrWorld)w).yttr$setUnmask(true);
        try {
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)515);
            class_243 cam = wrc.camera().method_19326();
            class_4587 ms = new class_4587();
            ms.method_22904(-cam.field_1352, -cam.field_1351, -cam.field_1350);
            class_2338.class_2339 mut = new class_2338.class_2339();
            List<class_2350.class_2351> axes = Arrays.asList(class_2350.class_2351.values());
            class_289 tess = class_289.method_1348();
            class_287 bb = tess.method_1349();
            for (EffectorHole hole : effectorHoles) {
                class_2350.class_2351 axisZ = hole.dir.method_10166();
                class_2350.class_2351 axisX = (class_2350.class_2351)Iterables.find(axes, a -> a != axisZ);
                class_2350.class_2351 axisY = (class_2350.class_2351)Iterables.find((Iterable)Lists.reverse(axes), a -> a != axisZ);
                float t = (float)hole.age + wrc.tickDelta();
                float a2 = t <= 4.0f ? 1.0f - Interp.sCurve5(1.0f - t / 4.0f) : (t >= 130.0f ? Interp.sCurve5((150.0f - t) / 20.0f) : 1.0f);
                if ((double)a2 < 0.05) {
                    a2 = 0.0f;
                }
                if ((double)a2 > 0.95) {
                    a2 = 1.0f;
                }
                if (a2 != 1.0f) {
                    EffectorRenderer.drawVoidCap(w, ms, mut, hole.length, axisX, axisY, a2, hole.start, hole.dir);
                    EffectorRenderer.drawVoidCap(w, ms, mut, 0, axisX, axisY, a2, hole.start.method_10079(hole.dir, hole.length - 1), hole.dir.method_10153());
                }
                RenderSystem.setShader(class_757::method_34497);
                RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
                bb.method_1328(class_293.class_5596.field_27382, class_1921.method_23581().method_23031());
                ms.method_22903();
                class_1160 trans = hole.dir.method_23955();
                trans.method_4942((float)hole.length / 2.0f);
                ms.method_22904((double)hole.start.method_10263(), (double)hole.start.method_10264(), (double)hole.start.method_10260());
                ms.method_22904((double)trans.method_4943(), (double)trans.method_4945(), (double)trans.method_4947());
                float s = ((float)hole.length - 0.01f) / (float)hole.length;
                switch (axisZ) {
                    case field_11048: {
                        ms.method_22905(s, 1.0f, 1.0f);
                        break;
                    }
                    case field_11052: {
                        ms.method_22905(1.0f, s, 1.0f);
                        break;
                    }
                    case field_11051: {
                        ms.method_22905(1.0f, 1.0f, s);
                    }
                }
                ms.method_22904((double)(-trans.method_4943()), (double)(-trans.method_4945()), (double)(-trans.method_4947()));
                ms.method_22904((double)(-hole.start.method_10263()), (double)(-hole.start.method_10264()), (double)(-hole.start.method_10260()));
                for (int z = 0; z < hole.length; ++z) {
                    int i;
                    mut.method_10101((class_2382)hole.start).method_10104(hole.dir, z);
                    EffectorItem.move(mut, axisY, -2);
                    EffectorItem.move(mut, axisX, -1);
                    for (i = 0; i < 3; ++i) {
                        EffectorRenderer.drawVoidFace((class_1937)w, ms, (class_4588)bb, (class_2338)mut, class_2350.method_10169((class_2350.class_2351)axisY, (class_2350.class_2352)class_2350.class_2352.field_11056));
                        EffectorItem.move(mut, axisX, 1);
                    }
                    mut.method_10101((class_2382)hole.start).method_10104(hole.dir, z);
                    EffectorItem.move(mut, axisY, 2);
                    EffectorItem.move(mut, axisX, -1);
                    for (i = 0; i < 3; ++i) {
                        EffectorRenderer.drawVoidFace((class_1937)w, ms, (class_4588)bb, (class_2338)mut, class_2350.method_10169((class_2350.class_2351)axisY, (class_2350.class_2352)class_2350.class_2352.field_11060));
                        EffectorItem.move(mut, axisX, 1);
                    }
                    mut.method_10101((class_2382)hole.start).method_10104(hole.dir, z);
                    EffectorItem.move(mut, axisY, -1);
                    EffectorItem.move(mut, axisX, -2);
                    for (i = 0; i < 3; ++i) {
                        EffectorRenderer.drawVoidFace((class_1937)w, ms, (class_4588)bb, (class_2338)mut, class_2350.method_10169((class_2350.class_2351)axisX, (class_2350.class_2352)class_2350.class_2352.field_11056));
                        EffectorItem.move(mut, axisY, 1);
                    }
                    mut.method_10101((class_2382)hole.start).method_10104(hole.dir, z);
                    EffectorItem.move(mut, axisY, -1);
                    EffectorItem.move(mut, axisX, 2);
                    for (i = 0; i < 3; ++i) {
                        EffectorRenderer.drawVoidFace((class_1937)w, ms, (class_4588)bb, (class_2338)mut, class_2350.method_10169((class_2350.class_2351)axisX, (class_2350.class_2352)class_2350.class_2352.field_11060));
                        EffectorItem.move(mut, axisY, 1);
                    }
                }
                ms.method_22909();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-1.0f, (float)1.0f);
                tess.method_1350();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.depthFunc((int)513);
                RenderSystem.disablePolygonOffset();
            }
        }
        finally {
            ((YttrWorld)w).yttr$setUnmask(false);
        }
    }

    private static void drawVoidCap(class_638 w, class_4587 ms, class_2338.class_2339 mut, int l, class_2350.class_2351 axisX, class_2350.class_2351 axisY, float a, class_2338 pos, class_2350 dir) {
        RenderSystem.setShader(class_757::method_34539);
        class_289 tess = class_289.method_1348();
        class_287 bb = tess.method_1349();
        ms.method_22903();
        ms.method_22904((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
        ms.method_22904((double)dir.method_10148() * -0.5, (double)dir.method_10164() * -0.5, (double)dir.method_10165() * -0.5);
        ms.method_22907(dir.method_23224());
        class_1159 mat = ms.method_23760().method_23761();
        if (a != 0.0f) {
            float s = a * 1.5f;
            if (l > 0) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)(a > 0.75f ? (1.0f - a) * 4.0f : 1.0f));
                RenderSystem.depthMask((boolean)false);
                bb.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
                bb.method_22918(mat, s, 0.0f, s).method_1344();
                bb.method_22918(mat, s, (float)l, s).method_1344();
                bb.method_22918(mat, s, (float)l, -s).method_1344();
                bb.method_22918(mat, s, 0.0f, -s).method_1344();
                bb.method_22918(mat, -s, 0.0f, -s).method_1344();
                bb.method_22918(mat, -s, (float)l, -s).method_1344();
                bb.method_22918(mat, -s, (float)l, s).method_1344();
                bb.method_22918(mat, -s, 0.0f, s).method_1344();
                bb.method_22918(mat, -s, 0.0f, s).method_1344();
                bb.method_22918(mat, -s, (float)l, s).method_1344();
                bb.method_22918(mat, s, (float)l, s).method_1344();
                bb.method_22918(mat, s, 0.0f, s).method_1344();
                bb.method_22918(mat, s, 0.0f, -s).method_1344();
                bb.method_22918(mat, s, (float)l, -s).method_1344();
                bb.method_22918(mat, -s, (float)l, -s).method_1344();
                bb.method_22918(mat, -s, 0.0f, -s).method_1344();
                tess.method_1350();
                RenderSystem.disableBlend();
                RenderSystem.depthMask((boolean)true);
            }
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
            RenderSystem.disableCull();
            bb.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
            bb.method_22918(mat, -s, 0.0f, -s).method_1344();
            bb.method_22918(mat, s, 0.0f, -s).method_1344();
            bb.method_22918(mat, s, 0.0f, s).method_1344();
            bb.method_22918(mat, -s, 0.0f, s).method_1344();
            tess.method_1350();
            RenderSystem.disablePolygonOffset();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableCull();
        }
        ms.method_22909();
        RenderSystem.setShader(class_757::method_34497);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
        bb.method_1328(class_293.class_5596.field_27382, class_1921.method_23581().method_23031());
        EffectorRenderer.mc.field_1773.method_22974().method_3316();
        Random r = new Random();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                mut.method_10101((class_2382)pos);
                EffectorItem.move(mut, axisX, x);
                EffectorItem.move(mut, axisY, y);
                mut.method_10104(dir, -1);
                int sky = w.method_8314(class_1944.field_9284, (class_2338)mut);
                int block = w.method_8314(class_1944.field_9282, (class_2338)mut);
                int light = class_765.method_23687((int)block, (int)sky);
                mut.method_10104(dir, 1);
                class_2680 state = EffectorRenderer.mc.field_1687.method_8320((class_2338)mut);
                class_1087 model = mc.method_1541().method_3349(state);
                if (model == null) continue;
                r.setSeed(state.method_26190((class_2338)mut));
                List quads = model.method_4707(state, dir.method_10153(), r);
                if (quads == null) continue;
                ms.method_22903();
                ms.method_22904((double)mut.method_10263(), (double)mut.method_10264(), (double)mut.method_10260());
                for (class_777 q : quads) {
                    int color = q.method_3360() ? mc.method_1505().method_1697(state, (class_1920)w, pos, q.method_3359()) : -1;
                    bb.method_22919(ms.method_23760(), q, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, light, class_4608.field_21444);
                }
                ms.method_22909();
            }
        }
        tess.method_1350();
        EffectorRenderer.mc.field_1773.method_22974().method_3315();
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.disableCull();
        bb.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bb.method_22918(mat, -1.5f, 0.0f, -1.5f).method_1344();
        bb.method_22918(mat, 1.5f, 0.0f, -1.5f).method_1344();
        bb.method_22918(mat, 1.5f, 0.0f, 1.5f).method_1344();
        bb.method_22918(mat, -1.5f, 0.0f, 1.5f).method_1344();
        tess.method_1350();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableCull();
    }

    private static void drawVoidFace(class_1937 w, class_4587 ms, class_4588 vc, class_2338 pos, class_2350 face) {
        YttrWorld ew = (YttrWorld)w;
        if (ew.yttr$isPhased(pos)) {
            return;
        }
        if (w.method_22347(pos.method_10093(face))) {
            return;
        }
        class_1087 model = mc.method_1541().method_3349(EffectorRenderer.mc.field_1687.method_8320(pos));
        if (model == null) {
            return;
        }
        List quads = model.method_4707(null, face, EffectorRenderer.mc.field_1687.field_9229);
        if (quads == null) {
            return;
        }
        ms.method_22903();
        ms.method_22904((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        for (class_777 q : quads) {
            vc.method_22919(ms.method_23760(), q, 0.0f, 0.0f, 0.0f, class_765.method_23687((int)0, (int)0), class_4608.field_21444);
        }
        ms.method_22909();
    }

    public static void tick() {
        Iterator<EffectorHole> iter = effectorHoles.iterator();
        while (iter.hasNext()) {
            if (iter.next().age++ <= 150) continue;
            iter.remove();
        }
    }

    public static void addHole(class_2338 pos, class_2350 dir, int length) {
        effectorHoles.add(new EffectorHole(pos, dir, length));
    }

    private static class EffectorHole {
        public final class_2338 start;
        public final class_2350 dir;
        public final int length;
        public int age;

        public EffectorHole(class_2338 start, class_2350 dir, int length) {
            this.start = start;
            this.dir = dir;
            this.length = length;
        }
    }
}

