/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.client.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.internal.UnsafeAllocator;
import com.unascribed.yttr.client.util.DummyServerWorld;
import com.unascribed.yttr.client.util.TextureColorThief;
import com.unascribed.yttr.init.YItems;
import com.unascribed.yttr.mixin.accessor.client.AccessorEntityRendererDispatcher;
import com.unascribed.yttr.util.YLog;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.class_1087;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_897;

public class SnareEntityTextureCache {
    private static final Supplier<class_1937> dummyWorld;
    private static final Cache<class_2487, class_2960> textureCache;

    public static class_2960 get(class_1799 stack) {
        class_1299<?> type = YItems.SNARE.getEntityType(stack);
        if (type == null) {
            return null;
        }
        class_2487 data = stack.method_7969().method_10562("Contents");
        if (!textureCache.asMap().containsKey(data)) {
            if (type == class_1299.field_6089) {
                class_2680 bs = class_2512.method_10681((class_2487)data.method_10562("BlockState"));
                class_1087 bm = class_310.method_1551().method_1541().method_3349(bs);
                class_2960 id = bm.method_4711().method_4598();
                textureCache.put((Object)data, (Object)new class_2960(id.method_12836(), "textures/" + id.method_12832() + ".png"));
            } else if (type == class_1299.field_6052) {
                class_1799 item = class_1799.method_7915((class_2487)data.method_10562("Item"));
                class_1087 bm = class_310.method_1551().method_1480().method_4012().method_3308(item);
                class_2960 id = bm.method_4711().method_4598();
                textureCache.put((Object)data, (Object)new class_2960(id.method_12836(), "textures/" + id.method_12832() + ".png"));
            } else {
                class_897<?> renderer = ((AccessorEntityRendererDispatcher)class_310.method_1551().method_1561()).yttr$getRenderers().get(type);
                if (renderer == null) {
                    textureCache.put((Object)data, (Object)TextureColorThief.MISSINGNO);
                } else {
                    try {
                        textureCache.put((Object)data, (Object)renderer.method_3931(YItems.SNARE.createEntity(dummyWorld.get(), stack)));
                    }
                    catch (Throwable e) {
                        YLog.debug("Failed to determine color for entity", e);
                        textureCache.put((Object)data, (Object)TextureColorThief.MISSINGNO);
                    }
                }
            }
        }
        return (class_2960)textureCache.getIfPresent((Object)data);
    }

    static {
        Supplier<class_1937> dummyWorldTemp;
        try {
            DummyServerWorld sw = (DummyServerWorld)((Object)UnsafeAllocator.create().newInstance(DummyServerWorld.class));
            sw.init();
            dummyWorldTemp = () -> sw;
        }
        catch (Exception e) {
            dummyWorldTemp = () -> class_310.method_1551().field_1687;
            YLog.warn("Failed to construct dummy ServerWorld, using client world directly. Snare color determination may be wrong for some entities!", e);
        }
        dummyWorld = dummyWorldTemp;
        textureCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build();
    }
}

