/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.client.cache;

import com.google.common.collect.Iterables;
import com.google.gson.internal.UnsafeAllocator;
import com.unascribed.yttr.client.util.UVObserver;
import com.unascribed.yttr.content.block.decor.CleavedBlockEntity;
import com.unascribed.yttr.util.math.partitioner.DEdge;
import com.unascribed.yttr.util.math.partitioner.Plane;
import com.unascribed.yttr.util.math.partitioner.Polygon;
import java.util.Random;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4696;
import net.minecraft.class_777;

public class CleavedBlockMeshes {
    private static final class_4587 IDENTITY = new class_4587();
    private static final UVObserver uvo = new UVObserver();

    public static Mesh getMesh(CleavedBlockEntity entity) {
        if (entity.clientCacheData instanceof Mesh) {
            return (Mesh)entity.clientCacheData;
        }
        if (!RendererAccess.INSTANCE.hasRenderer()) {
            return null;
        }
        class_310.method_1551().method_16011().method_15396("yttr:cleaved_modelgen");
        BlendMode bm = BlendMode.fromRenderLayer((class_1921)class_4696.method_23679((class_2680)entity.getDonor()));
        class_1087 donor = class_310.method_1551().method_1541().method_3349(entity.getDonor());
        Renderer r = RendererAccess.INSTANCE.getRenderer();
        RenderMaterial mat = r.materialFinder().blendMode(0, bm).find();
        MeshBuilder bldr = r.meshBuilder();
        QuadEmitter qe = bldr.getEmitter();
        Random rand = new Random(7L);
        class_777 firstNullQuad = (class_777)Iterables.getFirst((Iterable)donor.method_4707(entity.getDonor(), null, rand), null);
        class_1058 particle = donor.method_4711();
        for (Polygon p : entity.getPolygons()) {
            class_1058 sprite;
            Plane plane = p.plane();
            class_2350 face = CleavedBlockMeshes.findClosestFace(plane.normal());
            class_777 firstQuad = (class_777)Iterables.getFirst((Iterable)donor.method_4707(entity.getDonor(), face, rand), (Object)firstNullQuad);
            int tintIndex = -1;
            if (firstQuad == null) {
                sprite = particle;
            } else {
                uvo.reset();
                uvo.method_22919(IDENTITY.method_23760(), firstQuad, 0.0f, 0.0f, 0.0f, 0, 0);
                sprite = DummySprite.create(uvo.getMinU(), uvo.getMinV(), uvo.getMaxU(), uvo.getMaxV());
                tintIndex = firstQuad.method_3359();
            }
            if (p.nPoints() <= 2) continue;
            if (p.nPoints() == 3) {
                CleavedBlockMeshes.buildTrivial(sprite, qe, p, false);
                qe.material(mat);
                qe.colorIndex(tintIndex);
                qe.emit();
                continue;
            }
            if (p.nPoints() == 4) {
                CleavedBlockMeshes.buildTrivial(sprite, qe, p, false);
                qe.material(mat);
                qe.colorIndex(tintIndex);
                qe.emit();
                continue;
            }
            class_243 origin = p.first().srcPoint();
            int c = -1;
            for (DEdge de : p) {
                if (de == p.first()) continue;
                qe.nominalFace(face);
                qe.pos(0, (float)origin.field_1352, (float)origin.field_1351, (float)origin.field_1350);
                qe.pos(1, (float)de.srcPoint().field_1352, (float)de.srcPoint().field_1351, (float)de.srcPoint().field_1350);
                qe.pos(2, (float)de.dstPoint().field_1352, (float)de.dstPoint().field_1351, (float)de.dstPoint().field_1350);
                qe.pos(3, (float)origin.field_1352, (float)origin.field_1351, (float)origin.field_1350);
                for (int i = 0; i < 4; ++i) {
                    qe.normal(i, (float)plane.normal().field_1352, (float)plane.normal().field_1351, (float)plane.normal().field_1350);
                }
                qe.spriteBake(0, sprite, 36);
                qe.spriteColor(0, c, c, c, c);
                qe.material(mat);
                qe.colorIndex(tintIndex);
                qe.emit();
            }
        }
        Mesh mesh = bldr.build();
        class_310.method_1551().method_16011().method_15407();
        return mesh;
    }

    private static void buildTrivial(class_1058 sprite, QuadEmitter qe, Polygon p, boolean invert) {
        Plane plane = p.plane();
        class_2350 face = CleavedBlockMeshes.findClosestFace(plane.normal());
        qe.nominalFace(face);
        if (invert) {
            plane = new Plane(plane.normal().method_22882(), 0.0);
        }
        int i = invert ? 3 : 0;
        for (DEdge de : p) {
            CleavedBlockMeshes.emit(sprite, qe, plane, de, i);
            i += invert ? -1 : 1;
        }
        if (p.nPoints() == 3) {
            CleavedBlockMeshes.emit(sprite, qe, plane, p.first(), i);
        }
        qe.spriteBake(0, sprite, 36);
        int c = -1;
        qe.spriteColor(0, c, c, c, c);
    }

    private static void emit(class_1058 sprite, QuadEmitter qe, Plane plane, DEdge de, int i) {
        qe.pos(i, (float)de.srcPoint().field_1352, (float)de.srcPoint().field_1351, (float)de.srcPoint().field_1350);
        qe.normal(i, (float)plane.normal().field_1352, (float)plane.normal().field_1351, (float)plane.normal().field_1350);
    }

    private static class_2350 findClosestFace(class_243 normal) {
        return class_2350.method_10142((double)normal.field_1352, (double)normal.field_1351, (double)normal.field_1350);
    }

    private static class DummySprite
    extends class_1058 {
        private static final UnsafeAllocator UA = UnsafeAllocator.create();
        private float minU;
        private float minV;
        private float maxU;
        private float maxV;

        protected DummySprite() {
            super(null, new class_1058.class_4727(null, 0, 0, null), 0, 0, 0, 0, 0, null);
        }

        public static DummySprite create(float minU, float minV, float maxU, float maxV) {
            try {
                DummySprite ds = (DummySprite)((Object)UA.newInstance(DummySprite.class));
                ds.minU = minU;
                ds.minV = minV;
                ds.maxU = maxU;
                ds.maxV = maxV;
                return ds;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public float method_4594() {
            return this.minU;
        }

        public float method_4593() {
            return this.minV;
        }

        public float method_4577() {
            return this.maxU;
        }

        public float method_4575() {
            return this.maxV;
        }
    }
}

