/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr.client;

import com.unascribed.yttr.repackage.ibxm2.IBXM;
import com.unascribed.yttr.repackage.ibxm2.Module;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import net.minecraft.class_4234;
import org.lwjgl.BufferUtils;

public class IBXMAudioStream
implements class_4234 {
    private final IBXM ibxm;
    private final int[] mixBuf;
    private final byte[] outBuf;
    private int outIdx;
    private int outLen;
    private int remain;
    private int fadeLen;
    private final boolean stereo;

    public IBXMAudioStream(IBXM ibxm, boolean stereo) {
        this(ibxm, ibxm.calculateSongDuration() * (stereo ? 2 : 1), 0, stereo);
    }

    public IBXMAudioStream(IBXM ibxm, int duration, int fadeOutSeconds, boolean stereo) {
        this.ibxm = ibxm;
        this.mixBuf = new int[ibxm.getMixBufferLength()];
        this.outBuf = new byte[this.mixBuf.length * 2];
        int dataLen = duration * 2;
        int samplingRate = ibxm.getSampleRate();
        this.outIdx = 0;
        this.outLen = 0;
        this.remain = dataLen;
        this.fadeLen = samplingRate * 2 * fadeOutSeconds;
        this.stereo = stereo;
    }

    public static IBXMAudioStream create(InputStream in, InterpolationMode mode, boolean stereo) throws IOException {
        IBXM ibxm = new IBXM(new Module(in), 48000);
        ibxm.setInterpolation(mode.ibxm);
        return new IBXMAudioStream(ibxm, stereo);
    }

    public int getBytesRemaining() {
        return this.remain;
    }

    public ByteBuffer method_19720(int size) throws IOException {
        if (this.remain > 0) {
            ByteBuffer buf = BufferUtils.createByteBuffer((int)size);
            while (buf.position() < size && this.remain > 0) {
                int outRem;
                int count = this.remain;
                if (count > size) {
                    count = size;
                }
                if (count > (outRem = this.outLen - this.outIdx)) {
                    count = outRem;
                }
                if (count > buf.remaining()) {
                    count = buf.remaining();
                }
                buf.put(this.outBuf, this.outIdx, count);
                this.outIdx += count;
                if (this.outIdx >= this.outLen) {
                    this.getAudio();
                }
                this.remain -= count;
            }
            buf.flip();
            return buf;
        }
        return BufferUtils.createByteBuffer((int)0);
    }

    private void getAudio() {
        int mEnd = this.ibxm.getAudio(this.mixBuf) * 2;
        int gain = 768;
        if (this.remain < this.fadeLen) {
            gain = this.remain / (this.fadeLen >> 10);
            gain = gain * gain * gain >> 20;
        }
        int oIdx = 0;
        for (int mIdx = 0; mIdx < mEnd; mIdx += this.stereo ? 1 : 2) {
            int ampl1 = this.mixBuf[mIdx] * gain >> 10;
            if (this.stereo) {
                this.outBuf[oIdx++] = (byte)ampl1;
                this.outBuf[oIdx++] = (byte)(ampl1 >> 8);
                continue;
            }
            int ampl2 = this.mixBuf[mIdx + 1] * gain >> 10;
            int ampl = (ampl1 + ampl2) / 2;
            if (ampl > Short.MAX_VALUE) {
                ampl = Short.MAX_VALUE;
            }
            if (ampl < Short.MIN_VALUE) {
                ampl = Short.MIN_VALUE;
            }
            this.outBuf[oIdx++] = (byte)ampl;
            this.outBuf[oIdx++] = (byte)(ampl >> 8);
        }
        this.outIdx = 0;
        this.outLen = mEnd * (this.stereo ? 2 : 1);
    }

    public void close() throws IOException {
    }

    public AudioFormat method_19719() {
        return new AudioFormat(this.ibxm.getSampleRate(), 16, this.stereo ? 2 : 1, true, false);
    }

    public static enum InterpolationMode {
        NEAREST(0),
        LINEAR(1),
        SINC(2);

        public final int ibxm;

        private InterpolationMode(int ibxm) {
            this.ibxm = ibxm;
        }
    }
}

