/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.common.io.Resources;
import com.google.common.reflect.ClassPath;
import com.unascribed.yttr.util.YLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class YttrMixin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        List<String> mixins = YttrMixin.discoverClassesInPackage("com.unascribed.yttr.mixin", true);
        return mixins;
    }

    public static List<String> discoverClassesInPackage(String pkg, boolean truncate) {
        ArrayList rtrn = Lists.newArrayList();
        int skipped = 0;
        block2: for (ClassInfo ci : YttrMixin.getClassesInPackage(pkg)) {
            if (ci.getName().contains("$")) continue;
            try {
                ClassReader cr = new ClassReader(ci.asByteSource().read());
                ClassNode cn = new ClassNode();
                cr.accept((ClassVisitor)cn, 7);
                if (cn.invisibleAnnotations != null) {
                    for (AnnotationNode an : cn.invisibleAnnotations) {
                        if (!an.desc.equals("Lnet/fabricmc/api/Environment;") || an.values == null) continue;
                        for (int i = 0; i < an.values.size(); i += 2) {
                            EnvType e;
                            String[] arr;
                            String k = (String)an.values.get(i);
                            Object v = an.values.get(i + 1);
                            if (!"value".equals(k) || !(v instanceof String[]) || !(arr = (String[])v)[0].equals("Lnet/fabricmc/api/EnvType;") || (e = EnvType.valueOf((String)arr[1])) == FabricLoader.getInstance().getEnvironmentType()) continue;
                            YLog.debug("Skipping {} mixin {}", (Object)e, (Object)ci.getName());
                            ++skipped;
                            continue block2;
                        }
                    }
                }
                String truncName = ci.getName().substring(pkg.length() + 1);
                rtrn.add(truncate ? truncName : ci.getName());
            }
            catch (IOException e) {
                YLog.warn("Exception while trying to read {}", (Object)ci.getName(), (Object)e);
            }
        }
        YLog.info("Discovered {} classes in {} (skipped {})", rtrn.size(), pkg, skipped);
        return rtrn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Iterable<ClassInfo> getClassesInPackage(String pkg) {
        block12: {
            try {
                InputStream is;
                block13: {
                    is = YttrMixin.class.getClassLoader().getResourceAsStream("yttr-classes.txt");
                    if (is == null) break block12;
                    break block13;
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                ArrayList rtrn = Lists.newArrayList();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
                String prefix = pkg.replace('.', '/') + "/";
                while (true) {
                    String line;
                    if ((line = br.readLine()) == null) {
                        ArrayList arrayList = rtrn;
                        return arrayList;
                    }
                    if (!line.startsWith(prefix)) continue;
                    rtrn.add(new BareClassInfo(line, YttrMixin.class.getClassLoader()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            YLog.warn("Attempting to dynamically discover classes; this will only work in a development environment!");
            return Iterables.transform((Iterable)ClassPath.from((ClassLoader)YttrMixin.class.getClassLoader()).getTopLevelClassesRecursive(pkg), GuavaClassInfo::new);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static interface ClassInfo {
        public String getName();

        public ByteSource asByteSource();
    }

    private static class BareClassInfo
    implements ClassInfo {
        private final String name;
        private final ClassLoader loader;

        public BareClassInfo(String name, ClassLoader loader) {
            this.name = name;
            this.loader = loader;
        }

        @Override
        public String getName() {
            return this.name.replace('/', '.').replace(".class", "");
        }

        @Override
        public ByteSource asByteSource() {
            return Resources.asByteSource((URL)this.loader.getResource(this.name));
        }
    }

    private static class GuavaClassInfo
    implements ClassInfo {
        private final ClassPath.ClassInfo delegate;

        public GuavaClassInfo(ClassPath.ClassInfo delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public ByteSource asByteSource() {
            return this.delegate.asByteSource();
        }
    }
}

