/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr;

import com.google.common.base.Ascii;
import com.google.common.collect.EnumMultiset;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.unascribed.yttr.DelayedTask;
import com.unascribed.yttr.Substitutes;
import com.unascribed.yttr.YConfig;
import com.unascribed.yttr.compat.trinkets.YttrTrinketsCompat;
import com.unascribed.yttr.content.item.SuitArmorItem;
import com.unascribed.yttr.init.YBiomes;
import com.unascribed.yttr.init.YBlockEntities;
import com.unascribed.yttr.init.YBlocks;
import com.unascribed.yttr.init.YBrewing;
import com.unascribed.yttr.init.YCommands;
import com.unascribed.yttr.init.YCriteria;
import com.unascribed.yttr.init.YEnchantments;
import com.unascribed.yttr.init.YEntities;
import com.unascribed.yttr.init.YFluids;
import com.unascribed.yttr.init.YFuels;
import com.unascribed.yttr.init.YHandledScreens;
import com.unascribed.yttr.init.YItemGroups;
import com.unascribed.yttr.init.YItems;
import com.unascribed.yttr.init.YLatches;
import com.unascribed.yttr.init.YNetwork;
import com.unascribed.yttr.init.YRecipeSerializers;
import com.unascribed.yttr.init.YRecipeTypes;
import com.unascribed.yttr.init.YSounds;
import com.unascribed.yttr.init.YStats;
import com.unascribed.yttr.init.YStatusEffects;
import com.unascribed.yttr.init.YTags;
import com.unascribed.yttr.init.YTrades;
import com.unascribed.yttr.init.YWorldGen;
import com.unascribed.yttr.init.conditional.YTrinkets;
import com.unascribed.yttr.inred.InRedLogic;
import com.unascribed.yttr.mechanics.SoakingHandler;
import com.unascribed.yttr.mechanics.SuitResource;
import com.unascribed.yttr.mechanics.TickAlwaysItemHandler;
import com.unascribed.yttr.mixinsupport.Blameable;
import com.unascribed.yttr.mixinsupport.DiverPlayer;
import com.unascribed.yttr.mixinsupport.ParticleScreen;
import com.unascribed.yttr.network.MessageS2CDiscoveredGeyser;
import com.unascribed.yttr.network.MessageS2CDive;
import com.unascribed.yttr.util.EquipmentSlots;
import com.unascribed.yttr.util.LatchHolder;
import com.unascribed.yttr.util.SlotReference;
import com.unascribed.yttr.util.YLog;
import com.unascribed.yttr.util.annotate.RegisteredAs;
import com.unascribed.yttr.world.FilterNetworks;
import com.unascribed.yttr.world.Geyser;
import com.unascribed.yttr.world.GeysersState;
import com.unascribed.yttr.world.ScorchedGenerator;
import com.unascribed.yttr.world.WastelandPopulator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2891;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3738;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class Yttr
implements ModInitializer {
    public static Yttr INST;
    public static final int DIVING_BLOCKS_PER_TICK = 2;
    public static final Map<class_2960, class_3414> craftingSounds;
    public static final Multimap<class_2960, class_2960> discoveries;
    public static boolean lessCreepyAwareHopper;
    public static boolean vectorSuit;
    public static final List<DelayedTask> delayedServerTasks;
    public static TrinketsAccess trinketsAccess;
    public static EarsAccess earsAccess;
    private static final boolean debugRegistration;

    public Yttr() {
        if (INST != null) {
            throw new AssertionError((Object)"Double initialized!");
        }
        INST = this;
    }

    public void onInitialize() {
        YBlocks.init();
        YBlockEntities.init();
        YItems.init();
        YSounds.init();
        YFluids.init();
        YEntities.init();
        YWorldGen.init();
        YBiomes.init();
        YStatusEffects.init();
        YRecipeTypes.init();
        YRecipeSerializers.init();
        YCommands.init();
        YTags.init();
        YHandledScreens.init();
        YEnchantments.init();
        YStats.init();
        YCriteria.init();
        YBrewing.init();
        YTrades.init();
        YNetwork.init();
        YFuels.init();
        if (FabricLoader.getInstance().isModLoaded("trinkets")) {
            try {
                YttrTrinketsCompat.init();
                YTrinkets.init();
            }
            catch (Throwable t) {
                YLog.warn("Failed to load Trinkets compat", t);
            }
        }
        YItemGroups.init();
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, entity) -> {
            if (player instanceof class_3222) {
                YCriteria.BROKE_BLOCK.trigger((class_3222)player, pos, state, player.method_5998(class_1268.field_5808));
            }
        });
        ServerTickEvents.START_WORLD_TICK.register(world -> {
            TickAlwaysItemHandler.startServerWorldTick(world);
            SoakingHandler.startServerWorldTick(world);
            FilterNetworks.get(world).tick();
        });
        ServerTickEvents.END_WORLD_TICK.register(SoakingHandler::endServerWorldTick);
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            InRedLogic.onServerTick();
            Iterator<DelayedTask> iter = delayedServerTasks.iterator();
            int tasksRunThisTick = 0;
            while (iter.hasNext()) {
                DelayedTask dt = iter.next();
                if (tasksRunThisTick > 10 && !dt.important || dt.delay-- > 0) continue;
                dt.r.run();
                ++tasksRunThisTick;
                iter.remove();
            }
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(Substitutes.RELOADER);
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((server, mgr) -> discoveries.clear());
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (WastelandPopulator.isEligible(world, chunk)) {
                world.method_8503().method_18858((Runnable)new class_3738(world.method_8503().method_3780(), () -> WastelandPopulator.populate(world.method_8412(), world, chunk.method_12004())));
            }
            if (ScorchedGenerator.isEligibleForRetrogen(world, chunk)) {
                world.method_8503().method_18858((Runnable)new class_3738(world.method_8503().method_3780(), () -> ScorchedGenerator.retrogen(world.method_8412(), world, chunk.method_12004())));
            }
        });
    }

    public void onPostInitialize() {
        if (YConfig.General.fixupDebugWorld) {
            List states = class_2891.field_13163;
            HashSet known = Sets.newHashSet((Iterable)states);
            List newStates = class_2378.field_11146.method_10220().flatMap(b -> b.method_9595().method_11662().stream()).filter(bs -> !known.contains(bs)).collect(Collectors.toList());
            if (newStates.isEmpty()) {
                YLog.info("Looks like someone else already fixed the debug world.", (Object)newStates.size());
            } else {
                YLog.info("Adding {} missing blockstates to the debug world.", (Object)newStates.size());
                states.addAll(newStates);
                int oldX = class_2891.field_13161;
                int oldZ = class_2891.field_13160;
                class_2891.field_13161 = class_3532.method_15386((float)class_3532.method_15355((float)states.size()));
                class_2891.field_13160 = class_3532.method_15386((float)((float)states.size() / (float)class_2891.field_13161));
                YLog.info("Ok. Your debug world is now {}x{} instead of {}x{}.", class_2891.field_13161, class_2891.field_13160, oldX, oldZ);
            }
        }
        YLatches.latchAll();
    }

    public static class_2960 id(String path) {
        return new class_2960("yttr", path);
    }

    public static Multiset<SuitResource> determineAvailableResources(class_1657 player) {
        class_1799 is = player.method_6118(class_1304.field_6174);
        if (!(is.method_7909() instanceof SuitArmorItem)) {
            return ImmutableMultiset.of();
        }
        SuitArmorItem sai = (SuitArmorItem)is.method_7909();
        EnumMultiset resourcesAvailable = EnumMultiset.create(SuitResource.class);
        for (SuitResource sr : SuitResource.VALUES) {
            resourcesAvailable.add((Object)sr, sai.getResourceAmount(is, sr));
        }
        return resourcesAvailable;
    }

    public static Multiset<SuitResource> determineNeededResourcesForFastDive(double distance) {
        int simulatedTicks = (int)(distance / 2.0);
        int distanceI = (int)distance;
        EnumMultiset resourcesNeeded = EnumMultiset.create(SuitResource.class);
        for (SuitResource sr : SuitResource.VALUES) {
            if (distance < 4.0 && sr == SuitResource.FUEL) continue;
            resourcesNeeded.add((Object)sr, sr.getConsumptionPerTick(900) * simulatedTicks);
            resourcesNeeded.add((Object)sr, sr.getConsumptionPerBlock(900) * distanceI);
        }
        return resourcesNeeded;
    }

    public static <T, A extends Annotation> void eachRegisterableField(Class<?> holder, Class<T> type, Class<A> anno, TriConsumer<Field, T, A> cb) {
        for (Field f : holder.getDeclaredFields()) {
            if (!type.isAssignableFrom(f.getType()) || !Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers())) continue;
            try {
                f.setAccessible(true);
                cb.accept((Object)f, f.get(null), anno == null ? null : f.getAnnotation(anno));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <T> void autoRegister(class_2378<T> registry, Class<?> holder, Class<? super T> type) {
        Yttr.eachRegisterableField(holder, type, RegisteredAs.class, (f, v, ann) -> {
            class_2960 id = Yttr.deriveId(f, ann);
            try {
                class_2378.method_10230((class_2378)registry, (class_2960)id, (Object)v);
                if (debugRegistration) {
                    YLog.info("Registered {} in {} from {} - assigned id is {}", id, registry.method_30517().method_29177(), f.getName(), registry.method_10206(v));
                }
            }
            catch (RuntimeException e) {
                Object val = registry.method_10223(id);
                int rid = registry.method_10206(val);
                val = registry.method_10200(rid);
                YLog.error("Could not register {} in {} from {} - current registration: {} {} {} - we wanted to register {}", id, registry.method_30517().method_29177(), f.getName(), rid, registry.method_10221(val), Yttr.describe(val), Yttr.describe(v), e);
                if (val instanceof Blameable) {
                    Blameable b = (Blameable)val;
                    if (b.yttr$getConstructionBlame() != null) {
                        YLog.error("The interloper's registration stack trace is:", b.yttr$getConstructionBlame());
                    } else {
                        YLog.error("Add -Dyttr.debugRegistration=true to your JVM arguments for more information.");
                    }
                } else {
                    YLog.error("Blame data is not available for this registry, regardless of the value of -Dyttr.debugRegistration - sorry.");
                }
                YLog.error("Dazed and confused, but trying to continue...");
            }
            try {
                Field holderField = holder.getDeclaredField(f.getName() + "_HOLDER");
                if (holderField.getType() == LatchHolder.class && Modifier.isStatic(holderField.getModifiers()) && !Modifier.isTransient(holderField.getModifiers())) {
                    ((LatchHolder)holderField.get(null)).set(registry.method_40268(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)id)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private static String describe(Object val) {
        String identity = Integer.toHexString(System.identityHashCode(val));
        if (val instanceof class_3414) {
            class_3414 se = (class_3414)val;
            return "SoundEvent[" + se.method_14833() + "]@" + identity;
        }
        String str = String.valueOf(val);
        if (str.contains(identity)) {
            return str;
        }
        return str + "@" + identity;
    }

    public static <T> void autoRegister(Consumer<T> adhocRegistry, Class<?> holder, Class<T> type) {
        Yttr.eachRegisterableField(holder, type, null, (f, v, na) -> adhocRegistry.accept(v));
    }

    public static <T> void autoRegister(BiConsumer<class_2960, T> registry, Class<?> holder, Class<T> type) {
        Yttr.eachRegisterableField(holder, type, RegisteredAs.class, (f, v, ann) -> registry.accept(Yttr.deriveId(f, ann), v));
    }

    private static class_2960 deriveId(Field f, RegisteredAs ann) {
        class_2960 id = ann != null ? (ann.value().contains(":") ? new class_2960(ann.value()) : Yttr.id(ann.value())) : Yttr.id(Ascii.toLowerCase((String)f.getName()));
        return id;
    }

    public static class_2499 serializeInv(class_1263 inv) {
        class_2499 out = new class_2499();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 is = inv.method_5438(i);
            if (is.method_7960()) continue;
            class_2487 c = is.method_7953(new class_2487());
            if (is.method_7947() > 127) {
                c.method_10569("Count", is.method_7947());
            }
            c.method_10569("Slot", i);
            out.add((Object)c);
        }
        return out;
    }

    public static void deserializeInv(class_2499 tag, class_1263 inv) {
        inv.method_5448();
        for (int i = 0; i < tag.size(); ++i) {
            class_2487 c = tag.method_10602(i);
            int count = c.method_10550("Count");
            if (count > 127) {
                c = c.method_10553();
                c.method_10569("Count", 1);
            }
            class_1799 is = class_1799.method_7915((class_2487)c);
            is.method_7939(count);
            inv.method_5447(c.method_10550("Slot"), is);
        }
    }

    public static void sync(class_2586 be) {
        if (!be.method_11002()) {
            return;
        }
        if (be.method_10997().field_9236) {
            return;
        }
        be.method_10997().method_8413(be.method_11016(), class_2246.field_10124.method_9564(), be.method_11010(), 3);
    }

    public static void spawnGuiParticles(class_2394 particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            for (int i = 0; i < count; ++i) {
                double xo = r.nextGaussian() * deltaX;
                double yo = r.nextGaussian() * deltaY;
                double zo = r.nextGaussian() * deltaZ;
                double vx = r.nextGaussian() * speed;
                double vy = r.nextGaussian() * speed;
                double vz = r.nextGaussian() * speed;
                Yttr.spawnGuiParticle(particle, x + xo, y + yo, z + zo, vx, vy, vz);
            }
        }
    }

    public static void spawnGuiParticle(class_2394 parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            Yttr.spawnGuiParticleClient(parameters, x, y, z, velocityX, velocityY, velocityZ);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void spawnGuiParticleClient(class_2394 parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof ParticleScreen) {
            ParticleScreen ps = (ParticleScreen)class_4372;
            ps.yttr$getParticleWorld().method_8406(parameters, x, y, z, velocityX, velocityY, velocityZ);
        }
    }

    public static boolean isWearingFullSuit(class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return false;
        }
        class_1309 le = (class_1309)entity;
        for (class_1304 slot : EquipmentSlots.ARMOR) {
            if (le.method_6118(slot).method_7909() instanceof SuitArmorItem) continue;
            return false;
        }
        return true;
    }

    public static boolean isStandingOnDivingPlate(class_1297 e) {
        return e.method_24828() && e.field_6002.method_8320(e.method_24515().method_10074()).method_27852((class_2248)YBlocks.DIVING_PLATE);
    }

    public static void syncDive(class_3222 p) {
        if (!(p instanceof DiverPlayer)) {
            return;
        }
        GeysersState gs = GeysersState.get(p.method_14220());
        List<Geyser> geysers = ((DiverPlayer)p).yttr$getKnownGeysers().stream().map(gs::getGeyser).filter(g -> g != null).collect(Collectors.toList());
        new MessageS2CDive((int)p.method_19538().field_1352, (int)p.method_19538().field_1350, geysers).sendTo((class_1657)p);
    }

    public static void discoverGeyser(UUID id, class_3222 player) {
        if (!(player instanceof DiverPlayer)) {
            return;
        }
        DiverPlayer diver = (DiverPlayer)player;
        Set<UUID> knownGeysers = diver.yttr$getKnownGeysers();
        if (!knownGeysers.contains(id)) {
            Geyser g = GeysersState.get(player.method_14220()).getGeyser(id);
            if (g == null) {
                return;
            }
            knownGeysers.add(id);
            new MessageS2CDiscoveredGeyser(g).sendTo((class_1657)player);
        }
    }

    public static int calculatePressure(class_3218 world, int x, int z) {
        GeysersState gs = GeysersState.get(world);
        int absoluteMin = 100;
        int minPressure = 120;
        int maxPressure = 1000;
        int pressureGap = maxPressure - minPressure;
        int maxPressureGap = pressureGap + (minPressure - absoluteMin);
        int pressureEffect = 0;
        int falloff = 768;
        int falloffSq = falloff * falloff;
        for (Geyser g : gs.getGeysersInRange(x, z, falloff)) {
            double distSq = g.pos.method_40081((double)x, (double)g.pos.method_10264(), (double)z);
            if (!(distSq < (double)falloffSq)) continue;
            double effect = ((double)falloffSq - distSq) / (double)falloffSq;
            pressureEffect = (int)((double)pressureEffect + (double)pressureGap * effect);
        }
        return maxPressure - Math.min(maxPressureGap, pressureEffect);
    }

    public static List<class_1799> asList(class_1263 inv) {
        return Yttr.asListExcluding(inv, -1);
    }

    public static List<class_1799> asListExcluding(final class_1263 inv, final int exclude) {
        return new AbstractList<class_1799>(){

            @Override
            public class_1799 get(int index) {
                return index == exclude ? class_1799.field_8037 : inv.method_5438(index);
            }

            @Override
            public int size() {
                return inv.method_5439();
            }

            @Override
            public class_1799 remove(int index) {
                if (index == exclude) {
                    return class_1799.field_8037;
                }
                return inv.method_5441(index);
            }

            @Override
            public void clear() {
                inv.method_5448();
            }

            @Override
            public class_1799 set(int index, class_1799 element) {
                if (index == exclude) {
                    return class_1799.field_8037;
                }
                class_1799 old = inv.method_5438(index);
                inv.method_5447(index, element);
                return old;
            }
        };
    }

    public static int getSpringingLevel(class_1657 p) {
        return trinketsAccess.count(p, is -> class_1890.method_8225((class_1887)((class_1887)YEnchantments.SPRINGING.get()), (class_1799)is));
    }

    public static Optional<SlotReference> getWornCoil(class_1657 e) {
        return trinketsAccess.getWorn(e, YItems.CUPROSTEEL_COIL::is);
    }

    @Nullable
    public static SlotReference scanInventory(class_1263 inv, Predicate<class_1799> predicate) {
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 is = inv.method_5438(i);
            if (!predicate.test(is)) continue;
            return new SlotReference(inv, i);
        }
        return null;
    }

    static {
        craftingSounds = Maps.newHashMap();
        discoveries = HashMultimap.create();
        delayedServerTasks = Lists.newArrayList();
        trinketsAccess = new TrinketsAccess(){

            @Override
            public Optional<SlotReference> getWorn(class_1657 pe, Predicate<class_1792> predicate) {
                return Optional.empty();
            }

            @Override
            public int count(class_1657 pe, ToIntFunction<class_1799> func) {
                return 0;
            }

            @Override
            public void dropMagneticTrinkets(class_1657 pe) {
            }
        };
        earsAccess = new EarsAccess(){

            @Override
            public boolean isVisuallyWearingBoots(class_1657 pe) {
                return !pe.method_6118(class_1304.field_6166).method_7960();
            }

            @Override
            public float getChestSize(class_1657 pe) {
                return 0.0f;
            }
        };
        debugRegistration = Boolean.getBoolean("yttr.debugRegistration");
    }

    public static interface TrinketsAccess {
        public Optional<SlotReference> getWorn(class_1657 var1, Predicate<class_1792> var2);

        public int count(class_1657 var1, ToIntFunction<class_1799> var2);

        public void dropMagneticTrinkets(class_1657 var1);
    }

    public static interface EarsAccess {
        public boolean isVisuallyWearingBoots(class_1657 var1);

        public float getChestSize(class_1657 var1);
    }
}

