/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr;

import com.google.common.base.Ascii;
import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.unascribed.yttr.mechanics.LampColor;
import com.unascribed.yttr.util.QDCSS;
import com.unascribed.yttr.util.YLog;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class YConfig {
    public static final QDCSS defaults;
    public static QDCSS data;
    private static final List<Class<?>> sections;
    private static final Map<String, Class<?>> keyTypes;

    public static Class<?> getKeyType(String key) {
        return keyTypes.getOrDefault(key, Void.TYPE);
    }

    public static void copyFieldsToData() {
        for (Class<?> section : sections) {
            for (Field f : section.getFields()) {
                Key k;
                if (!Modifier.isStatic(f.getModifiers()) || (k = f.getAnnotation(Key.class)) == null) continue;
                try {
                    if (f.getType() == Boolean.TYPE) {
                        data.put(k.value(), f.getBoolean(null) ? "on" : "off");
                        continue;
                    }
                    if (!f.getType().isEnum()) continue;
                    data.put(k.value(), Ascii.toLowerCase((String)((Enum)f.get(null)).name()));
                }
                catch (Exception e) {
                    YLog.error("Could not serialize config", e);
                }
            }
        }
    }

    public static void copyDataToFields() {
        for (Class<?> section : sections) {
            for (Field f : section.getFields()) {
                Key k;
                if (!Modifier.isStatic(f.getModifiers()) || (k = f.getAnnotation(Key.class)) == null) continue;
                try {
                    keyTypes.put(k.value(), f.getType());
                    if (f.getType() == Boolean.TYPE) {
                        f.set(null, data.getBoolean(k.value()).get());
                        continue;
                    }
                    if (!f.getType().isEnum()) continue;
                    f.set(null, data.getEnum(k.value(), f.getType()).get());
                }
                catch (Exception e) {
                    YLog.error("Could not memoize config", e);
                }
            }
        }
    }

    public static void load() {
        File cfg = new File("config/yttr.css");
        if (!cfg.exists()) {
            data = defaults.copy();
            YConfig.save();
        } else {
            QDCSS dataTmp;
            try {
                dataTmp = QDCSS.load(cfg);
            }
            catch (IOException e) {
                YLog.error("IO error when reading configuration. Using defaults", e);
                dataTmp = defaults;
            }
            catch (QDCSS.SyntaxErrorException e) {
                YLog.error("Syntax error in configuration: {}. Using defaults", (Object)e.getMessage());
                dataTmp = defaults;
            }
            data = defaults.merge(dataTmp);
        }
        YConfig.copyDataToFields();
    }

    public static void save() {
        YConfig.copyFieldsToData();
        URL templateUrl = YConfig.class.getResource("/yttr-template.css");
        File cfg = new File("config/yttr.css");
        try {
            Files.createParentDirs((File)cfg);
            String s = Resources.asCharSource((URL)templateUrl, (Charset)Charsets.UTF_8).read();
            for (Map.Entry<String, String> en : data.flatten().entrySet()) {
                s = s.replace("var(" + en.getKey() + ")", en.getValue());
            }
            Files.asCharSink((File)cfg, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)s);
        }
        catch (IOException e) {
            YLog.error("IO error when copying default configuration", e);
        }
    }

    static void touch() {
    }

    static {
        sections = List.of(General.class, Client.class, Rifle.class, Enchantments.class, WorldGen.class, Debug.class);
        keyTypes = new HashMap();
        URL defaultsUrl = YConfig.class.getResource("/yttr-default.css");
        try {
            defaults = QDCSS.load(defaultsUrl);
        }
        catch (IOException e) {
            throw new Error("Could not load config defaults", e);
        }
        YConfig.load();
        YConfig.save();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Key {
        public String value();
    }

    public static final class General {
        @Key(value="general.trust-players")
        public static boolean trustPlayers = false;
        @Key(value="general.fixup-debug-world")
        public static boolean fixupDebugWorld = true;
        @Key(value="general.shenanigans")
        public static boolean shenanigans = true;
        @Key(value="general.convert-void-holes")
        public static boolean convertVoidHoles = true;

        private General() {
        }

        static {
            YConfig.touch();
        }
    }

    public static final class Client {
        @Key(value="client.slope-smoothing")
        public static boolean slopeSmoothing = true;
        @Key(value="client.force-opengl-core")
        public static Trilean forceOpenGLCore = Trilean.AUTO;
        @Key(value="client.config-color")
        public static LampColor configColor = LampColor.TEAL;
        @Key(value="client.shrink-debug-hud")
        public static boolean shrinkDebugHud = true;
        @Key(value="client.control-hints")
        public static boolean controlHints = true;

        private Client() {
        }

        static {
            YConfig.touch();
        }
    }

    public static final class Rifle {
        @Key(value="rifle.allow-void")
        public static boolean allowVoid = true;
        @Key(value="rifle.allow-explode")
        public static TrileanSoft allowExplode = TrileanSoft.ON;
        @Key(value="rifle.allow-fire")
        public static boolean allowFire = true;
        @Key(value="rifle.timing-assist")
        public static boolean timingAssist = true;

        private Rifle() {
        }

        static {
            YConfig.touch();
        }
    }

    public static final class Enchantments {
        @Key(value="enchantments.vorpal")
        public static boolean vorpal = true;
        @Key(value="enchantments.disjunction")
        public static boolean disjunction = true;
        @Key(value="enchantments.annihilation")
        public static boolean annihilation = true;
        @Key(value="enchantments.shattering")
        public static boolean shattering = true;
        @Key(value="enchantments.springing")
        public static boolean springing = true;
        @Key(value="enchantments.stabilization")
        public static boolean stabilization = true;
        @Key(value="enchantments.curses-in-table")
        public static boolean cursesInTable = true;

        private Enchantments() {
        }

        static {
            YConfig.touch();
        }
    }

    public static final class WorldGen {
        @Key(value="worldgen.gadolinite")
        public static boolean gadolinite = true;
        @Key(value="worldgen.brookite")
        public static boolean brookite = true;
        @Key(value="worldgen.squeeze-trees")
        public static boolean squeezeTrees = true;
        @Key(value="worldgen.wasteland")
        public static boolean wasteland = true;
        @Key(value="worldgen.core-lava")
        public static boolean coreLava = true;
        @Key(value="worldgen.scorched")
        public static boolean scorched = true;
        @Key(value="worldgen.continuity")
        public static boolean continuity = true;
        @Key(value="worldgen.scorched-retrogen")
        public static boolean scorchedRetrogen = true;

        private WorldGen() {
        }

        static {
            YConfig.touch();
        }
    }

    public static final class Debug {
        private Debug() {
        }

        static {
            YConfig.touch();
        }
    }

    public static enum TrileanSoft {
        ON,
        SOFT,
        OFF;

    }

    public static enum Trilean {
        AUTO,
        ON,
        OFF;


        public boolean resolve(boolean def) {
            if (this == AUTO) {
                return def;
            }
            return this == ON;
        }
    }
}

