/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.yttr;

import com.google.common.base.Charsets;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.unascribed.yttr.Yttr;
import com.unascribed.yttr.util.YLog;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.jetbrains.annotations.Nullable;

public class Substitutes
extends class_4080<BiMap<class_1792, class_1792>>
implements IdentifiableResourceReloadListener {
    public static final IdentifiableResourceReloadListener RELOADER = new Substitutes();
    private static final Gson gson = new Gson();
    private static final BiMap<class_1792, class_1792> MAP = HashBiMap.create();

    private Substitutes() {
    }

    public class_2960 getFabricId() {
        return Yttr.id("substitutes");
    }

    protected BiMap<class_1792, class_1792> prepare(class_3300 mgr, class_3695 profiler) {
        HashBiMap map = HashBiMap.create();
        for (String ns : mgr.method_14487()) {
            class_2960 id = new class_2960(ns, "yttr_substitutes.json");
            if (!mgr.method_18234(id)) continue;
            try {
                class_3298 r = mgr.method_14486(id);
                try (InputStreamReader isr = new InputStreamReader(r.method_14482(), Charsets.UTF_8);){
                    JsonObject obj = (JsonObject)gson.fromJson((Reader)isr, JsonObject.class);
                    for (Map.Entry en : obj.entrySet()) {
                        class_2960 kId;
                        Optional kI;
                        String k = (String)en.getKey();
                        boolean optionalK = false;
                        if (k.endsWith("?")) {
                            k = k.substring(0, k.length() - 1);
                            optionalK = true;
                        }
                        if ((kI = class_2378.field_11142.method_17966(kId = new class_2960(k))).isPresent()) {
                            class_2960 vId;
                            Optional vI;
                            String v = ((JsonElement)en.getValue()).getAsString();
                            boolean optionalV = false;
                            if (v.endsWith("?")) {
                                v = v.substring(0, v.length() - 1);
                                optionalV = true;
                            }
                            if ((vI = class_2378.field_11142.method_17966(vId = new class_2960(v))).isPresent()) {
                                if (map.containsKey(kI.get())) {
                                    if (optionalK) continue;
                                    YLog.warn("While loading " + id + " substitute " + kId + " to prime " + vId + ", a mapping already exists for this substitute to prime " + class_2378.field_11142.method_10221((Object)((class_1792)map.get(kI.get()))) + " - ignoring this mapping. Add a ? to make it optional and silence this warning.");
                                    continue;
                                }
                                if (map.containsValue(vI.get())) {
                                    if (optionalV) continue;
                                    YLog.warn("While loading " + id + " substitute " + kId + " to prime " + vId + ", a mapping already exists for this prime to substitute " + class_2378.field_11142.method_10221((Object)((class_1792)map.inverse().get(vI.get()))) + " - ignoring this mapping. Add a ? to make it optional and silence this warning.");
                                    continue;
                                }
                                map.put((Object)((class_1792)kI.get()), (Object)((class_1792)vI.get()));
                                continue;
                            }
                            if (optionalV) continue;
                            YLog.warn("While loading " + id + " substitute " + kId + ", could not find item with ID " + vId + " for prime (add a ? to make it optional and silence this warning)");
                            continue;
                        }
                        if (optionalK) continue;
                        YLog.warn("While loading " + id + ", could not find item with ID " + kId + " for substitute (add a ? to make it optional and silence this warning)");
                    }
                }
            }
            catch (Throwable e) {
                YLog.error("Failed to load " + id, e);
            }
        }
        YLog.info("Loaded " + map.size() + " substitution" + (map.size() == 1 ? "" : "s"));
        return map;
    }

    protected void apply(BiMap<class_1792, class_1792> prepared, class_3300 manager, class_3695 profiler) {
        MAP.clear();
        MAP.putAll(prepared);
    }

    public static Set<class_1792> allPrimes() {
        return MAP.inverse().keySet();
    }

    public static Set<class_1792> allSubstitutes() {
        return MAP.keySet();
    }

    @Nullable
    public static class_1792 getPrime(class_1792 substitute) {
        return (class_1792)MAP.get((Object)substitute);
    }

    @Nullable
    public static class_1792 getSubstitute(class_1792 prime) {
        return (class_1792)MAP.inverse().get((Object)prime);
    }

    public static class_1799 sub(class_1799 stack) {
        return Substitutes.copyWithAltItem(stack, Substitutes.getSubstitute(stack.method_7909()));
    }

    public static class_1799 prime(class_1799 stack) {
        return Substitutes.copyWithAltItem(stack, Substitutes.getPrime(stack.method_7909()));
    }

    private static class_1799 copyWithAltItem(class_1799 stack, class_1792 item) {
        if (item == null) {
            return stack.method_7972();
        }
        class_1799 copy = new class_1799((class_1935)item);
        copy.method_7939(stack.method_7947());
        copy.method_7980(stack.method_7969());
        return copy;
    }
}

