/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.mysticaloaktree.block;

import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.mysticaloaktree.MysticalOakTree;
import net.mehvahdjukaar.mysticaloaktree.block.WiseOakTile;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5714;
import net.minecraft.class_5945;
import org.jetbrains.annotations.Nullable;

public class WiseOakBlock
extends class_2383
implements class_2343 {
    public static final class_2754<State> STATE = class_2754.method_11850((String)"state", State.class);
    private static final List<class_2338> KNOWLEDGE_PARTICLE_POS = class_2338.method_17962((int)-2, (int)-2, (int)-2, (int)2, (int)1, (int)2).filter(blockPos -> Math.abs(blockPos.method_10263()) == 2 || Math.abs(blockPos.method_10260()) == 2).map(class_2338::method_10062).toList();
    private static final List<class_2338> DESTROY_PARTICLE_POS = class_2338.method_17962((int)-3, (int)-3, (int)-2, (int)3, (int)2, (int)3).filter(blockPos -> {
        double l = class_243.method_24953((class_2382)blockPos).method_1033();
        return l > 2.5 && l < 3.5;
    }).map(class_2338::method_10062).toList();

    public WiseOakBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657(STATE, (Comparable)((Object)State.NONE)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{STATE, field_11177});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new WiseOakTile(pos, state);
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, Random random) {
        super.method_9588(state, level, pos, random);
        State s = (State)((Object)state.method_11654(STATE));
        if (s.isBlinking()) {
            level.method_8652(pos, (class_2680)state.method_11657(STATE, (Comparable)((Object)State.getNonBlinking(s))), 3);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof WiseOakTile) {
            WiseOakTile tile = (WiseOakTile)class_25862;
            return tile.onInteract(state, level, pos, player, hand);
        }
        return class_1269.field_5811;
    }

    public void method_9606(class_2680 state, class_1937 level, class_2338 pos, class_1657 player) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof WiseOakTile) {
            WiseOakTile tile = (WiseOakTile)class_25862;
            tile.onAttack(state, level, pos, player);
        }
        super.method_9606(state, level, pos, player);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)super.method_9605(context).method_11657((class_2769)field_11177, (Comparable)context.method_8042().method_10153());
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 pLevel, class_2680 pState, class_2591<T> pBlockEntityType) {
        return WiseOakBlock.getTicker(pBlockEntityType, MysticalOakTree.TILE.get(), WiseOakTile::tick);
    }

    @javax.annotation.Nullable
    public static <E extends class_2586, A extends class_2586> class_5558<A> getTicker(class_2591<A> type, class_2591<E> targetType, class_5558<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    @Nullable
    public <T extends class_2586> class_5714 method_32896(class_1937 level, T blockEntity) {
        return super.method_32896(level, blockEntity);
    }

    public boolean method_9592(class_2680 state, class_1937 level, class_2338 pos, int id, int param) {
        if (id == 1) {
            if (level.field_9236) {
                for (class_2350 d : class_2350.class_2353.field_11062) {
                    class_5945.method_34681((class_1937)level, (class_2338)pos, (class_2350)d, (class_2394)class_2398.field_11231);
                }
            }
            return true;
        }
        return super.method_9592(state, level, pos, id, param);
    }

    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, Random random) {
        super.method_9496(state, level, pos, random);
        if (state.method_11654(STATE) == State.SLEEPING && random.nextInt(14) == 0) {
            class_2338 targetPos = KNOWLEDGE_PARTICLE_POS.get(level.field_9229.nextInt(KNOWLEDGE_PARTICLE_POS.size()));
            WiseOakBlock.spawnEnchantParticle(level, pos.method_10084(), random, targetPos);
        }
    }

    private static void spawnEnchantParticle(class_1937 level, class_2338 pos, Random random, class_2338 targetPos) {
        level.method_8406((class_2394)class_2398.field_11215, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (double)((float)targetPos.method_10263() + random.nextFloat()) - 0.5, (double)((float)targetPos.method_10264() + random.nextFloat()) - 0.5, (double)((float)targetPos.method_10260() + random.nextFloat()) - 0.5);
    }

    protected void method_33614(class_1937 level, class_1657 player, class_2338 pos, class_2680 state) {
        super.method_33614(level, player, pos, state);
        if (!class_1890.method_8222((class_1799)player.method_5998(player.method_6058())).containsKey(class_1893.field_9099)) {
            for (int i = 0; i < 30; ++i) {
                class_2338 targetPos = DESTROY_PARTICLE_POS.get(level.field_9229.nextInt(DESTROY_PARTICLE_POS.size()));
                WiseOakBlock.spawnEnchantParticle(level, pos.method_10081((class_2382)targetPos), level.field_9229, targetPos.method_35830(-1));
            }
        }
    }

    public static enum State implements class_3542
    {
        NONE("none"),
        BLINKING("blinking"),
        SLEEPING("sleeping"),
        ANGRY("angry"),
        ANGRY_BLINKING("angry_blinking"),
        BLOWING("blowing"),
        THICC("thicc");

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public boolean canBlink() {
            return this == NONE || this == ANGRY;
        }

        public boolean isBlinking() {
            return this == BLINKING || this == ANGRY_BLINKING;
        }

        public static State getBlinking(State s) {
            if (s == ANGRY || s == BLOWING || s == THICC) {
                return ANGRY_BLINKING;
            }
            return BLINKING;
        }

        public static State getNonBlinking(State s) {
            if (s == ANGRY_BLINKING) {
                return ANGRY;
            }
            return NONE;
        }

        public boolean canSleep() {
            return this == NONE || this == BLINKING;
        }

        public boolean isAngry() {
            return this == ANGRY || this == ANGRY_BLINKING;
        }

        public boolean isBlowing() {
            return this == BLOWING || this == THICC;
        }
    }
}

