/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight3.api.platform.fabric;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.mehvahdjukaar.moonlight3.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight3.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight3.api.platform.fabric.RegistryQueue;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_5458;

public class RegHelperImpl {
    public static final Map<class_2378<?>, Map<String, RegistryQueue<?>>> REGISTRIES = new LinkedHashMap();
    private static final List<Consumer<RegHelper.AttributeEvent>> ATTRIBUTE_REGISTRATIONS;

    public static void registerEntries() {
        for (Map.Entry<class_2378<?>, Map<String, RegistryQueue<?>>> m : REGISTRIES.entrySet()) {
            m.getValue().values().forEach(RegistryQueue::initializeEntries);
            if (m.getKey() != class_2378.field_11146) continue;
        }
        ATTRIBUTE_REGISTRATIONS.forEach(e -> e.accept(FabricDefaultAttributeRegistry::register));
    }

    public static <T, E extends T> RegSupplier<E> register(class_2960 name, Supplier<E> supplier, class_2378<T> reg) {
        String modId = name.method_12836();
        Map m = REGISTRIES.computeIfAbsent(reg, h -> new LinkedHashMap());
        RegistryQueue registry = m.computeIfAbsent(modId, c -> new RegistryQueue(reg));
        return registry.add(supplier, name);
    }

    public static <T, E extends T> RegSupplier<E> registerAsync(class_2960 name, Supplier<E> supplier, class_2378<T> reg) {
        RegistryQueue.EntryWrapper<E, T> entry = new RegistryQueue.EntryWrapper<E, T>(name, supplier, reg);
        entry.initialize();
        return entry;
    }

    public static RegSupplier<class_2400> registerParticle(class_2960 name) {
        return RegHelperImpl.register(name, FabricParticleTypes::simple, class_2378.field_11141);
    }

    public static <T extends class_1297> RegSupplier<class_1299<T>> registerEntityType(class_2960 name, class_1299.class_4049<T> factory, class_1311 category, float width, float height, int clientTrackingRange, int updateInterval) {
        Supplier<class_1299> s = () -> class_1299.class_1300.method_5903((class_1299.class_4049)factory, (class_1311)category).method_17687(width, height).method_5905(name.toString());
        return RegHelperImpl.register(name, s, class_2378.field_11145);
    }

    public static void registerItemBurnTime(class_1792 item, int burnTime) {
        FuelRegistry.INSTANCE.add((class_1935)item, (Object)burnTime);
    }

    public static void registerBlockFlammability(class_2248 item, int fireSpread, int flammability) {
        FlammableBlockRegistry.getDefaultInstance().add(item, fireSpread, flammability);
    }

    public static void addAttributeRegistration(Consumer<RegHelper.AttributeEvent> eventListener) {
        ATTRIBUTE_REGISTRATIONS.add(eventListener);
    }

    static {
        REGISTRIES.put(class_2378.field_11156, new LinkedHashMap());
        REGISTRIES.put((class_2378<?>)class_2378.field_11146, new LinkedHashMap());
        REGISTRIES.put((class_2378<?>)class_2378.field_11145, new LinkedHashMap());
        REGISTRIES.put((class_2378<?>)class_2378.field_11142, new LinkedHashMap());
        REGISTRIES.put(class_2378.field_11137, new LinkedHashMap());
        REGISTRIES.put(class_2378.field_35760, new LinkedHashMap());
        REGISTRIES.put(class_2378.field_16645, new LinkedHashMap());
        REGISTRIES.put(class_2378.field_11138, new LinkedHashMap());
        REGISTRIES.put(class_5458.field_25929, new LinkedHashMap());
        REGISTRIES.put(class_5458.field_35761, new LinkedHashMap());
        ATTRIBUTE_REGISTRATIONS = new ArrayList<Consumer<RegHelper.AttributeEvent>>();
    }
}

