/*
 * Decompiled with CFR 0.152.
 */
package uk.me.desert_island.rer.rei_stuff;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Platform;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_176;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3518;
import net.minecraft.class_3861;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import uk.me.desert_island.rer.RERUtils;
import uk.me.desert_island.rer.client.ClientLootCache;
import uk.me.desert_island.rer.rei_stuff.LootCategory;
import uk.me.desert_island.rer.rei_stuff.LootOutput;

@Environment(value=EnvType.CLIENT)
public abstract class LootDisplay
implements Display {
    public EntryStack<?> inputStack;
    public class_2960 lootTableId;
    public class_176 contextType;
    public List<LootOutput> outputs = null;
    public static final NumberFormat FORMAT = new DecimalFormat("#.##");
    public static final NumberFormat FORMAT_MORE = new DecimalFormat("#.####");

    public List<EntryIngredient> getInputEntries() {
        return Collections.singletonList(EntryIngredient.of(this.inputStack));
    }

    public abstract class_2960 getLocation();

    public List<EntryIngredient> getOutputEntries() {
        EntryIngredient.Builder stacks = EntryIngredient.builder();
        for (LootOutput output : this.getOutputs()) {
            stacks.add(output.original);
        }
        return Collections.singletonList(stacks.build());
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return LootCategory.CATEGORY_ID;
    }

    public List<LootOutput> munchLootEntryAlternativesJson(JsonObject object) {
        ArrayList<LootOutput> outputs = new ArrayList<LootOutput>();
        JsonArray children = object.get("children").getAsJsonArray();
        for (JsonElement child : children) {
            outputs.addAll(this.munchLootEntryJson(child.getAsJsonObject()));
        }
        if (object.getAsJsonObject().has("conditions")) {
            for (JsonElement conditionElement : object.getAsJsonObject().get("conditions").getAsJsonArray()) {
                this.munchLootCondition(conditionElement, outputs);
            }
        }
        if (object.getAsJsonObject().has("functions")) {
            ArrayList<LootOutput> newOutputs = new ArrayList<LootOutput>();
            for (JsonElement functionElement : object.getAsJsonObject().get("functions").getAsJsonArray()) {
                List<LootOutput> list = this.munchLootFunctions(functionElement, outputs);
                if (list == null) continue;
                newOutputs.addAll(list);
            }
            outputs.addAll(newOutputs);
        }
        return outputs;
    }

    public List<LootOutput> munchLootEntryItemJson(JsonObject object) {
        class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(object.get("name").getAsString()));
        EntryStack stack = EntryStacks.of((class_1935)item);
        LootOutput output = new LootOutput();
        output.output = EntryIngredient.of((EntryStack)stack);
        output.original = stack.copy();
        ArrayList<LootOutput> outputs = new ArrayList<LootOutput>();
        outputs.add(output);
        return outputs;
    }

    public void munchLootCondition(JsonElement conditionElement, List<LootOutput> outputs) {
        JsonObject conditionObject = conditionElement.getAsJsonObject();
        String kind = new class_2960(conditionObject.get("condition").getAsString()).toString();
        if (kind.equals("minecraft:inverted")) {
            for (LootOutput output : outputs) {
                output.nowInverted = !output.nowInverted;
                output.lastInverted = false;
            }
            if (conditionObject.has("term")) {
                this.munchLootCondition((JsonElement)conditionObject.get("term").getAsJsonObject(), outputs);
            }
            if (conditionObject.has("terms")) {
                for (JsonElement alternateCondition : conditionObject.get("terms").getAsJsonArray()) {
                    this.munchLootCondition(alternateCondition, outputs);
                }
            }
            for (LootOutput output : outputs) {
                output.nowInverted = !output.nowInverted;
                output.lastInverted = false;
            }
        } else if (kind.equals("minecraft:alternative")) {
            if (conditionObject.has("term")) {
                this.munchLootCondition((JsonElement)conditionObject.get("term").getAsJsonObject(), outputs);
            }
            if (conditionObject.has("terms")) {
                for (JsonElement alternateCondition : conditionObject.get("terms").getAsJsonArray()) {
                    this.munchLootCondition(alternateCondition, outputs);
                }
            }
        } else if (kind.equals("minecraft:killed_by_player")) {
            for (LootOutput output : outputs) {
                output.addExtraText(class_1074.method_4662((String)"rer.condition.killedByPlayer", (Object[])new Object[0]));
            }
        } else if (!kind.equals("minecraft:survives_explosion")) {
            if (kind.equals("minecraft:entity_properties") && conditionObject.has("predicate") && conditionObject.get("predicate").getAsJsonObject().has("flags") && conditionObject.get("predicate").getAsJsonObject().get("flags").getAsJsonObject().has("is_on_fire") && conditionObject.get("predicate").getAsJsonObject().get("flags").getAsJsonObject().get("is_on_fire").getAsBoolean() && conditionObject.has("entity") && conditionObject.get("entity").getAsString().equals("this")) {
                for (LootOutput output : outputs) {
                    output.addExtraText(class_1074.method_4662((String)"rer.condition.onFire", (Object[])new Object[0]));
                }
            } else if (!(kind.equals("minecraft:block_state_property") || kind.equals("minecraft:entity_properties") || kind.equals("minecraft:damage_source_properties"))) {
                if (kind.equals("minecraft:match_tool") && conditionObject.has("predicate") && conditionObject.get("predicate").getAsJsonObject().has("enchantments")) {
                    for (JsonElement enchantmentElement : conditionObject.get("predicate").getAsJsonObject().get("enchantments").getAsJsonArray()) {
                        JsonObject enchantmentObject = enchantmentElement.getAsJsonObject();
                        String enchantmentString = enchantmentObject.get("enchantment").getAsString();
                        class_1887 enchantment = (class_1887)class_2378.field_11160.method_10223(new class_2960(enchantmentString));
                        if (enchantment == null) continue;
                        for (LootOutput output : outputs) {
                            output.addExtraText(class_1074.method_4662((String)"rer.condition.enchantment", (Object[])new Object[]{class_1074.method_4662((String)enchantment.method_8184(), (Object[])new Object[0]).toLowerCase()}));
                        }
                    }
                } else if (kind.equals("minecraft:random_chance") && conditionObject.has("chance")) {
                    double chance = conditionObject.get("chance").getAsDouble() * 100.0;
                    for (LootOutput output : outputs) {
                        output.addExtraText(class_1074.method_4662((String)"rer.condition.chance", (Object[])new Object[]{FORMAT.format(chance)}));
                    }
                } else if (kind.equals("minecraft:random_chance_with_looting") && conditionObject.has("chance")) {
                    double chance = conditionObject.get("chance").getAsDouble() * 100.0;
                    for (LootOutput output : outputs) {
                        output.addExtraText(class_1074.method_4662((String)"rer.condition.chance.looting", (Object[])new Object[]{FORMAT.format(chance)}));
                    }
                } else if (kind.equals("minecraft:match_tool") && conditionObject.has("predicate") && conditionObject.get("predicate").getAsJsonObject().has("item")) {
                    String itemId = conditionObject.get("predicate").getAsJsonObject().get("item").getAsString();
                    class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(itemId));
                    for (LootOutput output : outputs) {
                        output.addExtraText(class_1074.method_4662((String)"rer.condition.item", (Object[])new Object[]{item.method_7848().getString().toLowerCase()}));
                    }
                } else if (kind.equals("minecraft:table_bonus")) {
                    double chance = conditionObject.get("chances").getAsJsonArray().get(0).getAsDouble() * 100.0;
                    for (LootOutput output : outputs) {
                        output.addExtraText(class_1074.method_4662((String)"rer.condition.chance", (Object[])new Object[]{FORMAT.format(chance)}));
                    }
                } else {
                    RERUtils.LOGGER.debug("Don't know how to deal with condition of type %s (%s)", kind, conditionObject);
                }
            }
        }
    }

    public List<LootOutput> munchLootEntryJson(JsonObject object) {
        String type = new class_2960(object.get("type").getAsString()).toString();
        ArrayList<LootOutput> outputs = new ArrayList<LootOutput>();
        switch (type) {
            case "minecraft:item": {
                outputs.addAll(this.munchLootEntryItemJson(object));
                break;
            }
            case "minecraft:alternatives": {
                outputs.addAll(this.munchLootEntryAlternativesJson(object));
                break;
            }
            case "minecraft:empty": {
                break;
            }
            case "minecraft:loot_table": {
                JsonElement json = ClientLootCache.ID_TO_LOOT.get(new class_2960(object.get("name").getAsString()));
                if (json == null) break;
                outputs.addAll(this.munchLootSupplierJson(json));
                break;
            }
            case "minecraft:tag": {
                class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(object.get("name").getAsString()));
                if (tag == null) break;
                outputs.addAll(StreamSupport.stream(class_2378.field_11142.method_40286(tag).spliterator(), false).map(class_6880::comp_349).map(item -> {
                    EntryStack stack = EntryStacks.of((class_1935)item);
                    LootOutput output = new LootOutput();
                    output.output = EntryIngredient.of((EntryStack)stack);
                    output.original = stack.copy();
                    return output;
                }).toList());
                break;
            }
            default: {
                RERUtils.LOGGER.debug("Don't know how to deal with entry of type %s (%s)", type, object);
            }
        }
        if (object.has("conditions")) {
            for (JsonElement conditionElement : object.get("conditions").getAsJsonArray()) {
                this.munchLootCondition(conditionElement, outputs);
            }
        }
        if (object.has("functions")) {
            ArrayList<LootOutput> newOutputs = new ArrayList<LootOutput>();
            for (JsonElement functionElement : object.get("functions").getAsJsonArray()) {
                List<LootOutput> list = this.munchLootFunctions(functionElement, outputs);
                if (list == null) continue;
                newOutputs.addAll(list);
            }
            outputs.addAll(newOutputs);
        }
        return outputs;
    }

    public static Integer tryGetNumber(JsonObject obj, String field) {
        JsonElement val = obj.get(field);
        if (val == null || !val.isJsonPrimitive()) {
            return null;
        }
        return val.getAsInt();
    }

    private List<LootOutput> munchLootFunctions(JsonElement lootFunction, List<LootOutput> outputs) {
        JsonObject functionObject = lootFunction.getAsJsonObject();
        String kind = new class_2960(functionObject.get("function").getAsString()).toString();
        boolean createNew = false;
        ArrayList<LootOutput> newOutputs = null;
        if (functionObject.has("conditions")) {
            newOutputs = new ArrayList<LootOutput>();
            for (LootOutput output : outputs) {
                newOutputs.add(output.copy());
            }
        }
        if (kind.equals("minecraft:set_count") && functionObject.has("count")) {
            String type;
            JsonElement countEl = functionObject.get("count");
            if (countEl.isJsonPrimitive()) {
                createNew = true;
                int count = countEl.getAsInt();
                for (LootOutput output : outputs) {
                    for (Object stack : output.output) {
                        ((class_1799)stack.castValue()).method_7939(count);
                    }
                    output.setCountText(String.valueOf(count));
                }
            } else if (countEl.isJsonObject() && (type = new class_2960(countEl.getAsJsonObject().get("type").getAsString()).toString()).equalsIgnoreCase("minecraft:uniform")) {
                Integer n = LootDisplay.tryGetNumber(countEl.getAsJsonObject(), "min");
                Integer max = LootDisplay.tryGetNumber(countEl.getAsJsonObject(), "max");
                int no = max != null && n != null ? max - n + 1 : 0;
                for (LootOutput output : outputs) {
                    ArrayList<EntryStack> newList = new ArrayList<EntryStack>((Collection<EntryStack>)output.output);
                    EntryStack first = (EntryStack)output.output.get(0);
                    while (newList.size() < no) {
                        newList.add(first.copy());
                    }
                    for (int i = 0; i < no; ++i) {
                        class_1799 value = (class_1799)((EntryStack)newList.get(i)).castValue();
                        value.method_7939(n + i);
                        value.method_7948().method_10569("RER_COUNT", n + i);
                    }
                    output.output = EntryIngredient.of(newList);
                    if (n != null && max != null) {
                        output.setCountText(class_1074.method_4662((String)"rer.loot.range", (Object[])new Object[]{n, max}));
                        continue;
                    }
                    if (n != null) {
                        output.setCountText(class_1074.method_4662((String)"rer.function.atLeast", (Object[])new Object[]{n}));
                        continue;
                    }
                    if (max == null) continue;
                    output.setCountText(class_1074.method_4662((String)"rer.function.atMost", (Object[])new Object[]{max}));
                }
                createNew = n != null || max != null;
            }
        } else if (kind.equals("minecraft:limit_count") && functionObject.has("limit") && functionObject.get("limit").isJsonObject()) {
            Integer min = LootDisplay.tryGetNumber(functionObject.get("limit").getAsJsonObject(), "min");
            Integer max = LootDisplay.tryGetNumber(functionObject.get("limit").getAsJsonObject(), "max");
            for (LootOutput output : outputs) {
                for (Object stack : output.output) {
                    class_1799 value = (class_1799)stack.castValue();
                    if (min != null) {
                        int amount;
                        int n = amount = stack.isEmpty() ? 0 : value.method_7947();
                        if (amount < min) {
                            value.method_7939(min.intValue());
                        }
                    }
                    if (max == null || value.method_7947() <= max) continue;
                    value.method_7939(max.intValue());
                }
                if (output.output.isEmpty()) {
                    output.output = EntryIngredient.of((EntryStack)EntryStack.empty());
                }
                if (min != null) {
                    output.addExtraTextCount(class_1074.method_4662((String)"rer.function.atLeast", (Object[])new Object[]{min}));
                }
                if (max == null) continue;
                output.addExtraTextCount(class_1074.method_4662((String)"rer.function.atMost", (Object[])new Object[]{max}));
            }
            createNew = min != null || max != null;
        } else if (!(kind.equals("minecraft:copy_nbt") || kind.equals("minecraft:copy_name") || kind.equals("minecraft:explosion_decay") || kind.equals("minecraft:set_contents") || kind.equals("minecraft:copy_state"))) {
            if (kind.equals("minecraft:set_nbt") && functionObject.has("tag")) {
                try {
                    class_2487 tag = class_2522.method_10718((String)class_3518.method_15265((JsonObject)functionObject, (String)"tag"));
                    for (LootOutput lootOutput : outputs) {
                        ArrayList<Object> newList = new ArrayList<Object>((Collection<Object>)lootOutput.output);
                        for (int i = 0; i < newList.size(); ++i) {
                            Object stack;
                            stack = ((EntryStack)newList.get(i)).copy();
                            if (!stack.isEmpty() && stack.getType() == VanillaEntryTypes.ITEM) {
                                ((class_1799)stack.castValue()).method_7948().method_10543(tag);
                            }
                            newList.set(i, stack);
                        }
                        lootOutput.output = EntryIngredient.of(newList);
                        EntryStack stack = lootOutput.original.copy();
                        if (!stack.isEmpty() && stack.getType() == VanillaEntryTypes.ITEM) {
                            ((class_1799)stack.castValue()).method_7948().method_10543(tag);
                        }
                        lootOutput.original = stack;
                    }
                    createNew = true;
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            } else if (kind.equals("minecraft:apply_bonus") && functionObject.has("enchantment")) {
                String enchantmentString = functionObject.get("enchantment").getAsString();
                class_1887 enchantment = (class_1887)class_2378.field_11160.method_10223(new class_2960(enchantmentString));
                if (enchantment != null) {
                    for (LootOutput output : outputs) {
                        output.addExtraTextCount(class_1074.method_4662((String)"rer.function.bonus.enchant", (Object[])new Object[]{class_1074.method_4662((String)enchantment.method_8184(), (Object[])new Object[0]).toLowerCase()}));
                    }
                    createNew = true;
                }
            } else if (kind.equals("minecraft:looting_enchant")) {
                for (LootOutput output : outputs) {
                    output.addExtraTextCount(class_1074.method_4662((String)"rer.function.bonus.enchant", (Object[])new Object[]{class_1074.method_4662((String)class_1893.field_9110.method_8184(), (Object[])new Object[0]).toLowerCase()}));
                }
                createNew = true;
            } else if (kind.equals("minecraft:furnace_smelt")) {
                for (LootOutput output : outputs) {
                    ArrayList arrayList = new ArrayList((Collection<EntryStack<?>>)output.output);
                    output.original = this.smelt(output.original);
                    for (int i = 0; i < arrayList.size(); ++i) {
                        arrayList.set(i, this.smelt((EntryStack)arrayList.get(i)));
                    }
                    output.output = EntryIngredient.of(arrayList);
                }
                createNew = true;
            } else {
                RERUtils.LOGGER.debug("Don't know how to deal with function of type %s (%s)", kind, functionObject);
            }
        }
        if (functionObject.has("conditions")) {
            for (JsonElement conditionElement : functionObject.get("conditions").getAsJsonArray()) {
                this.munchLootCondition(conditionElement, outputs);
            }
        }
        if (functionObject.has("functions")) {
            ArrayList<LootOutput> newNewOutputs = new ArrayList<LootOutput>();
            for (JsonElement jsonElement : functionObject.get("functions").getAsJsonArray()) {
                List<LootOutput> list = this.munchLootFunctions(jsonElement, outputs);
                if (list == null) continue;
                newNewOutputs.addAll(list);
            }
            outputs.addAll(newNewOutputs);
        }
        return createNew ? newOutputs : null;
    }

    private EntryStack<?> smelt(EntryStack<?> stack) {
        class_1799 itemStack;
        if (stack.isEmpty() || stack.getType() != VanillaEntryTypes.ITEM) {
            return stack.copy();
        }
        class_638 world = class_310.method_1551().field_1687;
        Optional optional = class_310.method_1551().method_1562().method_2877().method_8132(class_3956.field_17546, (class_1263)new class_1277(new class_1799[]{(class_1799)stack.castValue()}), (class_1937)world);
        if (optional.isPresent() && !(itemStack = ((class_3861)optional.get()).method_8110()).method_7960()) {
            EntryStack entryStack = EntryStacks.of((class_1799)itemStack.method_7972());
            ((class_1799)entryStack.castValue()).method_7939(((class_1799)stack.castValue()).method_7947());
            return entryStack;
        }
        return stack.copy();
    }

    public List<LootOutput> munchLootPoolJson(JsonObject poolObject) {
        ArrayList<LootOutput> outputs = new ArrayList<LootOutput>();
        JsonArray entries = poolObject.getAsJsonObject().get("entries").getAsJsonArray();
        for (JsonElement entryElement : entries) {
            JsonObject entryObject = entryElement.getAsJsonObject();
            outputs.addAll(this.munchLootEntryJson(entryObject));
        }
        if (poolObject.getAsJsonObject().has("conditions")) {
            for (JsonElement conditionElement : poolObject.getAsJsonObject().get("conditions").getAsJsonArray()) {
                this.munchLootCondition(conditionElement, outputs);
            }
        }
        if (poolObject.getAsJsonObject().has("functions")) {
            ArrayList<LootOutput> newOutputs = new ArrayList<LootOutput>();
            for (JsonElement functionElement : poolObject.getAsJsonObject().get("functions").getAsJsonArray()) {
                List<LootOutput> list = this.munchLootFunctions(functionElement, outputs);
                if (list == null) continue;
                newOutputs.addAll(list);
            }
            outputs.addAll(newOutputs);
        }
        return outputs;
    }

    public List<LootOutput> munchLootSupplierJson(JsonElement jsonSupplier) {
        ArrayList<LootOutput> outputs = new ArrayList<LootOutput>();
        if (!jsonSupplier.getAsJsonObject().has("pools")) {
            return outputs;
        }
        JsonArray pools = jsonSupplier.getAsJsonObject().get("pools").getAsJsonArray();
        for (JsonElement poolElement : pools) {
            JsonObject poolObject = poolElement.getAsJsonObject();
            outputs.addAll(this.munchLootPoolJson(poolObject));
        }
        return outputs;
    }

    public List<LootOutput> getOutputs() {
        JsonElement json = ClientLootCache.ID_TO_LOOT.get(this.lootTableId);
        if (json == null) {
            return Collections.emptyList();
        }
        if (this.outputs == null || Platform.isDevelopmentEnvironment()) {
            try {
                this.outputs = this.munchLootSupplierJson(json);
            }
            catch (Exception e) {
                RERUtils.LOGGER.warn("Failed to parse loot table '%s': ", this.lootTableId, e);
                this.outputs = Collections.emptyList();
            }
        }
        return this.outputs;
    }
}

