/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.platform.fabric.client.model;

import agency.highlysuspect.packages.block.PBlocks;
import agency.highlysuspect.packages.block.PackageBlock;
import agency.highlysuspect.packages.client.PackageModelBakery;
import agency.highlysuspect.packages.junk.PUtil;
import agency.highlysuspect.packages.platform.fabric.compat.frex.FrexCompat;
import java.util.Random;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_776;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

public class FrapiMeshModelBakery
implements PackageModelBakery<Mesh> {
    public final class_1087 baseModel;
    public final class_1058 specialFrameSprite;
    public final class_1058 specialInnerSprite;

    public FrapiMeshModelBakery(class_1087 baseModel, class_1058 specialFrameSprite, class_1058 specialInnerSprite) {
        this.baseModel = baseModel;
        this.specialFrameSprite = specialFrameSprite;
        this.specialInnerSprite = specialInnerSprite;
    }

    @Override
    public class_1087 getBaseModel() {
        return this.baseModel;
    }

    @Override
    public Mesh bake(@Nullable Object cacheKey, @Nullable class_1767 faceColor, @Nullable class_2248 frameBlock, @Nullable class_2248 innerBlock) {
        class_776 mgr = class_310.method_1551().method_1541();
        Renderer renderer = RendererAccess.INSTANCE.getRenderer();
        assert (renderer != null);
        MeshBuilder meshBuilder = renderer.meshBuilder();
        QuadEmitter emitter = meshBuilder.getEmitter();
        @Nullable class_2680 frameState = frameBlock == null ? null : frameBlock.method_9564();
        @Nullable class_1058 frameSprite = frameState == null ? null : mgr.method_3349(frameState).method_4711();
        @Nullable class_2680 innerState = innerBlock == null ? null : innerBlock.method_9564();
        @Nullable class_1058 innerSprite = innerState == null ? null : mgr.method_3349(innerState).method_4711();
        Random random = new Random(42L);
        for (class_2350 cullFace : PUtil.DIRECTIONS_AND_NULL) {
            for (class_777 quad : this.baseModel.method_4707(((PackageBlock)((Object)PBlocks.PACKAGE.get())).method_9564(), cullFace, random)) {
                emitter.fromVanilla(quad, null, cullFace);
                emitter.material(null);
                if (emitter.colorIndex() == 1) {
                    if (faceColor == null) continue;
                    int tint = 0xFF000000 | faceColor.method_7794().field_16011;
                    emitter.spriteColor(0, tint, tint, tint, tint);
                    emitter.emit();
                    continue;
                }
                SpriteUvBounds bounds = SpriteUvBounds.readOff(emitter);
                if (bounds.displaysSprite(this.specialFrameSprite)) {
                    if (frameSprite == null) continue;
                    bounds.normalizeEmitter(emitter, this.specialFrameSprite);
                    emitter.spriteBake(0, frameSprite, 32);
                    FrexCompat.PROXY.fancifyPackageQuad(emitter, frameState, frameSprite);
                    emitter.emit();
                    continue;
                }
                if (bounds.displaysSprite(this.specialInnerSprite)) {
                    if (innerSprite == null) continue;
                    bounds.normalizeEmitter(emitter, this.specialInnerSprite);
                    emitter.spriteBake(0, innerSprite, 32);
                    FrexCompat.PROXY.fancifyPackageQuad(emitter, innerState, innerSprite);
                    emitter.emit();
                    continue;
                }
                emitter.emit();
            }
        }
        return meshBuilder.build();
    }

    private record SpriteUvBounds(float minU, float maxU, float minV, float maxV) {
        static SpriteUvBounds readOff(QuadEmitter emitter) {
            float minU = Float.POSITIVE_INFINITY;
            float maxU = Float.NEGATIVE_INFINITY;
            float minV = Float.POSITIVE_INFINITY;
            float maxV = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < 4; ++i) {
                float v;
                float u = emitter.spriteU(i, 0);
                if (minU > u) {
                    minU = u;
                }
                if (maxU < u) {
                    maxU = u;
                }
                if (minV > (v = emitter.spriteV(i, 0))) {
                    minV = v;
                }
                if (!(maxV < v)) continue;
                maxV = v;
            }
            return new SpriteUvBounds(minU, maxU, minV, maxV);
        }

        boolean displaysSprite(class_1058 sprite) {
            return sprite.method_4594() <= this.minU && sprite.method_4577() >= this.maxU && sprite.method_4593() <= this.minV && sprite.method_4575() >= this.maxV;
        }

        void normalizeEmitter(QuadEmitter emitter, class_1058 sprite) {
            float remappedMinU = PUtil.rangeRemap(this.minU, sprite.method_4594(), sprite.method_4577(), 0.0f, 1.0f);
            float remappedMaxU = PUtil.rangeRemap(this.maxU, sprite.method_4594(), sprite.method_4577(), 0.0f, 1.0f);
            float remappedMinV = PUtil.rangeRemap(this.minV, sprite.method_4593(), sprite.method_4575(), 0.0f, 1.0f);
            float remappedMaxV = PUtil.rangeRemap(this.maxV, sprite.method_4593(), sprite.method_4575(), 0.0f, 1.0f);
            for (int i = 0; i < 4; ++i) {
                float writeU = class_3532.method_15347((float)emitter.spriteU(i, 0), (float)this.minU) ? remappedMinU : remappedMaxU;
                float writeV = class_3532.method_15347((float)emitter.spriteV(i, 0), (float)this.minV) ? remappedMinV : remappedMaxV;
                emitter.sprite(i, 0, writeU, writeV);
            }
        }
    }
}

