/*
 * Decompiled with CFR 0.152.
 */
package com.github.ethanicuss.astraladditions.playertracker;

import com.github.ethanicuss.astraladditions.AstralAdditions;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class PlayerTracker {
    private class_746 player;
    public boolean hasBeenToMoon = false;
    public boolean hasHeardPostMoonSong = false;
    public boolean doCombatMusic = true;

    public PlayerTracker() {
        this.player = class_310.method_1551().field_1724;
        this.LoadTrackingData();
        this.LoadCombatMusicPreference();
    }

    public void SaveTrackingData() {
        try {
            Path path = FabricLoader.getInstance().getConfigDir();
            if (new File(String.valueOf(path).concat("/astraladditions")).mkdirs()) {
                AstralAdditions.LOGGER.info("Astraladditions config folder did not exist. It has been created");
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(path).concat("/astraladditions/musicdata.txt")));
            writer.write(String.valueOf(this.hasBeenToMoon) + "\n");
            writer.write(String.valueOf(this.hasHeardPostMoonSong) + "\n");
            writer.close();
            AstralAdditions.LOGGER.info("Astraladditions music data successfully saved");
        }
        catch (Exception e) {
            AstralAdditions.LOGGER.warn("Could not save music memory data: " + e);
        }
    }

    public void LoadTrackingData() {
        try {
            Path path = FabricLoader.getInstance().getConfigDir();
            File file = new File(String.valueOf(path).concat("/astraladditions/musicdata.txt"));
            FileInputStream inputStream = new FileInputStream(file);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                int counter = 0;
                while ((line = br.readLine()) != null) {
                    switch (counter) {
                        case 0: {
                            this.hasBeenToMoon = line.matches("true");
                            break;
                        }
                        case 1: {
                            this.hasHeardPostMoonSong = line.matches("true");
                        }
                    }
                    ++counter;
                }
                AstralAdditions.LOGGER.info("Astraladditions music data successfully loaded");
            }
        }
        catch (Exception e) {
            AstralAdditions.LOGGER.warn("Could not load music memory data (this is fine if it's your first time loading this instance):  " + e);
            try {
                Path path = FabricLoader.getInstance().getConfigDir();
                if (new File(String.valueOf(path).concat("/astraladditions")).mkdirs()) {
                    AstralAdditions.LOGGER.info("Astraladditions config folder did not exist. It has been created");
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(path).concat("/astraladditions/musicdata.txt")));
                writer.write(String.valueOf(this.hasBeenToMoon) + "\n");
                writer.write(String.valueOf(this.hasHeardPostMoonSong) + "\n");
                writer.close();
            }
            catch (Exception e2) {
                AstralAdditions.LOGGER.warn("Could not create config path or data file: " + e2);
            }
        }
    }

    public void LoadCombatMusicPreference() {
        try {
            Path path = FabricLoader.getInstance().getConfigDir();
            File file = new File(String.valueOf(path).concat("/astraladditions/combatmusic.txt"));
            FileInputStream inputStream = new FileInputStream(file);
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                int counter = 0;
                while ((line = br.readLine()) != null) {
                    switch (counter) {
                        case 0: {
                            this.doCombatMusic = line.matches("true");
                        }
                    }
                    ++counter;
                }
                AstralAdditions.LOGGER.info("Astraladditions combat music preference successfully loaded: " + this.doCombatMusic);
            }
        }
        catch (FileNotFoundException e) {
            AstralAdditions.LOGGER.warn("Could not load combat music preference (this is fine if it's your first time loading this instance):  " + e);
            try {
                Path path = FabricLoader.getInstance().getConfigDir();
                if (new File(String.valueOf(path).concat("/astraladditions")).mkdirs()) {
                    AstralAdditions.LOGGER.info("Astraladditions config folder did not exist. It has been created");
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(String.valueOf(path).concat("/astraladditions/combatmusic.txt")));
                writer.write(String.valueOf(this.doCombatMusic) + "\n");
                writer.close();
            }
            catch (Exception e2) {
                AstralAdditions.LOGGER.warn("Could not create config path or data file: " + e2);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

