/*
 * Decompiled with CFR 0.152.
 */
package com.github.ethanicuss.astraladditions.mixin;

import com.github.ethanicuss.astraladditions.entities.ModEntities;
import com.github.ethanicuss.astraladditions.entities.shimmerblaze.ShimmerBlazeEntity;
import com.github.ethanicuss.astraladditions.fluids.ModFluids;
import com.github.ethanicuss.astraladditions.recipes.TransmuteRecipe;
import com.github.ethanicuss.astraladditions.registry.ModData;
import com.github.ethanicuss.astraladditions.registry.ModItems;
import com.github.ethanicuss.astraladditions.util.ModUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin
extends class_1297 {
    private static final int COOLDOWN_TIME = 40;
    private static final int MINIMUM_TIME_IN_SHIMMER = 40;
    private static final double MAX_RAYCAST_DISTANCE = 1.25;
    private static final Set<class_1799> processedItems = new HashSet<class_1799>();
    private int lastProcessedTick = -40;

    public ItemEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    public abstract class_1799 method_6983();

    private boolean isInShimmerFluid() {
        class_2338 pos = this.method_24515();
        class_3610 fluidState = this.field_6002.method_8316(pos);
        class_3611 fluid = fluidState.method_15772();
        return fluid == ModFluids.STILL_SHIMMER || fluid == ModFluids.FLOWING_SHIMMER;
    }

    private boolean hasShimmerAbove() {
        class_2338 currentPos = this.method_24515();
        int i = 1;
        while ((double)i <= 1.25) {
            class_2338 checkPos = currentPos.method_10086(i);
            class_3610 fluidState = this.field_6002.method_8316(checkPos);
            class_3611 fluid = fluidState.method_15772();
            if (fluid == ModFluids.STILL_SHIMMER || fluid == ModFluids.FLOWING_SHIMMER) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isValidItemForTransformation(class_1799 stack) {
        return !stack.method_7942() && !stack.method_7938();
    }

    private boolean isIgnoredByShimmerTransmutation(class_1799 stack) {
        return stack.method_31573(ModData.INGORE_TRANSMUTATION);
    }

    private boolean hasBeenProcessed(class_1799 stack) {
        return processedItems.contains(stack);
    }

    private void markAsProcessed(class_1799 stack) {
        processedItems.add(stack.method_7972());
    }

    @Inject(at={@At(value="RETURN")}, method={"applyWaterBuoyancy"}, cancellable=true)
    private void applyWaterBuoyancy(CallbackInfo ci) {
        if (!this.field_6002.method_8608()) {
            if (ModItems.isSacrificeItem(this.method_6983().method_7909())) {
                ModUtils.spawnForcedParticles((class_3218)this.field_6002, class_2398.field_11207, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 3, 0.2, 0.2, 0.2, 0.05);
                this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_18063, class_3419.field_15251, 0.5f, 0.8f, true);
                if (this.method_6983().method_7909() == ModItems.AWAKENED_SHIMMER_HEART && this.field_6012 > 60) {
                    ModUtils.spawnForcedParticles((class_3218)this.field_6002, class_2398.field_11207, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 15, 0.1, 1.0, 0.1, 0.15);
                    ShimmerBlazeEntity shimmerBlaze = new ShimmerBlazeEntity(ModEntities.SHIMMER_BLAZE, this.field_6002);
                    shimmerBlaze.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                    shimmerBlaze.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), 0.0f, 0.0f);
                    shimmerBlaze.method_18800(0.0, 1.0, 0.0);
                    this.field_6002.method_8649((class_1297)shimmerBlaze);
                    this.method_31472();
                    return;
                }
            }
            if (this.isInShimmerFluid() && !this.hasShimmerAbove() && this.field_6012 >= 40 && this.field_6012 - this.lastProcessedTick >= 40) {
                class_1799 itemStack = this.method_6983();
                if (!this.isValidItemForTransformation(itemStack) || this.isIgnoredByShimmerTransmutation(itemStack)) {
                    return;
                }
                if (this.hasBeenProcessed(itemStack)) {
                    return;
                }
                Optional<TransmuteRecipe> recipeOptional = this.field_6002.method_8433().method_30027((class_3956)TransmuteRecipe.Type.INSTANCE).stream().filter(recipe -> recipe.matches(itemStack)).findFirst();
                if (recipeOptional.isPresent()) {
                    TransmuteRecipe recipe2 = recipeOptional.get();
                    class_1799 recipeInputItem = recipe2.getInputItem();
                    int recipeInputCount = recipeInputItem.method_7947();
                    if (itemStack.method_7909() == recipeInputItem.method_7909() && itemStack.method_7947() == recipeInputCount) {
                        ModUtils.spawnForcedParticles((class_3218)this.field_6002, class_2398.field_11207, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 15, 0.1, 0.1, 0.1, 0.15);
                        this.field_6002.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_18063, class_3419.field_15254, 0.5f, 0.8f, true);
                        for (class_1799 outputItem : recipe2.getOutputItems()) {
                            class_1542 outputEntity = new class_1542(this.field_6002, this.method_23317(), this.method_23318() + 0.25, this.method_23321(), outputItem.method_7972());
                            outputEntity.method_5875(true);
                            outputEntity.method_18800(0.0, 0.05, 0.0);
                            this.field_6002.method_8649((class_1297)outputEntity);
                        }
                        this.markAsProcessed(itemStack);
                        this.method_31472();
                        this.lastProcessedTick = this.field_6012;
                    }
                }
            }
        }
    }
}

