/*
 * Decompiled with CFR 0.152.
 */
package com.github.ethanicuss.astraladditions.compat.rei.desizer;

import com.github.ethanicuss.astraladditions.compat.rei.AstralAdditionsREIClientPlugin;
import com.github.ethanicuss.astraladditions.compat.rei.desizer.DesizerDisplay;
import com.github.ethanicuss.astraladditions.registry.ModBlocks;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class DesizerCategory
implements DisplayCategory<DesizerDisplay> {
    private static final int GRID_ROWS = 3;
    private static final int GRID_COLUMNS = 3;
    private static final int CELL_SIZE = 20;

    public Renderer getIcon() {
        return EntryStacks.of((class_1935)ModBlocks.DESIZER_CONTROLLER);
    }

    public class_2561 getTitle() {
        return new class_2588("category.astraladditions.desizer");
    }

    public CategoryIdentifier<? extends DesizerDisplay> getCategoryIdentifier() {
        return AstralAdditionsREIClientPlugin.DESIZER;
    }

    private void drawGrid(List<Widget> gridWidgets, List<EntryIngredient> items, int layer, int startX, int startY) {
        gridWidgets.clear();
        int startIndex = (layer - 1) * 9;
        int endIndex = Math.min(startIndex + 9, items.size());
        List<EntryIngredient> currentItems = items.subList(startIndex, endIndex);
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int itemIndex = row * 3 + col;
                if (itemIndex >= currentItems.size()) {
                    return;
                }
                EntryIngredient entry = currentItems.get(itemIndex);
                int x = startX + col * 20 - 40;
                int y = startY + row * 20 - 10;
                boolean isBedrock = entry.stream().anyMatch(stack -> EntryStacks.equalsExact((EntryStack)stack, (EntryStack)EntryStacks.of((class_1935)class_1802.field_8542)));
                if (isBedrock) {
                    gridWidgets.add((Widget)Widgets.createSlot((Point)new Point(x, y)));
                    continue;
                }
                gridWidgets.add((Widget)Widgets.createSlot((Point)new Point(x, y)).entries((Collection)entry));
            }
        }
    }

    public List<Widget> setupDisplay(DesizerDisplay display, Rectangle bounds) {
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        AtomicInteger currentLayer = new AtomicInteger(1);
        int gridWidth = 60;
        int gridHeight = 60;
        int startX = bounds.x + (bounds.width - gridWidth) / 2;
        int startY = bounds.y + (bounds.height - gridHeight) / 2;
        int buttonY = bounds.y + bounds.height - 25;
        List inputs = display.getInputEntries();
        List outputs = display.getOutputEntries();
        ArrayList gridWidgets = Lists.newArrayList();
        this.drawGrid(gridWidgets, inputs, currentLayer.get(), startX, startY);
        widgets.addAll(gridWidgets);
        Widget[] layerLabel = new Widget[]{this.createLayerLabel(startX, buttonY, currentLayer.get())};
        widgets.add(layerLabel[0]);
        widgets.add(Widgets.createSlot((Point)new Point(bounds.x + bounds.width / 2 + 20, startY + 10)).entries((Collection)outputs.get(0)));
        widgets.add(Widgets.createArrow((Point)new Point(bounds.x + bounds.width / 2 - 10, startY + 10)));
        widgets.add(Widgets.createButton((Rectangle)new Rectangle(startX - 40, buttonY, 16, 16), (class_2561)class_2561.method_30163((String)"<")).onClick(button -> {
            if (currentLayer.get() > 1) {
                currentLayer.decrementAndGet();
                this.updateLayerLabelAndGrid(currentLayer.get(), inputs, layerLabel, gridWidgets, widgets, startX, startY, buttonY);
            }
        }));
        widgets.add(Widgets.createButton((Rectangle)new Rectangle(startX, buttonY, 16, 16), (class_2561)class_2561.method_30163((String)">")).onClick(button -> {
            if (currentLayer.get() < 3) {
                currentLayer.incrementAndGet();
                this.updateLayerLabelAndGrid(currentLayer.get(), inputs, layerLabel, gridWidgets, widgets, startX, startY, buttonY);
            }
        }));
        return widgets;
    }

    private void updateLayerLabelAndGrid(int newLayer, List<EntryIngredient> inputs, Widget[] layerLabel, List<Widget> gridWidgets, List<Widget> widgets, int startX, int startY, int buttonY) {
        widgets.remove(layerLabel[0]);
        layerLabel[0] = this.createLayerLabel(startX, buttonY, newLayer);
        widgets.add(layerLabel[0]);
        widgets.removeAll(gridWidgets);
        gridWidgets.clear();
        this.drawGrid(gridWidgets, inputs, newLayer, startX, startY);
        widgets.addAll(gridWidgets);
    }

    private Widget createLayerLabel(int startX, int buttonY, int layer) {
        return Widgets.createLabel((Point)new Point((double)startX - 11.1, (double)buttonY + 3.5), (class_2561)class_2561.method_30163((String)String.valueOf(layer))).noShadow().color(0xFFFFFF, 0xAAAAAA);
    }

    public int getDisplayHeight() {
        return 90;
    }
}

