/*
 * Decompiled with CFR 0.152.
 */
package com.github.ethanicuss.astraladditions.compat.rei;

import com.github.ethanicuss.astraladditions.compat.rei.desizer.DesizerCategory;
import com.github.ethanicuss.astraladditions.compat.rei.desizer.DesizerDisplay;
import com.github.ethanicuss.astraladditions.compat.rei.transmute.TransmuteCategory;
import com.github.ethanicuss.astraladditions.compat.rei.transmute.TransmuteDisplay;
import com.github.ethanicuss.astraladditions.compat.rei.vacuum.VacuumCategory;
import com.github.ethanicuss.astraladditions.compat.rei.vacuum.VacuumDisplay;
import com.github.ethanicuss.astraladditions.fluids.ModFluids;
import com.github.ethanicuss.astraladditions.recipes.DesizerRecipe;
import com.github.ethanicuss.astraladditions.recipes.TransmuteRecipe;
import com.github.ethanicuss.astraladditions.registry.ChromaticVacuumRecipe;
import com.github.ethanicuss.astraladditions.registry.ModBlocks;
import com.github.ethanicuss.astraladditions.registry.ModItems;
import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;

public class AstralAdditionsREIClientPlugin
implements REIClientPlugin {
    public static final CategoryIdentifier<DesizerDisplay> DESIZER = CategoryIdentifier.of((class_2960)new class_2960("astraladditions", "desizer"));
    public static final CategoryIdentifier<TransmuteDisplay> TRANSMUTE = CategoryIdentifier.of((class_2960)new class_2960("astraladditions", "transmute"));
    public static final CategoryIdentifier<VacuumDisplay> VACUUM = CategoryIdentifier.of((class_2960)new class_2960("astraladditions", "vacuum"));

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new DesizerCategory());
        registry.addWorkstations(DESIZER, new EntryStack[]{EntryStacks.of((class_1935)ModBlocks.DESIZER_CONTROLLER)});
        registry.add((DisplayCategory)new TransmuteCategory());
        registry.addWorkstations(TRANSMUTE, new EntryStack[]{EntryStacks.of((class_1935)ModFluids.SHIMMER_BUCKET)});
        registry.add((DisplayCategory)new VacuumCategory());
        registry.addWorkstations(VACUUM, new EntryStack[]{EntryStacks.of((class_1935)ModItems.CHROMATIC_VACUUM)});
    }

    public void registerDisplays(DisplayRegistry registry) {
        class_1863 recipeManager = class_310.method_1551().method_1576().method_3772();
        List<DesizerDisplay> desizerRecipes = recipeManager.method_30027((class_3956)DesizerRecipe.Type.INSTANCE).stream().map(DesizerDisplay::of).toList();
        desizerRecipes.forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        List<TransmuteDisplay> transmuteRecipes = recipeManager.method_30027((class_3956)TransmuteRecipe.Type.INSTANCE).stream().map(TransmuteDisplay::of).toList();
        transmuteRecipes.forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        List<VacuumDisplay> vacuumRecipes = recipeManager.method_30027((class_3956)ChromaticVacuumRecipe.Type.INSTANCE).stream().map(VacuumDisplay::of).toList();
        vacuumRecipes.forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
    }

    public void registerScreens(ScreenRegistry registry) {
        super.registerScreens(registry);
    }
}

