/*
 * Decompiled with CFR 0.152.
 */
package com.github.ethanicuss.astraladditions.blocks;

import com.github.ethanicuss.astraladditions.blocks.DesizerCasingBlock;
import com.github.ethanicuss.astraladditions.recipes.DesizerRecipe;
import com.github.ethanicuss.astraladditions.recipes.DesizerRecipes;
import com.github.ethanicuss.astraladditions.registry.ModData;
import com.github.ethanicuss.astraladditions.util.ModUtils;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_4970;

public class DesizerControllerBlock
extends class_2383 {
    boolean hasTicked = false;

    public DesizerControllerBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043));
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        if (!world.field_9236) {
            class_2338[] adjacentPositions;
            class_2680 controllerDirection = world.method_8320(pos);
            for (class_2338 adjacentPos : adjacentPositions = this.getAdjacentPositions(pos, (class_2350)controllerDirection.method_11654((class_2769)field_11177))) {
                class_2680 adjacentState = world.method_8320(adjacentPos);
                if (!(adjacentState.method_26204() instanceof DesizerCasingBlock)) continue;
                DesizerCasingBlock.Type type = this.getCasingType(adjacentPos, pos, (class_2350)controllerDirection.method_11654((class_2769)field_11177));
                class_2350 rotation = (class_2350)controllerDirection.method_11654((class_2769)field_11177);
                world.method_8501(adjacentPos, (class_2680)((class_2680)adjacentState.method_11657(DesizerCasingBlock.TYPE, (Comparable)((Object)type))).method_11657((class_2769)class_2383.field_11177, (Comparable)rotation));
            }
        }
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        this.method_33614(world, player, pos, state);
        if (!world.field_9236) {
            class_2338[] adjacentPositions;
            class_2680 controllerDirection = world.method_8320(pos);
            for (class_2338 adjacentPos : adjacentPositions = this.getAdjacentPositions(pos, (class_2350)controllerDirection.method_11654((class_2769)field_11177))) {
                class_2680 adjacentState = world.method_8320(adjacentPos);
                if (!(adjacentState.method_26204() instanceof DesizerCasingBlock)) continue;
                DesizerCasingBlock.Type baseType = DesizerCasingBlock.Type.BASE;
                world.method_8501(adjacentPos, (class_2680)((class_2680)adjacentState.method_11657(DesizerCasingBlock.TYPE, (Comparable)((Object)baseType))).method_11657((class_2769)class_2383.field_11177, (Comparable)class_2350.field_11043));
            }
        }
    }

    private class_2338[] getAdjacentPositions(class_2338 pos, class_2350 direction) {
        class_2338[] northSouthDirections = new class_2338[]{pos.method_10078(), pos.method_10067(), pos.method_10084(), pos.method_10074(), pos.method_10084().method_10078(), pos.method_10084().method_10067(), pos.method_10074().method_10078(), pos.method_10074().method_10067()};
        class_2338[] eastWestDirections = new class_2338[]{pos.method_10095(), pos.method_10072(), pos.method_10084(), pos.method_10074(), pos.method_10084().method_10095(), pos.method_10074().method_10095(), pos.method_10084().method_10072(), pos.method_10074().method_10072()};
        switch (direction.method_10153()) {
            case field_11043: 
            case field_11035: {
                return northSouthDirections;
            }
            case field_11034: 
            case field_11039: {
                return eastWestDirections;
            }
        }
        return new class_2338[0];
    }

    private DesizerCasingBlock.Type getCasingType(class_2338 adjacentPos, class_2338 controllerPos, class_2350 direction) {
        int xDiff = adjacentPos.method_10263() - controllerPos.method_10263();
        int yDiff = adjacentPos.method_10264() - controllerPos.method_10264();
        int zDiff = adjacentPos.method_10260() - controllerPos.method_10260();
        String positionKey = null;
        String yMath = yDiff == 1 ? "top" : (yDiff == -1 ? "bottom" : "middle");
        switch (direction.method_10153()) {
            case field_11043: {
                positionKey = yMath + (xDiff == -1 ? "left" : (xDiff == 1 ? "right" : "middle"));
                break;
            }
            case field_11034: {
                positionKey = yMath + (zDiff == -1 ? "left" : (zDiff == 1 ? "right" : "middle"));
                break;
            }
            case field_11035: {
                positionKey = yMath + (xDiff == 1 ? "left" : (xDiff == -1 ? "right" : "middle"));
                break;
            }
            case field_11039: {
                positionKey = yMath + (zDiff == 1 ? "left" : (zDiff == -1 ? "right" : "middle"));
            }
        }
        assert (positionKey != null);
        return switch (positionKey) {
            case "topleft" -> DesizerCasingBlock.Type.TOPLEFT;
            case "topmiddle" -> DesizerCasingBlock.Type.TOPMIDDLE;
            case "topright" -> DesizerCasingBlock.Type.TOPRIGHT;
            case "middleleft" -> DesizerCasingBlock.Type.MIDDLELEFT;
            case "middleright" -> DesizerCasingBlock.Type.MIDDLERIGHT;
            case "bottomleft" -> DesizerCasingBlock.Type.BOTTOMLEFT;
            case "bottommiddle" -> DesizerCasingBlock.Type.BOTTOMMIDDLE;
            case "bottomright" -> DesizerCasingBlock.Type.BOTTOMRIGHT;
            default -> DesizerCasingBlock.Type.BASE;
        };
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean notify) {
        if (!world.field_9236) {
            if (!this.hasTicked) {
                this.hasTicked = true;
                this.tryShrink(world, pos, state);
                this.hasTicked = false;
            } else {
                this.hasTicked = false;
            }
        }
    }

    private void tryShrink(class_1937 world, class_2338 pos, class_2680 state) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        boolean bl = this.shouldShrink(world, pos, direction);
        if (bl) {
            int _X = 0;
            int _Y = 0;
            int _Z = 0;
            switch (direction) {
                case field_11043: {
                    _X = -1;
                    _Y = 1;
                    _Z = -3;
                    break;
                }
                case field_11034: {
                    _X = 3;
                    _Y = 1;
                    _Z = -1;
                    break;
                }
                case field_11035: {
                    _X = 1;
                    _Y = 1;
                    _Z = 3;
                    break;
                }
                case field_11039: {
                    _X = -3;
                    _Y = 1;
                    _Z = 1;
                }
            }
            DesizerRecipes.RecipeStructure input = new DesizerRecipes.RecipeStructure();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        class_2248 block = world.method_8320(new class_2338(pos.method_10263() + _X + k * this.isDirection("x", direction) + j * this.isDirection("z", direction), pos.method_10264() + _Y - i, pos.method_10260() + _Z - k * this.isDirection("z", direction) + j * this.isDirection("x", direction))).method_26204();
                        if (block == class_2246.field_10124 || block == class_2246.field_10543 || block == class_2246.field_10243) {
                            block = class_2246.field_9987;
                        }
                        input.blocks[i][j][k] = block;
                    }
                }
            }
            class_1277 inventory = new class_1277(27);
            int slotCount = 0;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        inventory.method_5447(slotCount, new class_1799((class_1935)input.blocks[i][j][k].method_8389(), 1));
                        ++slotCount;
                    }
                }
            }
            Optional match = world.method_8433().method_8132((class_3956)DesizerRecipe.Type.INSTANCE, (class_1263)inventory, world);
            if (match.isPresent()) {
                class_1792 resultItem = ((DesizerRecipe)match.get()).method_8110().method_7909();
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            class_2338 returnBlockPos = new class_2338(pos.method_10263() + _X + k * this.isDirection("x", direction) + j * this.isDirection("z", direction), pos.method_10264() + _Y - i, pos.method_10260() + _Z - k * this.isDirection("z", direction) + j * this.isDirection("x", direction));
                            world.method_8501(returnBlockPos, class_2246.field_10124.method_9564());
                        }
                    }
                }
                switch (direction) {
                    case field_11043: {
                        _X = 0;
                        _Y = 1;
                        _Z = -2;
                        break;
                    }
                    case field_11034: {
                        _X = 2;
                        _Y = 1;
                        _Z = 0;
                        break;
                    }
                    case field_11035: {
                        _X = 0;
                        _Y = 1;
                        _Z = 2;
                        break;
                    }
                    case field_11039: {
                        _X = -2;
                        _Y = 1;
                        _Z = 0;
                    }
                }
                class_2338 returnPos = new class_2338(pos.method_10263() + _X, pos.method_10264() + _Y, pos.method_10260() + _Z);
                DesizerControllerBlock.dropResult(world, returnPos, new class_1799((class_1935)resultItem, 1));
                world.method_8465(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_14700, class_3419.field_15245, 1.0f, 1.5f);
                DesizerControllerBlock.particles(world, pos, direction, true);
            } else {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        for (int k = 0; k < 3; ++k) {
                            class_2248 returnBlock = input.blocks[i][j][k];
                            if (returnBlock.method_9564().method_26164(ModData.DESIZER_IGNORE_BLOCKS)) continue;
                            class_2338 returnBlockPos = new class_2338(pos.method_10263() + _X + k * this.isDirection("x", direction) + j * this.isDirection("z", direction), pos.method_10264() + _Y - i, pos.method_10260() + _Z - k * this.isDirection("z", direction) + j * this.isDirection("x", direction));
                            DesizerControllerBlock.dropResult(world, returnBlockPos, new class_1799((class_1935)returnBlock.method_8389(), 1));
                            world.method_8501(returnBlockPos, class_2246.field_10124.method_9564());
                        }
                    }
                }
                world.method_8465(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15081, class_3419.field_15245, 0.8f, 0.5f);
                DesizerControllerBlock.particles(world, pos, direction, false);
            }
        }
    }

    private static void particles(class_1937 world, class_2338 pos, class_2350 direction, Boolean success) {
        if (world.method_8608()) {
            return;
        }
        double _X = 0.0;
        double _Y = 0.0;
        double _Z = 0.0;
        switch (direction) {
            case field_11043: {
                _X = 0.0;
                _Y = 0.0;
                _Z = -2.0;
                break;
            }
            case field_11034: {
                _X = 2.0;
                _Y = 0.0;
                _Z = 0.0;
                break;
            }
            case field_11035: {
                _X = 0.0;
                _Y = 0.0;
                _Z = 2.0;
                break;
            }
            case field_11039: {
                _X = -2.0;
                _Y = 0.0;
                _Z = 0.0;
            }
        }
        if (success.booleanValue()) {
            float cubeDensity = 10.0f;
            for (int k = 0; k < 2; ++k) {
                for (int j = 0; j < 2; ++j) {
                    int i = 0;
                    while ((float)i < cubeDensity) {
                        ModUtils.spawnForcedParticles((class_3218)world, class_2398.field_11207, (double)pos.method_10263() + _X - 1.0 + (double)((float)i / cubeDensity) * 3.0, (double)pos.method_10264() + _Y - 1.0 + (double)(j * 3), (double)pos.method_10260() + _Z - 1.0 + (double)(k * 3), 1, 0.0, 0.0, 0.0, 0.0);
                        ModUtils.spawnForcedParticles((class_3218)world, class_2398.field_11207, (double)pos.method_10263() + _X - 1.0 + (double)(j * 3), (double)pos.method_10264() + _Y - 1.0 + (double)((float)i / cubeDensity) * 3.0, (double)pos.method_10260() + _Z - 1.0 + (double)(k * 3), 1, 0.0, 0.0, 0.0, 0.0);
                        ModUtils.spawnForcedParticles((class_3218)world, class_2398.field_11207, (double)pos.method_10263() + _X - 1.0 + (double)(j * 3), (double)pos.method_10264() + _Y - 1.0 + (double)(k * 3), (double)pos.method_10260() + _Z - 1.0 + (double)((float)i / cubeDensity) * 3.0, 1, 0.0, 0.0, 0.0, 0.0);
                        ++i;
                    }
                }
            }
            ModUtils.spawnForcedParticles((class_3218)world, class_2398.field_11207, (double)pos.method_10263() + _X + 0.5, (double)pos.method_10264() + _Y + 0.5, (double)pos.method_10260() + _Z, 5, 0.0, 0.0, 0.0, 0.02);
        } else {
            ModUtils.spawnForcedParticles((class_3218)world, class_2398.field_11207, (double)pos.method_10263() + _X + 0.5, (double)pos.method_10264() + _Y + 1.0, (double)pos.method_10260() + _Z + 0.5, 30, 0.5, 0.5, 0.5, 0.2);
            ModUtils.spawnForcedParticles((class_3218)world, class_2398.field_11233, (double)pos.method_10263() + _X + 0.5, (double)pos.method_10264() + _Y + 1.0, (double)pos.method_10260() + _Z + 0.5, 10, 0.5, 0.5, 0.5, 0.2);
        }
    }

    private static void dropResult(class_1937 world, class_2338 pos, class_1799 stack) {
        float f = class_1299.field_6052.method_17686() / 2.0f;
        double d = (double)((float)pos.method_10263() + 0.5f) + class_3532.method_15366((Random)world.field_9229, (double)-0.25, (double)0.25);
        double e = (double)((float)pos.method_10264() + 0.5f) + class_3532.method_15366((Random)world.field_9229, (double)-0.25, (double)0.25) - (double)f;
        double g = (double)((float)pos.method_10260() + 0.5f) + class_3532.method_15366((Random)world.field_9229, (double)-0.25, (double)0.25);
        class_2248.method_9577((class_1937)world, (class_2338)new class_2338(d, e, g), (class_1799)stack);
    }

    private int isDirection(String xOrZ, class_2350 direction) {
        if (xOrZ == "x") {
            if (direction == class_2350.field_11043) {
                return 1;
            }
            if (direction == class_2350.field_11035) {
                return -1;
            }
        }
        if (xOrZ == "z") {
            if (direction == class_2350.field_11034) {
                return -1;
            }
            if (direction == class_2350.field_11039) {
                return 1;
            }
        }
        return 0;
    }

    private boolean shouldShrink(class_1937 world, class_2338 pos, class_2350 pistonFace) {
        class_2680 controllerDirection = world.method_8320(pos);
        class_2338[] adjacentPositions = this.getAdjacentPositions(pos, (class_2350)controllerDirection.method_11654((class_2769)field_11177));
        int casingCount = 0;
        for (class_2338 class_23382 : adjacentPositions) {
            class_2680 adjacentState = world.method_8320(class_23382);
            if (!(adjacentState.method_26204() instanceof DesizerCasingBlock)) continue;
            DesizerCasingBlock.Type type = this.getCasingType(class_23382, pos, (class_2350)controllerDirection.method_11654((class_2769)field_11177));
            if (adjacentState.method_11654(DesizerCasingBlock.TYPE) != type) continue;
            ++casingCount;
        }
        if (casingCount < 8) {
            return false;
        }
        for (class_2338 class_23383 : class_2350.values()) {
            if (class_23383 == pistonFace || !world.method_8459(pos.method_10093((class_2350)class_23383), (class_2350)class_23383)) continue;
            return true;
        }
        return false;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)ctx.method_8042().method_10153());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177});
    }
}

