/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.util.handlers;

import evergoodteam.chassis.util.IdentifierParser;
import evergoodteam.chassis.util.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)(Reference.CMI + "/Registry"));
    public static final Map<String, List<String>> REGISTERED_BLOCKS = new HashMap<String, List<String>>();
    public static final Map<String, List<String>> REGISTERED_ITEMS = new HashMap<String, List<String>>();
    public static final Map<String, List<String>> ITEM_TYPES = new HashMap<String, List<String>>();

    public static void registerBlockAndItem(String namespace, String path, class_2248 block, class_1761 itemGroup, String tooltipKey) {
        RegistryHandler.registerBlock(namespace, path, block);
        RegistryHandler.registerBlockItem(namespace, path, block, itemGroup, tooltipKey);
    }

    public static void registerBlockAndItem(String namespace, String path, class_2248 block, class_1761 itemGroup) {
        RegistryHandler.registerBlock(namespace, path, block);
        RegistryHandler.registerBlockItem(namespace, path, block, itemGroup);
    }

    public static void registerBlockAndItem(String namespace, String path, class_2248 block) {
        RegistryHandler.registerBlock(namespace, path, block);
        RegistryHandler.registerBlockItem(namespace, path, block);
    }

    public static void registerBlock(String namespace, String path, class_2248 block) {
        REGISTERED_BLOCKS.computeIfAbsent(namespace, k -> new ArrayList()).add(path);
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new class_2960(namespace, path), (Object)block);
    }

    private static void registerBlockItem(String namespace, String path, class_2248 block, class_1761 itemGroup, final String tooltipKey) {
        RegistryHandler.registerItem(namespace, path, (class_1792)new class_1747(block, (class_1792.class_1793)new FabricItemSettings().group(itemGroup)){

            public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
                tooltip.add((class_2561)new class_2588(tooltipKey));
            }
        }, false);
    }

    private static void registerBlockItem(String namespace, String path, class_2248 block, class_1761 itemGroup) {
        RegistryHandler.registerItem(namespace, path, (class_1792)new class_1747(block, (class_1792.class_1793)new FabricItemSettings().group(itemGroup)), false);
    }

    private static void registerBlockItem(String namespace, String path, class_2248 block) {
        RegistryHandler.registerItem(namespace, path, (class_1792)new class_1747(block, (class_1792.class_1793)new FabricItemSettings()), false);
    }

    public static void registerHandheldItem(String namespace, String path, class_1792 item) {
        ITEM_TYPES.get("handheld").add(IdentifierParser.getString(namespace, path));
        RegistryHandler.registerItem(namespace, path, item, true);
    }

    public static void registerGeneratedItem(String namespace, String path, class_1792 item) {
        ITEM_TYPES.get("generated").add(IdentifierParser.getString(namespace, path));
        RegistryHandler.registerItem(namespace, path, item, true);
    }

    private static void registerItem(String namespace, String path, class_1792 item, Boolean count) {
        if (count.booleanValue()) {
            REGISTERED_ITEMS.computeIfAbsent(namespace, k -> new ArrayList()).add(path);
        }
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960(namespace, path), (Object)item);
    }

    static {
        ITEM_TYPES.put("generated", new ArrayList());
        ITEM_TYPES.put("handheld", new ArrayList());
    }
}

