/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.util.handlers;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import evergoodteam.chassis.util.JsonUtils;
import evergoodteam.chassis.util.StringUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"chassis/H/Json");
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();

    public static void writeToJson(String json, Path path) {
        JsonHandler.writeToJson(JsonUtils.getJsonObject(json), path);
    }

    public static void writeToJson(JsonObject jsonObject, Path path) {
        Path actual = StringUtils.checkMissingExtension(path, ".json");
        if (jsonObject.size() != 0) {
            String jsonString = GSON.toJson((JsonElement)jsonObject);
            try (FileWriter fileWriter = new FileWriter(actual.toFile());){
                fileWriter.write(jsonString);
            }
            catch (IOException e) {
                LOGGER.error("Error on writing to Json file with path {}", (Object)path, (Object)e);
            }
        } else {
            LOGGER.warn("Provided JsonObject is not valid");
        }
    }
}

