/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.util.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"chassis/H/Dir");

    public static void create(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            new File(path.toString()).mkdirs();
        }
    }

    public static void create(Path parent, String @NotNull [] children) {
        for (String child : children) {
            DirHandler.create(parent.resolve(child));
        }
    }

    public static void clean(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                FileUtils.cleanDirectory((File)path.toFile());
            }
        }
        catch (IOException e) {
            LOGGER.error("Error on cleaning {}", (Object)path, (Object)e);
        }
    }
}

