/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.objects.resourcepacks;

import com.mojang.bridge.game.GameVersion;
import evergoodteam.chassis.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_151;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePackBuilder
extends class_3255
implements class_3262 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"chassis/R/Builder");
    private static final Pattern RESOURCEPACK_PATH = Pattern.compile("[a-z0-9-_]+");
    public static final List<ResourcePackBuilder> BUILT = new ArrayList<ResourcePackBuilder>();
    private final String id;
    private final class_3264 resourceType;
    private final class_3272 packMetadata;
    private final Path basePath;
    private final String separator;
    private Set<String> namespaces;

    public ResourcePackBuilder(String id, class_3264 resourceType, Path basePath) {
        super(null);
        this.id = id;
        this.resourceType = resourceType;
        this.packMetadata = new class_3272((class_2561)new class_2588(id + ".metadata.description"), class_3264.field_14188.method_31438((GameVersion)class_155.method_16673()));
        this.basePath = basePath.resolve(id).resolve("resources").toAbsolutePath().normalize();
        this.separator = basePath.getFileSystem().getSeparator();
        BUILT.add(this);
    }

    private Path getPath(String filename) {
        Path childPath = this.basePath.resolve(filename.replace("/", this.separator));
        if (childPath.startsWith(this.basePath) && Files.exists(childPath, new LinkOption[0])) {
            return childPath;
        }
        return null;
    }

    protected boolean method_14393(String filename) {
        if ("pack.mcmeta".equals(filename)) {
            return true;
        }
        Path path = this.getPath(filename);
        return path != null && Files.isRegularFile(path, new LinkOption[0]);
    }

    protected InputStream method_14391(String fileName) throws IOException {
        Path path = this.getPath(fileName);
        if (path != null && Files.isRegularFile(path, new LinkOption[0])) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        return InputStream.nullInputStream();
    }

    public Collection<class_2960> method_14408(class_3264 type, String namespace, String prefix, int maxDepth, Predicate<String> pathFilter) {
        Path searchPath;
        ArrayList<class_2960> ids = new ArrayList<class_2960>();
        String path = prefix.replace("/", this.separator);
        Path namespacePath = this.getPath(type.method_14413() + "/" + namespace);
        if (namespacePath != null && Files.exists(searchPath = namespacePath.resolve(path).toAbsolutePath().normalize(), new LinkOption[0])) {
            try {
                Files.walk(searchPath, maxDepth, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> {
                    String filename = p.getFileName().toString();
                    return !filename.endsWith(".mcmeta") && pathFilter.test(filename);
                }).map(namespacePath::relativize).map(p -> p.toString().replace(this.separator, "/")).forEach(string -> {
                    try {
                        ids.add(new class_2960(namespace, string));
                    }
                    catch (class_151 e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error("findResources at {} in namespace {} failed: {}", new Object[]{path, namespace, e});
            }
        }
        return ids;
    }

    public Set<String> method_14406(class_3264 type) {
        if (this.namespaces == null) {
            Path file = this.getPath(type.method_14413());
            if (file == null) {
                LOGGER.error("Invalid Path");
            }
            if (!Files.isDirectory(file, new LinkOption[0])) {
                return Collections.emptySet();
            }
            HashSet<String> namespaces = new HashSet<String>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(file, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                for (Path path : stream) {
                    String s = path.getFileName().toString();
                    if (RESOURCEPACK_PATH.matcher(s = s.replace(this.separator, "")).matches()) {
                        namespaces.add(s);
                        continue;
                    }
                    LOGGER.error("Invalid namespace format at {}", (Object)path);
                }
            }
            catch (IOException e) {
                LOGGER.error("Could not get namespaces", (Throwable)e);
            }
            this.namespaces = namespaces;
        }
        return this.namespaces;
    }

    @Nullable
    public <T> T method_14407(class_3270<T> metaReader) throws IOException {
        if (metaReader.method_14420().equals("pack")) {
            return (T)this.packMetadata;
        }
        return null;
    }

    public String method_14409() {
        return StringUtils.capitalize(this.id);
    }

    public void close() {
    }
}

