/*
 * Decompiled with CFR 0.152.
 */
package evergoodteam.chassis.objects.resourcepacks;

import com.google.gson.JsonObject;
import evergoodteam.chassis.configs.ConfigBase;
import evergoodteam.chassis.configs.ConfigHandler;
import evergoodteam.chassis.objects.assets.BlockstateJson;
import evergoodteam.chassis.objects.assets.LangJson;
import evergoodteam.chassis.objects.assets.LootJson;
import evergoodteam.chassis.objects.assets.ModelJson;
import evergoodteam.chassis.objects.assets.TagJson;
import evergoodteam.chassis.util.Reference;
import evergoodteam.chassis.util.StringUtils;
import evergoodteam.chassis.util.handlers.DirHandler;
import evergoodteam.chassis.util.handlers.FileHandler;
import evergoodteam.chassis.util.handlers.JsonHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.impl.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePackBase {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)(Reference.CMI + "/Resource"));
    public static final Map<String, List<ResourcePackBase>> RESOURCE_PACKS = new HashMap<String, List<ResourcePackBase>>();
    public static final List<String> HIDDEN = new ArrayList<String>();
    public static final List<String> NO_ICON = new ArrayList<String>();
    public String namespace;
    public Path path;
    public String hexDescColor;
    private Path assetsDir;
    private Path dataDir;
    private Path namespaceAssetsDir;
    private Path namespaceDataDir;
    private Path blockstatesDir;
    private Path tagsDir;

    public ResourcePackBase(@NotNull ConfigBase config, @NotNull String namespace, @Nullable String iconUrl, @Nullable String hexDescColor) {
        this.namespace = namespace;
        this.path = Paths.get(config.dirPath.toString(), "resourcepacks/" + namespace.toLowerCase());
        this.hexDescColor = hexDescColor;
        RESOURCE_PACKS.computeIfAbsent(config.namespace, k -> new ArrayList()).add(this);
        this.configInit(config);
        if (iconUrl == null) {
            NO_ICON.add(namespace);
        } else {
            this.createPackIcon(config, namespace, iconUrl);
        }
        this.assignDirs();
    }

    public ResourcePackBase(ConfigBase config, String namespace) {
        this(config, namespace, null, "AAAAAA");
    }

    public static ResourcePackBase getResourcePack(String id, String name) {
        List<ResourcePackBase> baseList = RESOURCE_PACKS.get(id);
        int index = 0;
        for (ResourcePackBase pack : baseList) {
            if (!name.toLowerCase().equals(pack.namespace)) continue;
            index = baseList.indexOf(pack);
        }
        return RESOURCE_PACKS.get(id).get(index);
    }

    private void configInit(ConfigBase config) {
        config.resourcesLocked.put(this.namespace + "ResourceLocked", false);
        ConfigHandler.readOptions(config);
        if (ConfigHandler.getOption(config, this.namespace + "ResourceLocked") == null) {
            DirHandler.clean(this.path);
            this.createRoot();
            config.resourcesLocked.put(this.namespace + "ResourceLocked", true);
            config.builder.setupResourceProperties();
            LOGGER.info("Generated Resources for \"{}\"", (Object)this.namespace);
        } else if (!Boolean.parseBoolean(String.valueOf(ConfigHandler.getOption(config, this.namespace + "ResourceLocked")))) {
            FileHandler.delete(this.path);
            this.createRoot();
            config.resourcesLocked.put(this.namespace + "ResourceLocked", true);
            config.overwrite(this.namespace + "ResourceLocked", "true");
            LOGGER.info("Regenerated Resources for \"{}\"", (Object)this.namespace);
        } else {
            LOGGER.info("Resources for \"{}\" already exist, skipping first generation", (Object)this.namespace);
        }
    }

    private void assignDirs() {
        this.assetsDir = this.path.resolve("resources/assets");
        this.dataDir = this.path.resolve("resources/data");
        this.namespaceAssetsDir = this.path.resolve("resources/assets/" + this.namespace);
        this.namespaceDataDir = this.path.resolve("resources/data/" + this.namespace);
        this.blockstatesDir = this.namespaceAssetsDir.resolve("blockstates");
        this.tagsDir = this.namespaceDataDir.resolve("tags");
    }

    private void createRoot() {
        DirHandler.create(this.path.resolve("resources"), new String[]{"assets", "data"});
    }

    public ResourcePackBase createBlockstate(String path) {
        DirHandler.create(this.blockstatesDir);
        this.createJsonFile(this.blockstatesDir.resolve(path)).writeJsonIfEmpty(BlockstateJson.createBlockstateJson(this.namespace, path), this.blockstatesDir.resolve(path));
        return this;
    }

    public ResourcePackBase createItemModel(String path, String texture) {
        Path item = Paths.get(this.namespaceAssetsDir.toString(), "models/item");
        DirHandler.create(item);
        this.createJsonFile(item.resolve(path)).writeJsonIfEmpty(ModelJson.createItemModelJson(this.namespace, "generated", texture), item.resolve(path));
        return this;
    }

    public ResourcePackBase createBlockModels(String path, String texture, String cubeType) {
        DirHandler.create(this.namespaceAssetsDir.resolve("models"), new String[]{"block", "item"});
        Path block = Paths.get(this.namespaceAssetsDir.toString(), "models/block");
        Path item = Paths.get(this.namespaceAssetsDir.toString(), "models/item");
        this.createJsonFile(block.resolve(path)).writeJsonIfEmpty(ModelJson.createBlockModelJson(cubeType, this.namespace + ":block/" + texture), block.resolve(path));
        this.createJsonFile(item.resolve(path)).writeJsonIfEmpty(ModelJson.createItemModelJson(this.namespace, "block", path), item.resolve(path));
        return this;
    }

    public ResourcePackBase createBlockDropLootTable(String path) {
        Path lootTables = Paths.get(this.namespaceDataDir.toString(), "loot_tables/blocks");
        DirHandler.create(lootTables);
        this.createJsonFile(lootTables.resolve(path)).writeJsonIfEmpty(LootJson.createBlockBreakLootJson(this.namespace, path), lootTables.resolve(path));
        return this;
    }

    public ResourcePackBase createGlobalTag(String input) {
        Path commonTagsDir = this.dataDir.resolve("c/tags");
        DirHandler.create(commonTagsDir, new String[]{"blocks", "items"});
        Path blocks = Paths.get(commonTagsDir.toString(), "blocks");
        Path items = Paths.get(commonTagsDir.toString(), "items");
        this.createJsonFile(blocks.resolve(input)).writeJsonIfEmpty(TagJson.createTagJson(this.namespace, new String[]{input}), blocks.resolve(input));
        this.createJsonFile(items.resolve(input)).writeJsonIfEmpty(TagJson.createTagJson(this.namespace, new String[]{input}), items.resolve(input));
        return this;
    }

    public ResourcePackBase createRequiredToolTag(String tool, String[] inputs) {
        Path mineable = Paths.get(this.dataDir.toString(), "minecraft/tags/blocks/mineable");
        DirHandler.create(mineable);
        if (!Files.exists(mineable.resolve(tool), new LinkOption[0])) {
            this.createJsonFile(mineable.resolve(tool));
        }
        this.writeJsonIfEmpty(TagJson.createTagJson(this.namespace, inputs), mineable.resolve(tool));
        return this;
    }

    public ResourcePackBase createMiningLevelTag(String miningLevel, String[] inputs) {
        String fileName = "needs_" + miningLevel + "_tool";
        Path tagBlocks = Paths.get(this.dataDir.toString(), "minecraft/tags/blocks");
        DirHandler.create(tagBlocks);
        if (!Files.exists(tagBlocks.resolve(fileName), new LinkOption[0])) {
            this.createJsonFile(tagBlocks.resolve(fileName));
        }
        this.writeJsonIfEmpty(TagJson.createTagJson(this.namespace, inputs), tagBlocks.resolve(fileName));
        return this;
    }

    public ResourcePackBase createTexture(Boolean block, String textureURL, String textureName) {
        String actual = StringUtils.checkMissingExtension(textureName, ".png");
        DirHandler.create(this.namespaceAssetsDir.resolve("textures"), new String[]{"block", "item"});
        Path blockDir = this.namespaceAssetsDir.resolve("textures/block");
        Path itemDir = this.namespaceAssetsDir.resolve("textures/item");
        try (InputStream in = new URL(textureURL).openStream();){
            if (block.booleanValue()) {
                if (!Files.exists(blockDir.resolve(actual), new LinkOption[0])) {
                    Files.copy(in, blockDir.resolve(actual), new CopyOption[0]);
                }
            } else if (!Files.exists(itemDir.resolve(actual), new LinkOption[0])) {
                Files.copy(in, itemDir.resolve(actual), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error on creating Texture .png", (Throwable)e);
        }
        return this;
    }

    public ResourcePackBase createLang(String language, Map<String, String> entries) {
        DirHandler.create(this.namespaceAssetsDir.resolve("lang"));
        this.createJsonFile(this.namespaceAssetsDir.resolve("lang/" + language)).writeJsonIfEmpty(LangJson.createLangJson(entries), this.namespaceAssetsDir.resolve("lang/" + language));
        return this;
    }

    private ResourcePackBase writeJsonIfEmpty(JsonObject jsonObject, @NotNull Path path) {
        if (Paths.get(path + ".json", new String[0]).toFile().length() == 0L) {
            this.writeJson(jsonObject, path);
        }
        return this;
    }

    private ResourcePackBase writeJsonIfEmpty(String json, @NotNull Path path) {
        if (Paths.get(path + ".json", new String[0]).toFile().length() == 0L) {
            LOGGER.info("File is empty, writing at {}", (Object)path);
            this.writeJson(json, path);
        }
        return this;
    }

    private ResourcePackBase writeJson(JsonObject jsonObject, Path path) {
        JsonHandler.writeToJson(jsonObject, path);
        return this;
    }

    private ResourcePackBase writeJson(String json, Path path) {
        JsonHandler.writeToJson(json, path);
        return this;
    }

    private ResourcePackBase createJsonFile(Path path) {
        FileHandler.createJsonFile(path);
        return this;
    }

    public ResourcePackBase hide() {
        HIDDEN.add(StringUtil.capitalize((String)this.namespace));
        return this;
    }

    private void createPackIcon(@NotNull ConfigBase config, @NotNull String namespace, String iconURL) {
        Path iconPath = Paths.get(config.dirPath.toString(), "resourcepacks/" + namespace.toLowerCase() + "/resources/pack.png");
        try (InputStream in = new URL(iconURL).openStream();){
            if (!Files.exists(iconPath, new LinkOption[0])) {
                Files.copy(in, iconPath, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error on creating Pack Icon file, falling back to Unknown Icon", (Throwable)e);
            this.hide();
        }
    }
}

